/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer.backend.providers.vswin.parsers;

import com.intellij.ide.startup.importSettings.db.KnownKeymaps;
import com.intellij.ide.startup.importSettings.models.KeyBinding;
import com.intellij.ide.startup.importSettings.models.Keymap;
import com.intellij.ide.startup.importSettings.models.PatchedKeymap;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.providers.vswin.parsers.data.FontsAndColorsParsedData;
import com.intellij.ide.startup.importSettings.providers.vswin.parsers.data.VSParsedData;
import com.intellij.ide.startup.importSettings.providers.vswin.parsers.data.VSParsedDataCreator;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.Version2;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vswin.parsers.VSXmlParserException;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vswin.parsers.data.KeyBindingsParsedData;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vswin.utilities.VSHive;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\tJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J,\u0010\u0016\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0018\u00010\u00172\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00152\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/parsers/VSXmlParser;", "", "settingsFile", "Ljava/nio/file/Path;", "hive", "Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/utilities/VSHive;", "<init>", "(Ljava/nio/file/Path;Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/utilities/VSHive;)V", "allSettings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "getAllSettings", "()Lcom/intellij/ide/startup/importSettings/models/Settings;", "ver", "Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/Version2;", "getVer", "()Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/Version2;", "toSettings", "categoryDigger", "", "version", "rtElement", "Lorg/jdom/Element;", "parserDispatcher", "Lkotlin/Function0;", "Lcom/intellij/ide/startup/importSettings/providers/vswin/parsers/data/VSParsedData;", "el", "Companion", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nVSXmlParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VSXmlParser.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/parsers/VSXmlParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,103:1\n1#2:104\n13#3:105\n*S KotlinDebug\n*F\n+ 1 VSXmlParser.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/parsers/VSXmlParser\n*L\n31#1:105\n*E\n"})
public final class VSXmlParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final VSHive hive;
    @NotNull
    private final Settings allSettings;
    @NotNull
    private final Version2 ver;
    @NotNull
    public static final String APPLICATION_IDENTITY = "ApplicationIdentity";
    @NotNull
    public static final String TOOLS_OPTIONS = "ToolsOptions";
    @NotNull
    public static final String CATEGORY = "Category";
    @NotNull
    public static final String ENVIRONMENT_GROUP = "Environment_Group";
    @NotNull
    public static final String NAME_ATTRIBUTE = "name";
    @NotNull
    public static final String VERSION_ATTRIBUTE = "version";
    @NotNull
    private static final Logger logger;

    public VSXmlParser(@NotNull Path settingsFile, @Nullable VSHive hive) {
        Intrinsics.checkNotNullParameter((Object)settingsFile, (String)"settingsFile");
        this.hive = hive;
        this.allSettings = new Settings(null, null, null, KnownKeymaps.INSTANCE.getVisualStudio2022(), null, 23, null);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(settingsFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean $i$a$-require-VSXmlParser$22 = false;
            String $i$a$-require-VSXmlParser$22 = "Settings file was not found";
            throw new IllegalArgumentException($i$a$-require-VSXmlParser$22.toString());
        }
        if (this.hive != null) {
            logger.info("Parsing " + this.hive);
        }
        Element element = JDOMUtil.load((Path)settingsFile);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
        Element rootElement = element;
        logger.info("Parsing file " + ((Object)settingsFile.toAbsolutePath()).toString());
        Object object = rootElement.getChild(APPLICATION_IDENTITY);
        if (object == null || (object = object.getAttribute(VERSION_ATTRIBUTE)) == null || (object = object.getValue()) == null) {
            throw new VSXmlParserException("Can't find version");
        }
        Object verStr = object;
        this.ver = Version2.Companion.parse((String)verStr);
        this.categoryDigger(this.ver, rootElement);
    }

    public /* synthetic */ VSXmlParser(Path path, VSHive vSHive, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            vSHive = null;
        }
        this(path, vSHive);
    }

    @NotNull
    public final Settings getAllSettings() {
        return this.allSettings;
    }

    @NotNull
    public final Version2 getVer() {
        return this.ver;
    }

    @NotNull
    public final Settings toSettings() {
        return this.allSettings;
    }

    private final void categoryDigger(Version2 version, Element rtElement) {
        for (Element el : rtElement.getChildren()) {
            String name;
            VSParsedData disp;
            VSParsedData vSParsedData;
            block9: {
                block8: {
                    if (Intrinsics.areEqual((Object)el.getName(), (Object)APPLICATION_IDENTITY)) continue;
                    if (Intrinsics.areEqual((Object)el.getName(), (Object)TOOLS_OPTIONS)) break block8;
                    if (!Intrinsics.areEqual((Object)el.getName(), (Object)CATEGORY)) break block9;
                    Attribute attribute = el.getAttribute(NAME_ATTRIBUTE);
                    if (!Intrinsics.areEqual((Object)(attribute != null ? attribute.getValue() : null), (Object)ENVIRONMENT_GROUP)) break block9;
                }
                Intrinsics.checkNotNull((Object)el);
                this.categoryDigger(version, el);
                continue;
            }
            Intrinsics.checkNotNull((Object)el);
            if (this.parserDispatcher(version, el, this.hive) != null) {
                Function0<VSParsedData> it;
                boolean bl = false;
                vSParsedData = (VSParsedData)it.invoke();
            } else {
                vSParsedData = null;
            }
            if ((disp = vSParsedData) == null) continue;
            Attribute attribute = el.getAttribute(NAME_ATTRIBUTE);
            String string = name = attribute != null ? attribute.getValue() : null;
            if (name == null) {
                logger.info("This should not happen. For some reason there is no name attribute");
                continue;
            }
            VSParsedData vSParsedData2 = disp;
            if (vSParsedData2 instanceof FontsAndColorsParsedData) {
                this.allSettings.setLaf(((FontsAndColorsParsedData)disp).getTheme().toRiderTheme());
                continue;
            }
            if (!(vSParsedData2 instanceof KeyBindingsParsedData)) continue;
            List<KeyBinding> format = ((KeyBindingsParsedData)disp).convertToSettingsFormat();
            Keymap oldKeymap = this.allSettings.getKeymap();
            if (!(!((Collection)format).isEmpty()) || oldKeymap == null) continue;
            this.allSettings.setKeymap(new PatchedKeymap(oldKeymap.getTransferableId(), oldKeymap, ((KeyBindingsParsedData)disp).convertToSettingsFormat(), CollectionsKt.emptyList()));
        }
    }

    private final Function0<VSParsedData> parserDispatcher(Version2 version, Element el, VSHive hive) {
        String string;
        Attribute attribute = el.getAttribute(NAME_ATTRIBUTE);
        String string2 = string = attribute != null ? attribute.getValue() : null;
        return Intrinsics.areEqual((Object)string, (Object)"Environment_FontsAndColors") ? () -> VSXmlParser.parserDispatcher$lambda$0(version, el) : (Intrinsics.areEqual((Object)string, (Object)"Environment_KeyBindings") ? () -> VSXmlParser.parserDispatcher$lambda$1(version, el, hive) : null);
    }

    private static final VSParsedData parserDispatcher$lambda$0(Version2 $version, Element $el) {
        return VSParsedDataCreator.INSTANCE.fontsAndColors($version, $el);
    }

    private static final VSParsedData parserDispatcher$lambda$1(Version2 $version, Element $el, VSHive $hive) {
        return VSParsedDataCreator.INSTANCE.keyBindings($version, $el, $hive);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VSXmlParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        VSXmlParser.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/parsers/VSXmlParser$Companion;", "", "<init>", "()V", "APPLICATION_IDENTITY", "", "TOOLS_OPTIONS", "CATEGORY", "ENVIRONMENT_GROUP", "NAME_ATTRIBUTE", "VERSION_ATTRIBUTE", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.ide.startup.importSettings"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

