/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.orm.reference.provider;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.icons.AllIcons;
import com.intellij.jpa.jpb.model.complition.JpbLookupElements;
import com.intellij.jpa.jpb.model.service.JpabReferenceManager;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.jpa.jpb.model.util.SUastUtils;
import com.intellij.liquibase.core.msg.LiquibaseResourceBundle;
import com.intellij.liquibase.core.reference.provider.LiquibaseReference;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0016J\u0013\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0004H\u0016J\b\u0010\u0016\u001a\u00020\u0004H\u0016R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/liquibase/orm/reference/provider/TableNameReference;", "Lcom/intellij/liquibase/core/reference/provider/LiquibaseReference;", "Lcom/intellij/codeInsight/daemon/EmptyResolveMessageProvider;", "tableName", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "getTableName", "()Ljava/lang/String;", "referenceManager", "Lcom/intellij/jpa/jpb/model/service/JpabReferenceManager;", "resolve", "getVariants", "", "", "()[Ljava/lang/Object;", "createOption", "Lcom/intellij/codeInsight/lookup/LookupElement;", "handleElementRename", "newElementName", "getUnresolvedMessagePattern", "intellij.liquibase.orm"})
@SourceDebugExtension(value={"SMAP\nTableNameReferenceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableNameReferenceProvider.kt\ncom/intellij/liquibase/orm/reference/provider/TableNameReference\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,63:1\n139#2,10:64\n221#2:74\n222#2:76\n149#2:77\n1#3:75\n37#4,2:78\n*S KotlinDebug\n*F\n+ 1 TableNameReferenceProvider.kt\ncom/intellij/liquibase/orm/reference/provider/TableNameReference\n*L\n43#1:64,10\n43#1:74\n43#1:76\n43#1:77\n43#1:75\n43#1:78,2\n*E\n"})
public class TableNameReference
extends LiquibaseReference
implements EmptyResolveMessageProvider {
    @Nullable
    private final String tableName;
    @NotNull
    private final JpabReferenceManager referenceManager;

    public TableNameReference(@Nullable String tableName, @NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        super(psiElement);
        this.tableName = tableName;
        this.referenceManager = JpabReferenceManager.Companion.getInstance(this.getProject());
    }

    @Nullable
    public final String getTableName() {
        return this.tableName;
    }

    @Nullable
    public PsiElement resolve() {
        try {
            CharSequence charSequence = this.tableName;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return null;
            }
            return this.referenceManager.findTableOwnerElementByTableName(this.tableName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Object[] getVariants() {
        void $this$mapNotNullTo$iv$iv;
        Map $this$mapNotNull$iv = this.referenceManager.getAllTables();
        boolean $i$f$mapNotNull = false;
        Map map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            LookupElement it$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry it = element$iv$iv;
            boolean bl2 = false;
            if (this.createOption((PsiElement)it.getValue(), (String)it.getKey()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Object[0]);
    }

    private final LookupElement createOption(PsiElement psiElement, String tableName) {
        PsiClass psiClass = SUastUtils.getContainingClass((PsiElement)psiElement);
        if (psiClass == null) {
            return null;
        }
        PsiClass psiClass2 = psiClass;
        String string = EntityUtil.getPackageName((PsiClass)psiClass2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
        String packageName = string;
        Object[] objectArray = new String[]{tableName, psiClass2.getName()};
        return (LookupElement)JpbLookupElements.element((String)tableName, (String)packageName).withPsiElement((PsiElement)psiClass2).withIcon(AllIcons.Javaee.PersistenceEntity).withLookupStrings((Collection)CollectionsKt.listOf((Object[])objectArray)).withCaseSensitivity(false);
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) {
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        PsiElement psiElement = this.myElement;
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"myElement");
        return psiElement;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        Object[] objectArray = new Object[]{this.tableName};
        String string = LiquibaseResourceBundle.message((String)"inspection.message.unknown.table", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

