/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.snapshot;

import com.intellij.jpa.jpb.model.liquibase.ns.PhysicalNamingStrategy;
import com.intellij.jpa.jpb.model.model.CollectionTableAttribute;
import com.intellij.jpa.jpb.model.model.JoinTableAttribute;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.liquibase.orm.LiquibaseModelObjectFactory;
import com.intellij.liquibase.orm.StubLiquibaseModelObjectFactory;
import com.intellij.liquibase.orm.ddl.LiquibaseGenerator;
import com.intellij.liquibase.orm.extension.OrmDiffModelProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import liquibase.exception.DatabaseException;
import liquibase.ext.intellij.LiquibaseUtils;
import liquibase.ext.intellij.database.IntellijDatabase;
import liquibase.ext.intellij.snapshot.IntellijSnapshotGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;

public class TableSnapshotGenerator
extends IntellijSnapshotGenerator {
    public TableSnapshotGenerator() {
        super(Table.class, new Class[]{Schema.class});
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (example.getSnapshotId() != null) {
            return example;
        }
        OrmEntity entity = this.findOrmEntity(example, snapshot);
        if (entity == null) {
            return example;
        }
        if (!TableSnapshotGenerator.isEntityIncludedInContext(entity, snapshot).booleanValue()) {
            return null;
        }
        OrmDiffModelProvider ormDiffModelProvider = this.getOrmDiffModelProvider(snapshot);
        IntellijDatabase intellijDatabase = LiquibaseUtils.getIntellijDatabase(snapshot);
        LiquibaseModelObjectFactory dbObjectFactory = intellijDatabase == null ? StubLiquibaseModelObjectFactory.INSTANCE : intellijDatabase.getDbObjectFactory();
        String tableName = ormDiffModelProvider.getTableName(entity);
        if (tableName == null) {
            throw new IllegalArgumentException("Cannot determine table name for " + entity.getName());
        }
        Table table = dbObjectFactory.createTable(tableName);
        LOG.debug("Found table " + table.getName());
        table.setSchema(example.getSchema());
        table.setRemarks(ormDiffModelProvider.getComment(entity));
        return table;
    }

    private static Boolean isEntityIncludedInContext(OrmEntity ormEntity, DatabaseSnapshot snapshot) {
        IntellijDatabase database = (IntellijDatabase)snapshot.getDatabase();
        List<OrmEntity> entitiesToProcess = database.getOrmEntitiesToProcess();
        if (entitiesToProcess.contains(ormEntity)) {
            return true;
        }
        String entityName = ormEntity.getName();
        for (OrmEntity entity : entitiesToProcess) {
            if (!entityName.equals(entity.getName()) || !Objects.equals(entity.getClassPsiPointer(), ormEntity.getClassPsiPointer())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(Table.class)) {
            return;
        }
        if (!(foundObject instanceof Schema)) {
            return;
        }
        Schema schema = (Schema)foundObject;
        IntellijDatabase database = (IntellijDatabase)snapshot.getDatabase();
        List<OrmEntity> ormEntities = database.getOrmEntitiesToProcess(schema);
        OrmDiffModelProvider ormDiffModelProvider = this.getOrmDiffModelProvider(snapshot);
        LiquibaseModelObjectFactory dbObjectFactory = database.getDbObjectFactory();
        PhysicalNamingStrategy namingStrategy = dbObjectFactory.getNamingStrategy();
        HashSet<String> processedTableNames = new HashSet<String>();
        for (OrmEntity ormEntity : ormEntities) {
            String tableName = ormDiffModelProvider.getTableName(ormEntity);
            if (tableName == null || !TableSnapshotGenerator.isTableToProcess(namingStrategy, processedTableNames, tableName)) continue;
            this.addTableToSchema(snapshot, schema, database, dbObjectFactory, tableName);
        }
        LiquibaseGenerator liquibaseGenerator = database.getLiquibaseGenerator();
        Map<String, JoinTableAttribute> joinTables = liquibaseGenerator.getJoinTables(ormEntities);
        for (String joinTableName : joinTables.keySet()) {
            if (!TableSnapshotGenerator.isTableToProcess(namingStrategy, processedTableNames, joinTableName)) continue;
            this.addTableToSchema(snapshot, schema, database, dbObjectFactory, joinTableName);
        }
        List<CollectionTableAttribute> collectionTables = liquibaseGenerator.getCollectionTables(ormEntities);
        for (CollectionTableAttribute collectionTableAttribute : collectionTables) {
            String tableName = collectionTableAttribute.getTableName();
            if (!TableSnapshotGenerator.isTableToProcess(namingStrategy, processedTableNames, tableName)) continue;
            this.addTableToSchema(snapshot, schema, database, dbObjectFactory, tableName);
        }
    }

    private static boolean isTableToProcess(PhysicalNamingStrategy namingStrategy, Set<String> processedTableNames, String tableName) {
        if (ContainerUtil.exists(processedTableNames, processedTable -> namingStrategy.compareLogicalWithPhysicalTableNames(processedTable, tableName))) {
            return false;
        }
        processedTableNames.add(tableName);
        return true;
    }

    private void addTableToSchema(DatabaseSnapshot snapshot, Schema schema, IntellijDatabase database, LiquibaseModelObjectFactory dbObjectFactory, String tableName) throws DatabaseException, InvalidExampleException {
        if (StringUtil.isEmpty((String)tableName) || database.getGenerationContext().isIgnoreTableName(PhysicalNamingStrategy.getInstance((Project)database.getProject()).toTableName(tableName))) {
            return;
        }
        Table table = dbObjectFactory.createTable(tableName);
        table.setSchema(schema);
        LOG.debug("Found table " + table.getName());
        schema.addDatabaseObject(this.snapshotObject((DatabaseObject)table, snapshot));
    }
}

