/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.junit.JUnitTestFramework;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JupiterFramework
extends JUnitTestFramework {
    public boolean shouldRunSingleClassAsJUnit5(Project project, GlobalSearchScope scope) {
        return true;
    }

    @Nullable
    public String getDefaultSuperClass() {
        return null;
    }

    public boolean isTestClass(PsiClass clazz, boolean canBePotential) {
        return (Boolean)JupiterFramework.callWithAlternateResolver((Project)clazz.getProject(), () -> {
            if (canBePotential) {
                return this.isUnderTestSources(clazz);
            }
            if (!this.isFrameworkAvailable((PsiElement)clazz)) {
                return false;
            }
            return JUnitUtil.isJUnit5TestClass((PsiClass)clazz, (boolean)false);
        }, (Object)false);
    }

    @Nullable
    protected PsiMethod findSetUpMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            JupiterFramework.$$$reportNull$$$0(0);
        }
        return JupiterFramework.findMethod(clazz, null, "org.junit.jupiter.api.BeforeEach");
    }

    @Nullable
    protected PsiMethod findBeforeClassMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            JupiterFramework.$$$reportNull$$$0(1);
        }
        return JupiterFramework.findMethod(clazz, "static", "org.junit.jupiter.api.BeforeAll");
    }

    @Nullable
    protected PsiElement findBeforeSuiteMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            JupiterFramework.$$$reportNull$$$0(2);
        }
        return JupiterFramework.findMethod(clazz, "static", "org.junit.platform.suite.api.BeforeSuite");
    }

    @Nullable
    protected PsiElement findAfterSuiteMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            JupiterFramework.$$$reportNull$$$0(3);
        }
        return JupiterFramework.findMethod(clazz, "static", "org.junit.platform.suite.api.AfterSuite");
    }

    @Nullable
    protected PsiMethod findTearDownMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            JupiterFramework.$$$reportNull$$$0(4);
        }
        return JupiterFramework.findMethod(clazz, null, "org.junit.jupiter.api.AfterEach");
    }

    @Nullable
    private static PsiMethod findMethod(@NotNull PsiClass clazz, @PsiModifier.ModifierConstant @Nullable String modifier, @NotNull String annotationFqn) {
        if (clazz == null) {
            JupiterFramework.$$$reportNull$$$0(5);
        }
        if (annotationFqn == null) {
            JupiterFramework.$$$reportNull$$$0(6);
        }
        return (PsiMethod)JupiterFramework.callWithAlternateResolver((Project)clazz.getProject(), () -> {
            for (PsiMethod each : clazz.getMethods()) {
                if (modifier != null && !each.hasModifierProperty(modifier) || !AnnotationUtil.isAnnotated((PsiModifierListOwner)each, (String)annotationFqn, (int)0)) continue;
                return each;
            }
            return null;
        }, null);
    }

    @Nullable
    protected PsiMethod findOrCreateSetUpMethod(PsiClass clazz) throws IncorrectOperationException {
        PsiMethod testMethod;
        PsiMethod method = this.findSetUpMethod(clazz);
        if (method != null) {
            return method;
        }
        PsiManager manager = clazz.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        method = this.createSetUpPatternMethod((JVMElementFactory)factory);
        PsiMethod existingMethod = clazz.findMethodBySignature(method, false);
        if (existingMethod != null) {
            int exit;
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)existingMethod, (String)"org.junit.jupiter.api.BeforeAll", (int)0)) {
                return existingMethod;
            }
            int n = exit = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showOkCancelDialog((String)JUnitBundle.message("create.setup.dialog.message", "@BeforeEach"), (String)JUnitBundle.message("create.setup.dialog.title", new Object[0]), (Icon)Messages.getWarningIcon());
            if (exit == 0) {
                AddAnnotationPsiFix.addPhysicalAnnotationIfAbsent((String)"org.junit.jupiter.api.BeforeEach", (PsiNameValuePair[])PsiNameValuePair.EMPTY_ARRAY, (PsiAnnotationOwner)existingMethod.getModifierList());
                return existingMethod;
            }
        }
        method = (testMethod = JUnitUtil.findFirstTestMethod((PsiClass)clazz)) != null ? (PsiMethod)clazz.addBefore((PsiElement)method, (PsiElement)testMethod) : (PsiMethod)clazz.add((PsiElement)method);
        JavaCodeStyleManager.getInstance((Project)manager.getProject()).shortenClassReferences((PsiElement)method);
        return method;
    }

    public boolean isIgnoredMethod(PsiElement element) {
        if (element == null) {
            return false;
        }
        return (Boolean)JupiterFramework.callWithAlternateResolver((Project)element.getProject(), () -> {
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                PsiMethod ignoredTestMethod = AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.junit.jupiter.api.Disabled", (int)0) ? JUnitUtil.getTestMethod((PsiElement)element) : null;
                return ignoredTestMethod != null;
            }
            return false;
        }, (Object)true);
    }

    public boolean acceptNestedClasses() {
        return true;
    }

    public FileTemplateDescriptor getSetUpMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit5 SetUp Method.java");
    }

    public FileTemplateDescriptor getBeforeClassMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit5 BeforeAll Method.java");
    }

    public FileTemplateDescriptor getTearDownMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit5 TearDown Method.java");
    }

    public FileTemplateDescriptor getAfterClassMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit5 AfterAll Method.java");
    }

    @NotNull
    public FileTemplateDescriptor getTestMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit5 Test Method.java");
    }

    public FileTemplateDescriptor getTestClassFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit5 Test Class.java");
    }

    public boolean isSuiteClass(PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        return (Boolean)JupiterFramework.callWithAlternateResolver((Project)psiClass.getProject(), () -> AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"org.junit.platform.suite.api.Suite", (int)1), (Object)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFqn";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/junit/JupiterFramework";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findSetUpMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findBeforeClassMethod";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findBeforeSuiteMethod";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findAfterSuiteMethod";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findTearDownMethod";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

