/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Url;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.Base64VLQ;
import org.jetbrains.debugger.sourcemap.CharSequenceIterator;
import org.jetbrains.debugger.sourcemap.FileBackedSourceMap;
import org.jetbrains.debugger.sourcemap.FlatSourceMap;
import org.jetbrains.debugger.sourcemap.MutableEntry;
import org.jetbrains.debugger.sourcemap.NamedEntry;
import org.jetbrains.debugger.sourcemap.Offset;
import org.jetbrains.debugger.sourcemap.OneLevelSourceMap;
import org.jetbrains.debugger.sourcemap.ParserKt;
import org.jetbrains.debugger.sourcemap.Section;
import org.jetbrains.debugger.sourcemap.SectionedSourceMap;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.sourcemap.SourceMapDataCache;
import org.jetbrains.debugger.sourcemap.SourceMapDataEx;
import org.jetbrains.debugger.sourcemap.SourceMapDataImpl;
import org.jetbrains.debugger.sourcemap.SourceMapV3;
import org.jetbrains.debugger.sourcemap.SourceResolver;
import org.jetbrains.debugger.sourcemap.UnmappedEntry;
import org.jetbrains.debugger.sourcemap.UnnamedEntry;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0007H\u0007\u001a6\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\u0007H\u0007\u001a;\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\r2'\u0010\u0010\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00170\u0011H\u0007\u001a\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\f\u001a\u00020\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0000\u001a\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u001a\u0084\u0001\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\"2\u000e\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00130\"2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00010\"2\u0006\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020\u00012\u0006\u0010*\u001a\u00020\u00012\u0006\u0010+\u001a\u00020\u00012\b\u0010,\u001a\u0004\u0018\u00010#H\u0002\u001a`\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\r2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010/\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020\u00012\u0006\u0010*\u001a\u00020\u00012\u0006\u0010+\u001a\u00020\u00012\b\u0010,\u001a\u0004\u0018\u00010#H\u0002\u001a\u0010\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u000202H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"UNMAPPED", "", "decodeSourceMapFromFile", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "file", "Ljava/nio/file/Path;", "trimFileScheme", "", "baseUrl", "Lcom/intellij/util/Url;", "baseUrlIsFile", "decodeSourceMapSafely", "sourceMapData", "", "transformToLocalFileUrlIfPossible", "decodeSourceMap", "sourceResolverFactory", "Lkotlin/Function1;", "", "", "Lkotlin/ParameterName;", "name", "sourceUrls", "Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "parseMapSafely", "Lorg/jetbrains/debugger/sourcemap/SourceMapDataImpl;", "mapDebugName", "flattenAndDecodeMappings", "rawMap", "Lorg/jetbrains/debugger/sourcemap/SourceMapV3;", "traverse", "", "map", "mappings", "", "Lorg/jetbrains/debugger/sourcemap/MutableEntry;", "sources", "sourcesContent", "names", "ignoreList", "lineOffset", "columnOffset", "stopLine", "stopColumn", "lastEntry", "readMappings", "value", "sourcesOffset", "isSeparator", "charIterator", "Lorg/jetbrains/debugger/sourcemap/CharSequenceIterator;", "intellij.platform.scriptDebugger.backend"})
@SourceDebugExtension(value={"SMAP\nSourceMapDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceMapDecoder.kt\norg/jetbrains/debugger/sourcemap/SourceMapDecoderKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,278:1\n13#2:279\n1586#3:280\n1661#3,3:281\n1915#3,2:284\n1#4:286\n*S KotlinDebug\n*F\n+ 1 SourceMapDecoder.kt\norg/jetbrains/debugger/sourcemap/SourceMapDecoderKt\n*L\n65#1:279\n100#1:280\n100#1:281,3\n168#1:284,2\n*E\n"})
public final class SourceMapDecoderKt {
    public static final int UNMAPPED = -1;

    @ApiStatus.Internal
    @Nullable
    public static final SourceMap decodeSourceMapFromFile(@NotNull Path file, boolean trimFileScheme, @Nullable Url baseUrl, boolean baseUrlIsFile) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FileBackedSourceMap.Companion.newFileBackedSourceMap(file, trimFileScheme, baseUrl, baseUrlIsFile);
    }

    @Deprecated(message="This function isn not a part of the public API and will be removed in the future")
    @JvmOverloads
    @Nullable
    public static final SourceMap decodeSourceMapSafely(@NotNull CharSequence sourceMapData, boolean trimFileScheme, @Nullable Url baseUrl, boolean baseUrlIsFile, boolean transformToLocalFileUrlIfPossible) {
        Intrinsics.checkNotNullParameter((Object)sourceMapData, (String)"sourceMapData");
        return SourceMapDecoderKt.decodeSourceMap(sourceMapData, (Function1<? super List<String>, SourceResolver>)((Function1)arg_0 -> SourceMapDecoderKt.decodeSourceMapSafely$lambda$0(baseUrl, baseUrlIsFile, transformToLocalFileUrlIfPossible, arg_0)));
    }

    public static /* synthetic */ SourceMap decodeSourceMapSafely$default(CharSequence charSequence, boolean bl, Url url, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl3 = true;
        }
        return SourceMapDecoderKt.decodeSourceMapSafely(charSequence, bl, url, bl2, bl3);
    }

    @ApiStatus.Internal
    @Nullable
    public static final SourceMap decodeSourceMap(@NotNull CharSequence sourceMapData, @NotNull Function1<? super List<String>, SourceResolver> sourceResolverFactory) {
        Intrinsics.checkNotNullParameter((Object)sourceMapData, (String)"sourceMapData");
        Intrinsics.checkNotNullParameter(sourceResolverFactory, (String)"sourceResolverFactory");
        SourceMapDataEx sourceMapDataEx = SourceMapDataCache.getOrCreate$default(SourceMapDataCache.INSTANCE, sourceMapData, null, 2, null);
        if (sourceMapDataEx == null) {
            return null;
        }
        SourceMapDataEx data = sourceMapDataEx;
        return new OneLevelSourceMap(data, (SourceResolver)sourceResolverFactory.invoke(data.getSourceMapData().getSources()));
    }

    @Nullable
    public static final SourceMapDataImpl parseMapSafely(@NotNull CharSequence sourceMapData, @Nullable String mapDebugName) {
        Intrinsics.checkNotNullParameter((Object)sourceMapData, (String)"sourceMapData");
        try {
            if (sourceMapData.length() == 0) {
                throw new IOException("source map contents cannot be empty");
            }
            SourceMapV3 sourceMapV3 = ParserKt.readMap(sourceMapData);
            if (sourceMapV3 == null) {
                return null;
            }
            SourceMapV3 rawMap = sourceMapV3;
            return SourceMapDecoderKt.flattenAndDecodeMappings(rawMap);
        }
        catch (Throwable t) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SourceMap.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            Attachment[] attachmentArray = new Attachment[]{new Attachment("sourceMap.txt", ((Object)sourceMapData).toString())};
            logger.error("Cannot decode sourcemap " + mapDebugName, t, attachmentArray);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final SourceMapDataImpl flattenAndDecodeMappings(@NotNull SourceMapV3 rawMap) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)rawMap, (String)"rawMap");
        List mappings = new ArrayList();
        List sources = new ArrayList();
        List sourcesContent = new ArrayList();
        List names = new ArrayList();
        List ignoreList = new ArrayList();
        SourceMapDecoderKt.traverse(rawMap, mappings, sources, sourcesContent, names, ignoreList, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE, null);
        if (mappings.isEmpty()) {
            return null;
        }
        Iterable iterable = sources;
        String string = rawMap.getFile();
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string3 = it;
            if (string3 == null) {
                string3 = "";
            }
            collection.add(string3);
        }
        List list = ignoreList;
        List list2 = mappings;
        boolean bl = !((Collection)names).isEmpty();
        List list3 = sourcesContent;
        List list4 = (List)destination$iv$iv;
        String string4 = string;
        return new SourceMapDataImpl(string4, list4, list3, bl, list2, list);
    }

    private static final void traverse(SourceMapV3 map, List<MutableEntry> mappings, List<String> sources, List<String> sourcesContent, List<String> names, List<Integer> ignoreList, int lineOffset, int columnOffset, int stopLine, int stopColumn, MutableEntry lastEntry) {
        MutableEntry lastEntry2 = lastEntry;
        SourceMapV3 sourceMapV3 = map;
        if (sourceMapV3 instanceof SectionedSourceMap) {
            Iterator iterator = ((Iterable)((SectionedSourceMap)map).getSections()).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int i = n++;
                Section section = (Section)iterator.next();
                Offset offset = section.getOffset();
                int sl = stopLine;
                int sc = stopColumn;
                if (i + 1 < ((SectionedSourceMap)map).getSections().size()) {
                    Offset nextOffset = ((SectionedSourceMap)map).getSections().get(i + 1).getOffset();
                    sl = Math.min(stopLine, lineOffset + nextOffset.getLine());
                    if (sl == stopLine) {
                        sc = Math.min(stopColumn, columnOffset + nextOffset.getColumn());
                    } else if (sl < stopLine) {
                        sc = columnOffset + nextOffset.getColumn();
                    }
                }
                SourceMapDecoderKt.traverse(section.getMap(), mappings, sources, sourcesContent, names, ignoreList, offset.getLine() + lineOffset, offset.getColumn() + columnOffset, sl, sc, lastEntry2);
                lastEntry2 = (MutableEntry)CollectionsKt.lastOrNull(mappings);
            }
        } else if (sourceMapV3 instanceof FlatSourceMap) {
            int sourcesOffset = sources.size();
            sources.addAll((Collection<String>)((FlatSourceMap)map).getSources());
            if (((FlatSourceMap)map).getSourcesContent() != null) {
                sourcesContent.addAll((Collection<String>)((FlatSourceMap)map).getSourcesContent());
            } else {
                int n = ((FlatSourceMap)map).getSources().size();
                int i = 0;
                while (i < n) {
                    int it = i++;
                    boolean bl = false;
                    sourcesContent.add(null);
                }
            }
            List<Integer> list = ((FlatSourceMap)map).getIgnoreList();
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl = false;
                    ignoreList.add(sourcesOffset + it);
                }
            }
            List<String> list2 = ((FlatSourceMap)map).getNames();
            if (list2 != null) {
                List<String> it = list2;
                boolean bl = false;
                names.addAll((Collection<String>)it);
            }
            SourceMapDecoderKt.readMappings(((FlatSourceMap)map).getMappings(), mappings, ((FlatSourceMap)map).getNames(), sourcesOffset, lineOffset, columnOffset, stopLine, stopColumn, lastEntry2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final void readMappings(CharSequence value, List<MutableEntry> mappings, List<String> names, int sourcesOffset, int lineOffset, int columnOffset, int stopLine, int stopColumn, MutableEntry lastEntry) {
        if (value.length() == 0) {
            return;
        }
        int line = 0;
        int column = 0;
        CharSequenceIterator charIterator = new CharSequenceIterator(value);
        int sourceIndex = sourcesOffset;
        int sourceLine = 0;
        int sourceColumn = 0;
        int nameIndex = 0;
        Ref.ObjectRef prevEntry = new Ref.ObjectRef();
        prevEntry.element = lastEntry;
        while (charIterator.hasNext()) {
            if (charIterator.peek() == ',') {
                charIterator.next();
            } else {
                while (charIterator.peek() == ';') {
                    ++line;
                    column = 0;
                    charIterator.next();
                    if (charIterator.hasNext()) continue;
                    return;
                }
            }
            int lineI = lineOffset + line;
            int cOffset = line == 0 ? columnOffset : 0;
            int colI = cOffset + (column += Base64VLQ.INSTANCE.decode(charIterator));
            if (lineI >= stopLine && colI >= stopColumn) {
                return;
            }
            if (SourceMapDecoderKt.isSeparator(charIterator)) {
                SourceMapDecoderKt.readMappings$addEntry((Ref.ObjectRef<MutableEntry>)prevEntry, mappings, new UnmappedEntry(lineI, colI));
                continue;
            }
            int sourceIndexDelta = Base64VLQ.INSTANCE.decode(charIterator);
            if (sourceIndexDelta != 0) {
                sourceIndex += sourceIndexDelta;
            }
            sourceLine += Base64VLQ.INSTANCE.decode(charIterator);
            sourceColumn += Base64VLQ.INSTANCE.decode(charIterator);
            MutableEntry entry = null;
            if (SourceMapDecoderKt.isSeparator(charIterator)) {
                entry = new UnnamedEntry(lineI, colI, sourceIndex, sourceLine, sourceColumn);
            } else {
                boolean bl;
                nameIndex += Base64VLQ.INSTANCE.decode(charIterator);
                boolean bl2 = bl = names != null;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                List<String> list = names;
                Intrinsics.checkNotNull(list);
                entry = new NamedEntry(list.get(nameIndex), lineI, colI, sourceIndex, sourceLine, sourceColumn);
            }
            SourceMapDecoderKt.readMappings$addEntry((Ref.ObjectRef<MutableEntry>)prevEntry, mappings, entry);
        }
    }

    private static final boolean isSeparator(CharSequenceIterator charIterator) {
        if (!charIterator.hasNext()) {
            return true;
        }
        char current = charIterator.peek();
        return current == ',' || current == ';';
    }

    @Deprecated(message="This function isn not a part of the public API and will be removed in the future")
    @JvmOverloads
    @Nullable
    public static final SourceMap decodeSourceMapSafely(@NotNull CharSequence sourceMapData, boolean trimFileScheme, @Nullable Url baseUrl, boolean baseUrlIsFile) {
        Intrinsics.checkNotNullParameter((Object)sourceMapData, (String)"sourceMapData");
        return SourceMapDecoderKt.decodeSourceMapSafely$default(sourceMapData, trimFileScheme, baseUrl, baseUrlIsFile, false, 16, null);
    }

    private static final SourceResolver decodeSourceMapSafely$lambda$0(Url $baseUrl, boolean $baseUrlIsFile, boolean $transformToLocalFileUrlIfPossible, List sourceUrls) {
        Intrinsics.checkNotNullParameter((Object)sourceUrls, (String)"sourceUrls");
        return new SourceResolver(sourceUrls, $baseUrl, $baseUrlIsFile, $transformToLocalFileUrlIfPossible);
    }

    private static final void readMappings$addEntry(Ref.ObjectRef<MutableEntry> prevEntry, List<MutableEntry> $mappings, MutableEntry entry) {
        if (prevEntry.element != null) {
            Object object = prevEntry.element;
            Intrinsics.checkNotNull((Object)object);
            ((MutableEntry)object).setNextGenerated(entry);
        }
        prevEntry.element = entry;
        $mappings.add(entry);
    }
}

