/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.ui;

import com.intellij.javaee.JavaeeIcons;
import com.intellij.javaee.web.WebRoot;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class WebPathChooserDescriptor
extends FileChooserDescriptor {
    private final List<? extends WebRoot> myWebRoots;

    public WebPathChooserDescriptor(boolean chooseFiles, boolean chooseFolders, boolean chooseJars, boolean chooseJarsAsFiles, boolean chooseJarContents, boolean chooseMultiple, List<? extends WebRoot> webRoots) {
        super(chooseFiles, chooseFolders, chooseJars, chooseJarsAsFiles, chooseJarContents, chooseMultiple);
        this.myWebRoots = webRoots;
    }

    public Icon getIcon(VirtualFile file) {
        return this.findWebRoot(file) != null ? WebPathChooserDescriptor.dressIcon((VirtualFile)file, (Icon)JavaeeIcons.WEB_FOLDER_CLOSED) : super.getIcon(file);
    }

    public String getName(VirtualFile file) {
        WebRoot webRoot = this.findWebRoot(file);
        return webRoot != null ? webRoot.getRelativePath() : super.getName(file);
    }

    @Nullable
    public String getComment(VirtualFile file) {
        WebRoot webRoot = this.findWebRoot(file);
        return webRoot != null ? webRoot.getPresentableUrl() : super.getComment(file);
    }

    @Nullable
    private WebRoot findWebRoot(VirtualFile file) {
        for (WebRoot webRoot : this.myWebRoots) {
            if (!Comparing.equal((Object)webRoot.getFile(), (Object)file)) continue;
            return webRoot;
        }
        return null;
    }
}

