/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.performance.CollectionsListSettings;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class CollectionAddAllCanBeReplacedWithConstructorInspection
extends AbstractBaseJavaLocalInspectionTool {
    private final CollectionsListSettings mySettings = new CollectionsListSettings(this){

        protected Collection<String> getDefaultSettings() {
            return Collections.emptyList();
        }
    };

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            CollectionAddAllCanBeReplacedWithConstructorInspection.$$$reportNull$$$0(0);
        }
        this.mySettings.writeSettings(node);
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = this.mySettings.getOptionPane();
        if (optPane == null) {
            CollectionAddAllCanBeReplacedWithConstructorInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = this.mySettings.getOptionController();
        if (optionController == null) {
            CollectionAddAllCanBeReplacedWithConstructorInspection.$$$reportNull$$$0(2);
        }
        return optionController;
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            CollectionAddAllCanBeReplacedWithConstructorInspection.$$$reportNull$$$0(3);
        }
        this.mySettings.readSettings(node);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            CollectionAddAllCanBeReplacedWithConstructorInspection.$$$reportNull$$$0(4);
        }
        if (session == null) {
            CollectionAddAllCanBeReplacedWithConstructorInspection.$$$reportNull$$$0(5);
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                PsiNewExpression assignmentExpression;
                if (expression == null) {
                    2.$$$reportNull$$$0(0);
                }
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                PsiElement nameElement = methodExpression.getReferenceNameElement();
                String methodName = methodExpression.getReferenceName();
                if (nameElement == null || !"addAll".equals(methodName) && !"putAll".equals(methodName)) {
                    return;
                }
                PsiExpression[] args = expression.getArgumentList().getExpressions();
                if (args.length != 1) {
                    return;
                }
                PsiExpressionStatement parent = (PsiExpressionStatement)ObjectUtils.tryCast((Object)expression.getParent(), PsiExpressionStatement.class);
                if (parent == null) {
                    return;
                }
                PsiLocalVariable variable = ExpressionUtils.resolveLocalVariable((PsiExpression)methodExpression.getQualifierExpression());
                if (variable == null) {
                    return;
                }
                if (PsiUtil.resolveClassInClassTypeOnly((PsiType)variable.getType()) == null) {
                    return;
                }
                if (CollectionAddAllCanBeReplacedWithConstructorInspection.statementHasSubsequentAddAll((PsiElement)parent, variable, methodName)) {
                    return;
                }
                PsiType argType = args[0].getType();
                if (!InheritanceUtil.isInheritor((PsiType)argType, (String)("putAll".equals(methodName) ? "java.util.Map" : "java.util.Collection"))) {
                    return;
                }
                ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus((PsiVariable)variable, (PsiStatement)parent);
                if (status == ControlFlowUtils.InitializerUsageStatus.DECLARED_JUST_BEFORE || status == ControlFlowUtils.InitializerUsageStatus.AT_WANTED_PLACE_ONLY) {
                    if (!CollectionAddAllCanBeReplacedWithConstructorInspection.this.isCollectionConstructor(variable.getInitializer())) {
                        return;
                    }
                    assignmentExpression = (PsiNewExpression)variable.getInitializer();
                } else {
                    assignmentExpression = CollectionAddAllCanBeReplacedWithConstructorInspection.this.getPreviousAssignment(variable, (PsiStatement)parent);
                }
                if (assignmentExpression == null || !CollectionAddAllCanBeReplacedWithConstructorInspection.isAddAllReplaceable((PsiExpression)expression, assignmentExpression)) {
                    return;
                }
                if (this.mayInheritComparator(args, argType, assignmentExpression)) {
                    return;
                }
                PsiMethod method = expression.resolveMethod();
                if (method != null) {
                    holder.registerProblem(nameElement, QuickFixBundle.message((String)"collection.addall.can.be.replaced.with.constructor.fix.description", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceAddAllWithConstructorFix(assignmentExpression, expression, methodName)});
                }
            }

            private boolean mayInheritComparator(PsiExpression[] args, PsiType argType, PsiNewExpression assignmentExpression) {
                String name;
                PsiType type = assignmentExpression.getType();
                PsiClass collectionType = Objects.requireNonNull(PsiUtil.resolveClassInClassTypeOnly((PsiType)type));
                return switch (name = Objects.requireNonNull(collectionType.getQualifiedName())) {
                    case "java.util.TreeSet", "java.util.concurrent.ConcurrentSkipListSet" -> InheritanceUtil.isInheritor((PsiType)argType, (String)"java.util.SortedSet");
                    case "java.util.TreeMap", "java.util.concurrent.ConcurrentSkipListMap" -> InheritanceUtil.isInheritor((PsiType)argType, (String)"java.util.SortedMap");
                    case "java.util.PriorityQueue", "java.util.concurrent.PriorityBlockingQueue" -> {
                        TypeConstraint constraint = TypeConstraint.fromDfType((DfType)CommonDataflow.getDfType((PsiExpression)args[0]));
                        PsiClassType sortedSet = JavaPsiFacade.getElementFactory((Project)holder.getProject()).createTypeByFQClassName("java.util.SortedSet");
                        if (constraint.meet(TypeConstraints.instanceOf((PsiType)sortedSet)) != TypeConstraints.BOTTOM || constraint.meet(TypeConstraints.instanceOf((PsiType)type)) != TypeConstraints.BOTTOM) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> false;
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/CollectionAddAllCanBeReplacedWithConstructorInspection$2", "visitMethodCallExpression"));
            }
        };
    }

    private PsiNewExpression getPreviousAssignment(PsiLocalVariable variable, PsiStatement statement) {
        do {
            if ((statement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class)) == null) {
                return null;
            }
            PsiExpression expression = ExpressionUtils.getAssignmentTo((PsiElement)statement, (PsiVariable)variable);
            if (!this.isCollectionConstructor(expression)) continue;
            return (PsiNewExpression)expression;
        } while (!VariableAccessUtils.variableIsUsed((PsiVariable)variable, (PsiElement)statement));
        return null;
    }

    private static boolean statementHasSubsequentAddAll(@NotNull PsiElement statement, @NotNull PsiLocalVariable referent, @NotNull String previousMethodName) {
        PsiMethod method;
        PsiReferenceExpression ref;
        PsiMethodCallExpression siblingMethodCall;
        PsiExpression qualifier;
        PsiExpressionStatement expressionStatement;
        PsiExpression siblingExpression;
        PsiElement sibling;
        if (statement == null) {
            CollectionAddAllCanBeReplacedWithConstructorInspection.$$$reportNull$$$0(6);
        }
        if (referent == null) {
            CollectionAddAllCanBeReplacedWithConstructorInspection.$$$reportNull$$$0(7);
        }
        if (previousMethodName == null) {
            CollectionAddAllCanBeReplacedWithConstructorInspection.$$$reportNull$$$0(8);
        }
        return (sibling = PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class)) instanceof PsiExpressionStatement && (siblingExpression = (expressionStatement = (PsiExpressionStatement)sibling).getExpression()) instanceof PsiMethodCallExpression && (qualifier = (siblingMethodCall = (PsiMethodCallExpression)siblingExpression).getMethodExpression().getQualifierExpression()) instanceof PsiReferenceExpression && referent.isEquivalentTo((ref = (PsiReferenceExpression)qualifier).resolve()) && (method = siblingMethodCall.resolveMethod()) != null && method.getName().equals(previousMethodName);
    }

    private boolean isCollectionConstructor(PsiExpression initializer) {
        if (!(initializer instanceof PsiNewExpression)) {
            return false;
        }
        PsiNewExpression newExpression = (PsiNewExpression)initializer;
        PsiJavaCodeReferenceElement classReference = newExpression.getClassReference();
        if (classReference == null) {
            return false;
        }
        PsiClass initializerClass = (PsiClass)classReference.resolve();
        if (initializerClass == null) {
            return false;
        }
        if (!(ConstructionUtils.isCollectionWithCopyConstructor((PsiClass)initializerClass) || this.mySettings.getCollectionClassesRequiringCapacity().contains(initializerClass.getQualifiedName()) && CollectionAddAllCanBeReplacedWithConstructorInspection.hasProperConstructor(initializerClass))) {
            return false;
        }
        PsiExpressionList argumentList = newExpression.getArgumentList();
        return argumentList != null && argumentList.isEmpty();
    }

    private static boolean hasProperConstructor(PsiClass psiClass) {
        for (PsiMethod psiMethod : psiClass.getConstructors()) {
            PsiType type;
            PsiParameter parameter;
            PsiTypeElement typeElement;
            PsiParameterList parameterList = psiMethod.getParameterList();
            if (parameterList.getParametersCount() != 1 || (typeElement = (parameter = Objects.requireNonNull(parameterList.getParameter(0))).getTypeElement()) == null || !InheritanceUtil.isInheritor((PsiType)(type = typeElement.getType()), (String)"java.util.Collection") && !InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Map")) continue;
            return true;
        }
        return false;
    }

    private static boolean isAddAllReplaceable(PsiExpression addAllExpression, PsiNewExpression newExpression) {
        final boolean[] isReplaceable = new boolean[]{true};
        final PsiFile newExpressionContainingFile = newExpression.getContainingFile();
        final TextRange newExpressionTextRange = newExpression.getTextRange();
        addAllExpression.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                PsiVariable variable;
                LocalSearchScope useScope;
                PsiElement resolved;
                if (expression == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (PsiUtil.isJvmLocalVariable((PsiElement)(resolved = expression.resolve())) && !(useScope = (LocalSearchScope)(variable = (PsiVariable)resolved).getUseScope()).containsRange(newExpressionContainingFile, newExpressionTextRange)) {
                    isReplaceable[0] = false;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/CollectionAddAllCanBeReplacedWithConstructorInspection$3", "visitReferenceExpression"));
            }
        });
        return isReplaceable[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/CollectionAddAllCanBeReplacedWithConstructorInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousMethodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/CollectionAddAllCanBeReplacedWithConstructorInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionController";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "statementHasSubsequentAddAll";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static class ReplaceAddAllWithConstructorFix
    extends PsiUpdateModCommandQuickFix {
        private final SmartPsiElementPointer<PsiMethodCallExpression> myMethodCallExpression;
        private final SmartPsiElementPointer<PsiNewExpression> myNewExpression;
        private final String methodName;

        ReplaceAddAllWithConstructorFix(PsiNewExpression newExpression, PsiMethodCallExpression expression, String methodName) {
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)newExpression.getProject());
            this.myMethodCallExpression = smartPointerManager.createSmartPsiElementPointer((PsiElement)expression);
            this.myNewExpression = smartPointerManager.createSmartPsiElementPointer((PsiElement)newExpression);
            this.methodName = methodName;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = QuickFixBundle.message((String)"collection.addall.can.be.replaced.with.constructor.fix.name", (Object[])new Object[]{this.methodName});
            if (string == null) {
                ReplaceAddAllWithConstructorFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message((String)"collection.addall.can.be.replaced.with.constructor.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                ReplaceAddAllWithConstructorFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiVariable variable;
            PsiElement parent;
            PsiMethodCallExpression methodCallExpression;
            if (project == null) {
                ReplaceAddAllWithConstructorFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ReplaceAddAllWithConstructorFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ReplaceAddAllWithConstructorFix.$$$reportNull$$$0(4);
            }
            if ((methodCallExpression = (PsiMethodCallExpression)updater.getWritable((PsiElement)((PsiMethodCallExpression)this.myMethodCallExpression.getElement()))) == null) {
                return;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)methodCallExpression.getParent(), PsiExpressionStatement.class);
            if (expressionStatement == null) {
                return;
            }
            PsiNewExpression newExpression = (PsiNewExpression)updater.getWritable((PsiElement)((PsiNewExpression)this.myNewExpression.getElement()));
            if (newExpression == null) {
                return;
            }
            PsiElement psiElement = parent = PsiUtil.skipParenthesizedExprUp((PsiElement)newExpression.getParent());
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PsiVariable.class, PsiAssignmentExpression.class}, (Object)psiElement, n)) {
                case 0: {
                    PsiVariable psiVariable;
                    PsiVariable psiVariable2 = psiVariable = (PsiVariable)psiElement;
                    break;
                }
                case 1: {
                    PsiAssignmentExpression expression = (PsiAssignmentExpression)psiElement;
                    PsiVariable psiVariable2 = ExpressionUtils.resolveLocalVariable((PsiExpression)expression.getLExpression());
                    break;
                }
                default: {
                    PsiVariable psiVariable2 = variable = null;
                }
            }
            if (variable == null) {
                return;
            }
            PsiJavaCodeReferenceElement reference = newExpression.getClassReference();
            if (reference == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            PsiExpression parameter = methodCallExpression.getArgumentList().getExpressions()[0];
            String replacement = "new " + reference.getText() + "(" + ct.text((PsiElement)parameter) + ")";
            if (parent instanceof PsiAssignmentExpression) {
                ct.delete(parent);
            } else {
                PsiElement scope;
                if (variable.getParent() instanceof PsiDeclarationStatement && ((PsiDeclarationStatement)variable.getParent()).getDeclaredElements().length == 1 && (scope = PsiTreeUtil.getParentOfType((PsiElement)expressionStatement, (Class[])new Class[]{PsiMember.class, PsiStatement.class, PsiLambdaExpression.class})) != null && ContainerUtil.and((Iterable)VariableAccessUtils.getVariableReferences((PsiVariable)variable), ref -> PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)ref, (boolean)true))) {
                    PsiDeclarationStatement newDeclaration = JavaPsiFacade.getElementFactory((Project)project).createVariableDeclarationStatement("x", (PsiType)PsiTypes.intType(), null, (PsiElement)methodCallExpression);
                    PsiVariable newVariable = (PsiVariable)newDeclaration.getDeclaredElements()[0].replace((PsiElement)variable);
                    ct.delete((PsiElement)variable);
                    ct.replace((PsiElement)Objects.requireNonNull(newVariable.getInitializer()), replacement);
                    ct.replaceAndRestoreComments((PsiElement)expressionStatement, (PsiElement)newDeclaration);
                    return;
                }
                ct.delete((PsiElement)newExpression);
            }
            ct.replaceAndRestoreComments((PsiElement)methodCallExpression, variable.getName() + "=" + replacement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/CollectionAddAllCanBeReplacedWithConstructorInspection$ReplaceAddAllWithConstructorFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/CollectionAddAllCanBeReplacedWithConstructorInspection$ReplaceAddAllWithConstructorFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

