/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultAnnotationParamInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DefaultAnnotationParamInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitNameValuePair(@NotNull PsiNameValuePair pair) {
                if (pair == null) {
                    1.$$$reportNull$$$0(0);
                }
                PsiAnnotationMemberValue value = pair.getValue();
                PsiReference reference = pair.getReference();
                if (reference == null) {
                    return;
                }
                PsiElement element = reference.resolve();
                if (!(element instanceof PsiAnnotationMethod)) {
                    return;
                }
                PsiAnnotationMemberValue defaultValue = ((PsiAnnotationMethod)element).getDefaultValue();
                if (defaultValue == null) {
                    return;
                }
                if (AnnotationUtil.equal((PsiAnnotationMemberValue)value, (PsiAnnotationMemberValue)defaultValue)) {
                    PsiElement elementParent = element.getParent();
                    if (elementParent instanceof PsiClass) {
                        String qualifiedName = ((PsiClass)elementParent).getQualifiedName();
                        String name = ((PsiAnnotationMethod)element).getName();
                        if (ContainerUtil.exists((Iterable)IgnoreAnnotationParamSupport.EP_NAME.getExtensionList(), ext -> ext.ignoreAnnotationParam(qualifiedName, name))) {
                            return;
                        }
                    }
                    holder.registerProblem((PsiElement)value, JavaBundle.message((String)"inspection.message.redundant.default.parameter.value.assignment", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{DefaultAnnotationParamInspection.createRemoveParameterFix()});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pair", "com/intellij/codeInspection/DefaultAnnotationParamInspection$1", "visitNameValuePair"));
            }
        };
    }

    @NotNull
    private static LocalQuickFix createRemoveParameterFix() {
        return new PsiUpdateModCommandQuickFix(){

            @Nls
            @NotNull
            public String getFamilyName() {
                String string = JavaBundle.message((String)"quickfix.family.remove.redundant.parameter", (Object[])new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (element == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (updater == null) {
                    2.$$$reportNull$$$0(3);
                }
                element.getParent().delete();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/DefaultAnnotationParamInspection$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "updater";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/DefaultAnnotationParamInspection$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2, 3 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/DefaultAnnotationParamInspection", "buildVisitor"));
    }

    public static interface IgnoreAnnotationParamSupport {
        public static final ExtensionPointName<IgnoreAnnotationParamSupport> EP_NAME = ExtensionPointName.create((String)"com.intellij.lang.jvm.ignoreAnnotationParamSupport");

        default public boolean ignoreAnnotationParam(@Nullable String annotationFQN, @NotNull String annotationParameterName) {
            if (annotationParameterName == null) {
                IgnoreAnnotationParamSupport.$$$reportNull$$$0(0);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationParameterName", "com/intellij/codeInspection/DefaultAnnotationParamInspection$IgnoreAnnotationParamSupport", "ignoreAnnotationParam"));
        }
    }
}

