/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDefaultCaseLabelElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.SwitchUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnhancedSwitchBackwardMigrationInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            EnhancedSwitchBackwardMigrationInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitSwitchExpression(@NotNull PsiSwitchExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!1.isNonemptyRuleFormatSwitch((PsiSwitchBlock)expression)) {
                    return;
                }
                if (EnhancedSwitchBackwardMigrationInspection.findReplacer((PsiSwitchBlock)expression) == null) {
                    return;
                }
                String message = JavaBundle.message((String)"inspection.switch.expression.backward.expression.migration.inspection.name", (Object[])new Object[0]);
                holder.registerProblem(expression.getFirstChild(), message, new LocalQuickFix[]{new ReplaceWithOldStyleSwitchFix()});
            }

            public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!1.isNonemptyRuleFormatSwitch((PsiSwitchBlock)statement)) {
                    return;
                }
                if (EnhancedSwitchBackwardMigrationInspection.findReplacer((PsiSwitchBlock)statement) == null) {
                    return;
                }
                String message = JavaBundle.message((String)"inspection.switch.expression.backward.statement.migration.inspection.name", (Object[])new Object[0]);
                holder.registerProblem(statement.getFirstChild(), message, new LocalQuickFix[]{new ReplaceWithOldStyleSwitchFix()});
            }

            private static boolean isNonemptyRuleFormatSwitch(PsiSwitchBlock block) {
                PsiSwitchLabelStatementBase label = (PsiSwitchLabelStatementBase)PsiTreeUtil.getChildOfType((PsiElement)block.getBody(), PsiSwitchLabelStatementBase.class);
                return label instanceof PsiSwitchLabeledRuleStatement;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/EnhancedSwitchBackwardMigrationInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSwitchExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSwitchStatement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static Replacer findReplacer(@NotNull PsiSwitchBlock block) {
        Replacer replacer;
        if (block == null) {
            EnhancedSwitchBackwardMigrationInspection.$$$reportNull$$$0(1);
        }
        if ((replacer = EnhancedSwitchBackwardMigrationInspection.inspectReturningSwitch(block)) != null) {
            return replacer;
        }
        replacer = EnhancedSwitchBackwardMigrationInspection.inspectVariableSavingSwitch(block);
        if (replacer != null) {
            return replacer;
        }
        replacer = EnhancedSwitchBackwardMigrationInspection.inspectSwitchStatement(block);
        if (replacer != null) {
            return replacer;
        }
        replacer = EnhancedSwitchBackwardMigrationInspection.inspectAssignmentSwitch(block);
        if (replacer != null) {
            return replacer;
        }
        return null;
    }

    private static Replacer inspectReturningSwitch(@NotNull PsiSwitchBlock switchBlock) {
        if (switchBlock == null) {
            EnhancedSwitchBackwardMigrationInspection.$$$reportNull$$$0(2);
        }
        if (!(switchBlock instanceof PsiSwitchExpression)) {
            return null;
        }
        PsiElement returnStatement = switchBlock.getParent();
        return returnStatement instanceof PsiReturnStatement ? new ReturningReplacer((PsiReturnStatement)returnStatement) : null;
    }

    private static Replacer inspectVariableSavingSwitch(@NotNull PsiSwitchBlock switchBlock) {
        if (switchBlock == null) {
            EnhancedSwitchBackwardMigrationInspection.$$$reportNull$$$0(3);
        }
        if (!(switchBlock instanceof PsiSwitchExpression)) {
            return null;
        }
        PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)switchBlock.getParent(), PsiLocalVariable.class);
        if (variable == null) {
            return null;
        }
        return new VariableSavingReplacer(variable);
    }

    private static Replacer inspectAssignmentSwitch(@NotNull PsiSwitchBlock switchBlock) {
        if (switchBlock == null) {
            EnhancedSwitchBackwardMigrationInspection.$$$reportNull$$$0(4);
        }
        if (!(switchBlock instanceof PsiSwitchExpression)) {
            return null;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)switchBlock.getParent(), PsiAssignmentExpression.class);
        if (assignment == null || !(assignment.getLExpression() instanceof PsiReferenceExpression)) {
            return null;
        }
        return new AssignmentReplacer(assignment);
    }

    private static Replacer inspectSwitchStatement(@NotNull PsiSwitchBlock switchBlock) {
        if (switchBlock == null) {
            EnhancedSwitchBackwardMigrationInspection.$$$reportNull$$$0(5);
        }
        if (!(switchBlock instanceof PsiSwitchStatement)) {
            return null;
        }
        return new SwitchStatementReplacer();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchBlock";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/EnhancedSwitchBackwardMigrationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findReplacer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "inspectReturningSwitch";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "inspectVariableSavingSwitch";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "inspectAssignmentSwitch";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "inspectSwitchStatement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static interface Replacer {
        public void replace(PsiSwitchBlock var1);
    }

    private static final class ReturningReplacer
    implements Replacer {
        private final PsiReturnStatement myReturnStatement;

        private ReturningReplacer(PsiReturnStatement returnStatement) {
            this.myReturnStatement = returnStatement;
        }

        @Override
        public void replace(PsiSwitchBlock block) {
            CommentTracker ct = new CommentTracker();
            PsiSwitchStatement switchStatement = new ReturnSwitchGenerator(block).generate(ct);
            if (switchStatement == null) {
                return;
            }
            ct.markUnchanged((PsiElement)block);
            ct.replaceAndRestoreComments((PsiElement)this.myReturnStatement, (PsiElement)switchStatement);
        }
    }

    private static final class VariableSavingReplacer
    implements Replacer {
        private final PsiLocalVariable myVariable;

        private VariableSavingReplacer(PsiLocalVariable variable) {
            this.myVariable = variable;
        }

        @Override
        public void replace(PsiSwitchBlock block) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)block.getProject());
            PsiTypesUtil.replaceWithExplicitType((PsiTypeElement)this.myVariable.getTypeElement());
            CommentTracker ct = new CommentTracker();
            PsiSwitchStatement switchStatement = new VarSavingSwitchGenerator(block, this.myVariable.getName(), "=").generate(ct);
            ct.markUnchanged((PsiElement)block);
            PsiDeclarationStatement variableDeclaration = (PsiDeclarationStatement)factory.createStatementFromText(this.myVariable.getTypeElement().getText() + " " + this.myVariable.getName() + ";", (PsiElement)this.myVariable);
            ct.markUnchanged((PsiElement)switchStatement);
            PsiStatement declaration = (PsiStatement)ct.replaceAndRestoreComments(this.myVariable.getParent(), (PsiElement)variableDeclaration);
            BlockUtils.addAfter((PsiStatement)declaration, (PsiStatement)switchStatement);
        }
    }

    private static final class AssignmentReplacer
    implements Replacer {
        @NotNull
        private final PsiAssignmentExpression myAssignment;

        private AssignmentReplacer(@NotNull PsiAssignmentExpression assignment) {
            if (assignment == null) {
                AssignmentReplacer.$$$reportNull$$$0(0);
            }
            this.myAssignment = assignment;
        }

        @Override
        public void replace(PsiSwitchBlock block) {
            PsiExpression expression = this.myAssignment.getLExpression();
            if (!(expression instanceof PsiReferenceExpression)) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            String sign = this.myAssignment.getOperationSign().getText();
            PsiSwitchStatement switchStatement = new VarSavingSwitchGenerator(block, expression.getText(), sign).generate(ct);
            ct.replaceAndRestoreComments(this.myAssignment.getParent(), (PsiElement)switchStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/intellij/codeInspection/EnhancedSwitchBackwardMigrationInspection$AssignmentReplacer", "<init>"));
        }
    }

    private static class SwitchStatementReplacer
    implements Replacer {
        private SwitchStatementReplacer() {
        }

        @Override
        public void replace(PsiSwitchBlock block) {
            CommentTracker ct = new CommentTracker();
            PsiSwitchStatement switchStatement = new SwitchStatementGenerator(block).generate(ct);
            if (switchStatement == null) {
                return;
            }
            PsiElement newStatement = block.replace((PsiElement)switchStatement);
            ct.insertCommentsBefore(newStatement);
        }
    }

    private static class SwitchStatementGenerator
    extends SwitchGenerator {
        SwitchStatementGenerator(PsiSwitchBlock switchBlock) {
            super(switchBlock);
        }

        @Override
        void handleYieldInside(@NotNull PsiYieldStatement yieldStatement, CommentTracker ct) {
            if (yieldStatement == null) {
                SwitchStatementGenerator.$$$reportNull$$$0(0);
            }
        }

        @Override
        String generateExpressionBranch(@NotNull PsiStatement statement, CommentTracker ct) {
            if (statement == null) {
                SwitchStatementGenerator.$$$reportNull$$$0(1);
            }
            if (ControlFlowUtils.statementMayCompleteNormally((PsiStatement)statement)) {
                return ct.text((PsiElement)statement) + "\nbreak;";
            }
            return ct.text((PsiElement)statement);
        }

        @Override
        String generateBlockBranch(@NotNull PsiStatement statement, CommentTracker ct) {
            if (statement == null) {
                SwitchStatementGenerator.$$$reportNull$$$0(2);
            }
            if (ControlFlowUtils.statementMayCompleteNormally((PsiStatement)statement)) {
                return super.generateBlockBranch(statement, ct) + "\nbreak;";
            }
            return super.generateBlockBranch(statement, ct);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "yieldStatement";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/EnhancedSwitchBackwardMigrationInspection$SwitchStatementGenerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleYieldInside";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generateExpressionBranch";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generateBlockBranch";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class VarSavingSwitchGenerator
    extends SwitchGenerator {
        @NotNull
        private final String myReferenceText;
        @NotNull
        private final String mySign;

        VarSavingSwitchGenerator(PsiSwitchBlock switchBlock, @NotNull String referenceText, @NotNull String sign) {
            if (referenceText == null) {
                VarSavingSwitchGenerator.$$$reportNull$$$0(0);
            }
            if (sign == null) {
                VarSavingSwitchGenerator.$$$reportNull$$$0(1);
            }
            super(switchBlock);
            this.myReferenceText = referenceText;
            this.mySign = sign;
        }

        @Override
        void handleYieldInside(@NotNull PsiYieldStatement yieldStatement, CommentTracker ct) {
            if (yieldStatement == null) {
                VarSavingSwitchGenerator.$$$reportNull$$$0(2);
            }
            PsiExpression valueExpression = yieldStatement.getExpression();
            assert (valueExpression != null);
            String assignText = this.myReferenceText + " " + this.mySign + " " + ct.text((PsiElement)valueExpression) + ";\n";
            PsiStatement assignment = this.myFactory.createStatementFromText(assignText, (PsiElement)valueExpression);
            PsiStatement newAssignment = (PsiStatement)ct.replace((PsiElement)yieldStatement, (PsiElement)assignment);
            BlockUtils.addAfter((PsiStatement)newAssignment, (PsiStatement)this.myFactory.createStatementFromText("break;", null));
        }

        @Override
        String generateExpressionBranch(@NotNull PsiStatement statement, CommentTracker ct) {
            if (statement == null) {
                VarSavingSwitchGenerator.$$$reportNull$$$0(3);
            }
            if (statement instanceof PsiThrowStatement) {
                return ct.text((PsiElement)statement);
            }
            return this.myReferenceText + " " + this.mySign + " " + ct.text((PsiElement)statement) + "\nbreak;";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sign";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "yieldStatement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/EnhancedSwitchBackwardMigrationInspection$VarSavingSwitchGenerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleYieldInside";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generateExpressionBranch";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ReturnSwitchGenerator
    extends SwitchGenerator {
        ReturnSwitchGenerator(PsiSwitchBlock switchBlock) {
            super(switchBlock);
        }

        @Override
        void handleYieldInside(@NotNull PsiYieldStatement yieldStatement, CommentTracker ct) {
            if (yieldStatement == null) {
                ReturnSwitchGenerator.$$$reportNull$$$0(0);
            }
            PsiExpression valueExpression = yieldStatement.getExpression();
            assert (valueExpression != null);
            PsiStatement replacement = this.myFactory.createStatementFromText("return " + ct.text((PsiElement)valueExpression) + ";", (PsiElement)yieldStatement);
            ct.replace((PsiElement)yieldStatement, (PsiElement)replacement);
        }

        @Override
        String generateExpressionBranch(@NotNull PsiStatement statement, CommentTracker ct) {
            if (statement == null) {
                ReturnSwitchGenerator.$$$reportNull$$$0(1);
            }
            if (statement instanceof PsiThrowStatement) {
                return ct.text((PsiElement)statement);
            }
            return "return " + ct.text((PsiElement)statement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "yieldStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/EnhancedSwitchBackwardMigrationInspection$ReturnSwitchGenerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleYieldInside";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generateExpressionBranch";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class SwitchGenerator {
        private final PsiSwitchBlock mySwitchBlock;
        final PsiElementFactory myFactory;

        SwitchGenerator(PsiSwitchBlock switchBlock) {
            this.mySwitchBlock = switchBlock;
            this.myFactory = JavaPsiFacade.getElementFactory((Project)this.mySwitchBlock.getProject());
        }

        PsiSwitchStatement generate(CommentTracker mainCommentTracker) {
            PsiSwitchBlock switchCopy = (PsiSwitchBlock)this.mySwitchBlock.copy();
            PsiExpression expression = switchCopy.getExpression();
            if (expression == null) {
                return null;
            }
            PsiCodeBlock body = switchCopy.getBody();
            if (body == null) {
                return null;
            }
            List rules = ContainerUtil.filterIsInstance((Object[])body.getStatements(), PsiSwitchLabeledRuleStatement.class);
            ArrayList<CommentTracker> branchTrackers = new ArrayList<CommentTracker>();
            IntArrayList caseCounts = new IntArrayList();
            StringJoiner joiner = new StringJoiner("\n");
            boolean addDefaultBranch = this.mySwitchBlock instanceof PsiSwitchExpression;
            if (this.mySwitchBlock.getExpression() != null) {
                addDefaultBranch &= !TypeConversionUtil.isBooleanType((PsiType)this.mySwitchBlock.getExpression().getType());
            }
            for (int i = 0; i < rules.size(); ++i) {
                PsiCaseLabelElementList labelElementList;
                PsiSwitchLabeledRuleStatement rule = (PsiSwitchLabeledRuleStatement)rules.get(i);
                CommentTracker ct = new CommentTracker();
                branchTrackers.add(ct);
                Object generate = SwitchGenerator.collectCommentsBefore((PsiElement)rule, mainCommentTracker);
                generate = (String)generate + this.generateBranch(rule, ct, switchCopy);
                if (i == rules.size() - 1) {
                    generate = (String)generate + SwitchGenerator.collectCommentsBefore((PsiElement)body.getRBrace(), mainCommentTracker);
                }
                int caseCount = (labelElementList = rule.getCaseLabelElementList()) == null ? 1 : labelElementList.getElementCount();
                caseCounts.add(caseCount);
                if (joiner.length() != 0 && ((String)generate).startsWith("\n")) {
                    generate = ((String)generate).substring(1);
                }
                joiner.add((CharSequence)generate);
                mainCommentTracker.markUnchanged((PsiElement)rule);
                addDefaultBranch &= !SwitchUtils.isDefaultLabel((PsiSwitchLabelStatementBase)rule);
            }
            if (addDefaultBranch) {
                joiner.add("default:throw new java.lang.IllegalArgumentException();");
            }
            String bodyText = joiner.toString();
            String switchText = "switch(" + mainCommentTracker.text((PsiElement)expression) + "){" + bodyText + "}";
            mainCommentTracker.grabComments((PsiElement)switchCopy);
            PsiSwitchStatement newBlock = (PsiSwitchStatement)this.myFactory.createStatementFromText(switchText, (PsiElement)this.mySwitchBlock);
            PsiCodeBlock newBody = newBlock.getBody();
            assert (newBody != null);
            List branches = ContainerUtil.filterIsInstance((Object[])newBody.getStatements(), PsiSwitchLabelStatement.class);
            int totalCaseStatements = 0;
            for (int i = 0; i < caseCounts.size(); ++i) {
                totalCaseStatements += caseCounts.getInt(i);
            }
            if (branches.size() != totalCaseStatements) {
                return newBlock;
            }
            int firstCaseInChainIndex = 0;
            for (int i = 0; i < branchTrackers.size(); ++i) {
                PsiSwitchLabelStatement branch = (PsiSwitchLabelStatement)branches.get(firstCaseInChainIndex);
                ((CommentTracker)branchTrackers.get(i)).insertCommentsBefore((PsiElement)branch);
                firstCaseInChainIndex += caseCounts.getInt(i);
            }
            return newBlock;
        }

        @NotNull
        private static String collectCommentsBefore(@Nullable PsiElement rule, @NotNull CommentTracker ct) {
            if (ct == null) {
                SwitchGenerator.$$$reportNull$$$0(0);
            }
            boolean commentFound = false;
            if (rule == null) {
                return "";
            }
            ArrayList<String> lists = new ArrayList<String>();
            PsiElement previous = rule.getPrevSibling();
            while (previous instanceof PsiComment || previous instanceof PsiWhiteSpace) {
                if (previous instanceof PsiComment) {
                    commentFound = true;
                }
                lists.add(ct.text(previous));
                previous = previous.getPrevSibling();
            }
            if (!commentFound) {
                return "";
            }
            Collections.reverse(lists);
            String string = String.join((CharSequence)"", lists);
            if (string == null) {
                SwitchGenerator.$$$reportNull$$$0(1);
            }
            return string;
        }

        private String generateBranch(PsiSwitchLabeledRuleStatement rule, CommentTracker ct, PsiSwitchBlock switchBlock) {
            String caseExpressionsText;
            ((StreamEx)StreamEx.ofTree((Object)rule, el -> StreamEx.of((Object[])el.getChildren())).select(PsiYieldStatement.class).filter(statement -> statement.getExpression() != null && statement.findEnclosingExpression() == switchBlock)).forEach(statement -> this.handleYieldInside((PsiYieldStatement)statement, ct));
            PsiCaseLabelElementList labelElementList = rule.getCaseLabelElementList();
            if (labelElementList == null || labelElementList.getElementCount() == 0) {
                caseExpressionsText = SwitchUtils.isDefaultLabel((PsiSwitchLabelStatementBase)rule) ? "default:" : "case:";
            } else {
                Object[] labelElements = labelElementList.getElements();
                if (ContainerUtil.exists((Object[])labelElements, label -> label instanceof PsiPattern)) {
                    PsiExpression guardExpression = rule.getGuardExpression();
                    String guardText = guardExpression == null ? "" : " when " + ct.text((PsiElement)guardExpression);
                    caseExpressionsText = StreamEx.of((Object[])labelElements).map(e -> ct.text((PsiElement)e)).joining((CharSequence)",", (CharSequence)"case ", (CharSequence)(guardText + ":"));
                } else {
                    caseExpressionsText = StreamEx.of((Object[])labelElements).map(e -> e instanceof PsiDefaultCaseLabelElement ? ct.text((PsiElement)e) + ":" : "case " + ct.text((PsiElement)e) + ":").joining((CharSequence)"\n");
                }
            }
            PsiStatement body = rule.getBody();
            String finalBody = body == null ? "" : (!(body instanceof PsiBlockStatement) ? this.generateExpressionBranch(body, ct) : this.generateBlockBranch(body, ct));
            ct.grabComments((PsiElement)rule);
            return caseExpressionsText + finalBody;
        }

        String generateBlockBranch(@NotNull PsiStatement statement, CommentTracker ct) {
            if (statement == null) {
                SwitchGenerator.$$$reportNull$$$0(2);
            }
            if (statement instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)statement;
                StringBuilder builder = new StringBuilder();
                PsiCodeBlock block = blockStatement.getCodeBlock();
                for (PsiJavaToken element = block.getLBrace(); element != null && element != block.getRBrace(); element = element.getNextSibling()) {
                    if (element == block.getLBrace() || element == block.getRBrace()) continue;
                    builder.append(ct.text((PsiElement)element));
                }
                return builder.toString().strip();
            }
            return ct.text((PsiElement)statement);
        }

        abstract void handleYieldInside(@NotNull PsiYieldStatement var1, CommentTracker var2);

        abstract String generateExpressionBranch(@NotNull PsiStatement var1, CommentTracker var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ct";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/EnhancedSwitchBackwardMigrationInspection$SwitchGenerator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/EnhancedSwitchBackwardMigrationInspection$SwitchGenerator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectCommentsBefore";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "collectCommentsBefore";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "generateBlockBranch";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class ReplaceWithOldStyleSwitchFix
    extends PsiUpdateModCommandQuickFix {
        private ReplaceWithOldStyleSwitchFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.replace.with.old.style.switch.statement.fix.name", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithOldStyleSwitchFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiSwitchBlock switchBlock;
            if (project == null) {
                ReplaceWithOldStyleSwitchFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceWithOldStyleSwitchFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithOldStyleSwitchFix.$$$reportNull$$$0(3);
            }
            if ((switchBlock = (PsiSwitchBlock)ObjectUtils.tryCast((Object)(element instanceof PsiSwitchBlock ? element : element.getParent()), PsiSwitchBlock.class)) == null) {
                return;
            }
            Replacer replacer = EnhancedSwitchBackwardMigrationInspection.findReplacer(switchBlock);
            if (replacer == null) {
                return;
            }
            replacer.replace(switchBlock);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/EnhancedSwitchBackwardMigrationInspection$ReplaceWithOldStyleSwitchFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/EnhancedSwitchBackwardMigrationInspection$ReplaceWithOldStyleSwitchFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

