/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.MigrateToJavaLangIoInspection;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.JavaBundle;
import com.intellij.java.codeserver.core.JavaPsiModuleUtil;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ipp.imports.ReplaceOnDemandImportIntention;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class ExplicitToImplicitClassMigrationInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean convertToIo = true;

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.IMPLICIT_CLASSES);
        if (set == null) {
            ExplicitToImplicitClassMigrationInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"convertToIo", (String)JavaBundle.message((String)"inspection.explicit.to.implicit.convert.to.io", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ExplicitToImplicitClassMigrationInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            ExplicitToImplicitClassMigrationInspection.$$$reportNull$$$0(2);
        }
        return new JavaElementVisitor(){

            public void visitClass(@NotNull PsiClass aClass) {
                PsiReference first;
                SearchScope scope;
                boolean underRoot;
                if (aClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (aClass.isInterface() || aClass.isRecord() || aClass.isEnum() || PsiUtil.isLocalOrAnonymousClass((PsiClass)aClass)) {
                    return;
                }
                if (aClass.hasAnnotations()) {
                    return;
                }
                PsiElement lBrace = aClass.getLBrace();
                PsiElement rBrace = aClass.getRBrace();
                if (lBrace == null || rBrace == null) {
                    return;
                }
                if (aClass.getContainingClass() != null) {
                    return;
                }
                PsiFile file = aClass.getContainingFile();
                if (!(file instanceof PsiJavaFile)) {
                    return;
                }
                PsiJavaFile javaFile = (PsiJavaFile)file;
                boolean bl = underRoot = javaFile.getPackageStatement() == null;
                if (javaFile.getClasses().length != 1) {
                    return;
                }
                PsiJavaModule javaModule = JavaPsiModuleUtil.findDescriptorByElement((PsiElement)aClass);
                if (javaModule != null) {
                    return;
                }
                String fileName = file.getName();
                if (!fileName.endsWith(".java")) {
                    return;
                }
                String className = aClass.getName();
                if (className == null || !className.equals(fileName.substring(0, fileName.length() - ".java".length()))) {
                    return;
                }
                if (aClass.hasTypeParameters()) {
                    return;
                }
                if (!PsiMethodUtil.hasMainMethod((PsiClass)aClass)) {
                    return;
                }
                PsiClassType[] extendsListTypes = aClass.getExtendsListTypes();
                if (extendsListTypes.length != 0 && !1.onlyObjectExtends(extendsListTypes) || aClass.getImplementsListTypes().length != 0) {
                    return;
                }
                if (aClass.hasModifierProperty("sealed") || aClass.hasModifierProperty("abstract")) {
                    return;
                }
                PsiMethod[] constructors = aClass.getConstructors();
                if (constructors.length > 0) {
                    if (constructors.length > 1) {
                        return;
                    }
                    PsiMethod constructor = constructors[0];
                    if (constructor.hasParameters() || constructor.hasModifierProperty("private") || constructor.getBody() != null && constructor.getBody().getStatements().length > 0) {
                        return;
                    }
                }
                Project project = holder.getProject();
                PsiIdentifier classIdentifier = aClass.getNameIdentifier();
                if (classIdentifier == null) {
                    return;
                }
                if (TestFrameworks.getInstance().isTestClass(aClass) || UnusedSymbolUtil.isImplicitUsage((Project)aClass.getProject(), (PsiModifierListOwner)aClass)) {
                    return;
                }
                if (underRoot) {
                    PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project).findPackage("");
                    if (aPackage == null) {
                        return;
                    }
                    scope = new PackageScope(aPackage, false, false);
                } else {
                    scope = aClass.getUseScope();
                }
                if (isOnTheFly && scope instanceof GlobalSearchScope) {
                    GlobalSearchScope globalSearchScope = (GlobalSearchScope)scope;
                    PsiSearchHelper searchHelper = PsiSearchHelper.getInstance((Project)project);
                    PsiSearchHelper.SearchCostResult cost = searchHelper.isCheapEnoughToSearch(className, globalSearchScope, null);
                    if (cost == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                        holder.registerPossibleProblem((PsiElement)aClass);
                        return;
                    }
                }
                if ((first = (PsiReference)ReferencesSearch.search((PsiElement)aClass, (SearchScope)scope).findFirst()) != null) {
                    return;
                }
                if (PsiTreeUtil.hasErrorElements((PsiElement)aClass)) {
                    return;
                }
                if (underRoot) {
                    holder.registerProblem((PsiElement)aClass, new TextRange(0, classIdentifier.getTextRangeInParent().getEndOffset()), JavaBundle.message((String)"inspection.explicit.to.implicit.class.migration.name", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceWithImplicitClassFix(ExplicitToImplicitClassMigrationInspection.this.convertToIo)});
                } else {
                    holder.registerProblem((PsiElement)aClass, JavaBundle.message((String)"inspection.explicit.to.implicit.class.migration.name", (Object[])new Object[0]), ProblemHighlightType.INFORMATION, new TextRange(0, classIdentifier.getTextRangeInParent().getEndOffset()), new LocalQuickFix[]{new ReplaceWithImplicitClassFix(ExplicitToImplicitClassMigrationInspection.this.convertToIo)});
                }
            }

            private static boolean onlyObjectExtends(PsiClassType[] types) {
                if (types.length != 1) {
                    return false;
                }
                PsiClassType type = types[0];
                return type.equalsToText("java.lang.Object");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInspection/ExplicitToImplicitClassMigrationInspection$1", "visitClass"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ExplicitToImplicitClassMigrationInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ExplicitToImplicitClassMigrationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private static class ReplaceWithImplicitClassFix
    extends ModCommandQuickFix {
        private final boolean myConvertToIo;

        private ReplaceWithImplicitClassFix(boolean io) {
            this.myConvertToIo = io;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.explicit.to.implicit.class.migration.fix.name", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithImplicitClassFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public final ModCommand perform(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            PsiFile file;
            if (project == null) {
                ReplaceWithImplicitClassFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ReplaceWithImplicitClassFix.$$$reportNull$$$0(2);
            }
            if (!((file = (element = descriptor.getStartElement()).getContainingFile()) instanceof PsiJavaFile)) {
                ModCommand modCommand = ModCommand.nop();
                if (modCommand == null) {
                    ReplaceWithImplicitClassFix.$$$reportNull$$$0(3);
                }
                return modCommand;
            }
            PsiJavaFile javaFile = (PsiJavaFile)file;
            PsiPackageStatement statement = javaFile.getPackageStatement();
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            VirtualFile sourceRoot = fileIndex.getSourceRootForFile(javaFile.getVirtualFile());
            if (statement == null || sourceRoot == null) {
                ModCommand modCommand = ModCommand.psiUpdate((PsiElement)element, (e, updater) -> this.applyFix(project, (PsiElement)e));
                if (modCommand == null) {
                    ReplaceWithImplicitClassFix.$$$reportNull$$$0(4);
                }
                return modCommand;
            }
            ModCommand modCommand = ModCommand.chooseAction((String)JavaBundle.message((String)"inspection.explicit.to.implicit.move.to.root.title", (Object[])new Object[0]), (ModCommandAction[])new ModCommandAction[]{this.getCommandActionWithMovingToRoot(project), ModCommand.psiUpdateStep((PsiElement)element, (String)JavaBundle.message((String)"inspection.explicit.to.implicit.move.to.root.delete.package", (Object[])new Object[0]), (e, updater) -> this.applyFix(project, (PsiElement)e))});
            if (modCommand == null) {
                ReplaceWithImplicitClassFix.$$$reportNull$$$0(5);
            }
            return modCommand;
        }

        @NotNull
        private ModCommandAction getCommandActionWithMovingToRoot(final @NotNull Project project) {
            if (project == null) {
                ReplaceWithImplicitClassFix.$$$reportNull$$$0(6);
            }
            return new ModCommandAction(){

                public Presentation getPresentation(@NotNull ActionContext context) {
                    if (context == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return Presentation.of((String)this.getFamilyName());
                }

                @NotNull
                public ModCommand perform(@NotNull ActionContext context) {
                    if (context == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    int offset = context.offset();
                    PsiElement element = context.file().findElementAt(offset);
                    if (element == null) {
                        ModCommand modCommand = ModCommand.nop();
                        if (modCommand == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return modCommand;
                    }
                    PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
                    if (psiClass == null) {
                        ModCommand modCommand = ModCommand.nop();
                        if (modCommand == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        return modCommand;
                    }
                    PsiFile containingFile = psiClass.getContainingFile();
                    if (containingFile == null) {
                        ModCommand modCommand = ModCommand.nop();
                        if (modCommand == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        return modCommand;
                    }
                    ModCommand modCommand = ModCommand.psiUpdate((PsiElement)psiClass, (e, updater) -> this.applyFix(project, (PsiElement)e));
                    VirtualFile from = containingFile.getVirtualFile();
                    ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                    VirtualFile sourceRoot = fileIndex.getSourceRootForFile(from);
                    if (sourceRoot != null) {
                        modCommand = modCommand.andThen(ModCommand.moveFile((VirtualFile)from, (VirtualFile)sourceRoot));
                    }
                    ModCommand modCommand2 = modCommand;
                    if (modCommand2 == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return modCommand2;
                }

                @NotNull
                public String getFamilyName() {
                    String string = JavaBundle.message((String)"inspection.explicit.to.implicit.move.to.root.move", (Object[])new Object[0]);
                    if (string == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 2, 3, 4, 5, 6 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "context";
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/codeInspection/ExplicitToImplicitClassMigrationInspection$ReplaceWithImplicitClassFix$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/codeInspection/ExplicitToImplicitClassMigrationInspection$ReplaceWithImplicitClassFix$1";
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[1] = "perform";
                            break;
                        }
                        case 6: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFamilyName";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getPresentation";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "perform";
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
                    };
                }
            };
        }

        private void applyFix(@NotNull Project project, @NotNull PsiElement element) {
            PsiJavaFile dummyFile;
            PsiClass psiClass;
            PsiImportList list;
            PsiFile containingFile;
            if (project == null) {
                ReplaceWithImplicitClassFix.$$$reportNull$$$0(7);
            }
            if (element == null) {
                ReplaceWithImplicitClassFix.$$$reportNull$$$0(8);
            }
            if (!((containingFile = element.getContainingFile()) instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile javaFile = (PsiJavaFile)containingFile;
            PsiPackageStatement packageStatement = javaFile.getPackageStatement();
            if (packageStatement != null) {
                new CommentTracker().deleteAndRestoreComments((PsiElement)packageStatement);
            }
            if ((list = javaFile.getImportList()) != null) {
                ArrayList<SmartPsiElementPointer> pointers = new ArrayList<SmartPsiElementPointer>();
                PsiImportStatementBase[] statements = list.getAllImportStatements();
                for (PsiImportStatementBase statement : statements) {
                    SmartPsiElementPointer pointer = SmartPointerManager.createPointer((PsiElement)statement);
                    pointers.add(pointer);
                }
                for (SmartPsiElementPointer pointer : pointers) {
                    PsiImportStatementBase importStatementBase = (PsiImportStatementBase)pointer.getElement();
                    if (importStatementBase == null || !importStatementBase.isOnDemand()) continue;
                    ReplaceOnDemandImportIntention.replaceOnDemand((PsiImportStatementBase)importStatementBase);
                }
            }
            if ((psiClass = (PsiClass)ObjectUtils.tryCast((Object)element, PsiClass.class)) == null) {
                return;
            }
            PsiElement lBrace = psiClass.getLBrace();
            PsiElement rBrace = psiClass.getRBrace();
            if (lBrace == null || rBrace == null || lBrace.getNextSibling() == null || rBrace.getPrevSibling() == null) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            String body = tracker.rangeText(lBrace.getNextSibling(), rBrace.getPrevSibling());
            PsiImplicitClass newClass = PsiElementFactory.getInstance((Project)project).createImplicitClassFromText(body, (PsiElement)psiClass);
            PsiFile psiFile = newClass.getContainingFile();
            if (!(psiFile instanceof PsiJavaFile) || (dummyFile = (PsiJavaFile)psiFile).getImportList() == null || javaFile.getImportList() == null) {
                return;
            }
            dummyFile.getImportList().replace((PsiElement)javaFile.getImportList());
            PsiElement replaced = tracker.replace((PsiElement)psiClass, (PsiElement)newClass);
            if (!(replaced instanceof PsiImplicitClass)) {
                return;
            }
            PsiImplicitClass implicitClass = (PsiImplicitClass)replaced;
            tracker.insertCommentsBefore((PsiElement)implicitClass);
            ReplaceWithImplicitClassFix.cleanMainMethod(implicitClass);
            PsiFile replacedContainingFile = replaced.getContainingFile();
            if (replacedContainingFile == null) {
                return;
            }
            if (this.myConvertToIo && PsiUtil.isAvailable((JavaFeature)JavaFeature.JAVA_LANG_IO, (PsiElement)replacedContainingFile)) {
                ReplaceWithImplicitClassFix.convertToIOMethods(replacedContainingFile);
            }
            JavaCodeStyleManager.getInstance((Project)project).optimizeImports(replacedContainingFile);
        }

        private static void convertToIOMethods(@NotNull PsiFile file) {
            if (file == null) {
                ReplaceWithImplicitClassFix.$$$reportNull$$$0(9);
            }
            if (!(file instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile javaFile = (PsiJavaFile)file;
            final ArrayList systemOutPrints = new ArrayList();
            final SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)file.getProject());
            javaFile.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                    if (expression == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (MigrateToJavaLangIoInspection.isSystemOutPrintln(expression)) {
                        systemOutPrints.add(smartPointerManager.createSmartPsiElementPointer((PsiElement)expression));
                    }
                    super.visitMethodCallExpression(expression);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/ExplicitToImplicitClassMigrationInspection$ReplaceWithImplicitClassFix$2", "visitMethodCallExpression"));
                }
            });
            for (SmartPsiElementPointer print : systemOutPrints) {
                PsiMethodCallExpression element = (PsiMethodCallExpression)print.getElement();
                if (element == null) continue;
                MigrateToJavaLangIoInspection.replaceToIO(element);
            }
        }

        private static void cleanMainMethod(@NotNull PsiImplicitClass implicitClass) {
            PsiMethod mainMethod;
            if (implicitClass == null) {
                ReplaceWithImplicitClassFix.$$$reportNull$$$0(10);
            }
            if ((mainMethod = PsiMethodUtil.findMainInClass((PsiClass)implicitClass)) == null) {
                return;
            }
            PsiModifierList modifierList = mainMethod.getModifierList();
            modifierList.setModifierProperty("public", false);
            modifierList.setModifierProperty("protected", false);
            modifierList.setModifierProperty("static", false);
            PsiParameterList parameterList = mainMethod.getParameterList();
            if (parameterList.getParametersCount() == 0) {
                return;
            }
            PsiParameter parameter = parameterList.getParameters()[0];
            if (VariableAccessUtils.variableIsUsed((PsiVariable)parameter, (PsiElement)mainMethod)) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            ct.deleteAndRestoreComments((PsiElement)parameter);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 6, 7, 8, 9, 10 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ExplicitToImplicitClassMigrationInspection$ReplaceWithImplicitClassFix";
                    break;
                }
                case 1: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "implicitClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ExplicitToImplicitClassMigrationInspection$ReplaceWithImplicitClassFix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommandActionWithMovingToRoot";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "convertToIOMethods";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "cleanMainMethod";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
            };
        }
    }
}

