/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.UpdateInspectionOptionFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeconstructionList;
import com.intellij.psi.PsiDeconstructionPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachPatternStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiForeachStatementBase;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.util.ArrayUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.lang.invoke.CallSite;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ForEachWithRecordPatternCanBeUsedInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    private static final int MAX_LEVEL = 5;
    private static final int MAX_COMPONENT_COUNTS = 10;
    public int maxNotUsedComponentCounts = 0;
    public int maxComponentCounts = 5;
    public int maxLevel = 2;
    public boolean forceUseVar = false;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"maxLevel", (String)InspectionGadgetsBundle.message((String)"inspection.enhanced.for.with.record.pattern.can.be.used.level.option", (Object[])new Object[0]), (int)0, (int)5), OptPane.number((String)"maxComponentCounts", (String)InspectionGadgetsBundle.message((String)"inspection.enhanced.for.with.record.pattern.can.be.used.components.option", (Object[])new Object[0]), (int)1, (int)10), OptPane.number((String)"maxNotUsedComponentCounts", (String)InspectionGadgetsBundle.message((String)"inspection.enhanced.for.with.record.pattern.can.be.used.not.used.option", (Object[])new Object[0]), (int)0, (int)10)});
        if (optPane == null) {
            ForEachWithRecordPatternCanBeUsedInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.RECORD_PATTERNS_IN_FOR_EACH);
        if (set == null) {
            ForEachWithRecordPatternCanBeUsedInspection.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            ForEachWithRecordPatternCanBeUsedInspection.$$$reportNull$$$0(2);
        }
        final boolean useVar = IntroduceVariableBase.createVarType() || this.forceUseVar;
        return new JavaElementVisitor(){
            private final Options options;
            {
                this.options = new Options(ForEachWithRecordPatternCanBeUsedInspection.this.maxNotUsedComponentCounts, Math.min(ForEachWithRecordPatternCanBeUsedInspection.this.maxComponentCounts, 10), Math.min(ForEachWithRecordPatternCanBeUsedInspection.this.maxLevel, 5), useVar, isOnTheFly);
            }

            public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitForeachStatement(statement);
                ComponentContext context = ForEachWithRecordPatternCanBeUsedInspection.createContext(statement, this.options);
                if (context == null) {
                    return;
                }
                ForEachWithRecordPatternCanBeUsedInspection.processComponentContext(context, this::highlight);
            }

            public void visitForeachPatternStatement(@NotNull PsiForeachPatternStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitForeachPatternStatement(statement);
                boolean showAsInfo = false;
                if (this.options.maxLevel <= 0) {
                    return;
                }
                PsiStatement foreachBody = statement.getBody();
                if (foreachBody == null) {
                    return;
                }
                PsiPattern pattern = statement.getIterationPattern();
                if (!(pattern instanceof PsiDeconstructionPattern)) {
                    return;
                }
                PsiDeconstructionPattern deconstructionPattern = (PsiDeconstructionPattern)pattern;
                ArrayDeque<DeconstructionContext> queueToProcess = new ArrayDeque<DeconstructionContext>();
                queueToProcess.add(new DeconstructionContext(1, deconstructionPattern, statement));
                while (!queueToProcess.isEmpty()) {
                    DeconstructionContext currentContext = (DeconstructionContext)queueToProcess.poll();
                    int level = currentContext.level;
                    if (level >= this.options.maxLevel + 1) {
                        if (!this.options.isOnTheFly) {
                            return;
                        }
                        showAsInfo = true;
                    }
                    PsiDeconstructionPattern currentDeconstruction = currentContext.pattern;
                    PsiDeconstructionList list = currentDeconstruction.getDeconstructionList();
                    for (PsiPattern component : list.getDeconstructionComponents()) {
                        PsiClass parameterClass;
                        if (component instanceof PsiDeconstructionPattern) {
                            PsiDeconstructionPattern newDeconstruction = (PsiDeconstructionPattern)component;
                            queueToProcess.add(new DeconstructionContext(level + 1, newDeconstruction, currentContext.foreachPatternStatement));
                            continue;
                        }
                        if (!(component instanceof PsiTypeTestPattern)) continue;
                        PsiTypeTestPattern typeTestPattern = (PsiTypeTestPattern)component;
                        PsiTypeElement typeElement = typeTestPattern.getCheckType();
                        PsiPatternVariable variable = typeTestPattern.getPatternVariable();
                        if (typeElement == null || variable == null) continue;
                        PsiType type = typeElement.getType();
                        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
                        if (type instanceof PsiClassType) {
                            PsiClassType referenceType = (PsiClassType)type;
                            substitutor = referenceType.resolveGenerics().getSubstitutor();
                        }
                        if ((parameterClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type)) == null) continue;
                        ShowInfoFolder showInfoFolder = new ShowInfoFolder();
                        showInfoFolder.showInfo = showAsInfo;
                        ComponentContext context = new ComponentContext(level, (PsiParameter)variable, parameterClass, substitutor, (PsiForeachStatementBase)currentContext.foreachPatternStatement, this.options, showInfoFolder);
                        ForEachWithRecordPatternCanBeUsedInspection.processComponentContext(context, this::highlight);
                    }
                }
            }

            private void highlight(@NotNull ComponentContext context, @NotNull Map<String, List<PsiElement>> components) {
                if (context == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (components == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (context.showInfoFolder.showInfo && !context.options.isOnTheFly) {
                    return;
                }
                this.registerProblemForIdentifier((PsiVariable)context.currentParameter, context, holder);
            }

            private void registerProblemForIdentifier(@NotNull PsiVariable variable, @NotNull ComponentContext context, @NotNull ProblemsHolder holder2) {
                PsiIdentifier[] identifiers;
                if (variable == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (holder2 == null) {
                    1.$$$reportNull$$$0(6);
                }
                if ((identifiers = (PsiIdentifier[])PsiTreeUtil.getChildrenOfType((PsiElement)variable, PsiIdentifier.class)) == null || identifiers.length != 1) {
                    return;
                }
                PsiIdentifier identifier = identifiers[0];
                LocalQuickFix localQuickFix = this.getLocalQuickFix(context);
                if (context.showInfoFolder.showInfo) {
                    holder2.registerProblem((PsiElement)identifier, InspectionGadgetsBundle.message((String)"inspection.enhanced.for.with.record.pattern.can.be.used.message", (Object[])new Object[0]), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{localQuickFix});
                } else {
                    Integer level;
                    ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
                    fixes.add(localQuickFix);
                    int length = context.recordClass.getRecordComponents().length;
                    if (length > 1) {
                        fixes.add(LocalQuickFix.from((ModCommandAction)new UpdateInspectionOptionFix((InspectionProfileEntry)ForEachWithRecordPatternCanBeUsedInspection.this, "maxComponentCounts", InspectionGadgetsBundle.message((String)"inspection.enhanced.for.with.record.pattern.can.be.used.maximum.number.disabled", (Object[])new Object[]{length}), length - 1)));
                    }
                    if ((level = context.level) != null && level > 0) {
                        fixes.add(LocalQuickFix.from((ModCommandAction)new UpdateInspectionOptionFix((InspectionProfileEntry)ForEachWithRecordPatternCanBeUsedInspection.this, "maxLevel", InspectionGadgetsBundle.message((String)"inspection.enhanced.for.with.record.pattern.can.be.used.maximum.depth.disabled", (Object[])new Object[]{level}), level - 1)));
                    }
                    holder2.registerProblem((PsiElement)identifier, InspectionGadgetsBundle.message((String)"inspection.enhanced.for.with.record.pattern.can.be.used.message", (Object[])new Object[0]), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                }
            }

            @NotNull
            private LocalQuickFix getLocalQuickFix(@NotNull ComponentContext context) {
                if (context == null) {
                    1.$$$reportNull$$$0(7);
                }
                return new ForEachWithRecordCanBeUsedFix(context.base, context.currentParameter);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "components";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "variable";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "holder";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/ForEachWithRecordPatternCanBeUsedInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitForeachStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitForeachPatternStatement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "highlight";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerProblemForIdentifier";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getLocalQuickFix";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static void processComponentContext(@NotNull ComponentContext context, @NotNull ComponentContextProcessor processor) {
        List references;
        Map<String, List<PsiElement>> components;
        if (context == null) {
            ForEachWithRecordPatternCanBeUsedInspection.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            ForEachWithRecordPatternCanBeUsedInspection.$$$reportNull$$$0(4);
        }
        @Nullable Integer level = context.level;
        PsiClass recordClass = context.recordClass;
        PsiStatement scope = context.base.getBody();
        boolean showAsInfo = false;
        if (!recordClass.isRecord() || recordClass.getRecordComponents().length == 0) {
            return;
        }
        if (level != null && level > context.options.maxLevel || recordClass.getRecordComponents().length > context.options.maxComponentCount) {
            if (!context.options.isOnTheFly) {
                return;
            }
            showAsInfo = true;
        }
        if ((components = ForEachWithRecordPatternCanBeUsedInspection.processReferences(references = VariableAccessUtils.getVariableReferences((PsiVariable)context.currentParameter, (PsiElement)scope), context)).isEmpty()) {
            return;
        }
        PsiRecordComponent[] recordComponents = recordClass.getRecordComponents();
        if (recordComponents.length - components.size() > context.options.maxNotUsedComponentCount) {
            if (!context.options.isOnTheFly) {
                return;
            }
            showAsInfo = true;
        }
        context.showInfoFolder.showInfo = context.showInfoFolder.showInfo || showAsInfo;
        processor.accept(context, components);
    }

    @Nullable
    private static ComponentContext createContext(@NotNull PsiForeachStatement statement, @NotNull Options options) {
        PsiClass parameterClass;
        PsiClassType classType;
        PsiStatement body;
        if (statement == null) {
            ForEachWithRecordPatternCanBeUsedInspection.$$$reportNull$$$0(5);
        }
        if (options == null) {
            ForEachWithRecordPatternCanBeUsedInspection.$$$reportNull$$$0(6);
        }
        if ((body = statement.getBody()) == null) {
            return null;
        }
        PsiParameter parameter = statement.getIterationParameter();
        PsiType parameterType = parameter.getType();
        PsiExpression iteratedValue = statement.getIteratedValue();
        if (iteratedValue == null) {
            return null;
        }
        PsiType iteratedType = JavaGenericsUtil.getCollectionItemType((PsiExpression)iteratedValue);
        if (iteratedType == null || iteratedType instanceof PsiClassType && (classType = (PsiClassType)iteratedType).isRaw()) {
            return null;
        }
        if (!PsiTypesUtil.compareTypes((PsiType)parameterType, (PsiType)iteratedType, (boolean)false)) {
            return null;
        }
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        if (parameterType instanceof PsiClassType) {
            PsiClassType referenceType = (PsiClassType)parameterType;
            substitutor = referenceType.resolveGenerics().getSubstitutor();
        }
        if ((parameterClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)parameterType)) == null) {
            return null;
        }
        return new ComponentContext(0, parameter, parameterClass, substitutor, (PsiForeachStatementBase)statement, options, new ShowInfoFolder());
    }

    @NotNull
    private static Map<String, List<PsiElement>> processReferences(@NotNull List<? extends PsiElement> references, @NotNull ComponentContext context) {
        if (references == null) {
            ForEachWithRecordPatternCanBeUsedInspection.$$$reportNull$$$0(7);
        }
        if (context == null) {
            ForEachWithRecordPatternCanBeUsedInspection.$$$reportNull$$$0(8);
        }
        HashMap<String, List<PsiElement>> result = new HashMap<String, List<PsiElement>>();
        for (PsiElement psiElement : references) {
            PsiField field;
            PsiRecordComponent component;
            PsiMethod recordMethod;
            PsiElement element = PsiUtil.skipParenthesizedExprUp((PsiElement)psiElement.getParent());
            if (element == null) {
                Map<String, List<PsiElement>> map = Map.of();
                if (map == null) {
                    ForEachWithRecordPatternCanBeUsedInspection.$$$reportNull$$$0(9);
                }
                return map;
            }
            if (!(element instanceof PsiReferenceExpression)) {
                Map<String, List<PsiElement>> map = Map.of();
                if (map == null) {
                    ForEachWithRecordPatternCanBeUsedInspection.$$$reportNull$$$0(10);
                }
                return map;
            }
            PsiReferenceExpression componentReferenceExpression = (PsiReferenceExpression)element;
            PsiElement resolvedReferenceExpression = componentReferenceExpression.resolve();
            if (resolvedReferenceExpression instanceof PsiMethod && !(recordMethod = (PsiMethod)resolvedReferenceExpression).isPhysical()) {
                component = JavaPsiRecordUtil.getRecordComponentForAccessor((PsiMethod)recordMethod);
            } else if (resolvedReferenceExpression instanceof PsiField && !(field = (PsiField)resolvedReferenceExpression).isPhysical()) {
                component = JavaPsiRecordUtil.getComponentForField((PsiField)field);
            } else {
                Map<String, List<PsiElement>> map = Map.of();
                if (map == null) {
                    ForEachWithRecordPatternCanBeUsedInspection.$$$reportNull$$$0(11);
                }
                return map;
            }
            if (component == null) {
                Map<String, List<PsiElement>> map = Map.of();
                if (map == null) {
                    ForEachWithRecordPatternCanBeUsedInspection.$$$reportNull$$$0(12);
                }
                return map;
            }
            PsiType substituted = context.classSubstitutor.substitute(component.getType());
            if (substituted == null || substituted instanceof PsiWildcardType || substituted instanceof PsiCapturedWildcardType) {
                Map<String, List<PsiElement>> map = Map.of();
                if (map == null) {
                    ForEachWithRecordPatternCanBeUsedInspection.$$$reportNull$$$0(13);
                }
                return map;
            }
            List expressions = (List)result.get(component.getName());
            PsiElement normalizedElement = ForEachWithRecordPatternCanBeUsedInspection.normalizeElement(componentReferenceExpression, component, context);
            if (expressions == null) {
                ArrayList<PsiElement> referenceExpressions = new ArrayList<PsiElement>();
                referenceExpressions.add(normalizedElement);
                result.put(component.getName(), referenceExpressions);
                continue;
            }
            expressions.add(normalizedElement);
        }
        HashMap<String, List<PsiElement>> hashMap = result;
        if (hashMap == null) {
            ForEachWithRecordPatternCanBeUsedInspection.$$$reportNull$$$0(14);
        }
        return hashMap;
    }

    @NotNull
    private static PsiElement normalizeElement(@NotNull PsiReferenceExpression reference, @NotNull PsiRecordComponent component, @NotNull ComponentContext context) {
        PsiElement element;
        PsiReferenceExpression expectedCallExpression;
        PsiElement psiElement;
        if (reference == null) {
            ForEachWithRecordPatternCanBeUsedInspection.$$$reportNull$$$0(15);
        }
        if (component == null) {
            ForEachWithRecordPatternCanBeUsedInspection.$$$reportNull$$$0(16);
        }
        if (context == null) {
            ForEachWithRecordPatternCanBeUsedInspection.$$$reportNull$$$0(17);
        }
        if ((psiElement = PsiUtil.skipParenthesizedExprUp((PsiElement)(expectedCallExpression = reference).getParent())) instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)psiElement;
            expectedCallExpression = methodCallExpression;
        }
        if ((element = PsiUtil.skipParenthesizedExprUp((PsiElement)expectedCallExpression.getParent())) instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)element;
            PsiTypeElement variableTypeElement = variable.getTypeElement();
            if (variableTypeElement == null) {
                PsiReferenceExpression psiReferenceExpression = expectedCallExpression;
                if (psiReferenceExpression == null) {
                    ForEachWithRecordPatternCanBeUsedInspection.$$$reportNull$$$0(18);
                }
                return psiReferenceExpression;
            }
            if (!variableTypeElement.isInferredType() && context.options.useVar) {
                PsiReferenceExpression psiReferenceExpression = expectedCallExpression;
                if (psiReferenceExpression == null) {
                    ForEachWithRecordPatternCanBeUsedInspection.$$$reportNull$$$0(19);
                }
                return psiReferenceExpression;
            }
            PsiType componentType = context.classSubstitutor.substitute(component.getType());
            if (PsiTypesUtil.compareTypes((PsiType)componentType, (PsiType)variable.getType(), (boolean)false) && !variable.hasAnnotations()) {
                PsiVariable psiVariable = variable;
                if (psiVariable == null) {
                    ForEachWithRecordPatternCanBeUsedInspection.$$$reportNull$$$0(20);
                }
                return psiVariable;
            }
        }
        PsiReferenceExpression psiReferenceExpression = expectedCallExpression;
        if (psiReferenceExpression == null) {
            ForEachWithRecordPatternCanBeUsedInspection.$$$reportNull$$$0(21);
        }
        return psiReferenceExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 15, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ForEachWithRecordPatternCanBeUsedInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ForEachWithRecordPatternCanBeUsedInspection";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "processReferences";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processComponentContext";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processReferences";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "normalizeElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 15, 16, 17 -> new IllegalArgumentException(string);
        };
    }

    private record ComponentContext(@Nullable Integer level, @NotNull PsiParameter currentParameter, @NotNull PsiClass recordClass, @NotNull PsiSubstitutor classSubstitutor, @NotNull PsiForeachStatementBase base, @NotNull Options options, @NotNull ShowInfoFolder showInfoFolder) {
        @NotNull
        private final PsiParameter currentParameter;
        @NotNull
        private final PsiClass recordClass;
        @NotNull
        private final PsiSubstitutor classSubstitutor;
        @NotNull
        private final PsiForeachStatementBase base;
        @NotNull
        private final Options options;
        @NotNull
        private final ShowInfoFolder showInfoFolder;

        private ComponentContext(@Nullable Integer level, @NotNull PsiParameter currentParameter, @NotNull PsiClass recordClass, @NotNull PsiSubstitutor classSubstitutor, @NotNull PsiForeachStatementBase base, @NotNull Options options, @NotNull ShowInfoFolder showInfoFolder) {
            if (currentParameter == null) {
                ComponentContext.$$$reportNull$$$0(0);
            }
            if (recordClass == null) {
                ComponentContext.$$$reportNull$$$0(1);
            }
            if (classSubstitutor == null) {
                ComponentContext.$$$reportNull$$$0(2);
            }
            if (base == null) {
                ComponentContext.$$$reportNull$$$0(3);
            }
            if (options == null) {
                ComponentContext.$$$reportNull$$$0(4);
            }
            if (showInfoFolder == null) {
                ComponentContext.$$$reportNull$$$0(5);
            }
        }

        @NotNull
        public PsiParameter currentParameter() {
            PsiParameter psiParameter = this.currentParameter;
            if (psiParameter == null) {
                ComponentContext.$$$reportNull$$$0(6);
            }
            return psiParameter;
        }

        @NotNull
        public PsiClass recordClass() {
            PsiClass psiClass = this.recordClass;
            if (psiClass == null) {
                ComponentContext.$$$reportNull$$$0(7);
            }
            return psiClass;
        }

        @NotNull
        public PsiSubstitutor classSubstitutor() {
            PsiSubstitutor psiSubstitutor = this.classSubstitutor;
            if (psiSubstitutor == null) {
                ComponentContext.$$$reportNull$$$0(8);
            }
            return psiSubstitutor;
        }

        @NotNull
        public PsiForeachStatementBase base() {
            PsiForeachStatementBase psiForeachStatementBase = this.base;
            if (psiForeachStatementBase == null) {
                ComponentContext.$$$reportNull$$$0(9);
            }
            return psiForeachStatementBase;
        }

        @NotNull
        public Options options() {
            Options options = this.options;
            if (options == null) {
                ComponentContext.$$$reportNull$$$0(10);
            }
            return options;
        }

        @NotNull
        public ShowInfoFolder showInfoFolder() {
            ShowInfoFolder showInfoFolder = this.showInfoFolder;
            if (showInfoFolder == null) {
                ComponentContext.$$$reportNull$$$0(11);
            }
            return showInfoFolder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7, 8, 9, 10, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentParameter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "recordClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classSubstitutor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "base";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "showInfoFolder";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ForEachWithRecordPatternCanBeUsedInspection$ComponentContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ForEachWithRecordPatternCanBeUsedInspection$ComponentContext";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "currentParameter";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "recordClass";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "classSubstitutor";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "base";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "options";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "showInfoFolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
            };
        }
    }

    private record Options(int maxNotUsedComponentCount, int maxComponentCount, int maxLevel, boolean useVar, boolean isOnTheFly) {
    }

    private static class ShowInfoFolder {
        boolean showInfo;

        private ShowInfoFolder() {
        }
    }

    private static interface ComponentContextProcessor
    extends BiConsumer<ComponentContext, Map<String, List<PsiElement>>> {
    }

    private record PatternDefinition(@NotNull String text, @NotNull Map<String, String> namesToComponent) {
        @NotNull
        private final String text;
        @NotNull
        private final Map<String, String> namesToComponent;

        private PatternDefinition(@NotNull String text, @NotNull Map<String, String> namesToComponent) {
            if (text == null) {
                PatternDefinition.$$$reportNull$$$0(0);
            }
            if (namesToComponent == null) {
                PatternDefinition.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public String text() {
            String string = this.text;
            if (string == null) {
                PatternDefinition.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public Map<String, String> namesToComponent() {
            Map<String, String> map = this.namesToComponent;
            if (map == null) {
                PatternDefinition.$$$reportNull$$$0(3);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namesToComponent";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ForEachWithRecordPatternCanBeUsedInspection$PatternDefinition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ForEachWithRecordPatternCanBeUsedInspection$PatternDefinition";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "text";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "namesToComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private class ForEachWithRecordCanBeUsedFix
    extends PsiUpdateModCommandQuickFix {
        private final SmartPsiElementPointer<PsiForeachStatementBase> myForEachStatement;
        private final SmartPsiElementPointer<PsiParameter> myParameter;

        private ForEachWithRecordCanBeUsedFix(@NotNull PsiForeachStatementBase forEachStatement, PsiParameter parameter) {
            if (forEachStatement == null) {
                ForEachWithRecordCanBeUsedFix.$$$reportNull$$$0(0);
            }
            if (parameter == null) {
                ForEachWithRecordCanBeUsedFix.$$$reportNull$$$0(1);
            }
            this.myForEachStatement = SmartPointerManager.createPointer((PsiElement)forEachStatement);
            this.myParameter = SmartPointerManager.createPointer((PsiElement)parameter);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message((String)"inspection.enhanced.for.with.record.pattern.can.be.used.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                ForEachWithRecordCanBeUsedFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiClass parameterClass;
            if (project == null) {
                ForEachWithRecordCanBeUsedFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                ForEachWithRecordCanBeUsedFix.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                ForEachWithRecordCanBeUsedFix.$$$reportNull$$$0(5);
            }
            PsiForeachStatementBase foreachStatementBase = (PsiForeachStatementBase)updater.getWritable((PsiElement)((PsiForeachStatementBase)this.myForEachStatement.getElement()));
            PsiParameter parameter = (PsiParameter)updater.getWritable((PsiElement)((PsiParameter)this.myParameter.getElement()));
            if (foreachStatementBase == null || parameter == null) {
                return;
            }
            Options options = new Options(ForEachWithRecordPatternCanBeUsedInspection.this.maxNotUsedComponentCounts, ForEachWithRecordPatternCanBeUsedInspection.this.maxComponentCounts, ForEachWithRecordPatternCanBeUsedInspection.this.maxLevel, IntroduceVariableBase.createVarType() || ForEachWithRecordPatternCanBeUsedInspection.this.forceUseVar, true);
            PsiType parameterType = parameter.getType();
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            if (parameterType instanceof PsiClassType) {
                PsiClassType referenceType = (PsiClassType)parameterType;
                substitutor = referenceType.resolveGenerics().getSubstitutor();
            }
            if ((parameterClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)parameterType)) == null) {
                return;
            }
            ComponentContext componentContext = new ComponentContext(null, parameter, parameterClass, substitutor, foreachStatementBase, options, new ShowInfoFolder());
            ForEachWithRecordPatternCanBeUsedInspection.processComponentContext(componentContext, (currentContext, mapElements) -> {
                Map<String, List<String>> usedVariable = ForEachWithRecordCanBeUsedFix.deleteVariablesAndMapToMethodCalls(mapElements, currentContext);
                PatternDefinition patternDefinition = ForEachWithRecordCanBeUsedFix.createPatternDefinition(currentContext, usedVariable);
                if (patternDefinition == null) {
                    return;
                }
                ForEachWithRecordCanBeUsedFix.remapToPattern(patternDefinition, mapElements);
                ForEachWithRecordCanBeUsedFix.replace(patternDefinition, currentContext);
            });
        }

        private static void replace(@NotNull PatternDefinition patternDefinition, @NotNull ComponentContext context) {
            if (patternDefinition == null) {
                ForEachWithRecordCanBeUsedFix.$$$reportNull$$$0(6);
            }
            if (context == null) {
                ForEachWithRecordCanBeUsedFix.$$$reportNull$$$0(7);
            }
            PsiForeachStatementBase foreachStatementBase = context.base;
            StringBuilder newStatementWithPattern = new StringBuilder();
            CommentTracker commentTracker = new CommentTracker();
            for (PsiElement element : foreachStatementBase.getChildren()) {
                if (PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)context.currentParameter, (boolean)false)) {
                    ForEachWithRecordCanBeUsedFix.addPatternToString(element, context.currentParameter, newStatementWithPattern, patternDefinition, commentTracker);
                    continue;
                }
                newStatementWithPattern.append(element.getText());
                commentTracker.markUnchanged(element);
            }
            PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)context.base, (String)newStatementWithPattern.toString(), (CommentTracker)commentTracker);
        }

        private static void addPatternToString(@NotNull PsiElement parent, @NotNull PsiParameter parameter, @NotNull StringBuilder patternStringBuilder, @NotNull PatternDefinition patternDefinition, @NotNull CommentTracker commentTracker) {
            if (parent == null) {
                ForEachWithRecordCanBeUsedFix.$$$reportNull$$$0(8);
            }
            if (parameter == null) {
                ForEachWithRecordCanBeUsedFix.$$$reportNull$$$0(9);
            }
            if (patternStringBuilder == null) {
                ForEachWithRecordCanBeUsedFix.$$$reportNull$$$0(10);
            }
            if (patternDefinition == null) {
                ForEachWithRecordCanBeUsedFix.$$$reportNull$$$0(11);
            }
            if (commentTracker == null) {
                ForEachWithRecordCanBeUsedFix.$$$reportNull$$$0(12);
            }
            if (parent == parameter) {
                patternStringBuilder.append(patternDefinition.text);
                return;
            }
            for (PsiElement child : parent.getChildren()) {
                if (PsiTreeUtil.isAncestor((PsiElement)child, (PsiElement)parameter, (boolean)false)) {
                    ForEachWithRecordCanBeUsedFix.addPatternToString(child, parameter, patternStringBuilder, patternDefinition, commentTracker);
                    continue;
                }
                patternStringBuilder.append(child.getText());
                commentTracker.markUnchanged(child);
            }
        }

        @Nullable
        private static PatternDefinition createPatternDefinition(@NotNull ComponentContext context, @NotNull Map<String, List<String>> usedVariable) {
            if (context == null) {
                ForEachWithRecordCanBeUsedFix.$$$reportNull$$$0(13);
            }
            if (usedVariable == null) {
                ForEachWithRecordCanBeUsedFix.$$$reportNull$$$0(14);
            }
            PsiClass recordClass = context.recordClass;
            PsiStatement body = context.base.getBody();
            if (body == null) {
                return null;
            }
            HashMap<String, String> namesToComponents = new HashMap<String, String>();
            ArrayList<CallSite> variables = new ArrayList<CallSite>();
            for (PsiRecordComponent component : context.recordClass.getRecordComponents()) {
                String type = "var";
                if (!context.options.useVar) {
                    PsiType substituted = context.classSubstitutor.substitute(component.getType());
                    if (substituted == null) {
                        return null;
                    }
                    type = substituted.getCanonicalText();
                }
                ArrayList<String> proposedNames = new ArrayList<String>();
                proposedNames.add(component.getName());
                List<String> previouslyUsedNames = usedVariable.get(component.getName());
                if (previouslyUsedNames != null) {
                    proposedNames.addAll(previouslyUsedNames);
                }
                VariableNameGenerator generator = new VariableNameGenerator((PsiElement)body, VariableKind.PARAMETER).byName(ArrayUtil.toStringArray(proposedNames));
                String generatedName = generator.generate(true);
                variables.add((CallSite)((Object)(type + " " + generatedName)));
                namesToComponents.put(component.getName(), generatedName);
            }
            StringJoiner joiner = new StringJoiner(", ", "(", ")");
            variables.forEach(pattern -> joiner.add((CharSequence)pattern));
            return new PatternDefinition(recordClass.getQualifiedName() + String.valueOf(joiner), namesToComponents);
        }

        private static void remapToPattern(@NotNull PatternDefinition definition, @NotNull Map<String, List<PsiElement>> map) {
            if (definition == null) {
                ForEachWithRecordCanBeUsedFix.$$$reportNull$$$0(15);
            }
            if (map == null) {
                ForEachWithRecordCanBeUsedFix.$$$reportNull$$$0(16);
            }
            for (Map.Entry<String, List<PsiElement>> entry : map.entrySet()) {
                String componentName = definition.namesToComponent.get(entry.getKey());
                for (PsiElement element : entry.getValue()) {
                    CommentTracker tracker = new CommentTracker();
                    if (!(element instanceof PsiExpression)) continue;
                    PsiExpression expression = (PsiExpression)element;
                    PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)expression, (String)componentName, (CommentTracker)tracker);
                }
            }
        }

        @NotNull
        private static Map<String, List<String>> deleteVariablesAndMapToMethodCalls(@NotNull Map<String, List<PsiElement>> map, @NotNull ComponentContext context) {
            if (map == null) {
                ForEachWithRecordCanBeUsedFix.$$$reportNull$$$0(17);
            }
            if (context == null) {
                ForEachWithRecordCanBeUsedFix.$$$reportNull$$$0(18);
            }
            PsiParameter currentElement = context.currentParameter;
            String name = currentElement.getName();
            HashMap<String, List<String>> usedNames = new HashMap<String, List<String>>();
            for (Map.Entry<String, List<PsiElement>> componentReferences : map.entrySet()) {
                String method = name + "." + componentReferences.getKey() + "()";
                PsiElementFactory factory = PsiElementFactory.getInstance((Project)currentElement.getProject());
                ArrayList<PsiElement> newElements = new ArrayList<PsiElement>();
                for (PsiElement element : componentReferences.getValue()) {
                    PsiReferenceExpression referenceExpression;
                    if (element instanceof PsiReferenceExpression && (referenceExpression = (PsiReferenceExpression)element).resolve() instanceof PsiField) {
                        CommentTracker tracker = new CommentTracker();
                        newElements.add(PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)referenceExpression, (String)method, (CommentTracker)tracker));
                        continue;
                    }
                    if (element instanceof PsiVariable) {
                        PsiVariable currentVariable = (PsiVariable)element;
                        List references = VariableAccessUtils.getVariableReferences((PsiVariable)currentVariable, (PsiElement)context.base.getBody());
                        for (PsiReferenceExpression reference : references) {
                            PsiExpression newMethod = factory.createExpressionFromText(method, (PsiElement)reference);
                            PsiElement replacedElement = reference.replace((PsiElement)newMethod);
                            newElements.add(replacedElement);
                        }
                        String variableName = currentVariable.getName();
                        List<String> previousNames = usedNames.get(componentReferences.getKey());
                        if (previousNames == null) {
                            ArrayList<String> newNames = new ArrayList<String>();
                            newNames.add(variableName);
                            usedNames.put(componentReferences.getKey(), newNames);
                        } else {
                            previousNames.add(variableName);
                        }
                        CommentTracker tracker = new CommentTracker();
                        tracker.deleteAndRestoreComments((PsiElement)currentVariable);
                        continue;
                    }
                    newElements.add(element);
                }
                componentReferences.getValue().clear();
                componentReferences.getValue().addAll(newElements);
            }
            HashMap<String, List<String>> hashMap = usedNames;
            if (hashMap == null) {
                ForEachWithRecordCanBeUsedFix.$$$reportNull$$$0(19);
            }
            return hashMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 19 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "forEachStatement";
                    break;
                }
                case 1: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 2: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ForEachWithRecordPatternCanBeUsedInspection$ForEachWithRecordCanBeUsedFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 6: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patternDefinition";
                    break;
                }
                case 7: 
                case 13: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patternStringBuilder";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commentTracker";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usedVariable";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "definition";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ForEachWithRecordPatternCanBeUsedInspection$ForEachWithRecordCanBeUsedFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "deleteVariablesAndMapToMethodCalls";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 19: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "addPatternToString";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "createPatternDefinition";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "remapToPattern";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteVariablesAndMapToMethodCalls";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 19 -> new IllegalStateException(string);
            };
        }
    }

    private record DeconstructionContext(int level, @NotNull PsiDeconstructionPattern pattern, @NotNull PsiForeachPatternStatement foreachPatternStatement) {
        @NotNull
        private final PsiDeconstructionPattern pattern;
        @NotNull
        private final PsiForeachPatternStatement foreachPatternStatement;

        private DeconstructionContext(int level, @NotNull PsiDeconstructionPattern pattern, @NotNull PsiForeachPatternStatement foreachPatternStatement) {
            if (pattern == null) {
                DeconstructionContext.$$$reportNull$$$0(0);
            }
            if (foreachPatternStatement == null) {
                DeconstructionContext.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public PsiDeconstructionPattern pattern() {
            PsiDeconstructionPattern psiDeconstructionPattern = this.pattern;
            if (psiDeconstructionPattern == null) {
                DeconstructionContext.$$$reportNull$$$0(2);
            }
            return psiDeconstructionPattern;
        }

        @NotNull
        public PsiForeachPatternStatement foreachPatternStatement() {
            PsiForeachPatternStatement psiForeachPatternStatement = this.foreachPatternStatement;
            if (psiForeachPatternStatement == null) {
                DeconstructionContext.$$$reportNull$$$0(3);
            }
            return psiForeachPatternStatement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "foreachPatternStatement";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ForEachWithRecordPatternCanBeUsedInspection$DeconstructionContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ForEachWithRecordPatternCanBeUsedInspection$DeconstructionContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "pattern";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "foreachPatternStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

