/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.util.PsiPrecedenceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.JavaRefactoringActionHandlerFactory;
import com.intellij.refactoring.introduceVariable.IntroduceVariableHandler;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IOStreamConstructorInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            IOStreamConstructorInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel7OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                IOStreamConstructorInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new JavaElementVisitor(this){

            public void visitNewExpression(@NotNull PsiNewExpression newExpression) {
                if (newExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitNewExpression(newExpression);
                IOStreamConstructorModel constructorModel = IOStreamConstructorModel.create(newExpression);
                if (constructorModel == null) {
                    return;
                }
                StreamType streamType = constructorModel.myStreamType;
                PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)newExpression, (boolean)false);
                if (expectedType == null) {
                    return;
                }
                if (IOStreamConstructorInspection.isFileNotFoundHandled((PsiExpression)newExpression)) {
                    return;
                }
                boolean canUseBaseType = TypeConversionUtil.isAssignable((PsiType)expectedType, (PsiType)streamType.baseType((PsiElement)newExpression));
                if (!canUseBaseType) {
                    return;
                }
                boolean isInfoLevel = PsiUtil.getLanguageLevel((PsiElement)holder.getFile()).isAtLeast(LanguageLevel.JDK_10);
                if (isInfoLevel && !isOnTheFly) {
                    return;
                }
                ProblemHighlightType highlightType = isInfoLevel ? ProblemHighlightType.INFORMATION : ProblemHighlightType.WARNING;
                ReplaceWithNioCallFix fix = new ReplaceWithNioCallFix(streamType.myReplacement, isOnTheFly);
                holder.registerProblem((PsiElement)newExpression, JavaBundle.message((String)streamType.myErrorText, (Object[])new Object[0]), highlightType, new LocalQuickFix[]{fix});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "com/intellij/codeInspection/IOStreamConstructorInspection$1", "visitNewExpression"));
            }
        };
    }

    private static boolean isFileNotFoundHandled(@NotNull PsiExpression context) {
        PsiClassType fileNotFoundType;
        ExceptionUtil.HandlePlace place;
        ExceptionUtil.HandlePlace.TryCatch fileNotFoundCatch;
        if (context == null) {
            IOStreamConstructorInspection.$$$reportNull$$$0(2);
        }
        if ((fileNotFoundCatch = (ExceptionUtil.HandlePlace.TryCatch)ObjectUtils.tryCast((Object)(place = ExceptionUtil.getHandlePlace((PsiElement)context, (PsiClassType)(fileNotFoundType = TypeUtils.getType((String)"java.io.FileNotFoundException", (PsiElement)context)), null)), ExceptionUtil.HandlePlace.TryCatch.class)) == null) {
            return false;
        }
        PsiParameter catchParameter = fileNotFoundCatch.getParameter();
        if (catchParameter == null) {
            return false;
        }
        PsiClassType ioException = TypeUtils.getType((String)"java.io.IOException", (PsiElement)context);
        return !TypeConversionUtil.isAssignable((PsiType)catchParameter.getType(), (PsiType)ioException);
    }

    @Nullable
    private static PsiExpression getOnlyArgument(@NotNull PsiCallExpression expression) {
        PsiExpressionList argumentList;
        if (expression == null) {
            IOStreamConstructorInspection.$$$reportNull$$$0(3);
        }
        if ((argumentList = expression.getArgumentList()) == null) {
            return null;
        }
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length != 1) {
            return null;
        }
        return PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/IOStreamConstructorInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/IOStreamConstructorInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isFileNotFoundHandled";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOnlyArgument";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class ReplaceWithNioCallFix
    extends PsiUpdateModCommandQuickFix {
        private final String myReplacement;
        private final boolean myIsOnTheFly;

        private ReplaceWithNioCallFix(String replacement, boolean isOnTheFly) {
            this.myReplacement = replacement;
            this.myIsOnTheFly = isOnTheFly;
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myReplacement + "()"});
            if (string == null) {
                ReplaceWithNioCallFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiNewExpression newExpression;
            if (project == null) {
                ReplaceWithNioCallFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceWithNioCallFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithNioCallFix.$$$reportNull$$$0(3);
            }
            if ((newExpression = (PsiNewExpression)ObjectUtils.tryCast((Object)element, PsiNewExpression.class)) == null) {
                return;
            }
            IOStreamConstructorModel constructorModel = IOStreamConstructorModel.create(newExpression);
            if (constructorModel == null) {
                return;
            }
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)newExpression, PsiMethod.class);
            if (containingMethod == null) {
                return;
            }
            boolean isEffectivelyFinal = ReplaceWithNioCallFix.isEffectivelyFinal((PsiElement)newExpression, constructorModel.myArgument.getExpression());
            String filesCallText = "java.nio.file." + constructorModel.myStreamType.myReplacement + "(" + constructorModel.myArgument.createReplacement() + ")";
            PsiElement result = PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)newExpression, (String)filesCallText, (CommentTracker)new CommentTracker());
            if (!isEffectivelyFinal) {
                return;
            }
            PsiMethodCallExpression filesMethodCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)result, PsiMethodCallExpression.class);
            if (filesMethodCall == null) {
                return;
            }
            PsiMethodCallExpression toPathConversion = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)IOStreamConstructorInspection.getOnlyArgument((PsiCallExpression)filesMethodCall), PsiMethodCallExpression.class);
            if (toPathConversion == null) {
                return;
            }
            PsiExpression[] occurrences = CodeInsightUtil.findExpressionOccurrences((PsiElement)containingMethod, (PsiExpression)toPathConversion);
            if (occurrences.length < 2) {
                return;
            }
            List<PsiVariable> pathVars = Arrays.stream(occurrences).map(o -> ReplaceWithNioCallFix.findVariableAssignedTo(o)).filter(var -> var != null && ControlFlowUtil.isEffectivelyFinal((PsiVariable)var, (PsiElement)toPathConversion)).toList();
            if (!pathVars.isEmpty()) {
                PsiCodeBlock body = containingMethod.getBody();
                if (body == null) {
                    return;
                }
                ControlFlow flow = ReplaceWithNioCallFix.createControlFlow(body);
                if (flow == null) {
                    return;
                }
                int conversionOffset = flow.getStartOffset((PsiElement)toPathConversion);
                if (conversionOffset == -1) {
                    return;
                }
                Collection writtenVariables = ControlFlowUtil.getWrittenVariables((ControlFlow)flow, (int)0, (int)conversionOffset, (boolean)true);
                PsiVariable pathVar = (PsiVariable)ContainerUtil.find(pathVars, var -> writtenVariables.contains(var));
                if (pathVar != null) {
                    String varName = pathVar.getName();
                    if (varName == null) {
                        return;
                    }
                    PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)toPathConversion, (String)varName, (CommentTracker)new CommentTracker());
                    return;
                }
            }
            if (!this.myIsOnTheFly) {
                return;
            }
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            JavaRefactoringActionHandlerFactory factory = JavaRefactoringActionHandlerFactory.getInstance();
            IntroduceVariableHandler handler = (IntroduceVariableHandler)ObjectUtils.tryCast((Object)factory.createIntroduceVariableHandler(), IntroduceVariableHandler.class);
            if (handler != null) {
                handler.invoke(project, editor, (PsiExpression)toPathConversion);
            }
        }

        @Nullable
        private static PsiVariable findVariableAssignedTo(@NotNull PsiExpression occurrence) {
            if (occurrence == null) {
                ReplaceWithNioCallFix.$$$reportNull$$$0(4);
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)occurrence);
            PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PsiVariable.class, PsiAssignmentExpression.class});
            PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)context, PsiVariable.class);
            if (variable != null) {
                if (variable.getInitializer() != parent) {
                    return null;
                }
                return variable;
            }
            if (context == null) {
                return null;
            }
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)context;
            if (assignment.getRExpression() != parent) {
                return null;
            }
            PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)assignment.getLExpression(), PsiReferenceExpression.class);
            if (ref == null) {
                return null;
            }
            PsiVariable target = (PsiVariable)ObjectUtils.tryCast((Object)ref.resolve(), PsiVariable.class);
            if (!PsiUtil.isJvmLocalVariable((PsiElement)target)) {
                return null;
            }
            return target;
        }

        private static boolean isEffectivelyFinal(PsiElement context, PsiExpression expression) {
            return ExpressionUtils.nonStructuralChildren((PsiExpression)expression).allMatch(c -> ReplaceWithNioCallFix.isEffectivelyFinal(context, expression, c));
        }

        private static boolean isEffectivelyFinal(PsiElement context, PsiExpression parent, PsiExpression child) {
            if (child != parent) {
                return ReplaceWithNioCallFix.isEffectivelyFinal(context, child);
            }
            if (child instanceof PsiLiteralExpression) {
                return true;
            }
            if (!(child instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiVariable target = (PsiVariable)ObjectUtils.tryCast((Object)((PsiReferenceExpression)child).resolve(), PsiVariable.class);
            if (!PsiUtil.isJvmLocalVariable((PsiElement)target)) {
                return false;
            }
            return ControlFlowUtil.isEffectivelyFinal((PsiVariable)target, (PsiElement)context);
        }

        @Nullable
        private static ControlFlow createControlFlow(@NotNull PsiCodeBlock block) {
            if (block == null) {
                ReplaceWithNioCallFix.$$$reportNull$$$0(5);
            }
            try {
                LocalsOrMyInstanceFieldsControlFlowPolicy flowPolicy = LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance();
                return ControlFlowFactory.getInstance((Project)block.getProject()).getControlFlow((PsiElement)block, (ControlFlowPolicy)flowPolicy);
            }
            catch (AnalysisCanceledException ignored) {
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/IOStreamConstructorInspection$ReplaceWithNioCallFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "occurrence";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/IOStreamConstructorInspection$ReplaceWithNioCallFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findVariableAssignedTo";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createControlFlow";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class IOStreamConstructorModel {
        private final StreamType myStreamType;
        private final ArgumentModel myArgument;

        private IOStreamConstructorModel(@NotNull StreamType type, @NotNull ArgumentModel argument) {
            if (type == null) {
                IOStreamConstructorModel.$$$reportNull$$$0(0);
            }
            if (argument == null) {
                IOStreamConstructorModel.$$$reportNull$$$0(1);
            }
            this.myStreamType = type;
            this.myArgument = argument;
        }

        @Nullable
        private static IOStreamConstructorModel create(@NotNull PsiNewExpression expression) {
            PsiType expressionType;
            if (expression == null) {
                IOStreamConstructorModel.$$$reportNull$$$0(2);
            }
            if ((expressionType = expression.getType()) == null) {
                return null;
            }
            StreamType streamType = (StreamType)((Object)ContainerUtil.find((Object[])StreamType.values(), t -> expressionType.equalsToText(t.myTypeText)));
            if (streamType == null) {
                return null;
            }
            PsiExpression argument = IOStreamConstructorInspection.getOnlyArgument((PsiCallExpression)expression);
            if (argument == null) {
                return null;
            }
            ArgumentModel argModel = ArgumentModel.create(argument);
            if (argModel == null) {
                return null;
            }
            return new IOStreamConstructorModel(streamType, argModel);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/IOStreamConstructorInspection$IOStreamConstructorModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface ArgumentModel {
        public String createReplacement();

        public PsiExpression getExpression();

        @Nullable
        private static ArgumentModel create(@NotNull PsiExpression argument) {
            PsiType argType;
            if (argument == null) {
                ArgumentModel.$$$reportNull$$$0(0);
            }
            if ((argType = argument.getType()) == null) {
                return null;
            }
            if (argType.equalsToText("java.lang.String")) {
                return new StringExpr(argument);
            }
            if (argType.equalsToText("java.io.File")) {
                return new FileExpr(argument);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/codeInspection/IOStreamConstructorInspection$ArgumentModel", "create"));
        }

        public static class StringExpr
        implements ArgumentModel {
            private final PsiExpression myStringExpr;

            private StringExpr(@NotNull PsiExpression stringExpr) {
                if (stringExpr == null) {
                    StringExpr.$$$reportNull$$$0(0);
                }
                this.myStringExpr = stringExpr;
            }

            @Override
            public String createReplacement() {
                return PsiUtil.getLanguageLevel((PsiElement)this.myStringExpr).isAtLeast(LanguageLevel.JDK_11) ? "java.nio.file.Path.of(" + this.myStringExpr.getText() + ")" : "java.nio.file.Paths.get(" + this.myStringExpr.getText() + ")";
            }

            @Override
            public PsiExpression getExpression() {
                return this.myStringExpr;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringExpr", "com/intellij/codeInspection/IOStreamConstructorInspection$ArgumentModel$StringExpr", "<init>"));
            }
        }

        public static class FileExpr
        implements ArgumentModel {
            private final PsiExpression myFileExpr;

            private FileExpr(@NotNull PsiExpression fileExpr) {
                if (fileExpr == null) {
                    FileExpr.$$$reportNull$$$0(0);
                }
                this.myFileExpr = fileExpr;
            }

            @Override
            public String createReplacement() {
                boolean needsParenthesis;
                boolean bl = needsParenthesis = PsiPrecedenceUtil.getPrecedence((PsiExpression)this.myFileExpr) > 1;
                if (needsParenthesis) {
                    return "(" + this.myFileExpr.getText() + ").toPath()";
                }
                return this.myFileExpr.getText() + ".toPath()";
            }

            @Override
            public PsiExpression getExpression() {
                return this.myFileExpr;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileExpr", "com/intellij/codeInspection/IOStreamConstructorInspection$ArgumentModel$FileExpr", "<init>"));
            }
        }
    }

    private static enum StreamType {
        INPUT_STREAM("java.io.FileInputStream", "java.io.InputStream", "inspection.input.stream.constructor.message", "Files.newInputStream"),
        OUTPUT_STREAM("java.io.FileOutputStream", "java.io.OutputStream", "inspection.output.stream.constructor.message", "Files.newOutputStream");

        private final String myTypeText;
        private final String myBaseTypeText;
        private final String myErrorText;
        private final String myReplacement;

        private StreamType(String typeText, String baseTypeText, String errorText, String replacement) {
            this.myTypeText = typeText;
            this.myBaseTypeText = baseTypeText;
            this.myErrorText = errorText;
            this.myReplacement = replacement;
        }

        @NotNull
        public PsiType baseType(@NotNull PsiElement context) {
            if (context == null) {
                StreamType.$$$reportNull$$$0(0);
            }
            PsiElementFactory factory = PsiElementFactory.getInstance((Project)context.getProject());
            PsiType psiType = factory.createTypeFromText(this.myBaseTypeText, context);
            if (psiType == null) {
                StreamType.$$$reportNull$$$0(1);
            }
            return psiType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/IOStreamConstructorInspection$StreamType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/IOStreamConstructorInspection$StreamType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "baseType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "baseType";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

