/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.TrackingRunner;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.jdk.AutoBoxingInspection;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObviousNullCheckInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ObviousNullCheckInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                Object[] args;
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!ContainerUtil.exists((Object[])(args = call.getArgumentList().getExpressions()), arg -> TrackingRunner.getObviouslyNonNullExplanation((PsiExpression)PsiUtil.skipParenthesizedExprDown((PsiExpression)arg)) != null)) {
                    return;
                }
                NullCheckParameter nullCheckParameter = NullCheckParameter.fromCall(call);
                if (nullCheckParameter == null) {
                    return;
                }
                if (!ExpressionUtils.isVoidContext((PsiExpression)call) && !nullCheckParameter.myReturnsParameter) {
                    return;
                }
                if (args.length <= nullCheckParameter.myIndex) {
                    return;
                }
                PsiExpression nullArg = PsiUtil.skipParenthesizedExprDown((PsiExpression)args[nullCheckParameter.myIndex]);
                String explanation = TrackingRunner.getObviouslyNonNullExplanation((PsiExpression)nullArg);
                if (explanation == null) {
                    return;
                }
                if (nullCheckParameter.myNull) {
                    holder.registerProblem((PsiElement)nullArg, JavaBundle.message((String)"inspection.redundant.null.check.always.fail.message", (Object[])new Object[]{explanation}), new LocalQuickFix[0]);
                } else {
                    PsiReferenceExpression comparedToNull = ExpressionUtils.getReferenceExpressionFromNullComparison((PsiExpression)nullArg, (boolean)false);
                    PsiUpdateModCommandQuickFix fix = comparedToNull == null ? new RemoveNullCheckFix() : new RemoveExcessiveNullComparisonFix();
                    holder.registerProblem((PsiElement)nullArg, JavaBundle.message((String)"inspection.redundant.null.check.message", (Object[])new Object[]{explanation}), new LocalQuickFix[]{fix});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/ObviousNullCheckInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/ObviousNullCheckInspection", "buildVisitor"));
    }

    public static class RemoveNullCheckFix
    extends PsiUpdateModCommandQuickFix {
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.redundant.null.check.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                RemoveNullCheckFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiMethodCallExpression call;
            if (project == null) {
                RemoveNullCheckFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                RemoveNullCheckFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                RemoveNullCheckFix.$$$reportNull$$$0(3);
            }
            if ((call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiMethodCallExpression.class)) == null) {
                return;
            }
            PsiElement parent = call.getParent();
            CommentTracker ct = new CommentTracker();
            if (parent instanceof PsiExpressionStatement) {
                List expressions = ((StreamEx)StreamEx.of((Object[])call.getArgumentList().getExpressions()).flatCollection(SideEffectChecker::extractSideEffectExpressions).peek(arg_0 -> ((CommentTracker)ct).markUnchanged(arg_0))).toList();
                PsiStatement[] sideEffectStatements = StatementExtractor.generateStatements((List)expressions, (PsiExpression)call);
                if (sideEffectStatements.length > 0) {
                    BlockUtils.addBefore((PsiStatement)((PsiStatement)parent), (PsiStatement[])sideEffectStatements);
                }
                ct.deleteAndRestoreComments(parent);
            } else {
                PsiElement resultParent;
                boolean objectCall = call.getType() instanceof PsiClassType;
                PsiExpression result = (PsiExpression)ct.replaceAndRestoreComments((PsiElement)call, startElement);
                if (objectCall && result.getType() instanceof PsiPrimitiveType && (resultParent = result.getParent()) instanceof PsiReferenceExpression) {
                    AutoBoxingInspection.replaceWithBoxing((PsiExpression)result);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ObviousNullCheckInspection$RemoveNullCheckFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ObviousNullCheckInspection$RemoveNullCheckFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class RemoveExcessiveNullComparisonFix
    extends PsiUpdateModCommandQuickFix {
        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.redundant.null.check.fix.notnull.family.name", (Object[])new Object[0]);
            if (string == null) {
                RemoveExcessiveNullComparisonFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiExpression arg;
            if (project == null) {
                RemoveExcessiveNullComparisonFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                RemoveExcessiveNullComparisonFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                RemoveExcessiveNullComparisonFix.$$$reportNull$$$0(3);
            }
            if ((arg = (PsiExpression)ObjectUtils.tryCast((Object)element, PsiExpression.class)) == null) {
                return;
            }
            PsiReferenceExpression comparedToNull = ExpressionUtils.getReferenceExpressionFromNullComparison((PsiExpression)arg, (boolean)false);
            if (comparedToNull == null) {
                return;
            }
            new CommentTracker().replaceAndRestoreComments((PsiElement)arg, (PsiElement)comparedToNull);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ObviousNullCheckInspection$RemoveExcessiveNullComparisonFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ObviousNullCheckInspection$RemoveExcessiveNullComparisonFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    record NullCheckParameter(int myIndex, boolean myNull, boolean myReturnsParameter) {
        @Nullable
        static NullCheckParameter fromCall(PsiMethodCallExpression call) {
            PsiMethod method = call.resolveMethod();
            if (method == null || method.isConstructor()) {
                return null;
            }
            if (!JavaMethodContractUtil.isPure((PsiMethod)method)) {
                return null;
            }
            List contracts = JavaMethodContractUtil.getMethodCallContracts((PsiMethod)method, (PsiCallExpression)call);
            if (contracts.isEmpty()) {
                return null;
            }
            MethodContract contract = (MethodContract)contracts.getFirst();
            if (contract == null) {
                return null;
            }
            ContractReturnValue firstReturn = contract.getReturnValue();
            ContractValue condition = (ContractValue)ContainerUtil.getOnlyItem((Collection)contract.getConditions());
            if (condition == null) {
                return null;
            }
            if (firstReturn instanceof ContractReturnValue.ParameterReturnValue) {
                ContractReturnValue.ParameterReturnValue parameterReturnValue = (ContractReturnValue.ParameterReturnValue)firstReturn;
                int index = parameterReturnValue.getParameterNumber();
                int nullIndex = condition.getNullCheckedArgument(false).orElse(-1);
                if (nullIndex != index) {
                    return null;
                }
                return new NullCheckParameter(nullIndex, false, true);
            }
            if (contracts.size() > 2) {
                return null;
            }
            if (!firstReturn.isFail()) {
                return null;
            }
            boolean isNull = false;
            int nullIndex = condition.getNullCheckedArgument(true).orElse(-1);
            if (nullIndex == -1) {
                isNull = true;
                nullIndex = condition.getNullCheckedArgument(false).orElse(-1);
                if (nullIndex == -1) {
                    return null;
                }
            }
            boolean returnsParameter = false;
            if (contracts.size() == 2) {
                ContractReturnValue.ParameterReturnValue result;
                ContractReturnValue returnValue = JavaMethodContractUtil.getNonFailingReturnValue((List)contracts);
                if (returnValue instanceof ContractReturnValue.ParameterReturnValue && (result = (ContractReturnValue.ParameterReturnValue)returnValue).getParameterNumber() == nullIndex) {
                    returnsParameter = true;
                } else {
                    return null;
                }
            }
            if (!returnsParameter && !PsiTypes.voidType().equals((Object)method.getReturnType())) {
                return null;
            }
            return new NullCheckParameter(nullIndex, isNull, returnsParameter);
        }
    }
}

