/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.codeInspection.util.OptionalRefactoringUtil;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.callMatcher.CallHandler;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimplifyOptionalCallChainsInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher OPTIONAL_OR_ELSE = CallMatcher.instanceCall((String)"java.util.Optional", (String[])new String[]{"orElse"}).parameterCount(1);
    private static final CallMatcher OPTIONAL_GET = CallMatcher.instanceCall((String)"java.util.Optional", (String[])new String[]{"get"}).parameterCount(0);
    private static final CallMatcher OPTIONAL_OR_ELSE_GET = CallMatcher.instanceCall((String)"java.util.Optional", (String[])new String[]{"orElseGet"}).parameterCount(1);
    private static final CallMatcher OPTIONAL_MAP = CallMatcher.instanceCall((String)"java.util.Optional", (String[])new String[]{"map"}).parameterCount(1);
    private static final CallMatcher OPTIONAL_OF_NULLABLE = CallMatcher.staticCall((String)"java.util.Optional", (String[])new String[]{"ofNullable"}).parameterCount(1);
    private static final CallMatcher OPTIONAL_OF_OF_NULLABLE = CallMatcher.staticCall((String)"java.util.Optional", (String[])new String[]{"ofNullable", "of"}).parameterCount(1);
    private static final CallMatcher OPTIONAL_IS_PRESENT = CallMatcher.anyOf((CallMatcher[])new CallMatcher[]{CallMatcher.exactInstanceCall((String)"java.util.Optional", (String[])new String[]{"isPresent"}).parameterCount(0), CallMatcher.exactInstanceCall((String)"java.util.OptionalInt", (String[])new String[]{"isPresent"}).parameterCount(0), CallMatcher.exactInstanceCall((String)"java.util.OptionalLong", (String[])new String[]{"isPresent"}).parameterCount(0), CallMatcher.exactInstanceCall((String)"java.util.OptionalDouble", (String[])new String[]{"isPresent"}).parameterCount(0)});
    private static final CallMatcher OPTIONAL_IF_PRESENT = CallMatcher.anyOf((CallMatcher[])new CallMatcher[]{CallMatcher.exactInstanceCall((String)"java.util.Optional", (String[])new String[]{"ifPresent"}).parameterCount(1), CallMatcher.exactInstanceCall((String)"java.util.OptionalInt", (String[])new String[]{"ifPresent"}).parameterCount(1), CallMatcher.exactInstanceCall((String)"java.util.OptionalLong", (String[])new String[]{"ifPresent"}).parameterCount(1), CallMatcher.exactInstanceCall((String)"java.util.OptionalDouble", (String[])new String[]{"ifPresent"}).parameterCount(1)});
    private static final CallMatcher OPTIONAL_IS_EMPTY = CallMatcher.anyOf((CallMatcher[])new CallMatcher[]{CallMatcher.exactInstanceCall((String)"java.util.Optional", (String[])new String[]{"isEmpty"}).parameterCount(0), CallMatcher.exactInstanceCall((String)"java.util.OptionalInt", (String[])new String[]{"isEmpty"}).parameterCount(0), CallMatcher.exactInstanceCall((String)"java.util.OptionalLong", (String[])new String[]{"isEmpty"}).parameterCount(0), CallMatcher.exactInstanceCall((String)"java.util.OptionalDouble", (String[])new String[]{"isEmpty"}).parameterCount(0)});
    private static final List<ChainSimplificationCase<?>> ourCases = List.of(new IfPresentFoldedCase(), new MapUnwrappingCase(), new OrElseNonNullCase(OrElseType.OrElse), new OrElseNonNullCase(OrElseType.OrElseGet), new FlipPresentOrEmptyCase(true), new FlipPresentOrEmptyCase(false), new OrElseReturnCase(OrElseType.OrElse), new OrElseReturnCase(OrElseType.OrElseGet), new RewrappingCase(RewrappingCase.Type.OptionalGet), new RewrappingCase(RewrappingCase.Type.OrElseNull), new MapOrElseCase(OrElseType.OrElseGet), new MapOrElseCase(OrElseType.OrElse), new OptionalOfNullableOrElseNullCase(), new OptionalOfNullableStringCase());
    private static final CallMapper<OptionalSimplificationFix> ourMapper = (CallMapper)StreamEx.of(ourCases).map(theCase -> CallHandler.of((CallMatcher)theCase.getMatcher(), (Function)theCase)).foldLeft((Object)new CallMapper(), CallMapper::register);

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.STREAM_OPTIONAL);
        if (set == null) {
            SimplifyOptionalCallChainsInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SimplifyOptionalCallChainsInspection.$$$reportNull$$$0(1);
        }
        return new OptionalChainVisitor(this, PsiUtil.getLanguageLevel((PsiElement)holder.getFile())){

            @Override
            protected void handleSimplification(@NotNull PsiMethodCallExpression call, @NotNull OptionalSimplificationFix fix) {
                PsiElement element;
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (fix == null) {
                    1.$$$reportNull$$$0(1);
                }
                holder.registerProblem((PsiElement)((element = call.getMethodExpression().getReferenceNameElement()) != null ? element : call), fix.getDescription(), new LocalQuickFix[]{fix});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "call";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fix";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$1";
                objectArray[2] = "handleSimplification";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    private static <T> OptionalSimplificationFix getFix(PsiMethodCallExpression call, ChainSimplificationCase<T> inspection) {
        T context = inspection.extractContext(call.getProject(), call);
        if (context == null) {
            return null;
        }
        String name = inspection.getName(context);
        String description = inspection.getDescription(context);
        return new OptionalSimplificationFix(inspection, name, description);
    }

    private static <T> void handleSimplification(ChainSimplificationCase<T> inspection, Project project, PsiMethodCallExpression call) {
        if (!inspection.getMatcher().matches((PsiExpression)call)) {
            return;
        }
        T context = inspection.extractContext(project, call);
        if (context != null) {
            inspection.apply(project, call, context);
        }
    }

    @Nullable
    private static PsiLambdaExpression getLambda(PsiExpression initializer) {
        PsiMethodReferenceExpression methodRef;
        PsiLambdaExpression lambda;
        PsiExpression expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)initializer);
        if (expression instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)expression;
            return lambda2;
        }
        if (expression instanceof PsiMethodReferenceExpression && (lambda = LambdaRefactoringUtil.createLambda((PsiMethodReferenceExpression)(methodRef = (PsiMethodReferenceExpression)expression), (boolean)true)) != null) {
            LambdaUtil.specifyLambdaParameterTypes((PsiType)methodRef.getFunctionalInterfaceType(), (PsiLambdaExpression)lambda);
            return lambda;
        }
        return null;
    }

    private static PsiExpression getOrElseArgument(PsiMethodCallExpression call, OrElseType type) {
        if (type == OrElseType.OrElse) {
            return call.getArgumentList().getExpressions()[0];
        }
        if (type == OrElseType.OrElseGet) {
            PsiLambdaExpression lambda = SimplifyOptionalCallChainsInspection.getLambda(call.getArgumentList().getExpressions()[0]);
            if (lambda == null || !lambda.getParameterList().isEmpty()) {
                return null;
            }
            return LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda.getBody());
        }
        return null;
    }

    private static CallMatcher getMatcherByType(OrElseType type) {
        if (type == OrElseType.OrElse) {
            return OPTIONAL_OR_ELSE;
        }
        if (type == OrElseType.OrElseGet) {
            return OPTIONAL_OR_ELSE_GET;
        }
        throw new IllegalStateException();
    }

    @Nullable
    private static PsiExpression extractConditionalDefaultValue(@NotNull PsiStatement statement, @NotNull PsiVariable optValue) {
        if (statement == null) {
            SimplifyOptionalCallChainsInspection.$$$reportNull$$$0(2);
        }
        if (optValue == null) {
            SimplifyOptionalCallChainsInspection.$$$reportNull$$$0(3);
        }
        if (statement instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)statement;
            PsiExpression condition = ifStatement.getCondition();
            if (condition == null) {
                return null;
            }
            PsiExpression thenExpr = SimplifyOptionalCallChainsInspection.getReturnExpression(ifStatement.getThenBranch());
            PsiExpression elseExpr = SimplifyOptionalCallChainsInspection.getReturnExpression(ifStatement.getElseBranch());
            if (thenExpr == null || elseExpr == null) {
                return null;
            }
            return SimplifyOptionalCallChainsInspection.extractConditionalDefaultValue(thenExpr, elseExpr, condition, optValue);
        }
        if (statement instanceof PsiReturnStatement) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
            PsiExpression returnValue = returnStatement.getReturnValue();
            PsiConditionalExpression ternary = (PsiConditionalExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)returnValue), PsiConditionalExpression.class);
            if (ternary == null) {
                return null;
            }
            PsiExpression thenExpression = ternary.getThenExpression();
            PsiExpression elseExpression = ternary.getElseExpression();
            if (thenExpression == null || elseExpression == null) {
                return null;
            }
            return SimplifyOptionalCallChainsInspection.extractConditionalDefaultValue(thenExpression, elseExpression, ternary.getCondition(), optValue);
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    private static PsiExpression getReturnExpression(@Nullable PsiStatement block) {
        if (block == null) {
            return null;
        }
        PsiStatement statement = ControlFlowUtils.stripBraces((PsiStatement)block);
        PsiReturnStatement returnStatement = (PsiReturnStatement)ObjectUtils.tryCast((Object)statement, PsiReturnStatement.class);
        if (returnStatement == null) {
            return null;
        }
        return returnStatement.getReturnValue();
    }

    @Nullable
    private static PsiExpression extractConditionalDefaultValue(@NotNull PsiExpression thenExpr, @NotNull PsiExpression elseExpr, @NotNull PsiExpression condition, @NotNull PsiVariable optValue) {
        PsiExpression defaultExpression;
        if (thenExpr == null) {
            SimplifyOptionalCallChainsInspection.$$$reportNull$$$0(4);
        }
        if (elseExpr == null) {
            SimplifyOptionalCallChainsInspection.$$$reportNull$$$0(5);
        }
        if (condition == null) {
            SimplifyOptionalCallChainsInspection.$$$reportNull$$$0(6);
        }
        if (optValue == null) {
            SimplifyOptionalCallChainsInspection.$$$reportNull$$$0(7);
        }
        PsiVariable nullChecked = ExpressionUtils.getVariableFromNullComparison((PsiExpression)condition, (boolean)true);
        boolean inverted = false;
        if (nullChecked == null) {
            nullChecked = ExpressionUtils.getVariableFromNullComparison((PsiExpression)condition, (boolean)false);
            if (nullChecked == null) {
                return null;
            }
            inverted = true;
        }
        if (!nullChecked.equals((Object)optValue) || !ExpressionUtils.isReferenceTo((PsiExpression)(inverted ? thenExpr : elseExpr), (PsiVariable)optValue)) {
            return null;
        }
        PsiExpression psiExpression = defaultExpression = inverted ? elseExpr : thenExpr;
        if (VariableAccessUtils.variableIsUsed((PsiVariable)optValue, (PsiElement)defaultExpression)) {
            return null;
        }
        return defaultExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optValue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thenExpr";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elseExpr";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extractConditionalDefaultValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    private static interface ChainSimplificationCase<C>
    extends Function<PsiMethodCallExpression, OptionalSimplificationFix> {
        @Override
        default public OptionalSimplificationFix apply(PsiMethodCallExpression expression) {
            return SimplifyOptionalCallChainsInspection.getFix(expression, this);
        }

        @NotNull
        @IntentionName
        public String getName(@NotNull C var1);

        @NotNull
        @InspectionMessage
        public String getDescription(@NotNull C var1);

        @Nullable
        public C extractContext(@NotNull Project var1, @NotNull PsiMethodCallExpression var2);

        public void apply(@NotNull Project var1, @NotNull PsiMethodCallExpression var2, @NotNull C var3);

        @NotNull
        public CallMatcher getMatcher();

        default public boolean isAppropriateLanguageLevel(@NotNull LanguageLevel level) {
            if (level == null) {
                ChainSimplificationCase.$$$reportNull$$$0(0);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$ChainSimplificationCase", "isAppropriateLanguageLevel"));
        }
    }

    static class OptionalSimplificationFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        private final ChainSimplificationCase<?> myInspection;
        @IntentionFamilyName
        private final String myName;
        private final @InspectionMessage String myDescription;

        OptionalSimplificationFix(@NotNull ChainSimplificationCase<?> inspection, @IntentionFamilyName String name, @InspectionMessage String description) {
            if (inspection == null) {
                OptionalSimplificationFix.$$$reportNull$$$0(0);
            }
            this.myInspection = inspection;
            this.myName = name;
            this.myDescription = description;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myName;
            if (string == null) {
                OptionalSimplificationFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                OptionalSimplificationFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                OptionalSimplificationFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                OptionalSimplificationFix.$$$reportNull$$$0(4);
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class, (boolean)false);
            SimplifyOptionalCallChainsInspection.handleSimplification(this.myInspection, project, call);
        }

        @InspectionMessage
        String getDescription() {
            return this.myDescription;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inspection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OptionalSimplificationFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OptionalSimplificationFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static enum OrElseType {
        OrElse,
        OrElseGet;

    }

    private static class IfPresentFoldedCase
    implements ChainSimplificationCase<Context> {
        private IfPresentFoldedCase() {
        }

        @Override
        @NotNull
        public String getName(@NotNull Context context) {
            if (context == null) {
                IfPresentFoldedCase.$$$reportNull$$$0(0);
            }
            String string = InspectionGadgetsBundle.message((String)"fix.eliminate.folded.if.present.name", (Object[])new Object[0]);
            if (string == null) {
                IfPresentFoldedCase.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDescription(@NotNull Context context) {
            if (context == null) {
                IfPresentFoldedCase.$$$reportNull$$$0(2);
            }
            String string = InspectionGadgetsBundle.message((String)"fix.eliminate.folded.if.present.description", (Object[])new Object[0]);
            if (string == null) {
                IfPresentFoldedCase.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @Nullable
        public Context extractContext(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            if (project == null) {
                IfPresentFoldedCase.$$$reportNull$$$0(4);
            }
            if (call == null) {
                IfPresentFoldedCase.$$$reportNull$$$0(5);
            }
            PsiExpression outerIfPresentQualifier = call.getMethodExpression().getQualifierExpression();
            PsiMethodCallExpression qualifierCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)outerIfPresentQualifier, PsiMethodCallExpression.class);
            PsiLambdaExpression outerIfPresentArgument = (PsiLambdaExpression)ObjectUtils.tryCast((Object)call.getArgumentList().getExpressions()[0], PsiLambdaExpression.class);
            if (outerIfPresentArgument == null) {
                return null;
            }
            if (outerIfPresentArgument.getParameterList().getParametersCount() != 1) {
                return null;
            }
            PsiParameter outerParameter = outerIfPresentArgument.getParameterList().getParameters()[0];
            if (outerParameter == null) {
                return null;
            }
            String outerIfPresentParameterName = outerParameter.getName();
            PsiExpression outerIfPresentBodyExpr = LambdaUtil.extractSingleExpressionFromBody((PsiElement)outerIfPresentArgument.getBody());
            PsiMethodCallExpression outerIfPresentBody = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)outerIfPresentBodyExpr, PsiMethodCallExpression.class);
            if (!OPTIONAL_IF_PRESENT.test(outerIfPresentBody)) {
                return null;
            }
            PsiExpression innerIfPresentQualifier = outerIfPresentBody.getMethodExpression().getQualifierExpression();
            PsiExpression nonTrivialQualifier = ExpressionUtils.isReferenceTo((PsiExpression)innerIfPresentQualifier, (PsiVariable)outerParameter) ? null : innerIfPresentQualifier;
            PsiExpression innerIfPresentArgument = outerIfPresentBody.getArgumentList().getExpressions()[0];
            if (ReferencesSearch.search((PsiElement)outerParameter, (SearchScope)new LocalSearchScope((PsiElement)innerIfPresentArgument)).findFirst() != null) {
                return null;
            }
            PsiMethodCallExpression mapBefore = null;
            if (OPTIONAL_MAP.test(qualifierCall) && IfPresentFoldedCase.isOptionalTypeParameter(qualifierCall.getType())) {
                mapBefore = qualifierCall;
            }
            return new Context(mapBefore, nonTrivialQualifier, outerIfPresentParameterName, innerIfPresentArgument);
        }

        private static boolean isOptionalTypeParameter(@Nullable PsiType type) {
            PsiClassType classType = (PsiClassType)ObjectUtils.tryCast((Object)type, PsiClassType.class);
            if (classType == null) {
                return false;
            }
            if (classType.getParameterCount() != 1) {
                return false;
            }
            PsiType typeParameter = classType.getParameters()[0];
            PsiClass parameterClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)typeParameter);
            if (parameterClass == null) {
                return false;
            }
            return "java.util.Optional".equals(parameterClass.getQualifiedName());
        }

        @Override
        public void apply(@NotNull Project project, @NotNull PsiMethodCallExpression call, @NotNull Context context) {
            PsiExpression lambdaBodyAfter;
            if (project == null) {
                IfPresentFoldedCase.$$$reportNull$$$0(6);
            }
            if (call == null) {
                IfPresentFoldedCase.$$$reportNull$$$0(7);
            }
            if (context == null) {
                IfPresentFoldedCase.$$$reportNull$$$0(8);
            }
            PsiMethodCallExpression mapBefore = context.myMapBefore;
            CommentTracker ct = new CommentTracker();
            StringBuilder sb = new StringBuilder();
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            assert (qualifier != null);
            sb.append(ct.text((PsiElement)qualifier)).append(".");
            if (mapBefore != null) {
                PsiExpression mapArgument = mapBefore.getArgumentList().getExpressions()[0];
                sb.append("flatMap(").append(ct.text((PsiElement)mapArgument)).append(").");
            }
            if ((lambdaBodyAfter = context.myMapLambdaBodyAfter) != null) {
                sb.append("flatMap(").append(context.myOuterIfPresentVarName).append("->").append(ct.text((PsiElement)lambdaBodyAfter)).append(").");
            }
            sb.append("ifPresent(").append(ct.text((PsiElement)context.myInnerIfPresentArgument)).append(")");
            PsiElement result = ct.replaceAndRestoreComments((PsiElement)call, sb.toString());
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences((PsiElement)result);
        }

        @Override
        @NotNull
        public CallMatcher getMatcher() {
            CallMatcher callMatcher = OPTIONAL_IF_PRESENT;
            if (callMatcher == null) {
                IfPresentFoldedCase.$$$reportNull$$$0(9);
            }
            return callMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$IfPresentFoldedCase";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$IfPresentFoldedCase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDescription";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "extractContext";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 9 -> new IllegalStateException(string);
            };
        }

        static class Context {
            @Nullable
            PsiMethodCallExpression myMapBefore;
            @Nullable
            PsiExpression myMapLambdaBodyAfter;
            @NotNull
            String myOuterIfPresentVarName;
            @NotNull
            PsiExpression myInnerIfPresentArgument;

            Context(@Nullable PsiMethodCallExpression mapBefore, @Nullable PsiExpression mapLambdaBodyAfter, @NotNull String outerIfPresentVarName, @NotNull PsiExpression innerIfPresentArgument) {
                if (outerIfPresentVarName == null) {
                    Context.$$$reportNull$$$0(0);
                }
                if (innerIfPresentArgument == null) {
                    Context.$$$reportNull$$$0(1);
                }
                this.myMapBefore = mapBefore;
                this.myMapLambdaBodyAfter = mapLambdaBodyAfter;
                this.myOuterIfPresentVarName = outerIfPresentVarName;
                this.myInnerIfPresentArgument = innerIfPresentArgument;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outerIfPresentVarName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "innerIfPresentArgument";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$IfPresentFoldedCase$Context";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class MapUnwrappingCase
    implements ChainSimplificationCase<Context> {
        private MapUnwrappingCase() {
        }

        @Override
        @NotNull
        public String getName(@NotNull Context context) {
            if (context == null) {
                MapUnwrappingCase.$$$reportNull$$$0(0);
            }
            String string = CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"map()", "flatMap()"});
            if (string == null) {
                MapUnwrappingCase.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDescription(@NotNull Context context) {
            if (context == null) {
                MapUnwrappingCase.$$$reportNull$$$0(2);
            }
            String string = InspectionGadgetsBundle.message((String)"fix.replace.map.with.flat.map.description", (Object[])new Object[0]);
            if (string == null) {
                MapUnwrappingCase.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @Nullable
        public Context extractContext(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            PsiLambdaExpression lambda;
            if (project == null) {
                MapUnwrappingCase.$$$reportNull$$$0(4);
            }
            if (call == null) {
                MapUnwrappingCase.$$$reportNull$$$0(5);
            }
            if ((lambda = SimplifyOptionalCallChainsInspection.getLambda(call.getArgumentList().getExpressions()[0])) == null) {
                return null;
            }
            PsiParameter[] parameters = lambda.getParameterList().getParameters();
            if (parameters.length != 1) {
                return null;
            }
            PsiParameter mapLambdaParameter = parameters[0];
            PsiExpression argument = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda.getBody());
            PsiMethodCallExpression insideLambdaCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)argument, PsiMethodCallExpression.class);
            if (insideLambdaCall == null) {
                return null;
            }
            PsiExpression optionalQualifier = insideLambdaCall.getMethodExpression().getQualifierExpression();
            if (optionalQualifier == null) {
                return null;
            }
            if (!OPTIONAL_OR_ELSE.test(insideLambdaCall)) {
                if (!OPTIONAL_GET.test(insideLambdaCall)) {
                    return null;
                }
                PsiExpression qualifier = insideLambdaCall.getMethodExpression().getQualifierExpression();
                if (!MapUnwrappingCase.isPresentOptional(qualifier)) {
                    return null;
                }
                return new Context(optionalQualifier, call, mapLambdaParameter);
            }
            if (!ExpressionUtils.isNullLiteral((PsiExpression)insideLambdaCall.getArgumentList().getExpressions()[0])) {
                return null;
            }
            return new Context(optionalQualifier, call, mapLambdaParameter);
        }

        @Override
        public void apply(@NotNull Project project, @NotNull PsiMethodCallExpression call, @NotNull Context context) {
            if (project == null) {
                MapUnwrappingCase.$$$reportNull$$$0(6);
            }
            if (call == null) {
                MapUnwrappingCase.$$$reportNull$$$0(7);
            }
            if (context == null) {
                MapUnwrappingCase.$$$reportNull$$$0(8);
            }
            CommentTracker ct = new CommentTracker();
            String text = ct.text((PsiElement)context.myMapLambdaParameter) + " ->" + ct.text((PsiElement)context.myOptionalExpression);
            PsiExpression qualifier = context.myMapCall.getMethodExpression().getQualifierExpression();
            String callReplacement = Objects.requireNonNull(qualifier).getText() + ".flatMap(" + text + ")";
            PsiElement result = ct.replaceAndRestoreComments((PsiElement)context.myMapCall, callReplacement);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences((PsiElement)result);
        }

        @Override
        @NotNull
        public CallMatcher getMatcher() {
            CallMatcher callMatcher = OPTIONAL_MAP;
            if (callMatcher == null) {
                MapUnwrappingCase.$$$reportNull$$$0(9);
            }
            return callMatcher;
        }

        private static boolean isPresentOptional(PsiExpression optionalExpression) {
            return !SpecialField.OPTIONAL_VALUE.getFromQualifier(CommonDataflow.getDfType((PsiExpression)optionalExpression)).isSuperType((DfType)DfTypes.NULL);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$MapUnwrappingCase";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$MapUnwrappingCase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDescription";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "extractContext";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 9 -> new IllegalStateException(string);
            };
        }

        private static final class Context {
            private final PsiExpression myOptionalExpression;
            private final PsiMethodCallExpression myMapCall;
            private final PsiParameter myMapLambdaParameter;

            private Context(PsiExpression expression, PsiMethodCallExpression call, PsiParameter parameter) {
                this.myOptionalExpression = expression;
                this.myMapCall = call;
                this.myMapLambdaParameter = parameter;
            }
        }
    }

    private static final class OrElseNonNullCase
    implements ChainSimplificationCase<Context> {
        private final OrElseType myType;

        private OrElseNonNullCase(OrElseType type) {
            this.myType = type;
        }

        @Override
        @NotNull
        public String getName(@NotNull Context context) {
            if (context == null) {
                OrElseNonNullCase.$$$reportNull$$$0(0);
            }
            String string = JavaBundle.message((String)"simplify.optional.chain.inspection.or.else.non.null.fix.name", (Object[])new Object[0]);
            if (string == null) {
                OrElseNonNullCase.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDescription(@NotNull Context context) {
            if (context == null) {
                OrElseNonNullCase.$$$reportNull$$$0(2);
            }
            String string = JavaBundle.message((String)"simplify.optional.chain.inspection.or.else.non.null.fix.description", (Object[])new Object[0]);
            if (string == null) {
                OrElseNonNullCase.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @Nullable
        public Context extractContext(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            PsiExpression orElseArgument;
            if (project == null) {
                OrElseNonNullCase.$$$reportNull$$$0(4);
            }
            if (call == null) {
                OrElseNonNullCase.$$$reportNull$$$0(5);
            }
            if (!ExpressionUtils.isNullLiteral((PsiExpression)(orElseArgument = SimplifyOptionalCallChainsInspection.getOrElseArgument(call, this.myType)))) {
                return null;
            }
            PsiLocalVariable returnVar = (PsiLocalVariable)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent()), PsiLocalVariable.class);
            if (returnVar == null) {
                return null;
            }
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)returnVar, PsiStatement.class, (boolean)true);
            if (statement == null) {
                return null;
            }
            PsiStatement nextStatement = (PsiStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesForward((PsiElement)returnVar.getParent()), PsiStatement.class);
            if (nextStatement == null) {
                return null;
            }
            PsiExpression lambdaExpr = OrElseNonNullCase.extractMappingExpression(nextStatement, (PsiVariable)returnVar);
            if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)lambdaExpr)) {
                return null;
            }
            if (!ContainerUtil.and((Iterable)VariableAccessUtils.getVariableReferences((PsiVariable)returnVar), reference -> PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)reference, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)nextStatement, (PsiElement)reference, (boolean)false))) {
                return null;
            }
            return new Context(lambdaExpr, nextStatement, statement, (PsiVariable)returnVar, call);
        }

        @Override
        public void apply(@NotNull Project project, @NotNull PsiMethodCallExpression call, @NotNull Context context) {
            PsiExpression receiver;
            if (project == null) {
                OrElseNonNullCase.$$$reportNull$$$0(6);
            }
            if (call == null) {
                OrElseNonNullCase.$$$reportNull$$$0(7);
            }
            if (context == null) {
                OrElseNonNullCase.$$$reportNull$$$0(8);
            }
            if ((receiver = context.myOrElseCall.getMethodExpression().getQualifierExpression()) == null) {
                return;
            }
            String statementText = receiver.getText() + ".ifPresent(" + LambdaUtil.createLambda((PsiVariable)context.myVariable, (PsiExpression)context.myAction) + ");";
            PsiStatement finalStatement = JavaPsiFacade.getElementFactory((Project)project).createStatementFromText(statementText, (PsiElement)context.myStatement);
            PsiElement result = context.myStatement.replace((PsiElement)finalStatement);
            context.myConditionStatement.delete();
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences((PsiElement)result);
        }

        @Override
        @NotNull
        public CallMatcher getMatcher() {
            CallMatcher callMatcher = SimplifyOptionalCallChainsInspection.getMatcherByType(this.myType);
            if (callMatcher == null) {
                OrElseNonNullCase.$$$reportNull$$$0(9);
            }
            return callMatcher;
        }

        @Nullable
        private static PsiExpression extractMappingExpression(@NotNull PsiStatement statement, @NotNull PsiVariable optValue) {
            PsiIfStatement ifStatement;
            if (statement == null) {
                OrElseNonNullCase.$$$reportNull$$$0(10);
            }
            if (optValue == null) {
                OrElseNonNullCase.$$$reportNull$$$0(11);
            }
            if ((ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)statement, PsiIfStatement.class)) == null) {
                return null;
            }
            if (ifStatement.getElseBranch() != null) {
                return null;
            }
            PsiExpression condition = ifStatement.getCondition();
            if (condition == null) {
                return null;
            }
            if (ExpressionUtils.getVariableFromNullComparison((PsiExpression)condition, (boolean)false) != optValue) {
                return null;
            }
            PsiStatement thenStatement = ControlFlowUtils.stripBraces((PsiStatement)ifStatement.getThenBranch());
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)thenStatement, PsiExpressionStatement.class);
            if (expressionStatement == null) {
                return null;
            }
            return expressionStatement.getExpression();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OrElseNonNullCase";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "optValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OrElseNonNullCase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDescription";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "extractContext";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "extractMappingExpression";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 9 -> new IllegalStateException(string);
            };
        }

        private static final class Context {
            @NotNull
            private final PsiExpression myAction;
            @NotNull
            private final PsiStatement myConditionStatement;
            @NotNull
            private final PsiStatement myStatement;
            @NotNull
            private final PsiVariable myVariable;
            @NotNull
            private final PsiMethodCallExpression myOrElseCall;

            private Context(@NotNull PsiExpression action, @NotNull PsiStatement conditionStatement, @NotNull PsiStatement statement, @NotNull PsiVariable variable, @NotNull PsiMethodCallExpression call) {
                if (action == null) {
                    Context.$$$reportNull$$$0(0);
                }
                if (conditionStatement == null) {
                    Context.$$$reportNull$$$0(1);
                }
                if (statement == null) {
                    Context.$$$reportNull$$$0(2);
                }
                if (variable == null) {
                    Context.$$$reportNull$$$0(3);
                }
                if (call == null) {
                    Context.$$$reportNull$$$0(4);
                }
                this.myAction = action;
                this.myConditionStatement = conditionStatement;
                this.myStatement = statement;
                this.myVariable = variable;
                this.myOrElseCall = call;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "action";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "conditionStatement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "statement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "variable";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[0] = "call";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OrElseNonNullCase$Context";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static final class FlipPresentOrEmptyCase
    implements ChainSimplificationCase<Context> {
        private final boolean myIsPresent;

        private FlipPresentOrEmptyCase(boolean present) {
            this.myIsPresent = present;
        }

        @Override
        @NotNull
        public String getName(@NotNull Context context) {
            if (context == null) {
                FlipPresentOrEmptyCase.$$$reportNull$$$0(0);
            }
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{context.myReplacement + "()"});
            if (string == null) {
                FlipPresentOrEmptyCase.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDescription(@NotNull Context context) {
            if (context == null) {
                FlipPresentOrEmptyCase.$$$reportNull$$$0(2);
            }
            String string = CommonQuickFixBundle.message((String)"fix.can.replace.with.x", (Object[])new Object[]{context.myReplacement + "()"});
            if (string == null) {
                FlipPresentOrEmptyCase.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @Nullable
        public Context extractContext(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            if (project == null) {
                FlipPresentOrEmptyCase.$$$reportNull$$$0(4);
            }
            if (call == null) {
                FlipPresentOrEmptyCase.$$$reportNull$$$0(5);
            }
            if (!BoolUtils.isNegated((PsiExpression)call)) {
                return null;
            }
            PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
            if (nameElement == null) {
                return null;
            }
            if (this.myIsPresent) {
                return new Context("isEmpty");
            }
            return new Context("isPresent");
        }

        @Override
        public boolean isAppropriateLanguageLevel(@NotNull LanguageLevel level) {
            if (level == null) {
                FlipPresentOrEmptyCase.$$$reportNull$$$0(6);
            }
            return level.isAtLeast(LanguageLevel.JDK_11);
        }

        @Override
        public void apply(@NotNull Project project, @NotNull PsiMethodCallExpression call, @NotNull Context context) {
            PsiPrefixExpression negation;
            if (project == null) {
                FlipPresentOrEmptyCase.$$$reportNull$$$0(7);
            }
            if (call == null) {
                FlipPresentOrEmptyCase.$$$reportNull$$$0(8);
            }
            if (context == null) {
                FlipPresentOrEmptyCase.$$$reportNull$$$0(9);
            }
            if ((negation = (PsiPrefixExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent()), PsiPrefixExpression.class)) == null || BoolUtils.getNegated((PsiExpression)negation) != call) {
                return;
            }
            ExpressionUtils.bindCallTo((PsiMethodCallExpression)call, (String)context.myReplacement);
            new CommentTracker().replaceAndRestoreComments((PsiElement)negation, (PsiElement)call);
        }

        @Override
        @NotNull
        public CallMatcher getMatcher() {
            if (this.myIsPresent) {
                CallMatcher callMatcher = OPTIONAL_IS_PRESENT;
                if (callMatcher == null) {
                    FlipPresentOrEmptyCase.$$$reportNull$$$0(10);
                }
                return callMatcher;
            }
            CallMatcher callMatcher = OPTIONAL_IS_EMPTY;
            if (callMatcher == null) {
                FlipPresentOrEmptyCase.$$$reportNull$$$0(11);
            }
            return callMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 10, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$FlipPresentOrEmptyCase";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$FlipPresentOrEmptyCase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 1: 
                case 3: 
                case 10: 
                case 11: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDescription";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "extractContext";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isAppropriateLanguageLevel";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 10, 11 -> new IllegalStateException(string);
            };
        }

        private static final class Context {
            private final String myReplacement;

            private Context(String replacement) {
                this.myReplacement = replacement;
            }
        }
    }

    private static final class OrElseReturnCase
    implements ChainSimplificationCase<Context> {
        public static final String OR_ELSE = "orElse";
        public static final String OR_ELSE_GET = "orElseGet";
        private final OrElseType myType;

        private OrElseReturnCase(OrElseType type) {
            this.myType = type;
        }

        @Override
        @NotNull
        public String getName(@NotNull Context context) {
            if (context == null) {
                OrElseReturnCase.$$$reportNull$$$0(0);
            }
            String method = context.myIsSimple ? OR_ELSE : OR_ELSE_GET;
            String string = JavaBundle.message((String)"simplify.optional.chain.inspection.or.else.return.fix.name", (Object[])new Object[]{method, PsiExpressionTrimRenderer.render((PsiExpression)context.myDefaultExpression)});
            if (string == null) {
                OrElseReturnCase.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDescription(@NotNull Context context) {
            if (context == null) {
                OrElseReturnCase.$$$reportNull$$$0(2);
            }
            String string = JavaBundle.message((String)"simplify.optional.chain.inspection.or.else.return.fix.description", (Object[])new Object[0]);
            if (string == null) {
                OrElseReturnCase.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @Nullable
        public Context extractContext(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            PsiExpression falseArg;
            if (project == null) {
                OrElseReturnCase.$$$reportNull$$$0(4);
            }
            if (call == null) {
                OrElseReturnCase.$$$reportNull$$$0(5);
            }
            if (!ExpressionUtils.isNullLiteral((PsiExpression)(falseArg = SimplifyOptionalCallChainsInspection.getOrElseArgument(call, this.myType)))) {
                return null;
            }
            PsiLocalVariable returnVar = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)call, PsiLocalVariable.class, (boolean)true);
            if (returnVar == null) {
                return null;
            }
            PsiStatement nextStatement = (PsiStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesForward((PsiElement)returnVar.getParent()), PsiStatement.class);
            if (nextStatement == null) {
                return null;
            }
            PsiExpression defaultValue = SimplifyOptionalCallChainsInspection.extractConditionalDefaultValue(nextStatement, (PsiVariable)returnVar);
            boolean isSimple = ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)defaultValue);
            if (defaultValue == null || !isSimple && !LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)defaultValue)) {
                return null;
            }
            PsiType type = defaultValue.getType();
            PsiType methodCallReturnValue = call.getMethodExpression().getType();
            if (type == null || methodCallReturnValue == null || !methodCallReturnValue.isAssignableFrom(type)) {
                return null;
            }
            return new Context(call, defaultValue, nextStatement, isSimple);
        }

        @Override
        public void apply(@NotNull Project project, @NotNull PsiMethodCallExpression call, @NotNull Context context) {
            PsiExpression receiver;
            if (project == null) {
                OrElseReturnCase.$$$reportNull$$$0(6);
            }
            if (call == null) {
                OrElseReturnCase.$$$reportNull$$$0(7);
            }
            if (context == null) {
                OrElseReturnCase.$$$reportNull$$$0(8);
            }
            if ((receiver = context.myOrElseCall.getMethodExpression().getQualifierExpression()) == null) {
                return;
            }
            String methodWithArg = context.myIsSimple ? ".orElse(" + context.myDefaultExpression.getText() + ")" : ".orElseGet(()->" + context.myDefaultExpression.getText() + ")";
            String expressionText = receiver.getText() + methodWithArg;
            PsiStatement finalStatement = JavaPsiFacade.getElementFactory((Project)project).createStatementFromText("return " + expressionText + ";", (PsiElement)receiver);
            PsiStatement current = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)context.myOrElseCall, PsiStatement.class, (boolean)false);
            if (current == null) {
                return;
            }
            PsiElement result = new CommentTracker().replaceAndRestoreComments((PsiElement)current, (PsiElement)finalStatement);
            new CommentTracker().deleteAndRestoreComments((PsiElement)context.myNextStatement);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences((PsiElement)result);
        }

        @Override
        @NotNull
        public CallMatcher getMatcher() {
            if (this.myType == OrElseType.OrElse) {
                CallMatcher callMatcher = OPTIONAL_OR_ELSE;
                if (callMatcher == null) {
                    OrElseReturnCase.$$$reportNull$$$0(9);
                }
                return callMatcher;
            }
            CallMatcher callMatcher = OPTIONAL_OR_ELSE_GET;
            if (callMatcher == null) {
                OrElseReturnCase.$$$reportNull$$$0(10);
            }
            return callMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 9, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OrElseReturnCase";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OrElseReturnCase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 1: 
                case 3: 
                case 9: 
                case 10: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDescription";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "extractContext";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 9, 10 -> new IllegalStateException(string);
            };
        }

        private static final class Context {
            @NotNull
            private final PsiMethodCallExpression myOrElseCall;
            @NotNull
            private final PsiExpression myDefaultExpression;
            @NotNull
            private final PsiStatement myNextStatement;
            private final boolean myIsSimple;

            private Context(@NotNull PsiMethodCallExpression call, @NotNull PsiExpression defaultExpression, @NotNull PsiStatement nextStatement, boolean simple) {
                if (call == null) {
                    Context.$$$reportNull$$$0(0);
                }
                if (defaultExpression == null) {
                    Context.$$$reportNull$$$0(1);
                }
                if (nextStatement == null) {
                    Context.$$$reportNull$$$0(2);
                }
                this.myOrElseCall = call;
                this.myDefaultExpression = defaultExpression;
                this.myNextStatement = nextStatement;
                this.myIsSimple = simple;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "call";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "defaultExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "nextStatement";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OrElseReturnCase$Context";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static final class RewrappingCase
    implements ChainSimplificationCase<Context> {
        private final CallMatcher myWrapper;
        private final Type myType;

        private RewrappingCase(Type type) {
            this.myType = type;
            this.myWrapper = this.myType == Type.OrElseNull ? OPTIONAL_OF_NULLABLE : OPTIONAL_OF_OF_NULLABLE;
        }

        @Override
        @NotNull
        public String getName(@NotNull Context context) {
            if (context == null) {
                RewrappingCase.$$$reportNull$$$0(0);
            }
            String string = JavaBundle.message((String)"simplify.optional.chain.inspection.optional.rewrapping.name", (Object[])new Object[0]);
            if (string == null) {
                RewrappingCase.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDescription(@NotNull Context context) {
            if (context == null) {
                RewrappingCase.$$$reportNull$$$0(2);
            }
            String string = JavaBundle.message((String)"simplify.optional.chain.inspection.optional.rewrapping.description", (Object[])new Object[0]);
            if (string == null) {
                RewrappingCase.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @Nullable
        public Context extractContext(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            DfType dfType;
            PsiElement parent;
            if (project == null) {
                RewrappingCase.$$$reportNull$$$0(4);
            }
            if (call == null) {
                RewrappingCase.$$$reportNull$$$0(5);
            }
            if (!((parent = PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent())) instanceof PsiExpressionList)) {
                return null;
            }
            PsiMethodCallExpression parentCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethodCallExpression.class);
            if (!this.myWrapper.test(parentCall)) {
                return null;
            }
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null || !EquivalenceChecker.getCanonicalPsiEquivalence().typesAreEquivalent(qualifier.getType(), parentCall.getType())) {
                return null;
            }
            String name = call.getMethodExpression().getReferenceName();
            if ("get".equals(name) ? (dfType = SpecialField.OPTIONAL_VALUE.getFromQualifier(CommonDataflow.getDfType((PsiExpression)qualifier))).isSuperType((DfType)DfTypes.NULL) : "orElse".equals(name) && !ExpressionUtils.isNullLiteral((PsiExpression)call.getArgumentList().getExpressions()[0])) {
                return null;
            }
            return new Context(qualifier, (PsiExpression)parentCall);
        }

        @Override
        public void apply(@NotNull Project project, @NotNull PsiMethodCallExpression call, @NotNull Context context) {
            if (project == null) {
                RewrappingCase.$$$reportNull$$$0(6);
            }
            if (call == null) {
                RewrappingCase.$$$reportNull$$$0(7);
            }
            if (context == null) {
                RewrappingCase.$$$reportNull$$$0(8);
            }
            PsiElement result = context.myCallToReplace.replace((PsiElement)context.myQualifier);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences((PsiElement)result);
            RemoveRedundantTypeArgumentsUtil.removeRedundantTypeArguments((PsiElement)result);
        }

        @Override
        @NotNull
        public CallMatcher getMatcher() {
            if (this.myType == Type.OptionalGet) {
                CallMatcher callMatcher = OPTIONAL_GET;
                if (callMatcher == null) {
                    RewrappingCase.$$$reportNull$$$0(9);
                }
                return callMatcher;
            }
            CallMatcher callMatcher = OPTIONAL_OR_ELSE;
            if (callMatcher == null) {
                RewrappingCase.$$$reportNull$$$0(10);
            }
            return callMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 9, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$RewrappingCase";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$RewrappingCase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 1: 
                case 3: 
                case 9: 
                case 10: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDescription";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "extractContext";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 9, 10 -> new IllegalStateException(string);
            };
        }

        static enum Type {
            OrElseNull,
            OptionalGet;

        }

        private static final class Context {
            private final PsiExpression myQualifier;
            private final PsiExpression myCallToReplace;

            private Context(PsiExpression qualifier, PsiExpression callToReplace) {
                this.myQualifier = qualifier;
                this.myCallToReplace = callToReplace;
            }
        }
    }

    private static final class MapOrElseCase
    extends BasicSimplificationInspection {
        private final OrElseType myType;

        private MapOrElseCase(OrElseType type) {
            this.myType = type;
        }

        @Override
        @Nullable
        public BasicSimplificationInspection.StringReplacement extractContext(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            PsiExpression falseArg;
            if (project == null) {
                MapOrElseCase.$$$reportNull$$$0(0);
            }
            if (call == null) {
                MapOrElseCase.$$$reportNull$$$0(1);
            }
            if ((falseArg = SimplifyOptionalCallChainsInspection.getOrElseArgument(call, this.myType)) == null) {
                return null;
            }
            PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call);
            if (!OPTIONAL_MAP.test(qualifierCall)) {
                return null;
            }
            PsiLambdaExpression lambda = SimplifyOptionalCallChainsInspection.getLambda(qualifierCall.getArgumentList().getExpressions()[0]);
            if (lambda == null) {
                return null;
            }
            PsiExpression trueArg = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda.getBody());
            if (trueArg == null) {
                return null;
            }
            PsiParameter[] parameters = lambda.getParameterList().getParameters();
            if (parameters.length != 1) {
                return null;
            }
            PsiExpression qualifier = qualifierCall.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return null;
            }
            String opt = qualifier.getText();
            PsiParameter parameter = parameters[0];
            boolean useOrElseGet = this.myType == OrElseType.OrElseGet;
            String proposed = OptionalRefactoringUtil.generateOptionalUnwrap((String)opt, (PsiVariable)parameter, (PsiExpression)trueArg, (PsiExpression)falseArg, (PsiType)call.getType(), (boolean)useOrElseGet);
            String canonicalOrElse = useOrElseGet && !ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)falseArg) ? ".orElseGet(() -> " + falseArg.getText() + ")" : ".orElse(" + falseArg.getText() + ")";
            String canonical = opt + ".map(" + LambdaUtil.createLambda((PsiVariable)parameter, (PsiExpression)trueArg) + ")" + canonicalOrElse;
            if (proposed.length() < canonical.length()) {
                String displayCode;
                if (proposed.equals(opt)) {
                    displayCode = "";
                } else if (opt.length() > 10) {
                    opt = "(($))";
                    String template = OptionalRefactoringUtil.generateOptionalUnwrap((String)opt, (PsiVariable)parameter, (PsiExpression)trueArg, (PsiExpression)falseArg, (PsiType)call.getType(), (boolean)useOrElseGet);
                    displayCode = PsiExpressionTrimRenderer.render((PsiExpression)JavaPsiFacade.getElementFactory((Project)parameter.getProject()).createExpressionFromText(template, (PsiElement)call));
                    displayCode = displayCode.replaceFirst(Pattern.quote(opt), "..");
                } else {
                    displayCode = PsiExpressionTrimRenderer.render((PsiExpression)JavaPsiFacade.getElementFactory((Project)parameter.getProject()).createExpressionFromText(proposed, (PsiElement)call));
                }
                String message = displayCode.isEmpty() ? JavaBundle.message((String)"simplify.optional.chain.inspection.remove.redundant.steps.from.optional.chain", (Object[])new Object[0]) : JavaBundle.message((String)"simplify.optional.chain.inspection.to.x", (Object[])new Object[]{displayCode});
                String description = JavaBundle.message((String)"simplify.optional.chain.inspection.map.or.else.description", (Object[])new Object[0]);
                return new BasicSimplificationInspection.StringReplacement(proposed, message, description);
            }
            return null;
        }

        @Override
        @NotNull
        public CallMatcher getMatcher() {
            CallMatcher callMatcher = SimplifyOptionalCallChainsInspection.getMatcherByType(this.myType);
            if (callMatcher == null) {
                MapOrElseCase.$$$reportNull$$$0(2);
            }
            return callMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$MapOrElseCase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$MapOrElseCase";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "extractContext";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class OptionalOfNullableOrElseNullCase
    implements ChainSimplificationCase<Context> {
        private OptionalOfNullableOrElseNullCase() {
        }

        @Override
        @NotNull
        public String getName(@NotNull Context context) {
            if (context == null) {
                OptionalOfNullableOrElseNullCase.$$$reportNull$$$0(0);
            }
            String string = JavaBundle.message((String)"simplify.optional.chain.inspection.fix.name.remove.redundant.optional.chain", (Object[])new Object[0]);
            if (string == null) {
                OptionalOfNullableOrElseNullCase.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDescription(@NotNull Context context) {
            if (context == null) {
                OptionalOfNullableOrElseNullCase.$$$reportNull$$$0(2);
            }
            String string = JavaBundle.message((String)"simplify.optional.chain.inspection.fix.description.optional.chain.can.be.eliminated", (Object[])new Object[0]);
            if (string == null) {
                OptionalOfNullableOrElseNullCase.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @Nullable
        public Context extractContext(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            if (project == null) {
                OptionalOfNullableOrElseNullCase.$$$reportNull$$$0(4);
            }
            if (call == null) {
                OptionalOfNullableOrElseNullCase.$$$reportNull$$$0(5);
            }
            PsiMethodCallExpression outerCall = ExpressionUtils.getCallForQualifier((PsiExpression)call);
            PsiExpression wrappingArgument = call.getArgumentList().getExpressions()[0];
            if (!OPTIONAL_OR_ELSE.test(outerCall)) {
                return null;
            }
            PsiExpression argument = outerCall.getArgumentList().getExpressions()[0];
            if (!ExpressionUtils.isNullLiteral((PsiExpression)argument)) {
                return null;
            }
            return new Context(wrappingArgument, outerCall);
        }

        @Override
        public void apply(@NotNull Project project, @NotNull PsiMethodCallExpression call, @NotNull Context context) {
            if (project == null) {
                OptionalOfNullableOrElseNullCase.$$$reportNull$$$0(6);
            }
            if (call == null) {
                OptionalOfNullableOrElseNullCase.$$$reportNull$$$0(7);
            }
            if (context == null) {
                OptionalOfNullableOrElseNullCase.$$$reportNull$$$0(8);
            }
            CommentTracker ct = new CommentTracker();
            ct.replaceAndRestoreComments((PsiElement)context.outerCall, (PsiElement)context.wrappingArgument);
        }

        @Override
        @NotNull
        public CallMatcher getMatcher() {
            CallMatcher callMatcher = OPTIONAL_OF_NULLABLE;
            if (callMatcher == null) {
                OptionalOfNullableOrElseNullCase.$$$reportNull$$$0(9);
            }
            return callMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OptionalOfNullableOrElseNullCase";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OptionalOfNullableOrElseNullCase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDescription";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "extractContext";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 9 -> new IllegalStateException(string);
            };
        }

        record Context(PsiExpression wrappingArgument, PsiMethodCallExpression outerCall) {
        }
    }

    private static class OptionalOfNullableStringCase
    implements ChainSimplificationCase<Context> {
        private OptionalOfNullableStringCase() {
        }

        @Override
        @NotNull
        public String getName(@NotNull Context context) {
            if (context == null) {
                OptionalOfNullableStringCase.$$$reportNull$$$0(0);
            }
            String string = JavaBundle.message((String)"simplify.optional.chain.inspection.fix.description.replace.with.value.of.name", (Object[])new Object[0]);
            if (string == null) {
                OptionalOfNullableStringCase.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDescription(@NotNull Context context) {
            if (context == null) {
                OptionalOfNullableStringCase.$$$reportNull$$$0(2);
            }
            String string = JavaBundle.message((String)"simplify.optional.chain.inspection.fix.description.replace.with.value.of.description", (Object[])new Object[0]);
            if (string == null) {
                OptionalOfNullableStringCase.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @Nullable
        public Context extractContext(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            PsiExpression arg;
            if (project == null) {
                OptionalOfNullableStringCase.$$$reportNull$$$0(4);
            }
            if (call == null) {
                OptionalOfNullableStringCase.$$$reportNull$$$0(5);
            }
            if (!TypeUtils.isJavaLangString((PsiType)(arg = call.getArgumentList().getExpressions()[0]).getType())) {
                return null;
            }
            PsiMethodCallExpression maybeOrElse = ExpressionUtils.getCallForQualifier((PsiExpression)call);
            if (!OPTIONAL_OR_ELSE.matches((PsiExpression)maybeOrElse)) {
                return null;
            }
            PsiExpression orElseArgument = maybeOrElse.getArgumentList().getExpressions()[0];
            PsiLiteralExpression literal = ExpressionUtils.getLiteral((PsiExpression)orElseArgument);
            if (literal == null || !"null".equals(literal.getValue())) {
                return null;
            }
            return new Context(arg, maybeOrElse);
        }

        @Override
        public void apply(@NotNull Project project, @NotNull PsiMethodCallExpression call, @NotNull Context context) {
            if (project == null) {
                OptionalOfNullableStringCase.$$$reportNull$$$0(6);
            }
            if (call == null) {
                OptionalOfNullableStringCase.$$$reportNull$$$0(7);
            }
            if (context == null) {
                OptionalOfNullableStringCase.$$$reportNull$$$0(8);
            }
            CommentTracker ct = new CommentTracker();
            ct.replaceAndRestoreComments((PsiElement)context.orElseCall, "java.lang.String.valueOf(" + ct.text((PsiElement)context.argument) + ")");
        }

        @Override
        @NotNull
        public CallMatcher getMatcher() {
            CallMatcher callMatcher = OPTIONAL_OF_NULLABLE;
            if (callMatcher == null) {
                OptionalOfNullableStringCase.$$$reportNull$$$0(9);
            }
            return callMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OptionalOfNullableStringCase";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OptionalOfNullableStringCase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDescription";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "extractContext";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 9 -> new IllegalStateException(string);
            };
        }

        record Context(PsiExpression argument, PsiMethodCallExpression orElseCall) {
        }
    }

    private static abstract class BasicSimplificationInspection
    implements ChainSimplificationCase<StringReplacement> {
        private BasicSimplificationInspection() {
        }

        @Override
        @NotNull
        public String getName(@NotNull StringReplacement context) {
            if (context == null) {
                BasicSimplificationInspection.$$$reportNull$$$0(0);
            }
            String string = context.myMessage;
            if (string == null) {
                BasicSimplificationInspection.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDescription(@NotNull StringReplacement context) {
            if (context == null) {
                BasicSimplificationInspection.$$$reportNull$$$0(2);
            }
            String string = context.myDescription;
            if (string == null) {
                BasicSimplificationInspection.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public void apply(@NotNull Project project, @NotNull PsiMethodCallExpression call, @NotNull StringReplacement context) {
            if (project == null) {
                BasicSimplificationInspection.$$$reportNull$$$0(4);
            }
            if (call == null) {
                BasicSimplificationInspection.$$$reportNull$$$0(5);
            }
            if (context == null) {
                BasicSimplificationInspection.$$$reportNull$$$0(6);
            }
            PsiExpression replacementExpression = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(context.myReplacement, (PsiElement)call);
            PsiElement result = call.replace((PsiElement)replacementExpression);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences((PsiElement)result);
            RemoveRedundantTypeArgumentsUtil.removeRedundantTypeArguments((PsiElement)result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$BasicSimplificationInspection";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$BasicSimplificationInspection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDescription";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3 -> new IllegalStateException(string);
            };
        }

        protected static class StringReplacement {
            @NonNls
            private final String myReplacement;
            @IntentionName
            private final String myMessage;
            private final @InspectionMessage String myDescription;

            StringReplacement(@NonNls String replacement, @IntentionName String message, @InspectionMessage String description) {
                this.myReplacement = replacement;
                this.myMessage = message;
                this.myDescription = description;
            }
        }
    }

    private static abstract class OptionalChainVisitor
    extends JavaElementVisitor {
        private final LanguageLevel myLevel;

        private OptionalChainVisitor(LanguageLevel level) {
            this.myLevel = level;
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                OptionalChainVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            Optional<OptionalSimplificationFix> fix = ourMapper.mapAll(expression).filter(f -> f.myInspection.isAppropriateLanguageLevel(this.myLevel)).findAny();
            if (fix.isEmpty()) {
                return;
            }
            this.handleSimplification(expression, fix.get());
        }

        protected abstract void handleSimplification(@NotNull PsiMethodCallExpression var1, @NotNull OptionalSimplificationFix var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$OptionalChainVisitor", "visitMethodCallExpression"));
        }
    }
}

