/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.intention.impl.StreamRefactoringUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.redundantCast.RemoveRedundantCastUtil;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.impl.source.tree.java.PsiEmptyExpressionImpl;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.bugs.MismatchedCollectionQueryUpdateInspection;
import com.siyeh.ig.callMatcher.CallHandler;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EqualityCheck;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FunctionalExpressionUtils;
import com.siyeh.ig.psiutils.IndexedContainer;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.lang.runtime.SwitchBootstraps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimplifyStreamApiCallChainsInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher COLLECTION_STREAM = CallMatcher.instanceCall((String)"java.util.Collection", (String[])new String[]{"stream"}).parameterCount(0);
    private static final CallMatcher COLLECTION_SIZE_CHECK = CallMatcher.instanceCall((String)"java.util.Collection", (String[])new String[]{"size", "isEmpty"}).parameterCount(0);
    private static final CallMatcher COLLECTION_CONTAINS = CallMatcher.instanceCall((String)"java.util.Collection", (String[])new String[]{"contains"}).parameterCount(1);
    private static final CallMatcher OPTIONAL_STREAM = CallMatcher.instanceCall((String)"java.util.Optional", (String[])new String[]{"stream"}).parameterCount(0);
    private static final CallMatcher STREAM_FIND = CallMatcher.instanceCall((String)"java.util.stream.Stream", (String[])new String[]{"findFirst", "findAny"}).parameterCount(0);
    private static final CallMatcher STREAM_FILTER = CallMatcher.instanceCall((String)"java.util.stream.Stream", (String[])new String[]{"filter"}).parameterTypes(new String[]{"java.util.function.Predicate"});
    private static final CallMatcher STREAM_FIND_FIRST = CallMatcher.instanceCall((String)"java.util.stream.BaseStream", (String[])new String[]{"findFirst"}).parameterCount(0);
    private static final CallMatcher STREAM_SORTED = CallMatcher.instanceCall((String)"java.util.stream.BaseStream", (String[])new String[]{"sorted"});
    private static final CallMatcher STREAM_MAP = CallMatcher.instanceCall((String)"java.util.stream.Stream", (String[])new String[]{"map"}).parameterTypes(new String[]{"java.util.function.Function"});
    private static final CallMatcher BASE_STREAM_MAP = CallMatcher.instanceCall((String)"java.util.stream.BaseStream", (String[])new String[]{"map"}).parameterCount(1);
    private static final CallMatcher STREAM_ANY_MATCH = CallMatcher.instanceCall((String)"java.util.stream.BaseStream", (String[])new String[]{"anyMatch"}).parameterCount(1);
    private static final CallMatcher INT_STREAM_RANGE = CallMatcher.staticCall((String)"java.util.stream.IntStream", (String[])new String[]{"range"}).parameterTypes(new String[]{"int", "int"});
    private static final CallMatcher STREAM_NONE_MATCH = CallMatcher.instanceCall((String)"java.util.stream.BaseStream", (String[])new String[]{"noneMatch"}).parameterCount(1);
    private static final CallMatcher STREAM_ALL_MATCH = CallMatcher.instanceCall((String)"java.util.stream.BaseStream", (String[])new String[]{"allMatch"}).parameterCount(1);
    private static final CallMatcher STREAM_COLLECT = CallMatcher.instanceCall((String)"java.util.stream.Stream", (String[])new String[]{"collect"}).parameterCount(1);
    private static final CallMatcher OPTIONAL_IS_PRESENT = CallMatcher.instanceCall((String)"java.util.Optional", (String[])new String[]{"isPresent"}).parameterCount(0);
    private static final CallMatcher BOOLEAN_EQUALS = CallMatcher.instanceCall((String)"java.lang.Boolean", (String[])new String[]{"equals"}).parameterCount(1);
    private static final CallMatcher STREAM_OF = CallMatcher.staticCall((String)"java.util.stream.Stream", (String[])new String[]{"of"}).parameterTypes(new String[]{"T"});
    private static final CallMatcher ARRAYS_STREAM = CallMatcher.anyOf((CallMatcher[])new CallMatcher[]{CallMatcher.staticCall((String)"java.util.stream.Stream", (String[])new String[]{"of"}).parameterTypes(new String[]{"T..."}), CallMatcher.staticCall((String)"java.util.Arrays", (String[])new String[]{"stream"}).parameterTypes(new String[]{"T[]"})});
    private static final CallMatcher N_COPIES = CallMatcher.staticCall((String)"java.util.Collections", (String[])new String[]{"nCopies"}).parameterTypes(new String[]{"int", "T"});
    private static final CallMatcher COMPARATOR_REVERSED = CallMatcher.instanceCall((String)"java.util.Comparator", (String[])new String[]{"reversed"}).parameterCount(0);
    private static final CallMatcher STREAM_INT_MAP_TO_ALL = CallMatcher.instanceCall((String)"java.util.stream.IntStream", (String[])new String[]{"map", "mapToObj", "mapToDouble", "mapToLong"}).parameterCount(1);
    private static final CallMatcher STREAM_MAP_TO_ALL = CallMatcher.instanceCall((String)"java.util.stream.BaseStream", (String[])new String[]{"map", "mapToInt", "mapToDouble", "mapToLong"}).parameterCount(1);
    private static final CallMatcher STREAM_MATCH = CallMatcher.anyOf((CallMatcher[])new CallMatcher[]{STREAM_ANY_MATCH, STREAM_NONE_MATCH, STREAM_ALL_MATCH});
    private static final CallMatcher COLLECTORS_TO_LIST = CallMatcher.staticCall((String)"java.util.stream.Collectors", (String[])new String[]{"toList", "toUnmodifiableList"}).parameterCount(0);
    private static final CallMatcher MAP_ENTRY_SET = CallMatcher.instanceCall((String)"java.util.Map", (String[])new String[]{"entrySet"}).parameterCount(0);
    private static final CallMatcher STREAM_TAKE_WHILE = CallMatcher.instanceCall((String)"java.util.stream.BaseStream", (String[])new String[]{"takeWhile"}).parameterCount(1).withLanguageLevelAtLeast(LanguageLevel.JDK_1_9);
    private static final CallMatcher STREAM_ITERATE = CallMatcher.anyOf((CallMatcher[])new CallMatcher[]{CallMatcher.staticCall((String)"java.util.stream.Stream", (String[])new String[]{"iterate"}).parameterCount(2), CallMatcher.staticCall((String)"java.util.stream.IntStream", (String[])new String[]{"iterate"}).parameterCount(2), CallMatcher.staticCall((String)"java.util.stream.LongStream", (String[])new String[]{"iterate"}).parameterCount(2), CallMatcher.staticCall((String)"java.util.stream.DoubleStream", (String[])new String[]{"iterate"}).parameterCount(2)});
    private static final CallMatcher OPTIONAL_OR_ELSE_GET = CallMatcher.anyOf((CallMatcher[])new CallMatcher[]{CallMatcher.exactInstanceCall((String)"java.util.Optional", (String[])new String[]{"orElseGet"}).parameterCount(1), CallMatcher.exactInstanceCall((String)"java.util.OptionalInt", (String[])new String[]{"orElseGet"}).parameterCount(1), CallMatcher.exactInstanceCall((String)"java.util.OptionalLong", (String[])new String[]{"orElseGet"}).parameterCount(1), CallMatcher.exactInstanceCall((String)"java.util.OptionalDouble", (String[])new String[]{"orElseGet"}).parameterCount(1)});
    private static final CallMapper<CallChainSimplification> CALL_TO_FIX_MAPPER = new CallMapper(new CallHandler[]{ReplaceCollectionStreamFix.handler(), ReplaceWithToArrayFix.handler(), ReplaceStreamSupportWithCollectionStreamFix.handler(), ReplaceWithBoxedFix.handler(), ReplaceWithElementIterationFix.handler(), ReplaceForEachMethodFix.handler(), RemoveBooleanIdentityFix.handler(), ReplaceWithPeekFix.handler(), SimpleStreamOfFix.handler(), RangeToArrayStreamFix.handler(), NCopiesToGenerateStreamFix.handler(), SortedFirstToMinMaxFix.handler(), AllMatchContainsFix.handler(), AnyMatchContainsFix.handler(), JoiningStringsFix.handler(), ReplaceWithCollectorsJoiningFix.handler(), EntrySetMapFix.handler(), CollectorToListSize.handler(), IterateTakeWhileFix.handler(), FilterAndMapUseSameMethodChainFix.handler(), ReplaceWithOrElseThrowFix.handler()}).registerAll(SimplifyMatchNegationFix.handlers());
    private static final Logger LOG = Logger.getInstance(SimplifyStreamApiCallChainsInspection.class);
    private static final String FOR_EACH_METHOD = "forEach";
    private static final String IF_PRESENT_METHOD = "ifPresent";
    private static final String STREAM_METHOD = "stream";
    private static final String EMPTY_METHOD = "empty";
    private static final String OF_METHOD = "of";
    private static final String ANY_MATCH_METHOD = "anyMatch";
    private static final String NONE_MATCH_METHOD = "noneMatch";
    private static final String ALL_MATCH_METHOD = "allMatch";

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.STREAM_OPTIONAL);
        if (set == null) {
            SimplifyStreamApiCallChainsInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SimplifyStreamApiCallChainsInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression methodCall) {
                PsiElement nameElement;
                if (methodCall == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((nameElement = methodCall.getMethodExpression().getReferenceNameElement()) == null) {
                    return;
                }
                CALL_TO_FIX_MAPPER.mapAll(methodCall).forEach(simplification -> holder.registerProblem(nameElement, simplification.getMessage(), new LocalQuickFix[]{new SimplifyCallChainFix((CallChainFix)simplification)}));
                if (STREAM_COLLECT.test(methodCall)) {
                    this.handleStreamCollect(methodCall);
                } else if (OPTIONAL_IS_PRESENT.test(methodCall)) {
                    this.handleOptionalIsPresent(methodCall);
                }
            }

            private void handleOptionalIsPresent(PsiMethodCallExpression methodCall) {
                PsiMethodCallExpression optionalQualifier = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)methodCall);
                if (!STREAM_FIND.test(optionalQualifier)) {
                    return;
                }
                PsiMethodCallExpression streamQualifier = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)optionalQualifier);
                if (!STREAM_FILTER.test(streamQualifier)) {
                    return;
                }
                ReplaceOptionalIsPresentChainFix fix = new ReplaceOptionalIsPresentChainFix(optionalQualifier.getMethodExpression().getReferenceName());
                holder.registerProblem((PsiElement)methodCall, SimplifyStreamApiCallChainsInspection.getCallChainRange(methodCall, streamQualifier), fix.getMessage(), new LocalQuickFix[]{new SimplifyCallChainFix(fix)});
            }

            private void handleStreamCollect(PsiMethodCallExpression methodCall) {
                PsiExpression parameter = methodCall.getArgumentList().getExpressions()[0];
                if (parameter instanceof PsiMethodCallExpression) {
                    PsiElement startElement;
                    PsiMethodCallExpression qualifier;
                    String replacement;
                    PsiMethodCallExpression collectorCall = (PsiMethodCallExpression)parameter;
                    ReplaceCollectorFix fix = (ReplaceCollectorFix)ReplaceCollectorFix.COLLECTOR_TO_FIX_MAPPER.mapFirst(collectorCall);
                    if (fix != null) {
                        TextRange range = methodCall.getTextRange();
                        PsiElement nameElement = methodCall.getMethodExpression().getReferenceNameElement();
                        if (nameElement != null) {
                            range = new TextRange(nameElement.getTextOffset(), range.getEndOffset());
                        }
                        holder.registerProblem((PsiElement)methodCall, range.shiftRight(-methodCall.getTextOffset()), fix.getMessage(), new LocalQuickFix[]{new SimplifyCallChainFix(fix)});
                    } else if (!(PsiUtil.resolveClassInClassTypeOnly((PsiType)methodCall.getType()) instanceof PsiTypeParameter) && (replacement = (String)SimplifyCollectionCreationFix.COLLECTOR_TO_CLASS_MAPPER.mapFirst(collectorCall)) != null && COLLECTION_STREAM.test(qualifier = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)methodCall)) && (startElement = qualifier.getMethodExpression().getReferenceNameElement()) != null) {
                        holder.registerProblem((PsiElement)methodCall, new TextRange(startElement.getTextOffset() - methodCall.getTextOffset(), methodCall.getTextLength()), JavaBundle.message((String)"inspection.message.can.be.replaced.with.0.constructor", (Object[])new Object[]{replacement}), new LocalQuickFix[]{new SimplifyCallChainFix(new SimplifyCollectionCreationFix(replacement))});
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    public static PsiElement simplifyStreamExpressions(PsiElement element, boolean keepStream) {
        boolean replaced = true;
        while (replaced) {
            replaced = false;
            Map callToSimplification = ((EntryStream)StreamEx.ofTree((Object)element, e -> StreamEx.of((Object[])e.getChildren())).select(PsiMethodCallExpression.class).mapToEntry(arg_0 -> CALL_TO_FIX_MAPPER.mapFirst(arg_0)).nonNullValues().chain(s -> keepStream ? s.filterValues(CallChainSimplification::keepsStream) : s)).toCustomMap(LinkedHashMap::new);
            for (Map.Entry entry : callToSimplification.entrySet()) {
                PsiElement replacement;
                if (!((PsiMethodCallExpression)entry.getKey()).isValid() || (replacement = ((CallChainSimplification)entry.getValue()).simplify((PsiMethodCallExpression)entry.getKey())) == null) continue;
                replaced = true;
                if (element != entry.getKey()) continue;
                element = replacement;
            }
        }
        return element;
    }

    static CallMatcher collectorMatcher(String name, int parameterCount) {
        return CallMatcher.staticCall((String)"java.util.stream.Collectors", (String[])new String[]{name}).parameterCount(parameterCount);
    }

    @NotNull
    private static TextRange getCallChainRange(@NotNull PsiMethodCallExpression expression, @NotNull PsiMethodCallExpression qualifierExpression) {
        PsiReferenceExpression qualifierMethodExpression;
        PsiElement qualifierNameElement;
        if (expression == null) {
            SimplifyStreamApiCallChainsInspection.$$$reportNull$$$0(2);
        }
        if (qualifierExpression == null) {
            SimplifyStreamApiCallChainsInspection.$$$reportNull$$$0(3);
        }
        int startOffset = ((qualifierNameElement = (qualifierMethodExpression = qualifierExpression.getMethodExpression()).getReferenceNameElement()) != null ? qualifierNameElement : qualifierMethodExpression).getTextOffset();
        int endOffset = expression.getMethodExpression().getTextRange().getEndOffset();
        TextRange textRange = new TextRange(startOffset, endOffset).shiftRight(-expression.getTextOffset());
        if (textRange == null) {
            SimplifyStreamApiCallChainsInspection.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallChainRange";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCallChainRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }

    static interface CallChainSimplification
    extends CallChainFix {
        @InspectionMessage
        public String getMessage();

        default public boolean keepsStream() {
            return true;
        }

        @Override
        default public void applyFix(@NotNull Project project, PsiElement element) {
            PsiMethodCallExpression call;
            if (project == null) {
                CallChainSimplification.$$$reportNull$$$0(0);
            }
            if ((call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class, (boolean)false)) != null) {
                this.simplify(call);
            }
        }

        public PsiElement simplify(PsiMethodCallExpression var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$CallChainSimplification", "applyFix"));
        }
    }

    private static class ReplaceCollectionStreamFix
    implements CallChainSimplification {
        private static final CallMatcher EMPTY_LIST = CallMatcher.staticCall((String)"java.util.Collections", (String[])new String[]{"emptyList"}).parameterCount(0);
        private static final CallMatcher EMPTY_SET = CallMatcher.staticCall((String)"java.util.Collections", (String[])new String[]{"emptySet"}).parameterCount(0);
        private static final CallMatcher SINGLETON_LIST = CallMatcher.staticCall((String)"java.util.Collections", (String[])new String[]{"singletonList"}).parameterCount(1);
        private static final CallMatcher SINGLETON = CallMatcher.staticCall((String)"java.util.Collections", (String[])new String[]{"singleton"}).parameterCount(1);
        private static final CallMatcher AS_LIST = CallMatcher.staticCall((String)"java.util.Arrays", (String[])new String[]{"asList"}).parameterCount(1);
        private static final CallMatcher ENUMSET_OF = CallMatcher.staticCall((String)"java.util.EnumSet", (String[])new String[]{"of"});
        private static final CallMatcher LIST_OF = CallMatcher.staticCall((String)"java.util.List", (String[])new String[]{"of"});
        private static final CallMapper<ReplaceCollectionStreamFix> COLLECTION_TO_STREAM_MAPPER = new CallMapper().register(EMPTY_LIST, (Object)new ReplaceCollectionStreamFix("Collections.emptyList()", "java.util.stream.Stream", "empty")).register(EMPTY_SET, (Object)new ReplaceCollectionStreamFix("Collections.emptySet()", "java.util.stream.Stream", "empty")).register(SINGLETON, call -> ReplaceCollectionStreamFix.hasSingleArrayArgument(call) ? null : new ReplaceSingletonWithStreamOfFix("Collections.singleton()")).register(SINGLETON_LIST, call -> ReplaceCollectionStreamFix.hasSingleArrayArgument(call) ? null : new ReplaceSingletonWithStreamOfFix("Collections.singletonList()")).register(AS_LIST, call -> ReplaceCollectionStreamFix.hasSingleArrayArgument(call) ? new ReplaceCollectionStreamFix("Arrays.asList()", "java.util.Arrays", SimplifyStreamApiCallChainsInspection.STREAM_METHOD) : new ReplaceCollectionStreamFix("Arrays.asList()", "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.OF_METHOD)).register(ENUMSET_OF, call -> ReplaceCollectionStreamFix.isEnumSetReplaceableWithStream(call) ? new ReplaceCollectionStreamFix("EnumSet.of()", "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.OF_METHOD) : null).register(LIST_OF, call -> new ReplaceCollectionStreamFix("List.of()", "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.OF_METHOD));
        private static final String STREAM_SUFFIX = ".stream()";
        private final String myClassName;
        private final String myMethodName;
        private final String myQualifierCall;

        private ReplaceCollectionStreamFix(String qualifierCall, String className, String methodName) {
            this.myQualifierCall = qualifierCall;
            this.myClassName = className;
            this.myMethodName = methodName;
        }

        @Override
        @NotNull
        public String getMessage() {
            String oldExpr = this.myQualifierCall + STREAM_SUFFIX;
            String newExpr = ClassUtil.extractClassName((String)this.myClassName) + "." + this.myMethodName + "()";
            String string = JavaBundle.message((String)"simplify.stream.inspection.message.can.be.replaced", (Object[])new Object[]{oldExpr, newExpr});
            if (string == null) {
                ReplaceCollectionStreamFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = JavaBundle.message((String)"quickfix.text.replace.0.stream.with.1.2", (Object[])new Object[]{this.myQualifierCall, ClassUtil.extractClassName((String)this.myClassName), this.myMethodName});
            if (string == null) {
                ReplaceCollectionStreamFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        protected String getTypeParameter(@NotNull CommentTracker ct, @NotNull PsiMethodCallExpression qualifierCall) {
            PsiReferenceParameterList parameterList;
            if (ct == null) {
                ReplaceCollectionStreamFix.$$$reportNull$$$0(2);
            }
            if (qualifierCall == null) {
                ReplaceCollectionStreamFix.$$$reportNull$$$0(3);
            }
            if ((parameterList = qualifierCall.getMethodExpression().getParameterList()) == null) {
                return null;
            }
            PsiTypeElement[] elements = parameterList.getTypeParameterElements();
            return elements.length == 1 ? ct.text((PsiElement)elements[0]) : null;
        }

        @Override
        @Nullable
        public PsiElement simplify(PsiMethodCallExpression streamCall) {
            PsiMethodCallExpression collectionCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)streamCall);
            if (collectionCall == null) {
                return null;
            }
            CommentTracker ct = new CommentTracker();
            ct.replace((PsiElement)streamCall.getArgumentList(), (PsiElement)collectionCall.getArgumentList());
            String typeParameter = this.getTypeParameter(ct, collectionCall);
            String replacement = typeParameter != null ? this.myClassName + ".<" + typeParameter + ">" + this.myMethodName : this.myClassName + "." + this.myMethodName;
            Project project = streamCall.getProject();
            PsiElement result = ct.replaceAndRestoreComments((PsiElement)streamCall.getMethodExpression(), replacement);
            return JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
        }

        public static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of((CallMatcher)COLLECTION_STREAM, methodCall -> (CallChainSimplification)COLLECTION_TO_STREAM_MAPPER.mapFirst(MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)methodCall)));
        }

        private static boolean isEnumSetReplaceableWithStream(PsiMethodCallExpression call) {
            PsiExpression[] expressions = call.getArgumentList().getExpressions();
            if (expressions.length == 0) {
                return false;
            }
            HashSet<String> names = new HashSet<String>();
            PsiClass enumClass = null;
            for (PsiExpression arg : expressions) {
                PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)arg), PsiReferenceExpression.class);
                if (ref == null) {
                    return false;
                }
                PsiEnumConstant enumConstant = (PsiEnumConstant)ObjectUtils.tryCast((Object)ref.resolve(), PsiEnumConstant.class);
                if (enumConstant == null || !names.add(enumConstant.getName())) {
                    return false;
                }
                if (enumClass == null) {
                    enumClass = enumConstant.getContainingClass();
                    continue;
                }
                if (enumConstant.getContainingClass() == enumClass) continue;
                return false;
            }
            return true;
        }

        private static boolean hasSingleArrayArgument(PsiMethodCallExpression qualifierCall) {
            PsiType type;
            PsiExpression[] argumentExpressions = qualifierCall.getArgumentList().getExpressions();
            if (argumentExpressions.length == 1 && (type = argumentExpressions[0].getType()) instanceof PsiArrayType) {
                PsiType[] parameters;
                PsiType methodType = qualifierCall.getType();
                return !(methodType instanceof PsiClassType) || (parameters = ((PsiClassType)methodType).getParameters()).length != 1 || !TypeConversionUtil.isAssignable((PsiType)parameters[0], (PsiType)type) || TypeConversionUtil.isAssignable((PsiType)parameters[0], (PsiType)((PsiArrayType)type).getComponentType());
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectionStreamFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ct";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifierCall";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectionStreamFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getTypeParameter";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ReplaceWithToArrayFix
    implements CallChainSimplification {
        private static final CallMatcher TO_ARRAY = CallMatcher.instanceCall((String)"java.util.stream.Stream", (String[])new String[]{"toArray"});

        private ReplaceWithToArrayFix() {
        }

        @Override
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"stream().toArray()", "toArray()"});
        }

        @Override
        public boolean keepsStream() {
            return false;
        }

        @Override
        public String getMessage() {
            return CommonQuickFixBundle.message((String)"fix.can.replace.with.x", (Object[])new Object[]{"collection.toArray()"});
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression toArrayCall) {
            if (!TO_ARRAY.test(toArrayCall)) {
                return null;
            }
            CommentTracker ct = new CommentTracker();
            String replacement = ReplaceWithToArrayFix.getReplacement(toArrayCall, ct);
            if (replacement == null) {
                return null;
            }
            PsiMethodCallExpression streamCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)toArrayCall);
            if (streamCall == null) {
                return null;
            }
            PsiExpression collectionExpression = streamCall.getMethodExpression().getQualifierExpression();
            if (collectionExpression == null) {
                return null;
            }
            return ct.replaceAndRestoreComments((PsiElement)toArrayCall, ct.text((PsiElement)collectionExpression) + ".toArray(" + replacement + ")");
        }

        static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of((CallMatcher)TO_ARRAY, methodCall -> {
                if (!COLLECTION_STREAM.test(MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)methodCall))) {
                    return null;
                }
                return ReplaceWithToArrayFix.getReplacement(methodCall, new CommentTracker()) == null ? null : new ReplaceWithToArrayFix();
            });
        }

        @Nullable
        private static String getReplacement(PsiMethodCallExpression methodCall, CommentTracker ct) {
            PsiArrayType type = ReplaceWithToArrayFix.getArrayType(methodCall);
            if (type != null && type.equalsToText("java.lang.Object[]")) {
                return "";
            }
            if (PsiUtil.getLanguageLevel((PsiElement)methodCall).isAtLeast(LanguageLevel.JDK_11)) {
                return ct.text((PsiElement)methodCall.getArgumentList().getExpressions()[0]);
            }
            if (type != null) {
                return "new " + type.getCanonicalText().replaceFirst("\\[]", "[0]");
            }
            return null;
        }

        @Nullable
        private static PsiArrayType getArrayType(PsiMethodCallExpression call) {
            PsiType type = call.getType();
            if (!(type instanceof PsiArrayType)) {
                return null;
            }
            PsiArrayType candidate = (PsiArrayType)type;
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length == 0) {
                return candidate;
            }
            if (args.length != 1) {
                return null;
            }
            PsiExpression supplier = PsiUtil.skipParenthesizedExprDown((PsiExpression)args[0]);
            if (supplier instanceof PsiMethodReferenceExpression) {
                PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)supplier;
                PsiTypeElement qualifierType = methodRef.getQualifierType();
                if (methodRef.isConstructor() && qualifierType != null && candidate.isAssignableFrom(qualifierType.getType())) {
                    return candidate;
                }
            } else if (supplier instanceof PsiLambdaExpression) {
                PsiLambdaExpression lambda = (PsiLambdaExpression)supplier;
                PsiParameter[] parameters = lambda.getParameterList().getParameters();
                if (parameters.length != 1) {
                    return null;
                }
                PsiParameter sizeParameter = parameters[0];
                PsiExpression body = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda.getBody());
                if (body instanceof PsiNewExpression) {
                    PsiNewExpression newExpression = (PsiNewExpression)body;
                    PsiExpression[] dimensions = newExpression.getArrayDimensions();
                    PsiType newExpressionType = newExpression.getType();
                    if (dimensions.length != 0 && ExpressionUtils.isReferenceTo((PsiExpression)dimensions[0], (PsiVariable)sizeParameter) && newExpressionType != null && candidate.isAssignableFrom(newExpressionType)) {
                        return candidate;
                    }
                }
            }
            return null;
        }
    }

    private static class ReplaceStreamSupportWithCollectionStreamFix
    implements CallChainSimplification {
        private static final CallMatcher STREAM_SUPPORT = CallMatcher.staticCall((String)"java.util.stream.StreamSupport", (String[])new String[]{"stream"}).parameterTypes(new String[]{"java.util.Spliterator", "boolean"});
        private static final CallMatcher SPLITERATOR = CallMatcher.instanceCall((String)"java.util.Collection", (String[])new String[]{"spliterator"}).parameterCount(0);
        private final String myQualifierText;
        private final boolean myParallel;

        ReplaceStreamSupportWithCollectionStreamFix(@NotNull PsiExpression qualifier, boolean parallel) {
            if (qualifier == null) {
                ReplaceStreamSupportWithCollectionStreamFix.$$$reportNull$$$0(0);
            }
            this.myQualifierText = PsiExpressionTrimRenderer.render((PsiExpression)qualifier, (int)50);
            this.myParallel = parallel;
        }

        @Override
        public String getName() {
            return JavaBundle.message((String)"simplify.stream.replace.support.with.collection.fix.name", (Object[])new Object[]{this.myQualifierText, this.getMethodName()});
        }

        @Override
        public String getMessage() {
            return JavaBundle.message((String)"simplify.stream.replace.support.with.collection.fix.message", (Object[])new Object[]{this.myQualifierText, this.getMethodName()});
        }

        @NotNull
        private String getMethodName() {
            return this.myParallel ? "parallelStream" : SimplifyStreamApiCallChainsInspection.STREAM_METHOD;
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression call) {
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length != 2) {
                return null;
            }
            PsiMethodCallExpression spliteratorCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)args[0]), PsiMethodCallExpression.class);
            if (spliteratorCall == null) {
                return null;
            }
            ExpressionUtils.bindCallTo((PsiMethodCallExpression)spliteratorCall, (String)this.getMethodName());
            CommentTracker ct = new CommentTracker();
            return ct.replace((PsiElement)call, (PsiElement)spliteratorCall);
        }

        static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of((CallMatcher)STREAM_SUPPORT, call -> {
                PsiExpression[] args = call.getArgumentList().getExpressions();
                PsiExpression parallel = args[1];
                if (!ExpressionUtils.isLiteral((PsiElement)parallel, (Object)Boolean.TRUE) && !ExpressionUtils.isLiteral((PsiElement)parallel, (Object)Boolean.FALSE)) {
                    return null;
                }
                PsiMethodCallExpression spliterator = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)args[0]), PsiMethodCallExpression.class);
                if (!SPLITERATOR.test(spliterator)) {
                    return null;
                }
                PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)spliterator.getMethodExpression().getQualifierExpression());
                if (qualifier == null || qualifier instanceof PsiThisExpression) {
                    return null;
                }
                return new ReplaceStreamSupportWithCollectionStreamFix(qualifier, ExpressionUtils.isLiteral((PsiElement)parallel, (Object)Boolean.TRUE));
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceStreamSupportWithCollectionStreamFix", "<init>"));
        }
    }

    private static class ReplaceWithBoxedFix
    implements CallChainSimplification {
        private static final CallMatcher MAP_TO_OBJ = CallMatcher.instanceCall((String)"java.util.stream.BaseStream", (String[])new String[]{"mapToObj"}).parameterCount(1);

        private ReplaceWithBoxedFix() {
        }

        @Override
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"boxed"});
        }

        @Override
        public String getMessage() {
            return CommonQuickFixBundle.message((String)"fix.can.replace.with.x", (Object[])new Object[]{"boxed"});
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression call) {
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length != 1) {
                return null;
            }
            ExpressionUtils.bindCallTo((PsiMethodCallExpression)call, (String)"boxed");
            args[0].delete();
            call.getTypeArgumentList().delete();
            return call;
        }

        static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of((CallMatcher)MAP_TO_OBJ, call -> {
                PsiExpression arg = call.getArgumentList().getExpressions()[0];
                PsiType type = StreamApiUtil.getStreamElementType((PsiType)call.getType());
                PsiClass targetClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
                if (targetClass == null) {
                    return null;
                }
                PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
                if (qualifier == null || !TypeConversionUtil.boxingConversionApplicable((PsiType)StreamApiUtil.getStreamElementType((PsiType)qualifier.getType()), (PsiType)type) || !ReplaceWithBoxedFix.isBoxingFunction(arg, targetClass)) {
                    return null;
                }
                return new ReplaceWithBoxedFix();
            });
        }

        @Contract(value="null, _ -> false")
        private static boolean isBoxingFunction(PsiExpression arg, PsiClass targetClass) {
            PsiMethod method;
            PsiElement target;
            if (arg instanceof PsiMethodReferenceExpression && (target = ((PsiMethodReferenceExpression)arg).resolve()) instanceof PsiMethod && targetClass == (method = (PsiMethod)target).getContainingClass() && (method.isConstructor() || method.getName().equals("valueOf")) && method.getParameterList().getParametersCount() == 1) {
                return true;
            }
            if (arg instanceof PsiLambdaExpression) {
                PsiLambdaExpression lambda = (PsiLambdaExpression)arg;
                PsiParameter[] parameters = lambda.getParameterList().getParameters();
                if (parameters.length != 1) {
                    return false;
                }
                PsiParameter parameter = parameters[0];
                PsiExpression expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda.getBody()));
                if (ExpressionUtils.isReferenceTo((PsiExpression)expression, (PsiVariable)parameter)) {
                    return true;
                }
                if (expression instanceof PsiCallExpression) {
                    PsiMethod method2;
                    PsiJavaCodeReferenceElement ref;
                    PsiExpressionList list = ((PsiCallExpression)expression).getArgumentList();
                    if (list == null) {
                        return false;
                    }
                    PsiExpression[] args = list.getExpressions();
                    if (args.length != 1 || !ExpressionUtils.isReferenceTo((PsiExpression)args[0], (PsiVariable)parameter)) {
                        return false;
                    }
                    if (expression instanceof PsiNewExpression && (ref = ((PsiNewExpression)expression).getClassReference()) != null && ref.isReferenceTo((PsiElement)targetClass)) {
                        return true;
                    }
                    if (expression instanceof PsiMethodCallExpression && (method2 = ((PsiMethodCallExpression)expression).resolveMethod()) != null && method2.getContainingClass() == targetClass && method2.getName().equals("valueOf")) {
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private static class ReplaceWithElementIterationFix
    implements CallChainSimplification {
        private static final CallMatcher INT_STREAM_MAP = CallMatcher.instanceCall((String)"java.util.stream.IntStream", (String[])new String[]{"map", "mapToLong", "mapToDouble", "mapToObj"}).parameterCount(1);
        private static final CallMatcher MIN_INT = CallMatcher.anyOf((CallMatcher[])new CallMatcher[]{CallMatcher.staticCall((String)"java.lang.Math", (String[])new String[]{"min"}).parameterTypes(new String[]{"int", "int"}), CallMatcher.staticCall((String)"java.lang.Integer", (String[])new String[]{"min"}).parameterTypes(new String[]{"int", "int"})});
        private static final String STREAM_SUFFIX = ".stream()";
        private static final String ARRAY_STREAM_PREFIX = "Arrays.stream(";
        @IntentionName
        private final String myName;

        ReplaceWithElementIterationFix(IndexedContainer container, String name) {
            PsiExpression qualifier = container.getQualifier();
            String qualifierText = PsiExpressionTrimRenderer.render((PsiExpression)qualifier, (int)50);
            PsiType type = qualifier.getType();
            String replacement = type instanceof PsiArrayType ? ARRAY_STREAM_PREFIX + qualifierText + ")" : qualifierText + STREAM_SUFFIX;
            this.myName = CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"IntStream.range()." + name + "()", replacement});
        }

        @Override
        public String getName() {
            return this.myName;
        }

        @Override
        public String getMessage() {
            return JavaBundle.message((String)"simplify.stream.replace.with.element.iteration.fix.message", (Object[])new Object[0]);
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression mapToObjCall) {
            Project project = mapToObjCall.getProject();
            PsiExpression mapper = (PsiExpression)ArrayUtil.getFirstElement((Object[])mapToObjCall.getArgumentList().getExpressions());
            LimitedContainer limitedContainer = ReplaceWithElementIterationFix.extractContainer(MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)mapToObjCall), mapper);
            if (limitedContainer == null) {
                return null;
            }
            IndexedContainer container = limitedContainer.myContainer;
            PsiExpression limit = limitedContainer.myLimit;
            PsiExpression containerQualifier = container.getQualifier();
            PsiType type = containerQualifier.getType();
            PsiType elementType = container.getElementType();
            PsiType outElementType = StreamApiUtil.getStreamElementType((PsiType)mapToObjCall.getType());
            if (type == null || elementType == null) {
                return null;
            }
            String replacement = type instanceof PsiArrayType ? "java.util.Arrays.stream(" + containerQualifier.getText() + ")" : ParenthesesUtils.getText((PsiExpression)containerQualifier, (int)2) + STREAM_SUFFIX;
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            CommentTracker ct = new CommentTracker();
            if (limit != null) {
                replacement = replacement + ".limit(" + ct.text((PsiElement)limit) + ")";
            }
            if (mapper instanceof PsiMethodReferenceExpression) {
                mapper = LambdaRefactoringUtil.convertMethodReferenceToLambda((PsiMethodReferenceExpression)((PsiMethodReferenceExpression)mapper), (boolean)false, (boolean)true);
            }
            if (!(mapper instanceof PsiLambdaExpression)) {
                return null;
            }
            PsiLambdaExpression lambda = (PsiLambdaExpression)mapper;
            PsiParameter indexParameter = (PsiParameter)ArrayUtil.getFirstElement((Object[])lambda.getParameterList().getParameters());
            PsiElement body = lambda.getBody();
            if (body == null || indexParameter == null) {
                return null;
            }
            VariableNameGenerator generator = new VariableNameGenerator((PsiElement)mapToObjCall, VariableKind.PARAMETER);
            if (containerQualifier instanceof PsiReferenceExpression) {
                generator.byCollectionName(((PsiReferenceExpression)containerQualifier).getReferenceName());
            }
            String name = generator.byType(elementType).byName(new String[]{"item", "element"}).generate(true);
            ArrayList<PsiReference> refs = new ArrayList<PsiReference>(ReferencesSearch.search((PsiElement)indexParameter, (SearchScope)new LocalSearchScope(body)).findAll());
            refs.sort(Comparator.comparingInt(ref -> ref.getElement().getTextOffset()));
            for (PsiReference ref2 : refs) {
                PsiExpression getExpression = container.extractGetExpressionFromIndex((PsiExpression)ObjectUtils.tryCast((Object)ref2, PsiExpression.class));
                if (getExpression == null) continue;
                PsiElement result = ct.replace((PsiElement)getExpression, (PsiElement)factory.createIdentifier(name));
                if (getExpression != body) continue;
                body = result;
            }
            PsiLambdaExpression newLambda = (PsiLambdaExpression)factory.createExpressionFromText("(" + elementType.getCanonicalText() + " " + name + ")->" + ct.text(body), (PsiElement)mapToObjCall);
            PsiParameter newParameter = (PsiParameter)ArrayUtil.getFirstElement((Object[])newLambda.getParameterList().getParameters());
            replacement = replacement + StreamRefactoringUtil.generateMapOperation((PsiVariable)newParameter, (PsiType)outElementType, (PsiElement)newLambda.getBody());
            PsiElement result = ct.replaceAndRestoreComments((PsiElement)mapToObjCall, replacement);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences((PsiElement)result);
            result = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
            return CodeStyleManager.getInstance((Project)project).reformat(result);
        }

        static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of((CallMatcher)INT_STREAM_MAP, call -> {
                PsiExpression mapper = call.getArgumentList().getExpressions()[0];
                LimitedContainer limitedContainer = ReplaceWithElementIterationFix.extractContainer(MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call), mapper);
                if (limitedContainer == null) {
                    return null;
                }
                return new ReplaceWithElementIterationFix(limitedContainer.myContainer, call.getMethodExpression().getReferenceName());
            });
        }

        @Contract(value="null, _ -> null")
        private static LimitedContainer extractContainer(PsiMethodCallExpression qualifierCall, PsiExpression mapper) {
            if (!INT_STREAM_RANGE.test(qualifierCall)) {
                return null;
            }
            PsiExpression[] rangeArgs = qualifierCall.getArgumentList().getExpressions();
            if (!ExpressionUtils.isZero((PsiExpression)rangeArgs[0])) {
                return null;
            }
            PsiExpression bound = ExpressionUtils.resolveExpression((PsiExpression)rangeArgs[1]);
            IndexedContainer container = IndexedContainer.fromLengthExpression((PsiExpression)bound);
            PsiExpression limit = null;
            if (container == null) {
                if (bound instanceof PsiMethodCallExpression && MIN_INT.test((PsiMethodCallExpression)bound)) {
                    PsiExpression[] args = ((PsiMethodCallExpression)bound).getArgumentList().getExpressions();
                    container = IndexedContainer.fromLengthExpression((PsiExpression)args[0]);
                    if (container != null) {
                        limit = args[1];
                    } else {
                        container = IndexedContainer.fromLengthExpression((PsiExpression)args[1]);
                        if (container != null) {
                            limit = args[0];
                        }
                    }
                }
                if (container == null) {
                    return null;
                }
            }
            if (!StreamApiUtil.isSupportedStreamElement((PsiType)container.getElementType())) {
                return null;
            }
            LimitedContainer limitedContainer = new LimitedContainer(container, limit);
            if (mapper instanceof PsiMethodReferenceExpression && container.isGetMethodReference((PsiMethodReferenceExpression)mapper)) {
                return limitedContainer;
            }
            if (mapper instanceof PsiLambdaExpression) {
                PsiLambdaExpression lambda = (PsiLambdaExpression)mapper;
                PsiParameter[] parameters = lambda.getParameterList().getParameters();
                if (parameters.length != 1) {
                    return null;
                }
                PsiParameter indexParameter = parameters[0];
                PsiElement body = lambda.getBody();
                if (body == null) {
                    return null;
                }
                Collection refs = ReferencesSearch.search((PsiElement)indexParameter, (SearchScope)new LocalSearchScope(body)).findAll();
                if (!refs.isEmpty() && refs.stream().map(ref -> limitedContainer.myContainer.extractGetExpressionFromIndex((PsiExpression)ObjectUtils.tryCast((Object)ref, PsiExpression.class))).allMatch(expression -> expression != null && !PsiUtil.isAccessedForWriting((PsiExpression)expression))) {
                    return limitedContainer;
                }
            }
            return null;
        }

        static class LimitedContainer {
            @NotNull
            final IndexedContainer myContainer;
            @Nullable
            final PsiExpression myLimit;

            LimitedContainer(@NotNull IndexedContainer container, @Nullable PsiExpression limit) {
                if (container == null) {
                    LimitedContainer.$$$reportNull$$$0(0);
                }
                this.myContainer = container;
                this.myLimit = limit;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceWithElementIterationFix$LimitedContainer", "<init>"));
            }
        }
    }

    static class ReplaceForEachMethodFix
    implements CallChainSimplification {
        private static final CallMatcher STREAM_FOR_EACH = CallMatcher.instanceCall((String)"java.util.stream.Stream", (String[])new String[]{"forEach", "forEachOrdered"}).parameterCount(1);
        private static final String STREAM_PREFIX = "stream().";
        private final String myStreamMethod;
        private final String myReplacementMethod;
        private final boolean myChangeSemantics;

        ReplaceForEachMethodFix(String streamMethod, String replacementMethod, boolean changeSemantics) {
            this.myStreamMethod = streamMethod;
            this.myReplacementMethod = replacementMethod;
            this.myChangeSemantics = changeSemantics;
        }

        @Override
        public boolean keepsStream() {
            return false;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = JavaBundle.message((String)"quickfix.text.replace.stream.0.with.1.2", (Object[])new Object[]{this.myStreamMethod, this.myReplacementMethod, this.myChangeSemantics ? " (may change semantics)" : ""});
            if (string == null) {
                ReplaceForEachMethodFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getMessage() {
            String before = "'stream()." + this.myStreamMethod + "()'";
            String after = this.myReplacementMethod + "()'";
            String string = JavaBundle.message((String)(this.myChangeSemantics ? "simplify.stream.inspection.message.can.be.replaced.may.change.semantics" : "simplify.stream.inspection.message.can.be.replaced"), (Object[])new Object[]{before, after});
            if (string == null) {
                ReplaceForEachMethodFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression streamMethodCall) {
            PsiMethodCallExpression collectionStreamCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)streamMethodCall);
            if (collectionStreamCall == null) {
                return null;
            }
            PsiExpression collectionExpression = ExpressionUtils.getEffectiveQualifier((PsiReferenceExpression)collectionStreamCall.getMethodExpression());
            if (collectionExpression == null) {
                return null;
            }
            collectionStreamCall.replace((PsiElement)collectionExpression);
            ExpressionUtils.bindCallTo((PsiMethodCallExpression)streamMethodCall, (String)this.myReplacementMethod);
            return streamMethodCall;
        }

        static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of((CallMatcher)STREAM_FOR_EACH, call -> {
                PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call);
                if (qualifierCall == null || ExpressionUtils.getEffectiveQualifier((PsiReferenceExpression)qualifierCall.getMethodExpression()) == null) {
                    return null;
                }
                if (COLLECTION_STREAM.test(qualifierCall)) {
                    return new ReplaceForEachMethodFix(call.getMethodExpression().getReferenceName(), SimplifyStreamApiCallChainsInspection.FOR_EACH_METHOD, true);
                }
                if (OPTIONAL_STREAM.test(qualifierCall)) {
                    return new ReplaceForEachMethodFix(call.getMethodExpression().getReferenceName(), SimplifyStreamApiCallChainsInspection.IF_PRESENT_METHOD, false);
                }
                return null;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceForEachMethodFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class RemoveBooleanIdentityFix
    implements CallChainSimplification {
        private final boolean myInvert;

        RemoveBooleanIdentityFix(boolean invert) {
            this.myInvert = invert;
        }

        @Override
        public String getName() {
            return JavaBundle.message((String)"simplify.stream.remove.boolean.identity.fix.name", (Object[])new Object[0]);
        }

        @Override
        public String getMessage() {
            return JavaBundle.message((String)"simplify.stream.remove.boolean.identity.fix.message", (Object[])new Object[0]);
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression call) {
            PsiMethodCallExpression qualifier = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call);
            if (qualifier == null) {
                return null;
            }
            String name = call.getMethodExpression().getReferenceName();
            if (name == null) {
                return null;
            }
            if (this.myInvert) {
                if (name.equals(SimplifyStreamApiCallChainsInspection.ALL_MATCH_METHOD)) {
                    name = SimplifyStreamApiCallChainsInspection.NONE_MATCH_METHOD;
                } else if (name.equals(SimplifyStreamApiCallChainsInspection.NONE_MATCH_METHOD)) {
                    name = SimplifyStreamApiCallChainsInspection.ALL_MATCH_METHOD;
                } else {
                    return null;
                }
            }
            PsiExpression[] args = qualifier.getArgumentList().getExpressions();
            CommentTracker ct = new CommentTracker();
            if (args.length == 1) {
                PsiExpression arg = args[0];
                String replacement = RemoveBooleanIdentityFix.adaptToPredicate((PsiExpression)ct.markUnchanged((PsiElement)arg));
                if (replacement == null) {
                    return null;
                }
                ct.replace((PsiElement)arg, replacement);
            }
            ExpressionUtils.bindCallTo((PsiMethodCallExpression)qualifier, (String)name);
            return ct.replaceAndRestoreComments((PsiElement)call, (PsiElement)qualifier);
        }

        static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of((CallMatcher)STREAM_MATCH, call -> {
                PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call);
                if (!STREAM_MAP.test(qualifierCall)) {
                    return null;
                }
                PsiExpression qualifierArg = PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifierCall.getArgumentList().getExpressions()[0]);
                PsiExpression predicate = call.getArgumentList().getExpressions()[0];
                boolean invert = false;
                if (!RemoveBooleanIdentityFix.isBooleanIdentity(predicate)) {
                    Boolean target = RemoveBooleanIdentityFix.getBooleanEqualsTarget(predicate);
                    if (target == null || !target.booleanValue() && SimplifyStreamApiCallChainsInspection.ANY_MATCH_METHOD.equals(call.getMethodExpression().getReferenceName())) {
                        return null;
                    }
                    boolean bl = invert = target == false;
                    if (qualifierArg instanceof PsiMethodReferenceExpression) {
                        PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)((PsiMethodReferenceExpression)qualifierArg).resolve(), PsiMethod.class);
                        if (method == null) {
                            return null;
                        }
                        if (!PsiTypes.booleanType().equals((Object)method.getReturnType()) && !NullableNotNullManager.isNotNull((PsiModifierListOwner)method)) {
                            return null;
                        }
                    } else if (!(qualifierArg instanceof PsiLambdaExpression) || DfaUtil.inferLambdaNullability((PsiLambdaExpression)((PsiLambdaExpression)qualifierArg)) != Nullability.NOT_NULL) {
                        return null;
                    }
                } else if (RemoveBooleanIdentityFix.adaptToPredicate(qualifierArg) == null) {
                    return null;
                }
                return new RemoveBooleanIdentityFix(invert);
            });
        }

        private static boolean isBooleanIdentity(PsiExpression arg) {
            if (FunctionalExpressionUtils.isFunctionalReferenceTo((PsiExpression)(arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)arg)), (String)"java.lang.Boolean", (PsiType)PsiTypes.booleanType(), (String)"booleanValue", (PsiType[])PsiType.EMPTY_ARRAY) || FunctionalExpressionUtils.isFunctionalReferenceTo((PsiExpression)arg, (String)"java.lang.Boolean", null, (String)"valueOf", (PsiType[])new PsiType[]{PsiTypes.booleanType()})) {
                return true;
            }
            return arg instanceof PsiLambdaExpression && LambdaUtil.isIdentityLambda((PsiLambdaExpression)((PsiLambdaExpression)arg));
        }

        @Nullable
        private static Boolean getBooleanEqualsTarget(PsiExpression arg) {
            arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)arg);
            PsiReferenceExpression qualifier = null;
            if (arg instanceof PsiMethodReferenceExpression) {
                PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)arg;
                if (!BOOLEAN_EQUALS.methodReferenceMatches(methodRef)) {
                    return null;
                }
                qualifier = (PsiReferenceExpression)ObjectUtils.tryCast((Object)methodRef.getQualifierExpression(), PsiReferenceExpression.class);
            } else if (arg instanceof PsiLambdaExpression) {
                PsiLambdaExpression lambda = (PsiLambdaExpression)arg;
                PsiParameter parameter = (PsiParameter)ArrayUtil.getFirstElement((Object[])lambda.getParameterList().getParameters());
                if (parameter == null) {
                    return null;
                }
                PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda.getBody()), PsiMethodCallExpression.class);
                if (!BOOLEAN_EQUALS.test(call)) {
                    return null;
                }
                if (!ExpressionUtils.isReferenceTo((PsiExpression)call.getArgumentList().getExpressions()[0], (PsiVariable)parameter)) {
                    return null;
                }
                qualifier = (PsiReferenceExpression)ObjectUtils.tryCast((Object)call.getMethodExpression().getQualifierExpression(), PsiReferenceExpression.class);
            }
            if (qualifier == null) {
                return null;
            }
            return BoolUtils.fromBoxedConstantReference(qualifier);
        }

        @Nullable
        private static String adaptToPredicate(PsiExpression expression) {
            if (expression == null) {
                return null;
            }
            String text = expression.getText();
            if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) == null) {
                return null;
            }
            if (expression instanceof PsiFunctionalExpression) {
                return text;
            }
            if (expression instanceof PsiConditionalExpression) {
                PsiConditionalExpression ternary = (PsiConditionalExpression)expression;
                String thenBranch = RemoveBooleanIdentityFix.adaptToPredicate(ternary.getThenExpression());
                String elseBranch = RemoveBooleanIdentityFix.adaptToPredicate(ternary.getElseExpression());
                if (thenBranch == null || elseBranch == null) {
                    return null;
                }
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression.getProject());
                PsiConditionalExpression copy = (PsiConditionalExpression)factory.createExpressionFromText(text, (PsiElement)expression);
                Objects.requireNonNull(copy.getThenExpression()).replace((PsiElement)factory.createExpressionFromText(thenBranch, (PsiElement)expression));
                Objects.requireNonNull(copy.getElseExpression()).replace((PsiElement)factory.createExpressionFromText(elseBranch, (PsiElement)expression));
                return copy.getText();
            }
            String adapted = ParenthesesUtils.getText((PsiExpression)expression, (int)2) + "::apply";
            PsiClassType type = (PsiClassType)ObjectUtils.tryCast((Object)expression.getType(), PsiClassType.class);
            if (type == null) {
                return null;
            }
            if (PsiTypesUtil.classNameEquals((PsiType)type, (String)"java.util.function.Function")) {
                return adapted;
            }
            PsiClass typeClass = type.resolve();
            if (typeClass == null) {
                return null;
            }
            PsiMethod[] methods = typeClass.findMethodsByName("apply", true);
            if (methods.length != 1 || methods[0].getContainingClass() == null || !"java.util.function.Function".equals(methods[0].getContainingClass().getQualifiedName())) {
                return null;
            }
            return adapted;
        }
    }

    private static class ReplaceWithPeekFix
    implements CallChainSimplification {
        private ReplaceWithPeekFix() {
        }

        @Override
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"peek"});
        }

        @Override
        public String getMessage() {
            return CommonQuickFixBundle.message((String)"fix.can.replace.with.x", (Object[])new Object[]{"peek"});
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression call) {
            PsiLambdaExpression lambda = (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getArgumentList().getExpressions()[0]), PsiLambdaExpression.class);
            if (lambda == null) {
                return null;
            }
            PsiCodeBlock block = (PsiCodeBlock)ObjectUtils.tryCast((Object)lambda.getBody(), PsiCodeBlock.class);
            if (block == null) {
                return null;
            }
            PsiReturnStatement statement = (PsiReturnStatement)ObjectUtils.tryCast((Object)ArrayUtil.getLastElement((Object[])block.getStatements()), PsiReturnStatement.class);
            if (statement == null) {
                return null;
            }
            ExpressionUtils.bindCallTo((PsiMethodCallExpression)call, (String)"peek");
            new CommentTracker().deleteAndRestoreComments((PsiElement)statement);
            LambdaRefactoringUtil.simplifyToExpressionLambda((PsiLambdaExpression)lambda);
            LambdaCanBeMethodReferenceInspection.replaceLambdaWithMethodReference((PsiLambdaExpression)lambda);
            return call;
        }

        static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of((CallMatcher)BASE_STREAM_MAP, call -> {
                PsiLambdaExpression lambda = (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getArgumentList().getExpressions()[0]), PsiLambdaExpression.class);
                if (lambda == null) {
                    return null;
                }
                PsiParameter[] parameters = lambda.getParameterList().getParameters();
                if (parameters.length != 1) {
                    return null;
                }
                PsiCodeBlock block = (PsiCodeBlock)ObjectUtils.tryCast((Object)lambda.getBody(), PsiCodeBlock.class);
                if (block == null) {
                    return null;
                }
                Object[] statements = block.getStatements();
                if (statements.length <= 1) {
                    return null;
                }
                PsiReturnStatement returnStatement = (PsiReturnStatement)ObjectUtils.tryCast((Object)ArrayUtil.getLastElement((Object[])statements), PsiReturnStatement.class);
                PsiParameter parameter = parameters[0];
                if (returnStatement == null || !ExpressionUtils.isReferenceTo((PsiExpression)returnStatement.getReturnValue(), (PsiVariable)parameter)) {
                    return null;
                }
                if (VariableAccessUtils.variableIsAssigned((PsiVariable)parameter)) {
                    return null;
                }
                if (Arrays.stream(statements, 0, statements.length - 1).anyMatch(ControlFlowUtils::containsReturn)) {
                    return null;
                }
                return new ReplaceWithPeekFix();
            });
        }
    }

    private static class SimpleStreamOfFix
    implements CallChainSimplification {
        private static final CallMatcher LAMBDA_TERMINAL = CallMatcher.instanceCall((String)"java.util.stream.BaseStream", (String[])new String[]{"anyMatch", "allMatch", "noneMatch", "forEach", "forEachOrdered"}).parameterCount(1);
        private static final CallMatcher OPTIONAL_TERMINAL = CallMatcher.anyOf((CallMatcher[])new CallMatcher[]{CallMatcher.instanceCall((String)"java.util.stream.BaseStream", (String[])new String[]{"findFirst", "findAny"}).parameterCount(0), CallMatcher.instanceCall((String)"java.util.stream.BaseStream", (String[])new String[]{"min", "max", "reduce"}).parameterCount(1)});
        private final ReplacementMode myMode;

        @Override
        public boolean keepsStream() {
            return false;
        }

        SimpleStreamOfFix(ReplacementMode mode) {
            this.myMode = mode;
        }

        @Override
        public String getName() {
            if (this.myMode == ReplacementMode.OPTIONAL) {
                return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"Optional.of"});
            }
            return JavaBundle.message((String)"simplify.stream.simple.stream.of.fix.name.use.stream.element.explicitly", (Object[])new Object[0]);
        }

        @Override
        public String getMessage() {
            return JavaBundle.message((String)"simplify.stream.simple.stream.of.message", (Object[])new Object[0]);
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression streamOfCall) {
            String replacement;
            PsiExpression streamOfArg = (PsiExpression)ArrayUtil.getFirstElement((Object[])streamOfCall.getArgumentList().getExpressions());
            if (streamOfArg == null) {
                return null;
            }
            PsiMethodCallExpression nextCall = ExpressionUtils.getCallForQualifier((PsiExpression)streamOfCall);
            PsiExpression nextArg = (PsiExpression)ArrayUtil.getFirstElement((Object[])nextCall.getArgumentList().getExpressions());
            if (this.myMode == ReplacementMode.OPTIONAL) {
                replacement = "java.util.Optional.of(" + streamOfArg.getText() + ")";
            } else {
                if (nextArg == null) {
                    return null;
                }
                PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)nextArg.getType());
                if (method == null) {
                    return null;
                }
                String name = method.getName();
                replacement = (this.myMode == ReplacementMode.NEGATED_FUNCTION ? "!" : "") + nextArg.getText() + "." + name + "(" + streamOfArg.getText() + ")";
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)streamOfCall.getProject());
            PsiExpression result = factory.createExpressionFromText(replacement, (PsiElement)streamOfCall);
            return nextCall.replace((PsiElement)result);
        }

        public static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of((CallMatcher)STREAM_OF, call -> {
                PsiExpression arg;
                PsiMethodCallExpression nextCall = ExpressionUtils.getCallForQualifier((PsiExpression)call);
                if (nextCall == null) {
                    return null;
                }
                if (LAMBDA_TERMINAL.test(nextCall) && ((arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)nextCall.getArgumentList().getExpressions()[0])) instanceof PsiReferenceExpression || arg instanceof PsiMethodCallExpression)) {
                    PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)arg.getType());
                    boolean negate = SimplifyStreamApiCallChainsInspection.NONE_MATCH_METHOD.equals(nextCall.getMethodExpression().getReferenceName());
                    if (method == null || negate && PsiUtil.skipParenthesizedExprUp((PsiElement)nextCall.getParent()) instanceof PsiExpressionStatement) {
                        return null;
                    }
                    return new SimpleStreamOfFix(negate ? ReplacementMode.NEGATED_FUNCTION : ReplacementMode.FUNCTION);
                }
                if (OPTIONAL_TERMINAL.test(nextCall)) {
                    return new SimpleStreamOfFix(ReplacementMode.OPTIONAL);
                }
                return null;
            });
        }

        static enum ReplacementMode {
            OPTIONAL,
            FUNCTION,
            NEGATED_FUNCTION;

        }
    }

    static class RangeToArrayStreamFix
    implements CallChainSimplification {
        @NotNull
        private final String myReplacement;

        RangeToArrayStreamFix(@NotNull String replacement) {
            if (replacement == null) {
                RangeToArrayStreamFix.$$$reportNull$$$0(0);
            }
            this.myReplacement = replacement;
        }

        @Override
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"Arrays.stream()"});
        }

        @Override
        public String getMessage() {
            return CommonQuickFixBundle.message((String)"fix.can.replace.with.x", (Object[])new Object[]{"Arrays.stream()"});
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression call) {
            PsiMethodCallExpression mapCall = ExpressionUtils.getCallForQualifier((PsiExpression)call);
            if (mapCall == null) {
                return null;
            }
            return new CommentTracker().replaceAndRestoreComments((PsiElement)mapCall, this.myReplacement);
        }

        @NotNull
        static CallHandler<CallChainSimplification> handler() {
            CallHandler callHandler = CallHandler.of((CallMatcher)INT_STREAM_RANGE, call -> {
                PsiExpression[] args = call.getArgumentList().getExpressions();
                PsiMethodCallExpression maybeMap = ExpressionUtils.getCallForQualifier((PsiExpression)call);
                if (!STREAM_INT_MAP_TO_ALL.test(maybeMap)) {
                    return null;
                }
                PsiExpression arg = maybeMap.getArgumentList().getExpressions()[0];
                PsiLambdaExpression lambda = (PsiLambdaExpression)ObjectUtils.tryCast((Object)arg, PsiLambdaExpression.class);
                if (lambda == null) {
                    return null;
                }
                PsiParameter[] parameters = lambda.getParameterList().getParameters();
                if (parameters.length != 1) {
                    return null;
                }
                PsiExpression lambdaExpr = (PsiExpression)ObjectUtils.tryCast((Object)lambda.getBody(), PsiExpression.class);
                if (lambdaExpr == null) {
                    return null;
                }
                PsiArrayAccessExpression arrayAccess = (PsiArrayAccessExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)lambdaExpr), PsiArrayAccessExpression.class);
                if (arrayAccess == null) {
                    return null;
                }
                PsiExpression index = arrayAccess.getIndexExpression();
                if (!ExpressionUtils.isReferenceTo((PsiExpression)index, (PsiVariable)parameters[0])) {
                    return null;
                }
                PsiExpression arrayExpr = arrayAccess.getArrayExpression();
                PsiArrayType arrayType = (PsiArrayType)ObjectUtils.tryCast((Object)arrayExpr.getType(), PsiArrayType.class);
                if (arrayType == null) {
                    return null;
                }
                if (!StreamApiUtil.isSupportedStreamElement((PsiType)arrayType.getComponentType())) {
                    return null;
                }
                if (VariableAccessUtils.variableIsUsed((PsiVariable)parameters[0], (PsiElement)arrayExpr)) {
                    return null;
                }
                PsiExpression leftBound = args[0];
                PsiExpression rightBound = args[1];
                return new RangeToArrayStreamFix("java.util.Arrays.stream(" + arrayExpr.getText() + "," + leftBound.getText() + "," + rightBound.getText() + ")");
            });
            if (callHandler == null) {
                RangeToArrayStreamFix.$$$reportNull$$$0(1);
            }
            return callHandler;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$RangeToArrayStreamFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$RangeToArrayStreamFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "handler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    static class NCopiesToGenerateStreamFix
    implements CallChainSimplification {
        @NotNull
        private final String myReplacement;

        NCopiesToGenerateStreamFix(@NotNull String replacement) {
            if (replacement == null) {
                NCopiesToGenerateStreamFix.$$$reportNull$$$0(0);
            }
            this.myReplacement = replacement;
        }

        @Override
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"Stream.generate()"});
        }

        @Override
        public String getMessage() {
            return CommonQuickFixBundle.message((String)"fix.can.replace.with.x", (Object[])new Object[]{"Stream.generate()"});
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression streamCall) {
            PsiMethodCallExpression maybeMap = ExpressionUtils.getCallForQualifier((PsiExpression)streamCall);
            if (maybeMap == null) {
                return null;
            }
            Project project = streamCall.getProject();
            PsiElement result = new CommentTracker().replaceAndRestoreComments((PsiElement)maybeMap, this.myReplacement);
            return JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
        }

        @NotNull
        static CallHandler<CallChainSimplification> handler() {
            CallHandler callHandler = CallHandler.of((CallMatcher)COLLECTION_STREAM, call -> {
                PsiMethodCallExpression maybeNCopies = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call);
                if (!N_COPIES.test(maybeNCopies)) {
                    return null;
                }
                PsiExpression[] nCopiesArgs = maybeNCopies.getArgumentList().getExpressions();
                PsiExpression count = nCopiesArgs[0];
                PsiExpression obj = nCopiesArgs[1];
                if (!ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)obj)) {
                    return null;
                }
                PsiMethodCallExpression maybeMap = ExpressionUtils.getCallForQualifier((PsiExpression)call);
                if (!STREAM_MAP_TO_ALL.test(maybeMap)) {
                    return null;
                }
                PsiExpression arg = maybeMap.getArgumentList().getExpressions()[0];
                PsiLambdaExpression lambda = (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)arg), PsiLambdaExpression.class);
                if (lambda == null) {
                    return null;
                }
                PsiParameter[] parameters = lambda.getParameterList().getParameters();
                if (parameters.length != 1) {
                    return null;
                }
                PsiParameter lambdaVar = parameters[0];
                PsiExpression body = (PsiExpression)ObjectUtils.tryCast((Object)lambda.getBody(), PsiExpression.class);
                if (body == null || body.getType() == null) {
                    return null;
                }
                String streamClass = NCopiesToGenerateStreamFix.getStreamClassName(maybeMap);
                if (VariableAccessUtils.variableIsUsed((PsiVariable)lambdaVar, (PsiElement)body)) {
                    return null;
                }
                return new NCopiesToGenerateStreamFix(streamClass + ".generate(()->" + body.getText() + ").limit(" + count.getText() + ")");
            });
            if (callHandler == null) {
                NCopiesToGenerateStreamFix.$$$reportNull$$$0(1);
            }
            return callHandler;
        }

        private static String getStreamClassName(@NotNull PsiMethodCallExpression call) {
            String name;
            if (call == null) {
                NCopiesToGenerateStreamFix.$$$reportNull$$$0(2);
            }
            String string = name = MethodCallUtils.getMethodName((PsiMethodCallExpression)call);
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"mapToInt", "mapToLong", "mapToDouble"}, (Object)string, n)) {
                case 0 -> "java.util.stream.IntStream";
                case 1 -> "java.util.stream.LongStream";
                case 2 -> "java.util.stream.DoubleStream";
                default -> "java.util.stream.Stream";
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$NCopiesToGenerateStreamFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$NCopiesToGenerateStreamFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "handler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getStreamClassName";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    static class SortedFirstToMinMaxFix
    implements CallChainSimplification {
        private final String myMethodName;
        private final String myReplacement;

        SortedFirstToMinMaxFix(String methodName, String replacement) {
            this.myMethodName = methodName;
            this.myReplacement = replacement;
        }

        @Override
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myMethodName + "()"});
        }

        @Override
        public String getMessage() {
            return CommonQuickFixBundle.message((String)"fix.can.replace.with.x", (Object[])new Object[]{this.myMethodName + "()"});
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression call) {
            return new CommentTracker().replaceAndRestoreComments((PsiElement)call, this.myReplacement);
        }

        @NotNull
        static CallHandler<CallChainSimplification> handler() {
            CallHandler callHandler = CallHandler.of((CallMatcher)STREAM_FIND_FIRST, call -> {
                String comparator;
                PsiMethodCallExpression maybeSorted = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call);
                if (!STREAM_SORTED.test(maybeSorted)) {
                    return null;
                }
                PsiExpression[] args = maybeSorted.getArgumentList().getExpressions();
                PsiExpression qualifier = maybeSorted.getMethodExpression().getQualifierExpression();
                if (qualifier == null) {
                    return null;
                }
                boolean reversed = false;
                if (args.length == 1) {
                    PsiExpression maybeComparator = PsiUtil.skipParenthesizedExprDown((PsiExpression)args[0]);
                    if (maybeComparator instanceof PsiMethodCallExpression && COMPARATOR_REVERSED.test((PsiMethodCallExpression)maybeComparator)) {
                        PsiExpression comparatorQualifier = ((PsiMethodCallExpression)maybeComparator).getMethodExpression().getQualifierExpression();
                        if (comparatorQualifier == null) {
                            return null;
                        }
                        comparator = comparatorQualifier.getText();
                        reversed = true;
                    } else {
                        if (maybeComparator == null) {
                            return null;
                        }
                        PsiType comparatorType = FunctionalExpressionUtils.getFunctionalExpressionType((PsiExpression)maybeComparator);
                        if (!InheritanceUtil.isInheritor((PsiType)comparatorType, (String)"java.util.Comparator")) {
                            return null;
                        }
                        comparator = maybeComparator.getText();
                    }
                } else {
                    return null;
                }
                String methodName = reversed ? "max" : "min";
                return new SortedFirstToMinMaxFix(methodName, qualifier.getText() + "." + methodName + "(" + comparator + ")");
            });
            if (callHandler == null) {
                SortedFirstToMinMaxFix.$$$reportNull$$$0(0);
            }
            return callHandler;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$SortedFirstToMinMaxFix", "handler"));
        }
    }

    static class AllMatchContainsFix
    implements CallChainSimplification {
        AllMatchContainsFix() {
        }

        @Override
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"containsAll"});
        }

        @Override
        public String getMessage() {
            return CommonQuickFixBundle.message((String)"fix.can.replace.with.x", (Object[])new Object[]{"containsAll"});
        }

        @Override
        public boolean keepsStream() {
            return false;
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression call) {
            PsiExpression left = AllMatchContainsFix.extractLeft(call);
            if (left == null) {
                return null;
            }
            PsiExpression right = AllMatchContainsFix.extractRight(call);
            if (right == null) {
                return null;
            }
            CommentTracker ct = new CommentTracker();
            String replacement = ct.text((PsiElement)right) + ".containsAll(" + ct.text((PsiElement)left) + ")";
            return ct.replaceAndRestoreComments((PsiElement)call, replacement);
        }

        @Nullable
        private static PsiExpression extractRight(PsiMethodCallExpression allMatchCall) {
            PsiLambdaExpression lambda;
            PsiParameter[] parameters;
            PsiExpression arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)allMatchCall.getArgumentList().getExpressions()[0]);
            if (arg instanceof PsiMethodReferenceExpression) {
                PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)arg;
                if (COLLECTION_CONTAINS.methodReferenceMatches(methodRef) && !PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)methodRef) && !ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)methodRef)) {
                    return methodRef.getQualifierExpression();
                }
            } else if (arg instanceof PsiLambdaExpression && (parameters = (lambda = (PsiLambdaExpression)arg).getParameterList().getParameters()).length == 1) {
                PsiParameter parameter = parameters[0];
                PsiExpression expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda.getBody()));
                PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expression, PsiMethodCallExpression.class);
                if (COLLECTION_CONTAINS.test(call) && ExpressionUtils.isReferenceTo((PsiExpression)call.getArgumentList().getExpressions()[0], (PsiVariable)parameter) && !ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)call.getMethodExpression())) {
                    return call.getMethodExpression().getQualifierExpression();
                }
            }
            return null;
        }

        @Nullable
        private static PsiExpression extractLeft(PsiMethodCallExpression call) {
            PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call);
            if (!COLLECTION_STREAM.test(qualifierCall) || ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)qualifierCall.getMethodExpression())) {
                return null;
            }
            return PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifierCall.getMethodExpression().getQualifierExpression());
        }

        static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of((CallMatcher)CallMatcher.instanceCall((String)"java.util.stream.Stream", (String[])new String[]{SimplifyStreamApiCallChainsInspection.ALL_MATCH_METHOD}).parameterCount(1), call -> {
                if (AllMatchContainsFix.extractLeft(call) == null || AllMatchContainsFix.extractRight(call) == null) {
                    return null;
                }
                return new AllMatchContainsFix();
            });
        }
    }

    static class AnyMatchContainsFix
    implements CallChainSimplification {
        final SmartPsiElementPointer<PsiExpression> myValuePointer;

        AnyMatchContainsFix(@NotNull PsiExpression value) {
            if (value == null) {
                AnyMatchContainsFix.$$$reportNull$$$0(0);
            }
            this.myValuePointer = SmartPointerManager.createPointer((PsiElement)value);
        }

        @Override
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"List.contains()"});
        }

        @Override
        public String getMessage() {
            return CommonQuickFixBundle.message((String)"fix.can.replace.with.x", (Object[])new Object[]{"List.contains()"});
        }

        @Override
        public boolean keepsStream() {
            return false;
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression call) {
            PsiExpression value = (PsiExpression)this.myValuePointer.getElement();
            if (value == null) {
                return null;
            }
            PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call);
            if (qualifierCall == null) {
                return null;
            }
            PsiExpressionList qualifierArgs = qualifierCall.getArgumentList();
            CommentTracker ct = new CommentTracker();
            PsiReferenceParameterList typeParameters = qualifierCall.getMethodExpression().getParameterList();
            String typeParametersText = typeParameters == null ? "" : ct.text((PsiElement)typeParameters);
            String factory = PsiUtil.isAvailable((JavaFeature)JavaFeature.COLLECTION_FACTORIES, (PsiElement)call) && MethodCallUtils.isVarArgCall((PsiCall)qualifierCall) && ContainerUtil.and((Object[])qualifierArgs.getExpressions(), e -> NullabilityUtil.getExpressionNullability((PsiExpression)e, (boolean)true) == Nullability.NOT_NULL) ? "java.util.List." + typeParametersText + SimplifyStreamApiCallChainsInspection.OF_METHOD : "java.util.Arrays." + typeParametersText + "asList";
            PsiElement result = ct.replaceAndRestoreComments((PsiElement)call, factory + ct.text((PsiElement)qualifierArgs) + ".contains(" + ct.text((PsiElement)value) + ")");
            return JavaCodeStyleManager.getInstance((Project)result.getProject()).shortenClassReferences(result);
        }

        static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of((CallMatcher)STREAM_ANY_MATCH, call -> {
                PsiExpression qualifier;
                PsiMethod method;
                PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call);
                if (!ARRAYS_STREAM.test(qualifierCall)) {
                    return null;
                }
                PsiExpression arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getArgumentList().getExpressions()[0]);
                if (arg instanceof PsiMethodReferenceExpression && MethodUtils.isEquals((PsiMethod)(method = (PsiMethod)ObjectUtils.tryCast((Object)((PsiMethodReferenceExpression)arg).resolve(), PsiMethod.class))) && (qualifier = ((PsiMethodReferenceExpression)arg).getQualifierExpression()) != null) {
                    return new AnyMatchContainsFix(qualifier);
                }
                if (arg instanceof PsiLambdaExpression) {
                    PsiLambdaExpression lambda = (PsiLambdaExpression)arg;
                    PsiParameter[] parameters = lambda.getParameterList().getParameters();
                    if (parameters.length != 1) {
                        return null;
                    }
                    PsiParameter parameter = parameters[0];
                    PsiExpression lambdaBody = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda.getBody());
                    EqualityCheck check = EqualityCheck.from((PsiExpression)lambdaBody);
                    if (check == null) {
                        return null;
                    }
                    PsiExpression left = check.getLeft();
                    PsiExpression right = check.getRight();
                    if (ExpressionUtils.isReferenceTo((PsiExpression)left, (PsiVariable)parameter) && ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)right)) {
                        return new AnyMatchContainsFix(right);
                    }
                    if (ExpressionUtils.isReferenceTo((PsiExpression)right, (PsiVariable)parameter) && ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)left)) {
                        return new AnyMatchContainsFix(left);
                    }
                }
                return null;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$AnyMatchContainsFix", "<init>"));
        }
    }

    static class JoiningStringsFix
    implements CallChainSimplification {
        static final CallMatcher COLLECTOR_JOINING = CallMatcher.staticCall((String)"java.util.stream.Collectors", (String[])new String[]{"joining"}).parameterCount(0);
        static final CallMatcher COLLECTOR_JOINING_DELIMITER = CallMatcher.staticCall((String)"java.util.stream.Collectors", (String[])new String[]{"joining"}).parameterTypes(new String[]{"java.lang.CharSequence"});

        JoiningStringsFix() {
        }

        @Override
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"String.join"});
        }

        @Override
        public boolean keepsStream() {
            return false;
        }

        @Override
        public String getMessage() {
            return CommonQuickFixBundle.message((String)"fix.can.replace.with.x", (Object[])new Object[]{"String.join"});
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression call) {
            String argList;
            PsiExpression delimiter = JoiningStringsFix.extractDelimiter(call);
            if (delimiter == null) {
                return null;
            }
            PsiMethodCallExpression qualifier = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call);
            if (qualifier == null) {
                return null;
            }
            CommentTracker ct = new CommentTracker();
            if (ARRAYS_STREAM.matches((PsiExpression)qualifier)) {
                Object[] args = qualifier.getArgumentList().getChildren();
                argList = StreamEx.of((Object[])args, (int)1, (int)(args.length - 1)).map(arg_0 -> ((CommentTracker)ct).text(arg_0)).joining();
            } else if (COLLECTION_STREAM.matches((PsiExpression)qualifier)) {
                PsiExpression collection = ExpressionUtils.getEffectiveQualifier((PsiReferenceExpression)qualifier.getMethodExpression());
                if (collection == null) {
                    return null;
                }
                argList = ct.text((PsiElement)collection);
            } else {
                return null;
            }
            String delimiterText = ct.text((PsiElement)delimiter);
            if (delimiterText.isEmpty()) {
                delimiterText = "\"\"";
            }
            return ct.replaceAndRestoreComments((PsiElement)call, "java.lang.String.join(" + delimiterText + "," + argList + ")");
        }

        static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of((CallMatcher)STREAM_COLLECT, call -> {
                PsiType elementType;
                if (JoiningStringsFix.extractDelimiter(call) == null) {
                    return null;
                }
                PsiMethodCallExpression qualifier = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call);
                if (qualifier == null) {
                    return null;
                }
                if ((ARRAYS_STREAM.matches((PsiExpression)qualifier) || COLLECTION_STREAM.matches((PsiExpression)qualifier) && ExpressionUtils.getEffectiveQualifier((PsiReferenceExpression)qualifier.getMethodExpression()) != null) && InheritanceUtil.isInheritor((PsiType)(elementType = StreamApiUtil.getStreamElementType((PsiType)qualifier.getType())), (String)"java.lang.CharSequence")) {
                    return new JoiningStringsFix();
                }
                return null;
            });
        }

        @Nullable
        private static PsiExpression extractDelimiter(PsiMethodCallExpression call) {
            PsiMethodCallExpression collector = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getArgumentList().getExpressions()[0]), PsiMethodCallExpression.class);
            if (COLLECTOR_JOINING.test(collector)) {
                return new PsiEmptyExpressionImpl();
            }
            if (COLLECTOR_JOINING_DELIMITER.test(collector)) {
                PsiExpression delimiter = collector.getArgumentList().getExpressions()[0];
                return ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)delimiter) ? delimiter : null;
            }
            return null;
        }
    }

    static class ReplaceWithCollectorsJoiningFix
    implements CallChainSimplification {
        static final CallMatcher STRING_JOIN = CallMatcher.staticCall((String)"java.lang.String", (String[])new String[]{"join"}).parameterCount(2);

        ReplaceWithCollectorsJoiningFix() {
        }

        @Override
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"Collectors.joining"});
        }

        @Override
        public String getMessage() {
            return CommonQuickFixBundle.message((String)"fix.can.replace.with.x", (Object[])new Object[]{"Collectors.joining"});
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression call) {
            Context context = Context.from(call);
            if (context == null) {
                return null;
            }
            String collectorText = "java.util.stream.Collectors.joining(" + context.myDelimiterExpression.getText() + ")";
            new CommentTracker().replaceAndRestoreComments((PsiElement)context.myCollectorsToListCall, collectorText);
            CommentTracker ct = new CommentTracker();
            ct.markUnchanged((PsiElement)call);
            PsiElement result = ct.replaceAndRestoreComments((PsiElement)context.myStringJoinCall, (PsiElement)call);
            return JavaCodeStyleManager.getInstance((Project)result.getProject()).shortenClassReferences(result);
        }

        static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of((CallMatcher)STREAM_COLLECT, call -> {
                if (Context.from(call) == null) {
                    return null;
                }
                return new ReplaceWithCollectorsJoiningFix();
            });
        }

        private static final class Context {
            final PsiMethodCallExpression myStringJoinCall;
            final PsiExpression myDelimiterExpression;
            final PsiExpression myCollectorsToListCall;

            private Context(PsiMethodCallExpression stringJoinCall, PsiExpression delimiterExpression, PsiExpression collectorsToListCall) {
                this.myStringJoinCall = stringJoinCall;
                this.myDelimiterExpression = delimiterExpression;
                this.myCollectorsToListCall = collectorsToListCall;
            }

            static Context from(PsiMethodCallExpression call) {
                PsiExpressionList argumentList = call.getArgumentList();
                if (argumentList.getExpressionCount() != 1) {
                    return null;
                }
                PsiExpression firstArg = argumentList.getExpressions()[0];
                PsiMethodCallExpression argument = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)firstArg), PsiMethodCallExpression.class);
                if (!COLLECTORS_TO_LIST.matches((PsiExpression)argument)) {
                    return null;
                }
                PsiExpressionList arguments = (PsiExpressionList)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent()), PsiExpressionList.class);
                if (arguments == null) {
                    return null;
                }
                if (arguments.getExpressionCount() != 2) {
                    return null;
                }
                PsiMethodCallExpression maybeJoinCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)arguments.getParent()), PsiMethodCallExpression.class);
                if (!STRING_JOIN.matches((PsiExpression)maybeJoinCall)) {
                    return null;
                }
                PsiExpression[] argumentExpressions = arguments.getExpressions();
                if (PsiUtil.skipParenthesizedExprDown((PsiExpression)argumentExpressions[1]) != call) {
                    return null;
                }
                PsiExpression delimiter = argumentExpressions[0];
                if (delimiter == null) {
                    return null;
                }
                if (!InheritanceUtil.isInheritor((PsiType)delimiter.getType(), (String)"java.lang.CharSequence")) {
                    return null;
                }
                PsiMethodCallExpression stream = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call);
                if (stream == null) {
                    return null;
                }
                PsiType elementType = StreamApiUtil.getStreamElementType((PsiType)stream.getType());
                if (!InheritanceUtil.isInheritor((PsiType)elementType, (String)"java.lang.CharSequence")) {
                    return null;
                }
                return new Context(maybeJoinCall, delimiter, (PsiExpression)argument);
            }
        }
    }

    static class EntrySetMapFix
    implements CallChainSimplification {
        @NotNull
        private final String myMapMethod;
        private final boolean myDeleteMap;
        @NotNull
        private final @NotNull String @NotNull [] myNames;

        EntrySetMapFix(@NotNull String entryMethod, boolean deleteMap) {
            String[] stringArray;
            if (entryMethod == null) {
                EntrySetMapFix.$$$reportNull$$$0(0);
            }
            this.myMapMethod = entryMethod.equals("getKey") ? "keySet" : "values";
            this.myDeleteMap = deleteMap;
            if (this.myMapMethod.equals("keySet")) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "k";
                stringArray = stringArray2;
                stringArray2[1] = "key";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "v";
                stringArray = stringArray3;
                stringArray3[1] = "value";
            }
            this.myNames = stringArray;
        }

        @Override
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"." + this.myMapMethod + "().stream()"});
        }

        @Override
        public String getMessage() {
            return CommonQuickFixBundle.message((String)"fix.can.replace.with.x", (Object[])new Object[]{"." + this.myMapMethod + "().stream()"});
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression call) {
            PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call);
            if (qualifierCall == null) {
                return null;
            }
            if (this.myDeleteMap) {
                CommentTracker ct = new CommentTracker();
                call = (PsiMethodCallExpression)ct.replaceAndRestoreComments((PsiElement)call, (PsiElement)qualifierCall);
            }
            PsiMethodCallExpression result = call;
            while (call != null) {
                if (STREAM_MAP_TO_ALL.test(call) || STREAM_FILTER.test(call)) {
                    PsiExpression arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getArgumentList().getExpressions()[0]);
                    if (arg instanceof PsiLambdaExpression) {
                        PsiLambdaExpression lambdaExpr = (PsiLambdaExpression)arg;
                        this.updateLambda(lambdaExpr);
                    } else if (arg instanceof PsiMethodReferenceExpression) {
                        PsiType type = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiFunctionalExpression)arg));
                        String name = new VariableNameGenerator((PsiElement)arg, VariableKind.PARAMETER).byType(type).byName(this.myNames).generate(false);
                        new CommentTracker().replaceAndRestoreComments((PsiElement)arg, name + "->" + name);
                    }
                }
                if (!MAP_ENTRY_SET.test(call = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call))) continue;
                ExpressionUtils.bindCallTo((PsiMethodCallExpression)call, (String)this.myMapMethod);
                break;
            }
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences((PsiElement)result);
            return result;
        }

        private void updateLambda(PsiLambdaExpression lambda) {
            String name;
            PsiParameter[] parameters = lambda.getParameterList().getParameters();
            if (parameters.length != 1) {
                return;
            }
            PsiParameter parameter = parameters[0];
            PsiElement body = lambda.getBody();
            if (body == null) {
                return;
            }
            ArrayList<PsiMethodCallExpression> calls = new ArrayList<PsiMethodCallExpression>();
            PsiLocalVariable declaration = null;
            for (PsiReferenceExpression ref : VariableAccessUtils.getVariableReferences((PsiVariable)parameter)) {
                PsiLocalVariable var;
                PsiMethodCallExpression call = ExpressionUtils.getCallForQualifier((PsiExpression)ref);
                if (call == null) continue;
                calls.add(call);
                if (declaration != null || (var = (PsiLocalVariable)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent()), PsiLocalVariable.class)) == null || !(var.getParent() instanceof PsiDeclarationStatement) || var.getParent().getParent() != body) continue;
                declaration = var;
            }
            String string = name = declaration == null ? null : declaration.getName();
            if (name == null) {
                int typeParamIndex = this.myMapMethod.equals("keySet") ? 0 : 1;
                PsiType type = PsiUtil.substituteTypeParameter((PsiType)parameter.getType(), (String)"java.util.Map.Entry", (int)typeParamIndex, (boolean)true);
                name = new VariableNameGenerator((PsiElement)lambda, VariableKind.PARAMETER).byType(type).byName(this.myNames).generate(false);
            }
            for (PsiMethodCallExpression call : calls) {
                PsiElement result = new CommentTracker().replaceAndRestoreComments((PsiElement)call, name);
                if (call != body) continue;
                body = result;
            }
            if (declaration != null) {
                new CommentTracker().deleteAndRestoreComments(declaration);
            }
            CommentTracker ct = new CommentTracker();
            ct.replaceAndRestoreComments((PsiElement)lambda, name + "->" + ct.text(body));
        }

        public static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of((CallMatcher)STREAM_MAP_TO_ALL, call -> {
                PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call);
                List<String> methods = new ArrayList<String>(Arrays.asList("getKey", "getValue"));
                while (STREAM_FILTER.test(qualifierCall)) {
                    String methodName = EntrySetMapFix.getSingleCalledMethodName(qualifierCall.getArgumentList().getExpressions()[0]);
                    if (methodName == null || !methods.contains(methodName)) {
                        return null;
                    }
                    methods = Collections.singletonList(methodName);
                    qualifierCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)qualifierCall);
                }
                if (!COLLECTION_STREAM.test(qualifierCall)) {
                    return null;
                }
                PsiMethodCallExpression qualifierQualifierCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)qualifierCall);
                if (!MAP_ENTRY_SET.test(qualifierQualifierCall)) {
                    return null;
                }
                PsiExpression arg = call.getArgumentList().getExpressions()[0];
                for (String method : methods) {
                    if (!FunctionalExpressionUtils.isFunctionalReferenceTo((PsiExpression)arg, (String)"java.util.Map.Entry", null, (String)method, (PsiType[])new PsiType[0])) continue;
                    return new EntrySetMapFix(method, "map".equals(call.getMethodExpression().getReferenceName()));
                }
                String methodName = EntrySetMapFix.getSingleCalledMethodName(arg);
                if (methodName != null && methods.contains(methodName)) {
                    return new EntrySetMapFix(methodName, false);
                }
                return null;
            });
        }

        @Nullable
        private static String getSingleCalledMethodName(PsiExpression arg) {
            PsiLambdaExpression lambda = (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)arg), PsiLambdaExpression.class);
            if (lambda == null) {
                return null;
            }
            PsiParameter[] parameters = lambda.getParameterList().getParameters();
            if (parameters.length != 1) {
                return null;
            }
            PsiParameter parameter = parameters[0];
            PsiElement body = lambda.getBody();
            if (body == null) {
                return null;
            }
            String methodName = null;
            for (PsiReferenceExpression ref : VariableAccessUtils.getVariableReferences((PsiVariable)parameter)) {
                PsiMethodCallExpression call = ExpressionUtils.getCallForQualifier((PsiExpression)ref);
                if (call == null || !call.getArgumentList().isEmpty()) {
                    return null;
                }
                String name = call.getMethodExpression().getReferenceName();
                if (name == null || methodName != null && !methodName.equals(name)) {
                    return null;
                }
                methodName = name;
            }
            return methodName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryMethod", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$EntrySetMapFix", "<init>"));
        }
    }

    static class CollectorToListSize
    implements CallChainSimplification {
        private final boolean mySize;

        CollectorToListSize(boolean size) {
            this.mySize = size;
        }

        @Override
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"count()"});
        }

        @Override
        public String getMessage() {
            return CommonQuickFixBundle.message((String)"fix.can.replace.with.x", (Object[])new Object[]{"count()"});
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression call) {
            String replacement;
            PsiExpression streamExpression = call.getMethodExpression().getQualifierExpression();
            if (streamExpression == null) {
                return null;
            }
            PsiMethodCallExpression sizeCheck = ExpressionUtils.getCallForQualifier((PsiExpression)call);
            if (sizeCheck == null) {
                return null;
            }
            CommentTracker ct = new CommentTracker();
            if (this.mySize) {
                PsiElement parent;
                boolean addCast = true;
                PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)sizeCheck, (boolean)false);
                if (PsiTypes.longType().equals((Object)expectedType)) {
                    addCast = false;
                }
                if ((parent = PsiUtil.skipParenthesizedExprUp((PsiElement)sizeCheck.getParent())) instanceof PsiBinaryExpression && ComparisonUtils.isComparisonOperation((IElementType)((PsiBinaryExpression)parent).getOperationTokenType())) {
                    addCast = false;
                }
                replacement = (addCast ? "(int)" : "") + ct.text((PsiElement)streamExpression) + ".count()";
            } else {
                replacement = ct.text((PsiElement)streamExpression) + ".count() == 0";
            }
            return ct.replaceAndRestoreComments((PsiElement)sizeCheck, replacement);
        }

        public static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of((CallMatcher)STREAM_COLLECT, call -> {
                if (!COLLECTORS_TO_LIST.matches(call.getArgumentList().getExpressions()[0])) {
                    return null;
                }
                PsiMethodCallExpression nextCall = ExpressionUtils.getCallForQualifier((PsiExpression)call);
                if (!COLLECTION_SIZE_CHECK.test(nextCall)) {
                    return null;
                }
                return new CollectorToListSize("size".equals(nextCall.getMethodExpression().getReferenceName()));
            });
        }
    }

    private static class IterateTakeWhileFix
    implements CallChainSimplification {
        private IterateTakeWhileFix() {
        }

        @Override
        public String getName() {
            return JavaBundle.message((String)"simplify.stream.inspection.iterate.take.while.fix.name", (Object[])new Object[0]);
        }

        @Override
        public String getMessage() {
            return JavaBundle.message((String)"simplify.stream.inspection.iterate.take.while.fix.message", (Object[])new Object[0]);
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression call) {
            PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call);
            if (!STREAM_ITERATE.test(qualifierCall)) {
                return null;
            }
            CommentTracker ct = new CommentTracker();
            PsiExpression predicate = call.getArgumentList().getExpressions()[0];
            PsiExpressionList argList = qualifierCall.getArgumentList();
            argList.addAfter(ct.markUnchanged((PsiElement)predicate), (PsiElement)argList.getExpressions()[0]);
            return ct.replaceAndRestoreComments((PsiElement)call, (PsiElement)qualifierCall);
        }

        public static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of((CallMatcher)STREAM_TAKE_WHILE, call -> {
                PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call);
                if (STREAM_ITERATE.test(qualifierCall)) {
                    return new IterateTakeWhileFix();
                }
                return null;
            });
        }
    }

    private static class FilterAndMapUseSameMethodChainFix
    implements CallChainSimplification {
        private FilterAndMapUseSameMethodChainFix() {
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = JavaBundle.message((String)"simplify.stream.swap.filter.and.map.fix.name", (Object[])new Object[0]);
            if (string == null) {
                FilterAndMapUseSameMethodChainFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        @InspectionMessage
        public String getMessage() {
            String string = JavaBundle.message((String)"simplify.stream.swap.filter.and.map.fix.message", (Object[])new Object[0]);
            if (string == null) {
                FilterAndMapUseSameMethodChainFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression mapCall) {
            PsiMethodCallExpression filterCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)mapCall);
            if (filterCall == null) {
                return null;
            }
            PsiExpressionList mapArgList = mapCall.getArgumentList();
            PsiExpressionList filterArgList = filterCall.getArgumentList();
            PsiElement tempMapArgList = mapArgList.copy();
            VariableNameGenerator generator = new VariableNameGenerator((PsiElement)filterCall, VariableKind.PARAMETER);
            PsiMethodCallExpression candidateToRemove = FilterAndMapUseSameMethodChainFix.findCandidateToRemove(mapCall);
            if (candidateToRemove == null) {
                return null;
            }
            PsiType type = candidateToRemove.getMethodExpression().getType();
            if (type == null) {
                return null;
            }
            String newName = generator.byExpression((PsiExpression)candidateToRemove).byType(type).generate(false);
            PsiExpression filterArg = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)ArrayUtil.getFirstElement((Object[])filterCall.getArgumentList().getExpressions())));
            if (filterArg == null) {
                return null;
            }
            PsiLambdaExpression filterLambda = (PsiLambdaExpression)ObjectUtils.tryCast((Object)filterArg, PsiLambdaExpression.class);
            if (filterLambda == null) {
                return null;
            }
            CommentTracker ct = new CommentTracker();
            PsiLambdaExpression expression = (PsiLambdaExpression)JavaPsiFacade.getElementFactory((Project)filterLambda.getProject()).createExpressionFromText(newName + "->{}", (PsiElement)filterLambda);
            ct.replace((PsiElement)candidateToRemove, newName);
            ct.replace((PsiElement)filterLambda.getParameterList(), (PsiElement)expression.getParameterList());
            ct.replace((PsiElement)mapArgList, (PsiElement)filterArgList);
            ct.replace((PsiElement)filterArgList, tempMapArgList);
            ExpressionUtils.bindCallTo((PsiMethodCallExpression)mapCall, (String)"filter");
            ExpressionUtils.bindCallTo((PsiMethodCallExpression)filterCall, (String)"map");
            return mapCall;
        }

        public static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of((CallMatcher)STREAM_MAP, mapCall -> {
                if (mapCall.getTypeArguments().length != 0) {
                    return null;
                }
                PsiMethodCallExpression filterCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)mapCall);
                if (filterCall == null || filterCall.getTypeArguments().length != 0) {
                    return null;
                }
                PsiExpression mapArg = PsiUtil.skipParenthesizedExprDown((PsiExpression)mapCall.getArgumentList().getExpressions()[0]);
                PsiMethodReferenceExpression mapMethodRef = (PsiMethodReferenceExpression)ObjectUtils.tryCast((Object)mapArg, PsiMethodReferenceExpression.class);
                if (mapMethodRef != null) {
                    boolean instanceBound;
                    PsiMethod resolvedCandidateToRemove = FilterAndMapUseSameMethodChainFix.findAndResolveCandidateToRemove(mapCall);
                    if (resolvedCandidateToRemove == null) {
                        return null;
                    }
                    boolean isStatic = resolvedCandidateToRemove.hasModifierProperty("static");
                    boolean bl = instanceBound = !isStatic && !PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)mapMethodRef);
                    if (isStatic || instanceBound) {
                        return null;
                    }
                    PsiManager manager = resolvedCandidateToRemove.getManager();
                    if (!manager.areElementsEquivalent((PsiElement)resolvedCandidateToRemove, mapMethodRef.resolve())) {
                        return null;
                    }
                    return new FilterAndMapUseSameMethodChainFix();
                }
                PsiLambdaExpression lambda = (PsiLambdaExpression)ObjectUtils.tryCast((Object)mapArg, PsiLambdaExpression.class);
                if (lambda == null) {
                    return null;
                }
                PsiExpression body = PsiUtil.skipParenthesizedExprDown((PsiExpression)LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda.getBody()));
                PsiMethodCallExpression calledMethodInMap = FilterAndMapUseSameMethodChainFix.findSingleCalledMethod(mapArg);
                if (calledMethodInMap == null || body != calledMethodInMap) {
                    return null;
                }
                PsiMethod resolvedCandidateToRemove = FilterAndMapUseSameMethodChainFix.findAndResolveCandidateToRemove(mapCall);
                if (resolvedCandidateToRemove == null) {
                    return null;
                }
                PsiManager manager = resolvedCandidateToRemove.getManager();
                if (manager.areElementsEquivalent((PsiElement)resolvedCandidateToRemove, (PsiElement)calledMethodInMap.resolveMethod())) {
                    return new FilterAndMapUseSameMethodChainFix();
                }
                return null;
            });
        }

        private static PsiMethod findAndResolveCandidateToRemove(PsiMethodCallExpression mapCall) {
            PsiMethodCallExpression candidateToRemove = FilterAndMapUseSameMethodChainFix.findCandidateToRemove(mapCall);
            if (candidateToRemove == null) {
                return null;
            }
            PsiType type = StreamApiUtil.getStreamElementType((PsiType)mapCall.getType());
            if (type == null) {
                return null;
            }
            PsiMethod resolvedCandidateToRemove = candidateToRemove.resolveMethod();
            if (resolvedCandidateToRemove == null) {
                return null;
            }
            PsiType candidateToRemoveType = resolvedCandidateToRemove.getReturnType();
            if (candidateToRemoveType == null) {
                return null;
            }
            if (!type.equals(candidateToRemoveType) && !candidateToRemoveType.equals(PsiPrimitiveType.getUnboxedType((PsiType)type))) {
                return null;
            }
            return resolvedCandidateToRemove;
        }

        private static PsiMethodCallExpression findCandidateToRemove(PsiMethodCallExpression mapCall) {
            PsiMethodCallExpression filterCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)mapCall);
            if (!STREAM_FILTER.test(filterCall)) {
                return null;
            }
            return FilterAndMapUseSameMethodChainFix.findSingleCalledMethod(filterCall.getArgumentList().getExpressions()[0]);
        }

        private static PsiMethodCallExpression findSingleCalledMethod(PsiExpression arg) {
            PsiLambdaExpression lambda = (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)arg), PsiLambdaExpression.class);
            if (lambda == null) {
                return null;
            }
            PsiParameter[] parameters = lambda.getParameterList().getParameters();
            if (parameters.length != 1) {
                return null;
            }
            PsiParameter parameter = parameters[0];
            List references = VariableAccessUtils.getVariableReferences((PsiVariable)parameter);
            if (references.size() != 1) {
                return null;
            }
            PsiMethodCallExpression call = ExpressionUtils.getCallForQualifier((PsiExpression)((PsiExpression)references.getFirst()));
            if (call == null || !call.getArgumentList().isEmpty()) {
                return null;
            }
            return call;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$FilterAndMapUseSameMethodChainFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class ReplaceWithOrElseThrowFix
    implements CallChainSimplification {
        private ReplaceWithOrElseThrowFix() {
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"orElseThrow"});
            if (string == null) {
                ReplaceWithOrElseThrowFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        @InspectionMessage
        public String getMessage() {
            String string = CommonQuickFixBundle.message((String)"fix.can.replace.with.x", (Object[])new Object[]{"orElseThrow"});
            if (string == null) {
                ReplaceWithOrElseThrowFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression orElseGetCall) {
            PsiLambdaExpression lambda = (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)orElseGetCall.getArgumentList().getExpressions()[0]), PsiLambdaExpression.class);
            PsiExpression thrownException = ReplaceWithOrElseThrowFix.getThrownException(lambda);
            if (thrownException == null) {
                return null;
            }
            PsiElement body = lambda.getBody();
            assert (body != null);
            ExpressionUtils.bindCallTo((PsiMethodCallExpression)orElseGetCall, (String)"orElseThrow");
            new CommentTracker().replaceAndRestoreComments(body, (PsiElement)thrownException);
            LambdaCanBeMethodReferenceInspection.replaceLambdaWithMethodReference((PsiLambdaExpression)lambda);
            return orElseGetCall;
        }

        public static CallHandler<CallChainSimplification> handler() {
            return CallHandler.of((CallMatcher)OPTIONAL_OR_ELSE_GET, call -> {
                PsiLambdaExpression lambda = (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getArgumentList().getExpressions()[0]), PsiLambdaExpression.class);
                PsiExpression thrownException = ReplaceWithOrElseThrowFix.getThrownException(lambda);
                if (thrownException == null) {
                    return null;
                }
                return new ReplaceWithOrElseThrowFix();
            });
        }

        @Nullable
        private static PsiExpression getThrownException(@Nullable PsiLambdaExpression lambda) {
            if (lambda == null || !lambda.getParameterList().isEmpty()) {
                return null;
            }
            PsiCodeBlock body = (PsiCodeBlock)ObjectUtils.tryCast((Object)lambda.getBody(), PsiCodeBlock.class);
            if (body == null) {
                return null;
            }
            PsiStatement[] statements = body.getStatements();
            if (statements.length != 1) {
                return null;
            }
            PsiThrowStatement throwStatement = (PsiThrowStatement)ObjectUtils.tryCast((Object)statements[0], PsiThrowStatement.class);
            if (throwStatement == null) {
                return null;
            }
            return throwStatement.getException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceWithOrElseThrowFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static final class SimplifyMatchNegationFix
    implements CallChainSimplification {
        private final String myFrom;
        private final String myTo;

        private SimplifyMatchNegationFix(PsiMethodCallExpression call, boolean argNegated, boolean parentNegated, String to) {
            String name = call.getMethodExpression().getReferenceName();
            String arg = argNegated ? "x -> !(...)" : "...";
            String className = Objects.requireNonNull(Objects.requireNonNull(call.resolveMethod()).getContainingClass()).getName();
            this.myFrom = (parentNegated ? "!" : "") + className + "." + name + "(" + arg + ")";
            this.myTo = to;
        }

        @Override
        public String getName() {
            return JavaBundle.message((String)"simplify.stream.match.negation.fix.name", (Object[])new Object[]{this.myFrom, this.myTo});
        }

        @Override
        public String getMessage() {
            return CommonQuickFixBundle.message((String)"fix.can.replace.x.with.y", (Object[])new Object[]{this.myFrom, this.myTo + "()"});
        }

        @Override
        public PsiElement simplify(PsiMethodCallExpression methodCall) {
            boolean removeParentNegation;
            boolean removeLambdaNegation;
            String from = methodCall.getMethodExpression().getReferenceName();
            if (from == null) {
                return null;
            }
            switch (from) {
                case "allMatch": {
                    removeLambdaNegation = true;
                    removeParentNegation = this.myTo.equals(SimplifyStreamApiCallChainsInspection.ANY_MATCH_METHOD);
                    break;
                }
                case "anyMatch": {
                    removeParentNegation = true;
                    removeLambdaNegation = this.myTo.equals(SimplifyStreamApiCallChainsInspection.ALL_MATCH_METHOD);
                    break;
                }
                case "noneMatch": {
                    removeParentNegation = this.myTo.equals(SimplifyStreamApiCallChainsInspection.ANY_MATCH_METHOD);
                    removeLambdaNegation = this.myTo.equals(SimplifyStreamApiCallChainsInspection.ALL_MATCH_METHOD);
                    break;
                }
                default: {
                    return null;
                }
            }
            if (removeParentNegation && !SimplifyMatchNegationFix.isParentNegated(methodCall)) {
                return null;
            }
            if (removeLambdaNegation && !SimplifyMatchNegationFix.isArgumentLambdaNegated(methodCall)) {
                return null;
            }
            ExpressionUtils.bindCallTo((PsiMethodCallExpression)methodCall, (String)this.myTo);
            if (removeLambdaNegation) {
                PsiExpression body = (PsiExpression)((PsiLambdaExpression)methodCall.getArgumentList().getExpressions()[0]).getBody();
                PsiExpression negated = BoolUtils.getNegated((PsiExpression)body);
                LOG.assertTrue(negated != null);
                body.replace((PsiElement)negated);
            }
            if (removeParentNegation) {
                return PsiUtil.skipParenthesizedExprUp((PsiElement)methodCall.getParent()).replace((PsiElement)methodCall);
            }
            return methodCall;
        }

        static boolean isParentNegated(PsiMethodCallExpression methodCall) {
            if (ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)methodCall.getMethodExpression())) {
                return false;
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)methodCall.getParent());
            return parent instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)((PsiExpression)parent));
        }

        static boolean isArgumentLambdaNegated(PsiMethodCallExpression methodCall) {
            if (ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)methodCall.getMethodExpression())) {
                return false;
            }
            PsiExpression[] expressions = methodCall.getArgumentList().getExpressions();
            if (expressions.length != 1) {
                return false;
            }
            PsiExpression arg = expressions[0];
            if (!(arg instanceof PsiLambdaExpression)) {
                return false;
            }
            PsiElement body = ((PsiLambdaExpression)arg).getBody();
            return body instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)((PsiExpression)body));
        }

        static List<CallHandler<CallChainSimplification>> handlers() {
            return Arrays.asList(CallHandler.of((CallMatcher)STREAM_ANY_MATCH, methodCall -> {
                boolean argNegated;
                if (!SimplifyMatchNegationFix.isParentNegated(methodCall)) {
                    return null;
                }
                return new SimplifyMatchNegationFix((PsiMethodCallExpression)methodCall, argNegated, true, (argNegated = SimplifyMatchNegationFix.isArgumentLambdaNegated(methodCall)) ? SimplifyStreamApiCallChainsInspection.ALL_MATCH_METHOD : SimplifyStreamApiCallChainsInspection.NONE_MATCH_METHOD);
            }), CallHandler.of((CallMatcher)STREAM_NONE_MATCH, methodCall -> SimplifyMatchNegationFix.isParentNegated(methodCall) ? new SimplifyMatchNegationFix((PsiMethodCallExpression)methodCall, false, true, SimplifyStreamApiCallChainsInspection.ANY_MATCH_METHOD) : null), CallHandler.of((CallMatcher)STREAM_NONE_MATCH, methodCall -> SimplifyMatchNegationFix.isArgumentLambdaNegated(methodCall) ? new SimplifyMatchNegationFix((PsiMethodCallExpression)methodCall, true, false, SimplifyStreamApiCallChainsInspection.ALL_MATCH_METHOD) : null), CallHandler.of((CallMatcher)STREAM_ALL_MATCH, methodCall -> {
                boolean parentNegated;
                if (!SimplifyMatchNegationFix.isArgumentLambdaNegated(methodCall)) {
                    return null;
                }
                return new SimplifyMatchNegationFix((PsiMethodCallExpression)methodCall, true, parentNegated, (parentNegated = SimplifyMatchNegationFix.isParentNegated(methodCall)) ? SimplifyStreamApiCallChainsInspection.ANY_MATCH_METHOD : SimplifyStreamApiCallChainsInspection.NONE_MATCH_METHOD);
            }));
        }
    }

    private static class SimplifyCollectionCreationFix
    implements CallChainFix {
        static final CallMapper<String> COLLECTOR_TO_CLASS_MAPPER = new CallMapper().register(SimplifyStreamApiCallChainsInspection.collectorMatcher("toList", 0), (Object)"java.util.ArrayList").register(SimplifyStreamApiCallChainsInspection.collectorMatcher("toSet", 0), (Object)"java.util.HashSet").register(SimplifyStreamApiCallChainsInspection.collectorMatcher("toCollection", 1), SimplifyCollectionCreationFix::getCollectionClass);
        private final String myReplacement;

        SimplifyCollectionCreationFix(String replacement) {
            this.myReplacement = replacement;
        }

        @Override
        public String getName() {
            return JavaBundle.message((String)"simplify.stream.collection.creation.fix.name", (Object[])new Object[]{this.myReplacement});
        }

        @Override
        public void applyFix(@NotNull Project project, PsiElement element) {
            PsiElementFactory factory;
            PsiExpression result;
            PsiNewExpression newExpression;
            PsiJavaCodeReferenceElement classReference;
            if (project == null) {
                SimplifyCollectionCreationFix.$$$reportNull$$$0(0);
            }
            if (!(element instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression collectCall = (PsiMethodCallExpression)element;
            PsiType type = collectCall.getType();
            PsiClass resolvedType = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
            if (resolvedType == null || resolvedType instanceof PsiTypeParameter) {
                return;
            }
            PsiMethodCallExpression streamCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)collectCall);
            if (streamCall == null) {
                return;
            }
            PsiExpression collectionExpression = streamCall.getMethodExpression().getQualifierExpression();
            if (collectionExpression == null) {
                return;
            }
            Object typeText = type.getCanonicalText();
            if ("java.util.List".equals(resolvedType.getQualifiedName()) || "java.util.Set".equals(resolvedType.getQualifiedName())) {
                PsiType[] parameters = ((PsiClassType)type).getParameters();
                if (parameters.length != 1) {
                    return;
                }
                typeText = this.myReplacement + "<" + parameters[0].getCanonicalText() + ">";
            }
            LOG.assertTrue((classReference = (newExpression = (PsiNewExpression)element.replace((PsiElement)(result = (factory = JavaPsiFacade.getElementFactory((Project)project)).createExpressionFromText("new " + (String)typeText + "(" + collectionExpression.getText() + ")", element)))).getClassOrAnonymousClassReference()) != null);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)classReference);
            if (PsiDiamondTypeUtil.canCollapseToDiamond((PsiNewExpression)newExpression, (PsiNewExpression)newExpression, null)) {
                RemoveRedundantTypeArgumentsUtil.replaceExplicitWithDiamond((PsiElement)classReference.getParameterList());
            }
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)newExpression);
        }

        @Nullable
        private static String getCollectionClass(PsiMethodCallExpression call) {
            PsiClass aClass = FunctionalExpressionUtils.getClassOfDefaultConstructorFunction((PsiExpression)call.getArgumentList().getExpressions()[0]);
            return ConstructionUtils.isCollectionWithCopyConstructor((PsiClass)aClass) ? aClass.getQualifiedName() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$SimplifyCollectionCreationFix", "applyFix"));
        }
    }

    private static class ReplaceOptionalIsPresentChainFix
    implements CallChainFix {
        private final String myFindMethodName;

        ReplaceOptionalIsPresentChainFix(String findMethodName) {
            this.myFindMethodName = findMethodName;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = JavaBundle.message((String)"quickfix.text.replace.filter.0.is.present.with.any.match", (Object[])new Object[]{this.myFindMethodName});
            if (string == null) {
                ReplaceOptionalIsPresentChainFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, PsiElement element) {
            PsiMethodCallExpression findCall;
            PsiMethodCallExpression isPresentCall;
            PsiExpression psiExpression;
            if (project == null) {
                ReplaceOptionalIsPresentChainFix.$$$reportNull$$$0(1);
            }
            if (element instanceof PsiMethodCallExpression && (psiExpression = (isPresentCall = (PsiMethodCallExpression)element).getMethodExpression().getQualifierExpression()) instanceof PsiMethodCallExpression && (psiExpression = (findCall = (PsiMethodCallExpression)psiExpression).getMethodExpression().getQualifierExpression()) instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression filterCall = (PsiMethodCallExpression)psiExpression;
                PsiElement replacement = element.replace((PsiElement)filterCall);
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                PsiElement filterName = ((PsiMethodCallExpression)replacement).getMethodExpression().getReferenceNameElement();
                LOG.assertTrue(filterName != null);
                filterName.replace((PsiElement)factory.createIdentifier(SimplifyStreamApiCallChainsInspection.ANY_MATCH_METHOD));
            }
        }

        @NotNull
        @InspectionMessage
        public String getMessage() {
            String string = JavaBundle.message((String)"inspection.message.filter.is.present.chain.can.be.replaced.with.anymatch", (Object[])new Object[]{this.myFindMethodName});
            if (string == null) {
                ReplaceOptionalIsPresentChainFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceOptionalIsPresentChainFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceOptionalIsPresentChainFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ReplaceCollectorFix
    implements CallChainFix {
        static final CallMapper<ReplaceCollectorFix> COLLECTOR_TO_FIX_MAPPER = new CallMapper(new CallHandler[]{ReplaceCollectorFix.handler("counting", 0, "count()", false), ReplaceCollectorFix.returnTypeMatcher(ReplaceCollectorFix.handler("minBy", 1, "min({0})", true)), ReplaceCollectorFix.returnTypeMatcher(ReplaceCollectorFix.handler("maxBy", 1, "max({0})", true)), ReplaceCollectorFix.handler("mapping", 2, "map({0}).collect({1})", false), ReplaceCollectorFix.returnTypeMatcher(ReplaceCollectorFix.handler("reducing", 1, "reduce({0})", true)), ReplaceCollectorFix.handler("reducing", 2, "reduce({0}, {1})", false), ReplaceCollectorFix.handler("reducing", 3, "map({1}).reduce({0}, {2})", false), ReplaceCollectorFix.handler("summingInt", 1, "mapToInt({0}).sum()", false), ReplaceCollectorFix.handler("summingLong", 1, "mapToLong({0}).sum()", false), ReplaceCollectorFix.handler("summingDouble", 1, "mapToDouble({0}).sum()", false), CallHandler.of((CallMatcher)SimplifyStreamApiCallChainsInspection.collectorMatcher("toUnmodifiableList", 0).withLanguageLevelAtLeast(LanguageLevel.JDK_16), call -> ReplaceCollectorFix.elementTypeMatches((PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)call, PsiMethodCallExpression.class)) ? new ReplaceCollectorFix("toUnmodifiableList", "toList()", false) : null), CallHandler.of((CallMatcher)SimplifyStreamApiCallChainsInspection.collectorMatcher("toList", 0).withLanguageLevelAtLeast(LanguageLevel.JDK_16), call -> {
            PsiMethodCallExpression collectCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)call, PsiMethodCallExpression.class);
            return MismatchedCollectionQueryUpdateInspection.isUnmodified((PsiMethodCallExpression)collectCall) && ReplaceCollectorFix.elementTypeMatches(collectCall) ? new ReplaceCollectorFix("toList", "toList()", false) : null;
        })});
        private final String myCollector;
        private final String myStreamSequence;
        private final String myStreamSequenceStripped;
        private final boolean myChangeSemantics;

        private static CallHandler<ReplaceCollectorFix> returnTypeMatcher(CallHandler<ReplaceCollectorFix> orig) {
            return new CallHandler(orig.matcher(), call -> {
                PsiMethodCallExpression collectCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)call, PsiMethodCallExpression.class);
                if (collectCall == null) {
                    return null;
                }
                PsiExpression qualifier = collectCall.getMethodExpression().getQualifierExpression();
                if (qualifier == null) {
                    return null;
                }
                PsiType streamElementType = PsiUtil.substituteTypeParameter((PsiType)qualifier.getType(), (String)"java.util.stream.Stream", (int)0, (boolean)false);
                PsiType optionalElementType = PsiUtil.substituteTypeParameter((PsiType)collectCall.getType(), (String)"java.util.Optional", (int)0, (boolean)false);
                if (streamElementType == null || !streamElementType.equals(optionalElementType)) {
                    return null;
                }
                return (ReplaceCollectorFix)orig.apply(call);
            });
        }

        @Contract(value="null -> false")
        private static boolean elementTypeMatches(@Nullable PsiMethodCallExpression collect) {
            if (collect == null) {
                return false;
            }
            PsiExpression qualifier = collect.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            PsiType streamElementType = PsiUtil.substituteTypeParameter((PsiType)qualifier.getType(), (String)"java.util.stream.Stream", (int)0, (boolean)false);
            PsiType collectionElementType = PsiUtil.substituteTypeParameter((PsiType)collect.getType(), (String)"java.util.Collection", (int)0, (boolean)false);
            return streamElementType != null && collectionElementType != null && streamElementType.equals(collectionElementType);
        }

        ReplaceCollectorFix(String collector, String streamSequence, boolean changeSemantics) {
            this.myCollector = collector;
            this.myStreamSequence = streamSequence;
            this.myStreamSequenceStripped = streamSequence.replaceAll("\\([^)]+\\)", "()");
            this.myChangeSemantics = changeSemantics;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = JavaBundle.message((String)"quickfix.text.replace.collect.0.with.1.2", (Object[])new Object[]{this.myCollector, this.myStreamSequenceStripped, this.myChangeSemantics ? " (may change semantics when result is null)" : ""});
            if (string == null) {
                ReplaceCollectorFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, PsiElement element) {
            if (project == null) {
                ReplaceCollectorFix.$$$reportNull$$$0(1);
            }
            if (element instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression collectCall = (PsiMethodCallExpression)element;
                PsiExpression qualifierExpression = collectCall.getMethodExpression().getQualifierExpression();
                if (qualifierExpression == null) {
                    return;
                }
                PsiExpression[] collectArgs = collectCall.getArgumentList().getExpressions();
                if (collectArgs.length != 1) {
                    return;
                }
                PsiMethodCallExpression collectorCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)collectArgs[0]), PsiMethodCallExpression.class);
                if (collectorCall == null) {
                    return;
                }
                PsiExpression[] collectorArgs = collectorCall.getArgumentList().getExpressions();
                String result = MessageFormat.format(this.myStreamSequence, Arrays.stream(collectorArgs).map(PsiElement::getText).toArray());
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                PsiMethodCallExpression mock = (PsiMethodCallExpression)factory.createExpressionFromText(result, (PsiElement)collectCall);
                if (mock.getMethodExpression().getQualifierExpression() == null) {
                    ExpressionUtils.bindCallTo((PsiMethodCallExpression)collectCall, (String)Objects.requireNonNull(mock.getMethodExpression().getReferenceName()));
                    collectCall.getArgumentList().replace((PsiElement)mock.getArgumentList());
                } else {
                    PsiExpression replacement = factory.createExpressionFromText(qualifierExpression.getText() + "." + result, (PsiElement)collectCall);
                    collectCall = (PsiMethodCallExpression)collectCall.replace((PsiElement)replacement);
                }
                ReplaceCollectorFix.addBoxingIfNecessary(factory, (PsiElement)collectCall);
            }
        }

        private static void addBoxingIfNecessary(PsiElementFactory factory, PsiElement expression) {
            PsiExpression castExpression;
            PsiElement cast;
            PsiClassType boxedType;
            PsiType type;
            if (expression instanceof PsiExpression && (type = ((PsiExpression)expression).getType()) instanceof PsiPrimitiveType && (boxedType = ((PsiPrimitiveType)type).getBoxedType(expression)) != null && (cast = expression.replace((PsiElement)(castExpression = factory.createExpressionFromText("(" + boxedType.getCanonicalText() + ") " + expression.getText(), expression)))) instanceof PsiTypeCastExpression && RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)((PsiTypeCastExpression)cast))) {
                RemoveRedundantCastUtil.removeCast((PsiTypeCastExpression)((PsiTypeCastExpression)cast));
            }
        }

        @NotNull
        @InspectionMessage
        public String getMessage() {
            String before = "collect(" + this.myCollector + "())";
            String string = JavaBundle.message((String)(this.myChangeSemantics ? "simplify.stream.inspection.message.can.be.replaced.may.change.semantics" : "simplify.stream.inspection.message.can.be.replaced"), (Object[])new Object[]{before, this.myStreamSequenceStripped});
            if (string == null) {
                ReplaceCollectorFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        static CallHandler<ReplaceCollectorFix> handler(String collectorName, int parameterCount, String template, boolean changeSemantics) {
            return CallHandler.of((CallMatcher)SimplifyStreamApiCallChainsInspection.collectorMatcher(collectorName, parameterCount), call -> new ReplaceCollectorFix(collectorName, template, changeSemantics));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectorFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectorFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class ReplaceSingletonWithStreamOfFix
    extends ReplaceCollectionStreamFix {
        private ReplaceSingletonWithStreamOfFix(String qualifierCall) {
            super(qualifierCall, "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.OF_METHOD);
        }

        @Override
        @Nullable
        protected String getTypeParameter(@NotNull CommentTracker ct, @NotNull PsiMethodCallExpression qualifierCall) {
            PsiType argType;
            String typeParameter;
            if (ct == null) {
                ReplaceSingletonWithStreamOfFix.$$$reportNull$$$0(0);
            }
            if (qualifierCall == null) {
                ReplaceSingletonWithStreamOfFix.$$$reportNull$$$0(1);
            }
            if ((typeParameter = super.getTypeParameter(ct, qualifierCall)) != null) {
                return typeParameter;
            }
            PsiType[] argTypes = qualifierCall.getArgumentList().getExpressionTypes();
            if (argTypes.length == 1 && (argType = argTypes[0]) instanceof PsiArrayType) {
                return argType.getCanonicalText();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ct";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "qualifierCall";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceSingletonWithStreamOfFix";
            objectArray[2] = "getTypeParameter";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SimplifyCallChainFix
    extends PsiUpdateModCommandQuickFix {
        private final CallChainFix myFix;

        SimplifyCallChainFix(CallChainFix fix) {
            this.myFix = fix;
        }

        @NotNull
        public String getName() {
            String string = this.myFix.getName();
            if (string == null) {
                SimplifyCallChainFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"quickfix.family.simplify.stream.call.chain", (Object[])new Object[0]);
            if (string == null) {
                SimplifyCallChainFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                SimplifyCallChainFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                SimplifyCallChainFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                SimplifyCallChainFix.$$$reportNull$$$0(4);
            }
            this.myFix.applyFix(project, element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$SimplifyCallChainFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$SimplifyCallChainFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    static interface CallChainFix {
        @IntentionName
        public String getName();

        public void applyFix(@NotNull Project var1, PsiElement var2);
    }
}

