/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.generate.psi.PsiAdapter;

public final class SuspiciousTernaryOperatorInVarargsCallInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.VARARGS);
        if (set == null) {
            SuspiciousTernaryOperatorInVarargsCallInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SuspiciousTernaryOperatorInVarargsCallInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                LocalQuickFix[] localQuickFixArray;
                PsiType elseType;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitMethodCallExpression(expression);
                PsiExpressionList argumentList = expression.getArgumentList();
                if (argumentList.isEmpty()) {
                    return;
                }
                Object[] args = argumentList.getExpressions();
                PsiExpression varargsExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)ArrayUtil.getLastElement((Object[])args)));
                PsiConditionalExpression conditional = (PsiConditionalExpression)ObjectUtils.tryCast((Object)varargsExpression, PsiConditionalExpression.class);
                if (conditional == null) {
                    return;
                }
                PsiMethod method = expression.resolveMethod();
                if (method == null || !method.isVarArgs()) {
                    return;
                }
                PsiParameter[] params = method.getParameterList().getParameters();
                if (args.length != params.length) {
                    return;
                }
                PsiExpression thenExpression = conditional.getThenExpression();
                PsiExpression elseExpression = conditional.getElseExpression();
                if (thenExpression == null || elseExpression == null) {
                    return;
                }
                PsiType thenType = thenExpression.getType();
                boolean isThenArray = thenType instanceof PsiArrayType;
                if (isThenArray == (elseType = elseExpression.getType()) instanceof PsiArrayType) {
                    return;
                }
                PsiExpression nonArray = isThenArray ? elseExpression : thenExpression;
                PsiExpression array = isThenArray ? thenExpression : elseExpression;
                PsiClassType varargsType = (PsiClassType)ObjectUtils.tryCast((Object)varargsExpression.getType(), PsiClassType.class);
                if (varargsType == null) {
                    return;
                }
                String typeName = varargsType.getName();
                String replacementText = String.format("new %s[]{%s}", typeName, nonArray.getText());
                if (PsiAdapter.isPrimitiveArrayType((PsiType)array.getType())) {
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                } else {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = new WrapInArrayInitializerFix(replacementText, typeName);
                }
                LocalQuickFix[] fix = localQuickFixArray;
                holder.registerProblem((PsiElement)nonArray, JavaBundle.message((String)"inspection.suspicious.ternary.in.varargs.description", (Object[])new Object[0]), ProblemHighlightType.WARNING, fix);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/SuspiciousTernaryOperatorInVarargsCallInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/SuspiciousTernaryOperatorInVarargsCallInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/SuspiciousTernaryOperatorInVarargsCallInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class WrapInArrayInitializerFix
    extends PsiUpdateModCommandQuickFix {
        private final String myReplacementMessage;
        private final String myTypeName;

        WrapInArrayInitializerFix(String replacementMessage, String typeName) {
            this.myReplacementMessage = replacementMessage;
            this.myTypeName = typeName;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myReplacementMessage});
            if (string == null) {
                WrapInArrayInitializerFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.suspicious.ternary.in.varargs.quickfix", (Object[])new Object[0]);
            if (string == null) {
                WrapInArrayInitializerFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                WrapInArrayInitializerFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                WrapInArrayInitializerFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                WrapInArrayInitializerFix.$$$reportNull$$$0(4);
            }
            CommentTracker ct = new CommentTracker();
            String replacementText = String.format("new %s[]{%s}", this.myTypeName, ct.text(element));
            ct.replaceAndRestoreComments(element, replacementText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SuspiciousTernaryOperatorInVarargsCallInspection$WrapInArrayInitializerFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SuspiciousTernaryOperatorInVarargsCallInspection$WrapInArrayInitializerFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

