/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaOptionalSupport;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaDfaAnchor;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaMethodReferenceArgumentAnchor;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class OptionalOfNullableMisuseInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.STREAM_OPTIONAL);
        if (set == null) {
            OptionalOfNullableMisuseInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            OptionalOfNullableMisuseInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!OptionalUtil.OPTIONAL_OF_NULLABLE.matches((PsiExpression)call)) {
                    return;
                }
                PsiExpression arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions())));
                if (arg == null) {
                    return;
                }
                DfType type = CommonDataflow.getDfType((PsiExpression)arg);
                this.processArgument(type, (PsiElement)arg);
            }

            private void processArgument(@NotNull DfType type, @NotNull PsiElement anchor) {
                DfaNullability nullability;
                if (type == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (anchor == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((nullability = DfaNullability.fromDfType((DfType)type)) == DfaNullability.NOT_NULL) {
                    holder.registerProblem(anchor, JavaAnalysisBundle.message((String)"dataflow.message.passing.non.null.argument.to.optional", (Object[])new Object[0]), LocalQuickFix.notNullElements((LocalQuickFix)DfaOptionalSupport.createReplaceOptionalOfNullableWithOfFix((PsiElement)anchor)));
                } else if (nullability == DfaNullability.NULL) {
                    holder.registerProblem(anchor, JavaAnalysisBundle.message((String)"dataflow.message.passing.null.argument.to.optional", (Object[])new Object[0]), LocalQuickFix.notNullElements((LocalQuickFix)DfaOptionalSupport.createReplaceOptionalOfNullableWithEmptyFix((PsiElement)anchor)));
                }
            }

            public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression methodRef) {
                if (methodRef == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (!OptionalUtil.OPTIONAL_OF_NULLABLE.methodReferenceMatches(methodRef)) {
                    return;
                }
                CommonDataflow.DataflowResult dfr = CommonDataflow.getDataflowResult((PsiElement)methodRef);
                if (dfr == null) {
                    return;
                }
                PsiElement anchor = methodRef.getReferenceNameElement();
                if (anchor == null) {
                    return;
                }
                DfType type = dfr.getDfType((JavaDfaAnchor)new JavaMethodReferenceArgumentAnchor(methodRef));
                this.processArgument(type, anchor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "anchor";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "methodRef";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/OptionalOfNullableMisuseInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processArgument";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodReferenceExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/OptionalOfNullableMisuseInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/OptionalOfNullableMisuseInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

