/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.enhancedSwitch;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class SwitchLabeledRuleCanBeCodeBlockInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.ENHANCED_SWITCH);
        if (set == null) {
            SwitchLabeledRuleCanBeCodeBlockInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            SwitchLabeledRuleCanBeCodeBlockInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitSwitchLabeledRuleStatement(@NotNull PsiSwitchLabeledRuleStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitSwitchLabeledRuleStatement(statement);
                PsiSwitchBlock switchBlock = statement.getEnclosingSwitchBlock();
                PsiStatement body = statement.getBody();
                if (switchBlock != null && (body instanceof PsiExpressionStatement || body instanceof PsiThrowStatement)) {
                    if (switchBlock instanceof PsiSwitchExpression && body instanceof PsiExpressionStatement) {
                        this.registerProblem(statement, true);
                    } else {
                        this.registerProblem(statement, false);
                    }
                }
            }

            private void registerProblem(@NotNull PsiSwitchLabeledRuleStatement statement, boolean isResultExpression) {
                if (statement == null) {
                    1.$$$reportNull$$$0(1);
                }
                holder.registerProblem(this.getProblemElement(statement), JavaBundle.message((String)(isResultExpression ? "inspection.switch.labeled.rule.can.be.code.block.expression.message" : "inspection.switch.labeled.rule.can.be.code.block.statement.message"), (Object[])new Object[0]), new LocalQuickFix[]{new WrapWithCodeBlockFix(isResultExpression)});
            }

            @NotNull
            private PsiElement getProblemElement(@NotNull PsiSwitchLabeledRuleStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (isOnTheFly && (InspectionProjectProfileManager.isInformationLevel((String)SwitchLabeledRuleCanBeCodeBlockInspection.this.getShortName(), (PsiElement)statement) || ApplicationManager.getApplication().isUnitTestMode())) {
                    PsiSwitchLabeledRuleStatement psiSwitchLabeledRuleStatement = statement;
                    if (psiSwitchLabeledRuleStatement == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return psiSwitchLabeledRuleStatement;
                }
                PsiElement psiElement = (PsiElement)ObjectUtils.notNull((Object)((PsiElement)ObjectUtils.tryCast((Object)statement.getFirstChild(), PsiKeyword.class)), (Object)statement);
                if (psiElement == null) {
                    1.$$$reportNull$$$0(4);
                }
                return psiElement;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/enhancedSwitch/SwitchLabeledRuleCanBeCodeBlockInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/enhancedSwitch/SwitchLabeledRuleCanBeCodeBlockInspection$1";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getProblemElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitSwitchLabeledRuleStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "registerProblem";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getProblemElement";
                        break;
                    }
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3, 4 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/enhancedSwitch/SwitchLabeledRuleCanBeCodeBlockInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/enhancedSwitch/SwitchLabeledRuleCanBeCodeBlockInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class WrapWithCodeBlockFix
    extends PsiUpdateModCommandQuickFix {
        @Nls
        private final String myMessage;

        WrapWithCodeBlockFix(boolean isResultExpression) {
            this.myMessage = JavaBundle.message((String)(isResultExpression ? "inspection.switch.labeled.rule.can.be.code.block.fix.expression.name" : "inspection.switch.labeled.rule.can.be.code.block.fix.statement.name"), (Object[])new Object[0]);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = this.myMessage;
            if (string == null) {
                WrapWithCodeBlockFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                WrapWithCodeBlockFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                WrapWithCodeBlockFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                WrapWithCodeBlockFix.$$$reportNull$$$0(3);
            }
            if (element instanceof PsiKeyword) {
                element = element.getParent();
            }
            if (element instanceof PsiSwitchLabeledRuleStatement) {
                PsiSwitchLabeledRuleStatement rule = (PsiSwitchLabeledRuleStatement)element;
                PsiSwitchBlock switchBlock = rule.getEnclosingSwitchBlock();
                PsiStatement body = rule.getBody();
                if (switchBlock instanceof PsiSwitchExpression && body instanceof PsiExpressionStatement) {
                    PsiExpressionStatement statement = (PsiExpressionStatement)body;
                    WrapWithCodeBlockFix.wrapExpression(statement);
                } else if (body != null) {
                    WrapWithCodeBlockFix.wrapStatement(body);
                }
            }
        }

        private static void wrapExpression(PsiExpressionStatement expressionStatement) {
            CommentTracker tracker = new CommentTracker();
            String valueKeyword = "yield";
            tracker.replaceAndRestoreComments((PsiElement)expressionStatement, "{ " + valueKeyword + " " + tracker.text((PsiElement)expressionStatement) + "\n }");
        }

        private static void wrapStatement(@NotNull PsiStatement statement) {
            if (statement == null) {
                WrapWithCodeBlockFix.$$$reportNull$$$0(4);
            }
            CommentTracker tracker = new CommentTracker();
            tracker.replaceAndRestoreComments((PsiElement)statement, "{ " + tracker.text((PsiElement)statement) + "\n }");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/enhancedSwitch/SwitchLabeledRuleCanBeCodeBlockInspection$WrapWithCodeBlockFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/enhancedSwitch/SwitchLabeledRuleCanBeCodeBlockInspection$WrapWithCodeBlockFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "wrapStatement";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

