/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18api;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.Java8MigrationUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Java8MapApiInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(Java8MapApiInspection.class);
    public static final String SHORT_NAME = "Java8MapApi";
    private static final CallMatcher KEY_VALUE_GET_METHODS = CallMatcher.instanceCall((String)"java.util.Map.Entry", (String[])new String[]{"getKey", "getValue"}).parameterCount(0);
    public boolean mySuggestMapGetOrDefault = true;
    public boolean mySuggestMapComputeIfAbsent = true;
    public boolean mySuggestMapPutIfAbsent = true;
    public boolean mySuggestMapMerge = true;
    public boolean mySuggestMapReplaceAll = true;
    public boolean myTreatGetNullAsContainsKey = false;
    public boolean mySideEffects = false;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"mySuggestMapComputeIfAbsent", (String)JavaBundle.message((String)"checkbox.suggest.conversion.to.map.computeifabsent", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"mySuggestMapGetOrDefault", (String)JavaBundle.message((String)"checkbox.suggest.conversion.to.map.getordefault", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"mySuggestMapPutIfAbsent", (String)JavaBundle.message((String)"checkbox.suggest.conversion.to.map.putifabsent", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"mySuggestMapMerge", (String)JavaBundle.message((String)"checkbox.suggest.conversion.to.map.merge", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"mySuggestMapReplaceAll", (String)JavaBundle.message((String)"checkbox.suggest.conversion.to.map.replaceall", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"myTreatGetNullAsContainsKey", (String)JavaBundle.message((String)"checkbox.treat.get.k.null.the.same.as.containskey.k.may.change.semantics", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"mySideEffects", (String)JavaBundle.message((String)"checkbox.suggest.replacement.even.if.lambda.may.have.side.effects", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            Java8MapApiInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.ADVANCED_COLLECTIONS_API);
        if (set == null) {
            Java8MapApiInspection.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            Java8MapApiInspection.$$$reportNull$$$0(2);
        }
        return new JavaElementVisitor(){

            public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
                Java8MigrationUtils.MapCheckCondition condition;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((condition = Java8MigrationUtils.MapCheckCondition.fromConditional((PsiElement)expression, (boolean)Java8MapApiInspection.this.myTreatGetNullAsContainsKey)) == null || condition.hasVariable()) {
                    return;
                }
                PsiExpression existsBranch = (PsiExpression)condition.getExistsBranch((PsiElement)expression.getThenExpression(), (PsiElement)expression.getElseExpression());
                PsiExpression noneBranch = (PsiExpression)condition.getNoneBranch((PsiElement)expression.getThenExpression(), (PsiElement)expression.getElseExpression());
                this.processGetPut(condition, (PsiElement)existsBranch, (PsiElement)existsBranch, (PsiElement)noneBranch);
            }

            public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
                PsiExpressionStatement statement;
                PsiElement psiElement;
                PsiMethodCallExpression getCall;
                if (variable == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((getCall = Java8MigrationUtils.extractMapMethodCall((PsiExpression)variable.getInitializer(), (String)"get")) == null) {
                    return;
                }
                List references = VariableAccessUtils.getVariableReferences((PsiVariable)variable);
                if (references.isEmpty()) {
                    return;
                }
                PsiMethodCallExpression commonPutCall = 1.findPutMethodParent(((PsiReferenceExpression)references.getFirst()).getElement());
                if (commonPutCall == null || !1.isCommonPutCallForAllReferences(references, commonPutCall)) {
                    return;
                }
                PsiExpression getCallQualifierExpression = getCall.getMethodExpression().getQualifierExpression();
                PsiExpression putCallQualifierExpression = commonPutCall.getMethodExpression().getQualifierExpression();
                if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(getCallQualifierExpression, putCallQualifierExpression)) {
                    return;
                }
                PsiStatement variableDeclarationStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiDeclarationStatement.class);
                PsiElement nextSibling = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)variableDeclarationStatement);
                if (!(nextSibling instanceof PsiStatement) || !((psiElement = commonPutCall.getParent()) instanceof PsiExpressionStatement) || nextSibling != (statement = (PsiExpressionStatement)psiElement)) {
                    return;
                }
                PsiExpression[] getArgs = getCall.getArgumentList().getExpressions();
                PsiExpression[] putArgs = commonPutCall.getArgumentList().getExpressions();
                if (getArgs.length != 1 || putArgs.length != 2 || !EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(getArgs[0], putArgs[0])) {
                    return;
                }
                PsiExpression value = putArgs[1];
                if (LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)value)) {
                    GetPutToComputeFix fix = new GetPutToComputeFix(variable);
                    holder.registerProblem((PsiElement)commonPutCall, QuickFixBundle.message((String)"java.8.map.api.inspection.description", (Object[])new Object[]{"compute"}), new LocalQuickFix[]{fix});
                }
            }

            public void visitIfStatement(@NotNull PsiIfStatement statement) {
                Java8MigrationUtils.MapCheckCondition condition;
                if (statement == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((condition = Java8MigrationUtils.MapCheckCondition.fromConditional((PsiElement)statement, (boolean)Java8MapApiInspection.this.myTreatGetNullAsContainsKey)) == null) {
                    return;
                }
                PsiStatement thenBranch = statement.getThenBranch();
                PsiStatement elseBranch = statement.getElseBranch();
                PsiStatement existsBranch = ControlFlowUtils.stripBraces((PsiStatement)((PsiStatement)condition.getExistsBranch((PsiElement)thenBranch, (PsiElement)elseBranch)));
                PsiStatement noneBranch = ControlFlowUtils.stripBraces((PsiStatement)((PsiStatement)condition.getNoneBranch((PsiElement)thenBranch, (PsiElement)elseBranch)));
                if (existsBranch == null) {
                    this.processSingleBranch(condition, noneBranch);
                } else {
                    if (Java8MapApiInspection.this.mySuggestMapMerge && condition.isGetNull()) {
                        this.processMerge(condition, existsBranch, noneBranch);
                    }
                    if (condition.hasVariable()) {
                        return;
                    }
                    EquivalenceChecker.Match match = EquivalenceChecker.getCanonicalPsiEquivalence().statementsMatch(noneBranch, existsBranch);
                    this.processGetPut(condition, (PsiElement)existsBranch, match.getRightDiff(), match.getLeftDiff());
                }
            }

            public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (!Java8MapApiInspection.this.mySuggestMapReplaceAll) {
                    return;
                }
                Java8MigrationUtils.MapLoopCondition condition = Java8MigrationUtils.MapLoopCondition.create((PsiForeachStatement)statement);
                if (condition == null) {
                    return;
                }
                PsiMethodCallExpression putCall = condition.extractPut(statement);
                if (putCall == null) {
                    return;
                }
                PsiExpression[] args = putCall.getArgumentList().getExpressions();
                if (args.length != 2) {
                    return;
                }
                PsiExpression key = args[0];
                if (!condition.isKeyAccess(key)) {
                    return;
                }
                PsiExpression value = args[1];
                if (condition.isEntrySet() && 1.isUsedAsReference((PsiElement)value, condition)) {
                    return;
                }
                if (1.hasMapUsages(condition, value)) {
                    return;
                }
                if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)value, variable -> condition.getMap().equals(variable))) {
                    return;
                }
                ReplaceWithSingleMapOperation fix = ReplaceWithSingleMapOperation.create("replaceAll", putCall, value);
                holder.registerProblem(statement.getFirstChild(), QuickFixBundle.message((String)"java.8.map.api.inspection.description", (Object[])new Object[]{fix.myMethodName}), new LocalQuickFix[]{fix});
            }

            private static PsiMethodCallExpression findPutMethodParent(PsiElement element) {
                while (element != null && !(element instanceof PsiMethod)) {
                    PsiExpression expression;
                    PsiMethodCallExpression putCall;
                    if (element instanceof PsiExpression && (putCall = Java8MigrationUtils.extractMapMethodCall((PsiExpression)(expression = (PsiExpression)element), (String)"put")) != null) {
                        return putCall;
                    }
                    element = element.getParent();
                }
                return null;
            }

            private static boolean isCommonPutCallForAllReferences(List<PsiReferenceExpression> references, PsiMethodCallExpression commonPutCall) {
                for (PsiReferenceExpression reference : references) {
                    if (1.findPutMethodParent((PsiElement)reference) == commonPutCall) continue;
                    return false;
                }
                return true;
            }

            private static boolean hasMapUsages(@NotNull Java8MigrationUtils.MapLoopCondition condition, @Nullable PsiExpression value) {
                if (condition == null) {
                    1.$$$reportNull$$$0(4);
                }
                return !VariableAccessUtils.getVariableReferences((PsiVariable)condition.getMap(), (PsiElement)value).stream().map(ExpressionUtils::getCallForQualifier).allMatch(call -> call != null && condition.isValueAccess((PsiExpression)call));
            }

            private static boolean isUsedAsReference(@NotNull PsiElement value, @NotNull Java8MigrationUtils.MapLoopCondition condition) {
                if (value == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (condition == null) {
                    1.$$$reportNull$$$0(6);
                }
                return !VariableAccessUtils.getVariableReferences((PsiVariable)condition.getIterParam(), (PsiElement)value).stream().map(ExpressionUtils::getCallForQualifier).allMatch((Predicate<PsiMethodCallExpression>)KEY_VALUE_GET_METHODS);
            }

            private void processMerge(Java8MigrationUtils.MapCheckCondition condition, PsiStatement existsBranch, PsiStatement noneBranch) {
                if (noneBranch instanceof PsiExpressionStatement && existsBranch instanceof PsiExpressionStatement) {
                    PsiElement[] mapRefs;
                    PsiExpression absentValue = Java8MigrationUtils.extractPutValue((Java8MigrationUtils.MapCheckCondition)condition, (PsiStatement)noneBranch);
                    if (absentValue == null) {
                        return;
                    }
                    PsiExpression presentValue = Java8MigrationUtils.extractPutValue((Java8MigrationUtils.MapCheckCondition)condition, (PsiStatement)existsBranch);
                    if (presentValue == null || !LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)presentValue)) {
                        return;
                    }
                    if (!PsiTreeUtil.processElements((PsiElement)absentValue, e -> !condition.isMap(e))) {
                        return;
                    }
                    boolean hasVariable = condition.hasVariable();
                    if (hasVariable) {
                        if (PsiTreeUtil.collectElements((PsiElement)presentValue, arg_0 -> ((Java8MigrationUtils.MapCheckCondition)condition).isValueReference(arg_0)).length == 0) {
                            return;
                        }
                    }
                    if (hasVariable ^ (mapRefs = PsiTreeUtil.collectElements((PsiElement)presentValue, arg_0 -> ((Java8MigrationUtils.MapCheckCondition)condition).isMap(arg_0))).length == 0) {
                        return;
                    }
                    for (PsiElement mapRef : mapRefs) {
                        PsiReferenceExpression ref;
                        PsiElement psiElement = mapRef.getParent();
                        if (psiElement instanceof PsiReferenceExpression && condition.extractGetCall((ref = (PsiReferenceExpression)psiElement).getParent()) != null) continue;
                        return;
                    }
                    if (PsiTreeUtil.collectElements((PsiElement)presentValue, e -> PsiEquivalenceUtil.areElementsEquivalent((PsiElement)e, (PsiElement)absentValue)).length == 0) {
                        return;
                    }
                    if (NullabilityUtil.getExpressionNullability((PsiExpression)absentValue) == Nullability.NULLABLE || NullabilityUtil.getExpressionNullability((PsiExpression)presentValue) == Nullability.NULLABLE) {
                        return;
                    }
                    boolean informationLevel = !Java8MapApiInspection.this.mySideEffects && SideEffectChecker.mayHaveSideEffects((PsiElement)presentValue, ex -> condition.extractGetCall(ex) != null);
                    Java8MapApiInspection.register(condition, holder, informationLevel, new ReplaceWithSingleMapOperation("merge", (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)absentValue, PsiMethodCallExpression.class), presentValue, (PsiElement)noneBranch));
                }
            }

            private void processGetPut(Java8MigrationUtils.MapCheckCondition condition, PsiElement result, PsiElement exists, PsiElement none) {
                PsiMethodCallExpression getCall = condition.extractGetCall(exists);
                if (getCall == null) {
                    return;
                }
                if (!(none instanceof PsiExpression)) {
                    return;
                }
                PsiExpression noneExpression = (PsiExpression)none;
                PsiMethodCallExpression putCall = Java8MigrationUtils.extractMapMethodCall((PsiExpression)noneExpression, (String)"put");
                if (Java8MapApiInspection.this.mySuggestMapPutIfAbsent && putCall != null && condition.isGetNull() && condition.isMap((PsiElement)putCall.getMethodExpression().getQualifierExpression())) {
                    PsiExpression[] putArgs = putCall.getArgumentList().getExpressions();
                    if (putArgs.length != 2 || !condition.isKey((PsiElement)putArgs[0]) || !ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)putArgs[1])) {
                        return;
                    }
                    Java8MapApiInspection.register(condition, holder, false, new ReplaceWithSingleMapOperation("putIfAbsent", getCall, putArgs[1], result));
                }
                if (Java8MapApiInspection.this.mySuggestMapGetOrDefault && condition.isContainsKey() && ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)noneExpression) && condition.isMapValueType(noneExpression.getType())) {
                    Java8MapApiInspection.register(condition, holder, false, new ReplaceWithSingleMapOperation("getOrDefault", getCall, noneExpression, result));
                }
            }

            private void processSingleBranch(Java8MigrationUtils.MapCheckCondition condition, PsiStatement noneBranch) {
                PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)noneBranch);
                if (assignment != null && Java8MapApiInspection.this.mySuggestMapGetOrDefault && condition.isContainsKey()) {
                    PsiExpression rValue = assignment.getRExpression();
                    if (ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)rValue) && condition.isValueReference((PsiElement)assignment.getLExpression()) && !condition.isValueReference((PsiElement)rValue) && condition.isMapValueType(rValue.getType())) {
                        Java8MapApiInspection.register(condition, holder, false, ReplaceWithSingleMapOperation.create("getOrDefault", condition.getCheckCall(), rValue));
                    }
                } else if (condition.isGetNull()) {
                    PsiExpression expression;
                    PsiExpression lambdaCandidate = Java8MigrationUtils.extractLambdaCandidate((Java8MigrationUtils.MapCheckCondition)condition, (PsiStatement)noneBranch);
                    if (lambdaCandidate != null && Java8MapApiInspection.this.mySuggestMapComputeIfAbsent) {
                        if (NullabilityUtil.getExpressionNullability((PsiExpression)lambdaCandidate) == Nullability.NULLABLE) {
                            return;
                        }
                        boolean informationLevel = !Java8MapApiInspection.this.mySideEffects && SideEffectChecker.mayHaveSideEffects((PsiExpression)lambdaCandidate);
                        Java8MapApiInspection.register(condition, holder, informationLevel, ReplaceWithSingleMapOperation.create("computeIfAbsent", condition.getCheckCall(), lambdaCandidate));
                    }
                    if (lambdaCandidate == null && (expression = Java8MigrationUtils.extractPutValue((Java8MigrationUtils.MapCheckCondition)condition, (PsiStatement)noneBranch)) != null) {
                        String replacement = null;
                        boolean informationLevel = false;
                        if (Java8MapApiInspection.this.mySuggestMapPutIfAbsent && ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)expression) && !condition.isValueReference((PsiElement)expression)) {
                            replacement = "putIfAbsent";
                        } else if (Java8MapApiInspection.this.mySuggestMapComputeIfAbsent && !condition.hasVariable()) {
                            informationLevel = !Java8MapApiInspection.this.mySideEffects && SideEffectChecker.mayHaveSideEffects((PsiExpression)expression);
                            replacement = "computeIfAbsent";
                        }
                        if (replacement != null) {
                            if (condition.hasVariable()) {
                                Java8MapApiInspection.register(condition, holder, informationLevel, ReplaceWithSingleMapOperation.create(replacement, condition.getCheckCall(), expression));
                            } else {
                                PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethodCallExpression.class);
                                LOG.assertTrue(call != null);
                                Java8MapApiInspection.register(condition, holder, informationLevel, new ReplaceWithSingleMapOperation(replacement, call, expression, (PsiElement)noneBranch));
                            }
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "variable";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 4: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "condition";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/java18api/Java8MapApiInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitConditionalExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLocalVariable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitIfStatement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitForeachStatement";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "hasMapUsages";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isUsedAsReference";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public static String getNameCandidate(String name) {
        if ((name = name.replaceFirst("^[_\\d]+", "")).isEmpty()) {
            return "k";
        }
        String nameCandidate = name.substring(0, 1);
        for (int pos = name.length() - 1; pos > 0; --pos) {
            if (!Character.isUpperCase(name.charAt(pos))) continue;
            if (pos == name.length() - 1) break;
            nameCandidate = name.substring(pos, pos + 1);
            break;
        }
        String string = StringUtil.toLowerCase((String)nameCandidate);
        if (string == null) {
            Java8MapApiInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static void register(Java8MigrationUtils.MapCheckCondition condition, ProblemsHolder holder, boolean informationLevel, ReplaceWithSingleMapOperation fix) {
        if (informationLevel && !holder.isOnTheFly()) {
            return;
        }
        holder.registerProblem((PsiElement)condition.getFullCondition(), QuickFixBundle.message((String)"java.8.map.api.inspection.description", (Object[])new Object[]{fix.myMethodName}), informationLevel ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/java18api/Java8MapApiInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/java18api/Java8MapApiInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameCandidate";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private static class ReplaceWithSingleMapOperation
    extends PsiUpdateModCommandQuickFix {
        private final String myMethodName;
        private final SmartPsiElementPointer<PsiMethodCallExpression> myCallPointer;
        private final SmartPsiElementPointer<PsiExpression> myValuePointer;
        private final SmartPsiElementPointer<PsiElement> myResultPointer;

        ReplaceWithSingleMapOperation(String methodName, PsiMethodCallExpression call, PsiExpression value, PsiElement result) {
            this.myMethodName = methodName;
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)value.getProject());
            this.myCallPointer = manager.createSmartPsiElementPointer((PsiElement)call);
            this.myValuePointer = manager.createSmartPsiElementPointer((PsiElement)value);
            this.myResultPointer = manager.createSmartPsiElementPointer(result);
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiVariable variable;
            Java8MigrationUtils.MapCheckCondition checkCondition;
            PsiExpression replacement;
            Java8MigrationUtils.MapCheckCondition condition;
            PsiElement outerElement;
            if (project == null) {
                ReplaceWithSingleMapOperation.$$$reportNull$$$0(0);
            }
            if (element == null) {
                ReplaceWithSingleMapOperation.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                ReplaceWithSingleMapOperation.$$$reportNull$$$0(2);
            }
            if ((outerElement = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiIfStatement.class, PsiConditionalExpression.class, PsiForeachStatement.class})) == null) {
                return;
            }
            if (outerElement instanceof PsiForeachStatement) {
                PsiForeachStatement foreach = (PsiForeachStatement)outerElement;
                v0 = Java8MigrationUtils.MapLoopCondition.create((PsiForeachStatement)foreach);
            } else {
                v0 = condition = Java8MigrationUtils.MapCheckCondition.fromConditional((PsiElement)outerElement, (boolean)true);
            }
            if (condition == null) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)updater.getWritable((PsiElement)((PsiMethodCallExpression)this.myCallPointer.getElement()));
            if (call == null) {
                return;
            }
            PsiExpressionList argsList = call.getArgumentList();
            PsiExpression[] args = argsList.getExpressions();
            if (args.length == 0) {
                return;
            }
            if ((this.myMethodName.equals("merge") || this.myMethodName.equals("replaceAll")) && args.length != 2) {
                return;
            }
            PsiExpression value = (PsiExpression)updater.getWritable((PsiElement)((PsiExpression)this.myValuePointer.getElement()));
            if (value == null) {
                return;
            }
            PsiElement result = updater.getWritable(this.myResultPointer.getElement());
            if (result == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            CommentTracker ct = new CommentTracker();
            ExpressionUtils.bindCallTo((PsiMethodCallExpression)call, (String)this.myMethodName);
            switch (this.myMethodName) {
                case "computeIfAbsent": {
                    Object method;
                    PsiReferenceExpression expression;
                    PsiExpression key = args[0];
                    List<Object> refs = Collections.emptyList();
                    String nameCandidate = "k";
                    if (key instanceof PsiReferenceExpression && (expression = (PsiReferenceExpression)key).getQualifier() == null && (method = call.resolveMethod()) != null) {
                        PsiType argType = method.getParameterList().getParameters()[0].getType();
                        PsiType mapKeyType = call.resolveMethodGenerics().getSubstitutor().substitute(argType);
                        PsiType keyType = key.getType();
                        if (mapKeyType != null && keyType != null && keyType.isAssignableFrom(mapKeyType)) {
                            PsiElement target = expression.resolve();
                            List<Object> list = refs = target == null ? Collections.emptyList() : ((StreamEx)StreamEx.of((Collection)PsiTreeUtil.collectElementsOfType((PsiElement)value, (Class[])new Class[]{PsiReferenceExpression.class})).filter(ref -> ref.getQualifierExpression() == null && ref.isReferenceTo(target))).toList();
                            if (!refs.isEmpty()) {
                                nameCandidate = Java8MapApiInspection.getNameCandidate(expression.getReferenceName());
                            }
                        }
                    }
                    String varName = JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName(nameCandidate, (PsiElement)value, true);
                    for (PsiReferenceExpression ref2 : refs) {
                        ExpressionUtils.bindReferenceTo((PsiReferenceExpression)ref2, (String)varName);
                    }
                    replacement = factory.createExpressionFromText(varName + " -> " + ct.text((PsiElement)value), (PsiElement)value);
                    break;
                }
                case "merge": {
                    if (!(condition instanceof Java8MigrationUtils.MapCheckCondition)) {
                        return;
                    }
                    checkCondition = condition;
                    PsiExpression absentValue = args[1];
                    String aVar = JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName("a", (PsiElement)value, true);
                    String bVar = JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName("b", (PsiElement)value, true);
                    for (PsiElement e2 : PsiTreeUtil.collectElements((PsiElement)value, e -> PsiEquivalenceUtil.areElementsEquivalent((PsiElement)e, (PsiElement)absentValue))) {
                        ct.replace(e2, (PsiElement)factory.createIdentifier(bVar));
                    }
                    PsiElementFilter filter = e -> checkCondition.extractGetCall(e) != null || checkCondition.isValueReference(e);
                    for (PsiElement e3 : PsiTreeUtil.collectElements((PsiElement)value, (PsiElementFilter)filter)) {
                        ct.replace(e3, (PsiElement)factory.createIdentifier(aVar));
                    }
                    replacement = factory.createExpressionFromText("(" + aVar + "," + bVar + ") -> " + ct.text((PsiElement)value), (PsiElement)value);
                    break;
                }
                case "replaceAll": {
                    if (!(condition instanceof Java8MigrationUtils.MapLoopCondition)) {
                        return;
                    }
                    Java8MigrationUtils.MapLoopCondition loopCondition = (Java8MigrationUtils.MapLoopCondition)condition;
                    String kVar = ReplaceWithSingleMapOperation.suggestKeyName(loopCondition, (PsiElement)value);
                    String vVar = new VariableNameGenerator((PsiElement)value, VariableKind.PARAMETER).byName(new String[]{"v", "value"}).generate(true);
                    replacement = ReplaceWithSingleMapOperation.createLambdaForLoopReplacement(factory, kVar, vVar, loopCondition, value, ct);
                    ct.delete((PsiElement[])args);
                    break;
                }
                default: {
                    replacement = (PsiExpression)ct.markUnchanged((PsiElement)value);
                }
            }
            PsiElement newArg = args.length == 2 && !this.myMethodName.equals("merge") && !this.myMethodName.equals("replaceAll") ? ct.replace((PsiElement)args[1], (PsiElement)replacement) : argsList.add((PsiElement)replacement);
            if (newArg instanceof PsiLambdaExpression) {
                PsiLambdaExpression lambda = (PsiLambdaExpression)newArg;
                LambdaCanBeMethodReferenceInspection.replaceLambdaWithMethodReference((PsiLambdaExpression)lambda);
            }
            if (PsiTreeUtil.isAncestor((PsiElement)outerElement, (PsiElement)result, (boolean)true)) {
                result = ct.replaceAndRestoreComments(outerElement, result);
            } else {
                ct.deleteAndRestoreComments(outerElement);
            }
            if (condition instanceof Java8MigrationUtils.MapCheckCondition) {
                checkCondition = condition;
                v2 = checkCondition.extractDeclaration();
            } else {
                v2 = variable = null;
            }
            if (variable != null && !PsiTreeUtil.isAncestor((PsiElement)result, (PsiElement)variable, (boolean)true) && ReferencesSearch.search((PsiElement)variable).findFirst() == null) {
                new CommentTracker().deleteAndRestoreComments((PsiElement)variable);
            }
            CodeStyleManager.getInstance((Project)project).reformat(result);
        }

        @NotNull
        private static String suggestKeyName(@NotNull Java8MigrationUtils.MapLoopCondition loopCondition, @NotNull PsiElement value) {
            if (loopCondition == null) {
                ReplaceWithSingleMapOperation.$$$reportNull$$$0(3);
            }
            if (value == null) {
                ReplaceWithSingleMapOperation.$$$reportNull$$$0(4);
            }
            VariableNameGenerator generator = new VariableNameGenerator(value, VariableKind.PARAMETER);
            if (!loopCondition.isEntrySet()) {
                String nameCandidate;
                String origName = loopCondition.getIterParam().getName();
                if (origName.equals(nameCandidate = Java8MapApiInspection.getNameCandidate(origName))) {
                    String string = nameCandidate;
                    if (string == null) {
                        ReplaceWithSingleMapOperation.$$$reportNull$$$0(5);
                    }
                    return string;
                }
                generator.byName(new String[]{nameCandidate});
            }
            String string = generator.byName(new String[]{"k", "key"}).generate(true);
            if (string == null) {
                ReplaceWithSingleMapOperation.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        private static PsiExpression createLambdaForLoopReplacement(@NotNull PsiElementFactory factory, @NotNull String kVar, @NotNull String vVar, @NotNull Java8MigrationUtils.MapLoopCondition loopCondition, @NotNull PsiExpression value, @NotNull CommentTracker tracker) {
            if (factory == null) {
                ReplaceWithSingleMapOperation.$$$reportNull$$$0(7);
            }
            if (kVar == null) {
                ReplaceWithSingleMapOperation.$$$reportNull$$$0(8);
            }
            if (vVar == null) {
                ReplaceWithSingleMapOperation.$$$reportNull$$$0(9);
            }
            if (loopCondition == null) {
                ReplaceWithSingleMapOperation.$$$reportNull$$$0(10);
            }
            if (value == null) {
                ReplaceWithSingleMapOperation.$$$reportNull$$$0(11);
            }
            if (tracker == null) {
                ReplaceWithSingleMapOperation.$$$reportNull$$$0(12);
            }
            if (value instanceof PsiMethodCallExpression) {
                if (loopCondition.isKeyAccess(value)) {
                    PsiExpression psiExpression = factory.createExpressionFromText("(" + kVar + "," + vVar + ") ->" + kVar, (PsiElement)value);
                    if (psiExpression == null) {
                        ReplaceWithSingleMapOperation.$$$reportNull$$$0(13);
                    }
                    return psiExpression;
                }
                if (loopCondition.isValueAccess(value)) {
                    PsiExpression psiExpression = factory.createExpressionFromText("(" + kVar + "," + vVar + ") ->" + vVar, (PsiElement)value);
                    if (psiExpression == null) {
                        ReplaceWithSingleMapOperation.$$$reportNull$$$0(14);
                    }
                    return psiExpression;
                }
            }
            if (!loopCondition.isEntrySet()) {
                PsiParameter param = loopCondition.getIterParam();
                VariableAccessUtils.getVariableReferences((PsiVariable)param, (PsiElement)value).forEach(ref -> ExpressionUtils.bindReferenceTo((PsiReferenceExpression)ref, (String)kVar));
            }
            Collection calls = PsiTreeUtil.collectElementsOfType((PsiElement)value, (Class[])new Class[]{PsiMethodCallExpression.class});
            for (PsiMethodCallExpression call : calls) {
                if (loopCondition.isKeyAccess((PsiExpression)call)) {
                    tracker.replace((PsiElement)call, kVar);
                    continue;
                }
                if (!loopCondition.isValueAccess((PsiExpression)call)) continue;
                tracker.replace((PsiElement)call, vVar);
            }
            PsiExpression psiExpression = factory.createExpressionFromText("(" + kVar + "," + vVar + ") ->" + tracker.text((PsiElement)value), (PsiElement)value);
            if (psiExpression == null) {
                ReplaceWithSingleMapOperation.$$$reportNull$$$0(15);
            }
            return psiExpression;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = QuickFixBundle.message((String)"java.8.map.api.inspection.fix.text", (Object[])new Object[]{this.myMethodName});
            if (string == null) {
                ReplaceWithSingleMapOperation.$$$reportNull$$$0(16);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message((String)"java.8.map.api.inspection.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithSingleMapOperation.$$$reportNull$$$0(17);
            }
            return string;
        }

        @NotNull
        static ReplaceWithSingleMapOperation create(String methodName, PsiMethodCallExpression call, PsiExpression value) {
            PsiStatement result = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)call, PsiStatement.class);
            LOG.assertTrue(result != null);
            return new ReplaceWithSingleMapOperation(methodName, call, value, (PsiElement)result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 13, 14, 15, 16, 17 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loopCondition";
                    break;
                }
                case 4: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 5: 
                case 6: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/java18api/Java8MapApiInspection$ReplaceWithSingleMapOperation";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kVar";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vVar";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tracker";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/java18api/Java8MapApiInspection$ReplaceWithSingleMapOperation";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "suggestKeyName";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLambdaForLoopReplacement";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "suggestKeyName";
                    break;
                }
                case 5: 
                case 6: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "createLambdaForLoopReplacement";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 13, 14, 15, 16, 17 -> new IllegalStateException(string);
            };
        }
    }

    private static class GetPutToComputeFix
    extends PsiUpdateModCommandQuickFix {
        private final SmartPsiElementPointer<PsiLocalVariable> variablePointer;

        private GetPutToComputeFix(PsiLocalVariable variable) {
            this.variablePointer = SmartPointerManager.createPointer((PsiElement)variable);
        }

        @NotNull
        public String getName() {
            String string = QuickFixBundle.message((String)"java.8.map.api.inspection.fix.text", (Object[])new Object[]{"compute"});
            if (string == null) {
                GetPutToComputeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message((String)"java.8.map.api.inspection.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                GetPutToComputeFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiLocalVariable variable;
            if (project == null) {
                GetPutToComputeFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                GetPutToComputeFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                GetPutToComputeFix.$$$reportNull$$$0(4);
            }
            if ((variable = (PsiLocalVariable)updater.getWritable((PsiElement)((PsiLocalVariable)this.variablePointer.getElement()))) == null) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)element;
            ExpressionUtils.bindCallTo((PsiMethodCallExpression)call, (String)"compute");
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length != 2) {
                return;
            }
            PsiExpression exp = args[1];
            String keyName = new VariableNameGenerator((PsiElement)call, VariableKind.PARAMETER).byName(new String[]{"k", "key"}).generate(true);
            CommentTracker commentTracker = new CommentTracker();
            String lambdaExpressionText = "(" + keyName + ", " + variable.getName() + ") -> " + commentTracker.text((PsiElement)exp);
            commentTracker.delete((PsiElement)variable);
            commentTracker.replaceExpressionAndRestoreComments(exp, lambdaExpressionText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/java18api/Java8MapApiInspection$GetPutToComputeFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/java18api/Java8MapApiInspection$GetPutToComputeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

