/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19api;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInspection.java19api.ModuleInfo;
import com.intellij.codeInspection.java19api.ModuleNode;
import com.intellij.codeInspection.java19api.ModuleVisitor;
import com.intellij.codeInspection.java19api.ProgressTracker;
import com.intellij.codeInspection.java19api.UniqueModuleNames;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.java.analysis.bytecode.ClassFileAnalyzer;
import com.intellij.java.analysis.bytecode.JvmBytecodeAnalysis;
import com.intellij.java.analysis.bytecode.JvmBytecodeDeclarationProcessor;
import com.intellij.java.analysis.bytecode.JvmBytecodeReferenceProcessor;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DescriptorsGenerator {
    private final Logger myLogger;
    private static final String NONE_DECLARED_PACKAGES = "<none>";
    private final Project myProject;
    private final UniqueModuleNames myUniqueModuleNames;
    private final ProgressTracker myProgressTracker;

    DescriptorsGenerator(@NotNull Project project, @NotNull UniqueModuleNames uniqueModuleNames, @NotNull Logger logger) {
        if (project == null) {
            DescriptorsGenerator.$$$reportNull$$$0(0);
        }
        if (uniqueModuleNames == null) {
            DescriptorsGenerator.$$$reportNull$$$0(1);
        }
        if (logger == null) {
            DescriptorsGenerator.$$$reportNull$$$0(2);
        }
        this.myProgressTracker = new ProgressTracker(0.5, 0.3, 0.2);
        this.myProject = project;
        this.myUniqueModuleNames = uniqueModuleNames;
        this.myLogger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generate(@NotNull List<ModuleFiles> moduleFiles, @NotNull ProgressIndicator indicator) {
        List<ModuleInfo> modulesInfos;
        if (moduleFiles == null) {
            DescriptorsGenerator.$$$reportNull$$$0(3);
        }
        if (indicator == null) {
            DescriptorsGenerator.$$$reportNull$$$0(4);
        }
        this.myProgressTracker.init(indicator);
        try {
            this.myProgressTracker.startPhase(JavaRefactoringBundle.message((String)"generate.module.descriptors.collecting.message", (Object[])new Object[0]), moduleFiles.stream().mapToInt(m -> m.files().size()).sum());
            Map<String, Set<ModuleNode>> packagesDeclaredInModules = this.collectDependencies(moduleFiles);
            this.myProgressTracker.nextPhase();
            int modulesCount = packagesDeclaredInModules.values().stream().mapToInt(Set::size).sum();
            this.myProgressTracker.startPhase(JavaRefactoringBundle.message((String)"generate.module.descriptors.analysing.message", (Object[])new Object[0]), modulesCount);
            Set<ModuleNode> modules = this.prepareModulesWithDependencies(packagesDeclaredInModules);
            this.myProgressTracker.nextPhase();
            this.myProgressTracker.startPhase(JavaRefactoringBundle.message((String)"generate.module.descriptors.preparing.message", (Object[])new Object[0]), modulesCount);
            modulesInfos = this.prepareModuleInfos(modules);
            this.myProgressTracker.nextPhase();
        }
        finally {
            this.myProgressTracker.dispose();
        }
        this.createFilesLater(modulesInfos);
    }

    private void createFilesLater(@NotNull List<ModuleInfo> moduleInfos) {
        if (moduleInfos == null) {
            DescriptorsGenerator.$$$reportNull$$$0(5);
        }
        Runnable createFiles = () -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManagerEx.getApplicationEx().runWriteActionWithCancellableProgressInDispatchThread(DescriptorsGenerator.getCommandTitle(), this.myProject, null, indicator -> this.createFiles(this.myProject, moduleInfos, (ProgressIndicator)indicator)), DescriptorsGenerator.getCommandTitle(), null);
        };
        if (CoreProgressManager.shouldKeepTasksAsynchronous()) {
            ApplicationManager.getApplication().invokeLater(createFiles);
        } else {
            ApplicationManager.getApplication().invokeAndWait(createFiles);
        }
    }

    @NotNull
    private Map<String, Set<ModuleNode>> collectDependencies(@NotNull List<ModuleFiles> modulesFiles) {
        if (modulesFiles == null) {
            DescriptorsGenerator.$$$reportNull$$$0(6);
        }
        PackageNamesCache packageNamesCache = new PackageNamesCache(this.myProject);
        HashMap<String, Set<ModuleNode>> packagesDeclaredInModules = new HashMap<String, Set<ModuleNode>>();
        for (ModuleFiles moduleFiles : modulesFiles) {
            ModuleVisitor visitor = new ModuleVisitor(packageNamesCache::getPackageName);
            ClassFileAnalyzer analyzer = JvmBytecodeAnalysis.getInstance().createDeclarationAndReferencesAnalyzer((JvmBytecodeDeclarationProcessor)visitor, (JvmBytecodeReferenceProcessor)visitor);
            if (moduleFiles.files().isEmpty()) {
                this.myLogger.info("Output directory for module " + moduleFiles.module().getName() + " doesn't contain .class files");
                continue;
            }
            for (Path file : moduleFiles.files) {
                try {
                    analyzer.processFile(file);
                }
                catch (IOException e) {
                    this.myLogger.error("Failed to process " + String.valueOf(file), (Throwable)e);
                }
                this.myProgressTracker.increment();
            }
            Set<String> declaredPackages = visitor.getDeclaredPackages();
            Set<String> requiredPackages = visitor.getRequiredPackages();
            ModuleNode moduleNode = new ModuleNode(moduleFiles.module(), declaredPackages, requiredPackages, this.myUniqueModuleNames);
            for (String declaredPackage : declaredPackages) {
                packagesDeclaredInModules.computeIfAbsent(declaredPackage, key -> new HashSet()).add(moduleNode);
            }
            if (!declaredPackages.isEmpty()) continue;
            packagesDeclaredInModules.computeIfAbsent(NONE_DECLARED_PACKAGES, key -> new HashSet()).add(moduleNode);
        }
        HashMap<String, Set<ModuleNode>> hashMap = packagesDeclaredInModules;
        if (hashMap == null) {
            DescriptorsGenerator.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    @NotNull
    private Set<ModuleNode> prepareModulesWithDependencies(@NotNull Map<String, Set<ModuleNode>> packagesDeclaredInModules) {
        if (packagesDeclaredInModules == null) {
            DescriptorsGenerator.$$$reportNull$$$0(8);
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myProject);
        Set<ModuleNode> modules = packagesDeclaredInModules.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        HashMap<PsiJavaModule, ModuleNode> nodeByDescriptor = new HashMap<PsiJavaModule, ModuleNode>();
        HashMap<Module, ModuleNode> nodeByModule = new HashMap<Module, ModuleNode>();
        HashMap<Library, ModuleNode> nodeByLibrary = new HashMap<Library, ModuleNode>();
        for (ModuleNode module : modules) {
            if (module.getModule() == null) continue;
            nodeByModule.put(module.getModule(), module);
        }
        for (ModuleNode module : modules) {
            if (module.getDescriptor() != null) {
                nodeByDescriptor.put(module.getDescriptor(), module);
            }
            if (module.getModule() != null) {
                OrderEntry[] entries;
                for (OrderEntry entry : entries = ModuleRootManager.getInstance((Module)module.getModule()).getOrderEntries()) {
                    ModuleNode cachedNode;
                    Library library;
                    LibraryOrderEntry libraryOrderEntry;
                    ModuleOrderEntry moduleOrderEntry;
                    if (!(entry instanceof ExportableOrderEntry)) continue;
                    if (entry instanceof ModuleOrderEntry && (moduleOrderEntry = (ModuleOrderEntry)entry).getModule() != null) {
                        if (moduleOrderEntry.isExported()) {
                            ModuleNode node = (ModuleNode)nodeByModule.get(moduleOrderEntry.getModule());
                            if (node == null) continue;
                            module.getDependencies().compute(node, (key, old) -> DescriptorsGenerator.merge(old, Set.of(ModuleNode.DependencyType.TRANSITIVE), () -> EnumSet.noneOf(ModuleNode.DependencyType.class)));
                            continue;
                        }
                        for (String aPackage : module.getRequiredPackages()) {
                            Set nodes = packagesDeclaredInModules.getOrDefault(aPackage, Set.of());
                            for (PsiDirectory[] node : nodes) {
                                if (module.getDependencies().containsKey(node) || !moduleOrderEntry.getModule().equals((Object)node.getModule())) continue;
                                module.getDependencies().computeIfAbsent((ModuleNode)node, k -> Set.of());
                            }
                            PsiPackage psiPackage = (PsiPackage)ReadAction.compute(() -> psiFacade.findPackage(aPackage));
                            if (psiPackage == null) continue;
                            for (PsiDirectory directory : (PsiDirectory[])ReadAction.compute(() -> psiPackage.getDirectories())) {
                                ModuleNode node;
                                VirtualFile file = directory.getVirtualFile();
                                List indexedOrderEntries = (List)ReadAction.compute(() -> projectFileIndex.getOrderEntriesForFile(file));
                                if (!indexedOrderEntries.contains(moduleOrderEntry) || (node = (ModuleNode)nodeByModule.get(moduleOrderEntry.getModule())) == null) continue;
                                module.getDependencies().computeIfAbsent(node, k -> Set.of());
                            }
                        }
                        continue;
                    }
                    if (!(entry instanceof LibraryOrderEntry) || (libraryOrderEntry = (LibraryOrderEntry)entry).getLibrary() == null || (library = libraryOrderEntry.getLibrary()) == null || (cachedNode = nodeByLibrary.computeIfAbsent(library, lib -> DescriptorsGenerator.findLibraryNode(packagesDeclaredInModules, nodeByDescriptor, this.myProject, lib))) == null) continue;
                    nodeByLibrary.put(library, cachedNode);
                    if (libraryOrderEntry.isExported()) {
                        module.getDependencies().compute(cachedNode, (key, old) -> DescriptorsGenerator.merge(old, Set.of(ModuleNode.DependencyType.TRANSITIVE), () -> EnumSet.noneOf(ModuleNode.DependencyType.class)));
                        continue;
                    }
                    for (String aPackage : module.getRequiredPackages()) {
                        Set nodes = packagesDeclaredInModules.getOrDefault(aPackage, Set.of());
                        for (ModuleNode node : nodes) {
                            if (module.getDependencies().containsKey(node) || !cachedNode.equals(node)) continue;
                            module.getDependencies().computeIfAbsent(node, k -> Set.of());
                        }
                    }
                }
            }
            this.myProgressTracker.increment();
        }
        Set<ModuleNode> set = modules;
        if (set == null) {
            DescriptorsGenerator.$$$reportNull$$$0(9);
        }
        return set;
    }

    @Nullable
    private static ModuleNode findLibraryNode(@NotNull Map<String, Set<ModuleNode>> packagesDeclaredInModules, @NotNull Map<PsiJavaModule, ModuleNode> nodeByDescriptor, @NotNull Project project, @NotNull Library library) {
        PsiJavaModule descriptor;
        if (packagesDeclaredInModules == null) {
            DescriptorsGenerator.$$$reportNull$$$0(10);
        }
        if (nodeByDescriptor == null) {
            DescriptorsGenerator.$$$reportNull$$$0(11);
        }
        if (project == null) {
            DescriptorsGenerator.$$$reportNull$$$0(12);
        }
        if (library == null) {
            DescriptorsGenerator.$$$reportNull$$$0(13);
        }
        if ((descriptor = (PsiJavaModule)ReadAction.compute(() -> JavaModuleGraphUtil.findDescriptorByLibrary((Library)library, (Project)project))) == null) {
            return null;
        }
        ModuleNode node = nodeByDescriptor.computeIfAbsent(descriptor, d -> new ModuleNode((PsiJavaModule)d));
        for (PsiPackageAccessibilityStatement export : descriptor.getExports()) {
            String packageName = export.getPackageName();
            if (packageName == null) continue;
            packagesDeclaredInModules.computeIfAbsent(packageName, l -> new HashSet()).add(node);
        }
        return node;
    }

    @NotNull
    private List<ModuleInfo> prepareModuleInfos(@NotNull Set<ModuleNode> modules) {
        if (modules == null) {
            DescriptorsGenerator.$$$reportNull$$$0(14);
        }
        Set requiredPackages = modules.stream().map(ModuleNode::getRequiredPackages).flatMap(Collection::stream).collect(Collectors.toSet());
        ArrayList<ModuleInfo> moduleInfo = new ArrayList<ModuleInfo>();
        for (ModuleNode moduleNode : modules) {
            if (moduleNode.getDescriptor() != null) {
                this.myLogger.info("Module descriptor already exists in " + String.valueOf(moduleNode));
                continue;
            }
            for (String packageName : moduleNode.getDeclaredPackages()) {
                if (!requiredPackages.contains(packageName)) continue;
                moduleNode.addExport(packageName);
            }
            PsiDirectory rootDir = moduleNode.getRootDir();
            if (rootDir != null) {
                moduleInfo.add(new ModuleInfo(rootDir, moduleNode));
            } else {
                this.myLogger.info("Skipped module " + String.valueOf(moduleNode) + " because it doesn't have production source root");
            }
            this.myProgressTracker.increment();
        }
        ArrayList<ModuleInfo> arrayList = moduleInfo;
        if (arrayList == null) {
            DescriptorsGenerator.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private void createFiles(@NotNull Project project, @NotNull List<ModuleInfo> moduleInfos, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            DescriptorsGenerator.$$$reportNull$$$0(16);
        }
        if (moduleInfos == null) {
            DescriptorsGenerator.$$$reportNull$$$0(17);
        }
        if (indicator == null) {
            DescriptorsGenerator.$$$reportNull$$$0(18);
        }
        indicator.setIndeterminate(false);
        int count = 0;
        double total = moduleInfos.size();
        FileTemplate template = FileTemplateManager.getInstance((Project)project).getInternalTemplate("module-info");
        for (ModuleInfo moduleInfo : moduleInfos) {
            ProgressManager.getInstance().executeNonCancelableSection(() -> this.createFile(template, moduleInfo));
            indicator.setFraction((double)(++count) / total);
        }
    }

    private void createFile(@NotNull FileTemplate template, @NotNull ModuleInfo moduleInfo) {
        if (template == null) {
            DescriptorsGenerator.$$$reportNull$$$0(19);
        }
        if (moduleInfo == null) {
            DescriptorsGenerator.$$$reportNull$$$0(20);
        }
        if (moduleInfo.fileAlreadyExists()) {
            return;
        }
        Project project = moduleInfo.rootDir().getProject();
        Properties properties = FileTemplateManager.getInstance((Project)project).getDefaultProperties();
        FileTemplateUtil.fillDefaultProperties((Properties)properties, (PsiDirectory)moduleInfo.rootDir());
        properties.setProperty("NAME", "module-info");
        try {
            PsiJavaFile moduleInfoFile = (PsiJavaFile)FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)"module-info.java", (Properties)properties, (PsiDirectory)moduleInfo.rootDir());
            PsiJavaModule javaModule = moduleInfoFile.getModuleDeclaration();
            this.myLogger.assertTrue(javaModule != null, (Object)"module-info file should contain module declaration");
            CharSequence moduleText = moduleInfo.createModuleText();
            PsiJavaFile dummyFile = (PsiJavaFile)PsiFileFactory.getInstance((Project)project).createFileFromText("module-info.java", (Language)JavaLanguage.INSTANCE, moduleText);
            PsiJavaModule actualModule = dummyFile.getModuleDeclaration();
            this.myLogger.assertTrue(actualModule != null, (Object)"module declaration wasn't created");
            javaModule.replace((PsiElement)actualModule);
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)moduleInfoFile);
        }
        catch (Exception e) {
            this.myLogger.error("Failed to create module-info.java in " + moduleInfo.rootDir().getVirtualFile().getPath() + ": " + e.getMessage());
        }
    }

    @NlsContexts.Command
    private static String getCommandTitle() {
        return JavaRefactoringBundle.message((String)"generate.module.descriptors.command.title", (Object[])new Object[0]);
    }

    @Nullable
    private static <T> Set<T> merge(@Nullable Set<T> first, @Nullable Set<T> second, @NotNull Supplier<Set<T>> initializer) {
        if (initializer == null) {
            DescriptorsGenerator.$$$reportNull$$$0(21);
        }
        if (second == null || second.isEmpty()) {
            return first;
        }
        if (first == null || first.isEmpty()) {
            return second;
        }
        Set<T> result = initializer.get();
        result.addAll(first);
        result.addAll(second);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uniqueModuleNames";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFiles";
                break;
            }
            case 4: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleInfos";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesFiles";
                break;
            }
            case 7: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/java19api/DescriptorsGenerator";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagesDeclaredInModules";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeByDescriptor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleInfo";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/java19api/DescriptorsGenerator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDependencies";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareModulesWithDependencies";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareModuleInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFilesLater";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectDependencies";
                break;
            }
            case 7: 
            case 9: 
            case 15: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareModulesWithDependencies";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryNode";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "prepareModuleInfos";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createFiles";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9, 15 -> new IllegalStateException(string);
        };
    }

    private static class PackageNamesCache {
        private final Map<String, Boolean> myPackages;
        private final JavaPsiFacade myPsiFacade;

        PackageNamesCache(@NotNull Project project) {
            if (project == null) {
                PackageNamesCache.$$$reportNull$$$0(0);
            }
            this.myPackages = new HashMap<String, Boolean>();
            this.myPsiFacade = JavaPsiFacade.getInstance((Project)project);
        }

        @Nullable
        private String getPackageName(@NotNull String className) {
            int dotPos;
            if (className == null) {
                PackageNamesCache.$$$reportNull$$$0(1);
            }
            while ((dotPos = className.lastIndexOf(46)) > 0) {
                Boolean isPackage = this.myPackages.computeIfAbsent(className = className.substring(0, dotPos), packageName -> (Boolean)ReadAction.compute(() -> this.myPsiFacade.findPackage(packageName) != null));
                if (!isPackage.booleanValue()) continue;
                return className;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/java19api/DescriptorsGenerator$PackageNamesCache";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPackageName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    record ModuleFiles(@NotNull Module module, @NotNull List<Path> files) {
        @NotNull
        private final Module module;
        @NotNull
        private final List<Path> files;

        ModuleFiles(@NotNull Module module, @NotNull List<Path> files) {
            if (module == null) {
                ModuleFiles.$$$reportNull$$$0(0);
            }
            if (files == null) {
                ModuleFiles.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public Module module() {
            Module module = this.module;
            if (module == null) {
                ModuleFiles.$$$reportNull$$$0(2);
            }
            return module;
        }

        @NotNull
        public List<Path> files() {
            List<Path> list = this.files;
            if (list == null) {
                ModuleFiles.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/java19api/DescriptorsGenerator$ModuleFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/java19api/DescriptorsGenerator$ModuleFiles";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "module";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "files";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

