/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.codeInspection.SimplifyStreamApiCallChainsInspection;
import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.java.JavaBundle;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDeconstructionList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class MigrateToStreamFix
extends PsiUpdateModCommandQuickFix {
    private final BaseStreamApiMigration myMigration;

    protected MigrateToStreamFix(BaseStreamApiMigration migration) {
        this.myMigration = migration;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = JavaAnalysisBundle.message((String)"replace.with.stream.api.fix", (Object[])new Object[]{this.myMigration.getReplacement()});
        if (string == null) {
            MigrateToStreamFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaBundle.message((String)"quickfix.family.replace.with.stream.api.equivalent", (Object[])new Object[0]);
        if (string == null) {
            MigrateToStreamFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        PsiLoopStatement loopStatement;
        if (project == null) {
            MigrateToStreamFix.$$$reportNull$$$0(2);
        }
        if (element == null) {
            MigrateToStreamFix.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            MigrateToStreamFix.$$$reportNull$$$0(4);
        }
        if ((loopStatement = (PsiLoopStatement)ObjectUtils.tryCast((Object)element, PsiLoopStatement.class)) == null) {
            return;
        }
        StreamApiMigrationInspection.StreamSource source = StreamApiMigrationInspection.StreamSource.tryCreate(loopStatement);
        PsiStatement body = loopStatement.getBody();
        if (body == null || source == null) {
            return;
        }
        TerminalBlock tb = TerminalBlock.from(source, body);
        PsiElement result = this.myMigration.migrate(project, (PsiElement)body, tb);
        if (result == null) {
            return;
        }
        tb.operations().forEach(StreamApiMigrationInspection.Operation::cleanUp);
        MigrateToStreamFix.simplify(project, result);
    }

    static void simplify(@NotNull Project project, PsiElement result) {
        if (project == null) {
            MigrateToStreamFix.$$$reportNull$$$0(5);
        }
        if (result == null) {
            return;
        }
        LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences((PsiElement)result);
        RemoveRedundantTypeArgumentsUtil.removeRedundantTypeArguments((PsiElement)result);
        result = SimplifyStreamApiCallChainsInspection.simplifyStreamExpressions(result, true);
        MigrateToStreamFix.removeRedundantPatternVariables(result);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
    }

    private static void removeRedundantPatternVariables(PsiElement element) {
        for (PsiLambdaExpression lambda : PsiTreeUtil.collectElementsOfType((PsiElement)element, (Class[])new Class[]{PsiLambdaExpression.class})) {
            PsiElement body = lambda.getBody();
            if (!(body instanceof PsiExpression)) continue;
            PsiExpression expression = (PsiExpression)body;
            if (!PsiTypes.booleanType().equals((Object)expression.getType())) continue;
            List variables = JavaPsiPatternUtil.getExposedPatternVariablesIgnoreParent((PsiExpression)expression);
            for (PsiPatternVariable variable : variables) {
                PsiTypeTestPattern pattern;
                PsiPattern psiPattern = variable.getPattern();
                if (psiPattern instanceof PsiTypeTestPattern && (pattern = (PsiTypeTestPattern)psiPattern).getParent() instanceof PsiDeconstructionList || VariableAccessUtils.variableIsUsed((PsiVariable)variable, (PsiElement)expression)) continue;
                variable.delete();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/streamMigration/MigrateToStreamFix";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/streamMigration/MigrateToStreamFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "simplify";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

