/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.autolink;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.autolink.ExternalSystemProjectLinkListener;
import com.intellij.openapi.externalSystem.autolink.ExternalSystemUnlinkedProjectAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.open.GradleOpenProjectProvider;
import org.jetbrains.plugins.gradle.service.project.open.GradleProjectImportUtil;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\nH\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u001dJ\u001e\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u001dR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/gradle/autolink/GradleUnlinkedProjectAware;", "Lcom/intellij/openapi/externalSystem/autolink/ExternalSystemUnlinkedProjectAware;", "<init>", "()V", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "getSystemId", "()Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "buildFileExtensions", "", "", "()[Ljava/lang/String;", "isBuildFile", "", "project", "Lcom/intellij/openapi/project/Project;", "buildFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getLinkedProjectsPaths", "", "isLinkedProject", "externalProjectPath", "subscribe", "", "listener", "Lcom/intellij/openapi/externalSystem/autolink/ExternalSystemProjectLinkListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "linkAndLoadProjectAsync", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "unlinkProject", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleUnlinkedProjectAware.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleUnlinkedProjectAware.kt\norg/jetbrains/plugins/gradle/autolink/GradleUnlinkedProjectAware\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1642#2,10:53\n1915#2:63\n1916#2:65\n1652#2:66\n1#3:64\n*S KotlinDebug\n*F\n+ 1 GradleUnlinkedProjectAware.kt\norg/jetbrains/plugins/gradle/autolink/GradleUnlinkedProjectAware\n*L\n25#1:53,10\n25#1:63\n25#1:65\n25#1:66\n25#1:64\n*E\n"})
public final class GradleUnlinkedProjectAware
implements ExternalSystemUnlinkedProjectAware {
    @NotNull
    private final ProjectSystemId systemId;

    public GradleUnlinkedProjectAware() {
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"SYSTEM_ID");
        this.systemId = projectSystemId;
    }

    @NotNull
    public ProjectSystemId getSystemId() {
        return this.systemId;
    }

    @NotNull
    public String[] buildFileExtensions() {
        Intrinsics.checkNotNullExpressionValue((Object)GradleConstants.BUILD_FILE_EXTENSIONS, (String)"BUILD_FILE_EXTENSIONS");
        return GradleConstants.BUILD_FILE_EXTENSIONS;
    }

    public boolean isBuildFile(@NotNull Project project, @NotNull VirtualFile buildFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)buildFile, (String)"buildFile");
        return GradleConstants.KNOWN_GRADLE_FILES.contains(buildFile.getName());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<String> getLinkedProjectsPaths(@NotNull Project project) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Collection collection = GradleSettings.getInstance(project).getLinkedProjectsSettings();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getLinkedProjectsSettings(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            GradleProjectSettings it = (GradleProjectSettings)((Object)element$iv$iv);
            boolean bl2 = false;
            if (it.getExternalProjectPath() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public boolean isLinkedProject(@NotNull Project project, @NotNull String externalProjectPath2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        GradleSettings gradleSettings = GradleSettings.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"getInstance(...)");
        GradleSettings gradleSettings2 = gradleSettings;
        GradleProjectSettings projectSettings = (GradleProjectSettings)gradleSettings2.getLinkedProjectSettings(externalProjectPath2);
        return projectSettings != null;
    }

    public void subscribe(@NotNull Project project, @NotNull ExternalSystemProjectLinkListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        GradleSettings gradleSettings = GradleSettings.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"getInstance(...)");
        GradleSettings gradleSettings2 = gradleSettings;
        gradleSettings2.subscribe((ExternalSystemSettingsListener<GradleProjectSettings>)((ExternalSystemSettingsListener)new GradleSettingsListener(listener2){
            final /* synthetic */ ExternalSystemProjectLinkListener $listener;
            {
                this.$listener = $listener;
            }

            /*
             * WARNING - void declaration
             */
            public void onProjectsLinked(Collection<? extends GradleProjectSettings> settings) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter(settings, (String)"settings");
                Iterable iterable = settings;
                ExternalSystemProjectLinkListener externalSystemProjectLinkListener = this.$listener;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    GradleProjectSettings it = (GradleProjectSettings)((Object)element$iv);
                    boolean bl = false;
                    String string = it.getExternalProjectPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalProjectPath(...)");
                    externalSystemProjectLinkListener.onProjectLinked(string);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void onProjectsUnlinked(Set<String> linkedProjectPaths) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter(linkedProjectPaths, (String)"linkedProjectPaths");
                Iterable iterable = linkedProjectPaths;
                ExternalSystemProjectLinkListener externalSystemProjectLinkListener = this.$listener;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    externalSystemProjectLinkListener.onProjectUnlinked(it);
                }
            }
        }), parentDisposable);
    }

    @Nullable
    public Object linkAndLoadProjectAsync(@NotNull Project project, @NotNull String externalProjectPath2, @NotNull Continuation<? super Unit> $completion) {
        Object object = GradleProjectImportUtil.linkAndSyncGradleProject(project, externalProjectPath2, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object unlinkProject(@NotNull Project project, @NotNull String externalProjectPath2, @NotNull Continuation<? super Unit> $completion) {
        Object object = new GradleOpenProjectProvider().unlinkProject(project, externalProjectPath2, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }
}

