/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.jvmcompat;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.gradle.jvmcompat.GradleCompatibilityState;
import org.jetbrains.plugins.gradle.jvmcompat.GsonUtilKt;
import org.jetbrains.plugins.gradle.jvmcompat.IdeVersionedDataParser;
import org.jetbrains.plugins.gradle.jvmcompat.VersionMapping;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\bH\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/gradle/jvmcompat/GradleCompatibilityDataParser;", "Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataParser;", "Lorg/jetbrains/plugins/gradle/jvmcompat/GradleCompatibilityState;", "<init>", "()V", "parseVersions", "", "", "Lcom/google/gson/JsonArray;", "parseJson", "data", "Lcom/google/gson/JsonObject;", "intellij.gradle"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nGradleCompatibilityDataParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleCompatibilityDataParser.kt\norg/jetbrains/plugins/gradle/jvmcompat/GradleCompatibilityDataParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,32:1\n777#2:33\n873#2,2:34\n1586#2:36\n1661#2,3:37\n1642#2,10:40\n1915#2:50\n1916#2:52\n1652#2:53\n1#3:51\n*S KotlinDebug\n*F\n+ 1 GradleCompatibilityDataParser.kt\norg/jetbrains/plugins/gradle/jvmcompat/GradleCompatibilityDataParser\n*L\n11#1:33\n11#1:34,2\n11#1:36\n11#1:37,3\n22#1:40,10\n22#1:50\n22#1:52\n22#1:53\n22#1:51\n*E\n"})
public final class GradleCompatibilityDataParser
extends IdeVersionedDataParser<GradleCompatibilityState> {
    @NotNull
    public static final GradleCompatibilityDataParser INSTANCE = new GradleCompatibilityDataParser();

    private GradleCompatibilityDataParser() {
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> parseVersions(JsonArray $this$parseVersions) {
        void $this$mapTo$iv$iv;
        JsonElement it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = (Iterable)$this$parseVersions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (JsonElement)element$iv$iv;
            boolean bl = false;
            if (!it.isJsonPrimitive()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (JsonElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getAsString());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public GradleCompatibilityState parseJson(@NotNull JsonObject data) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        JsonElement jsonElement = data.get("supportedJavaVersions");
        if (jsonElement == null || (jsonElement = GsonUtilKt.getAsSafeJsonArray(jsonElement)) == null) {
            return null;
        }
        JsonElement supportedJavaVersionsArr = jsonElement;
        JsonElement jsonElement2 = data.get("supportedGradleVersions");
        if (jsonElement2 == null || (jsonElement2 = GsonUtilKt.getAsSafeJsonArray(jsonElement2)) == null) {
            return null;
        }
        JsonElement supportedGradleVersionsArr = jsonElement2;
        JsonElement jsonElement3 = data.get("compatibility");
        if (jsonElement3 == null || (jsonElement3 = GsonUtilKt.getAsSafeJsonArray(jsonElement3)) == null) {
            return null;
        }
        JsonElement compatibilityArr = jsonElement3;
        List<String> supportedJavaVersions = this.parseVersions((JsonArray)supportedJavaVersionsArr);
        List<String> supportedGradleVersions = this.parseVersions((JsonArray)supportedGradleVersionsArr);
        Iterable iterable = (Iterable)compatibilityArr;
        boolean $i$f$mapNotNull = false;
        void var10_9 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VersionMapping versionMapping;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            JsonElement element = (JsonElement)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)element);
            if (GsonUtilKt.getAsSafeJsonObject(element) == null) {
                versionMapping = null;
            } else {
                JsonObject obj;
                Object object = obj.get("java");
                if (object == null || (object = GsonUtilKt.getAsSafeString(object)) == null) {
                    versionMapping = var23_22 = null;
                } else {
                    VersionMapping versionMapping2 = new VersionMapping();
                    versionMapping2.setJavaVersionInfo((String)object);
                    Object object2 = obj.get("gradle");
                    if (object2 == null || (object2 = GsonUtilKt.getAsSafeString(object2)) == null) {
                        versionMapping = var23_22 = null;
                    } else {
                        versionMapping2.setGradleVersionInfo((String)object2);
                        versionMapping = versionMapping2;
                    }
                }
            }
            if (versionMapping == null) continue;
            VersionMapping it$iv$iv = versionMapping;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List versionMappings = (List)destination$iv$iv;
        return new GradleCompatibilityState(versionMappings, supportedJavaVersions, supportedGradleVersions);
    }
}

