/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import com.intellij.serialization.PropertyMapping;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.WarDirectory;

public class WebResource
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final WarDirectory warDirectory;
    @NotNull
    private final String warRelativePath;
    @NotNull
    private final Path filePath;

    @Deprecated
    @PropertyMapping(value={"warDirectory", "warRelativePath", "file"})
    public WebResource(@NotNull WarDirectory warDirectory, @NotNull String warRelativePath, @NotNull File file) {
        if (warDirectory == null) {
            WebResource.$$$reportNull$$$0(0);
        }
        if (warRelativePath == null) {
            WebResource.$$$reportNull$$$0(1);
        }
        if (file == null) {
            WebResource.$$$reportNull$$$0(2);
        }
        this(warDirectory, warRelativePath, file.toPath());
    }

    @PropertyMapping(value={"warDirectory", "warRelativePath", "file"})
    public WebResource(@NotNull WarDirectory warDirectory, @NotNull String warRelativePath, @NotNull Path filePath) {
        if (warDirectory == null) {
            WebResource.$$$reportNull$$$0(3);
        }
        if (warRelativePath == null) {
            WebResource.$$$reportNull$$$0(4);
        }
        if (filePath == null) {
            WebResource.$$$reportNull$$$0(5);
        }
        this.warDirectory = warDirectory;
        this.warRelativePath = WebResource.getAdjustedPath(warRelativePath);
        this.filePath = filePath;
    }

    @NotNull
    public WarDirectory getWarDirectory() {
        WarDirectory warDirectory = this.warDirectory;
        if (warDirectory == null) {
            WebResource.$$$reportNull$$$0(6);
        }
        return warDirectory;
    }

    @NotNull
    public String getWarRelativePath() {
        String string = this.warRelativePath;
        if (string == null) {
            WebResource.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Deprecated
    @NotNull
    public File getFile() {
        File file = this.filePath.toFile();
        if (file == null) {
            WebResource.$$$reportNull$$$0(8);
        }
        return file;
    }

    @NotNull
    public Path getFilePath() {
        Path path = this.filePath;
        if (path == null) {
            WebResource.$$$reportNull$$$0(9);
        }
        return path;
    }

    private static String getAdjustedPath(@NotNull String path) {
        if (path == null) {
            WebResource.$$$reportNull$$$0(10);
        }
        return path.isEmpty() || path.charAt(0) != '/' ? "/" + path : path;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebResource resource = (WebResource)o;
        return Objects.equals(this.warDirectory, resource.warDirectory) && Objects.equals(this.warRelativePath, resource.warRelativePath) && Objects.equals(this.filePath, resource.filePath);
    }

    public int hashCode() {
        return Objects.hash(this.warDirectory, this.warRelativePath, this.filePath);
    }

    public String toString() {
        return "WebResource{warDirectory=" + String.valueOf(this.warDirectory) + ", warRelativePath='" + this.warRelativePath + "', filePath=" + String.valueOf(this.filePath) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warDirectory";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warRelativePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/model/data/WebResource";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/model/data/WebResource";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWarDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getWarRelativePath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAdjustedPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

