/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.open;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.observation.TrackingUtil;
import java.nio.file.Path;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.GradleCoroutineScope;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.project.open.GradleOpenProjectProvider;
import org.jetbrains.plugins.gradle.settings.GradleDefaultProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleEnvironment;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u0001H\u0086@\u00a2\u0006\u0002\u0010\t\u001a\"\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u0001H\u0007\u001a\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0007\u001a\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\u0012\u001a\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H\u0086@\u00a2\u0006\u0002\u0010\u0013\u001a\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u0005H\u0007\u001a\f\u0010\u0018\u001a\u00020\u0010*\u00020\u0019H\u0007\u001a\u0012\u0010\u001a\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0005\u001a\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002\"\u0013\u0010\u001d\u001a\u00070\u001e\u00a2\u0006\u0002\b\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"canOpenGradleProject", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "openGradleProject", "Lcom/intellij/openapi/project/Project;", "projectFile", "projectToClose", "forceOpenInNewFrame", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "canLinkAndRefreshGradleProject", "projectFilePath", "", "project", "showValidationDialog", "linkAndRefreshGradleProject", "", "linkAndSyncGradleProject", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createLinkSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "projectDirectory", "Ljava/nio/file/Path;", "setupGradleSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleSettings;", "suggestGradleHome", "validateGradleProject", "Lcom/intellij/openapi/ui/ValidationInfo;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.gradle"})
@JvmName(name="GradleProjectImportUtil")
public final class GradleProjectImportUtil {
    @NotNull
    private static final Logger LOG;

    public static final boolean canOpenGradleProject(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new GradleOpenProjectProvider().canOpenProject(file);
    }

    @Nullable
    public static final Object openGradleProject(@NotNull VirtualFile projectFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame, @NotNull Continuation<? super Project> $completion) {
        return new GradleOpenProjectProvider().openProject(projectFile, projectToClose, forceOpenInNewFrame, $completion);
    }

    @ApiStatus.Experimental
    @JvmOverloads
    public static final boolean canLinkAndRefreshGradleProject(@NotNull String projectFilePath, @NotNull Project project, boolean showValidationDialog) {
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ValidationInfo validationInfo = GradleProjectImportUtil.validateGradleProject(projectFilePath, project);
        if (validationInfo == null) {
            return true;
        }
        ValidationInfo validationInfo2 = validationInfo;
        if (showValidationDialog) {
            String title = ExternalSystemBundle.message((String)"error.project.import.error.title", (Object[])new Object[0]);
            ActionsKt.invokeAndWaitIfNeeded$default(null, () -> GradleProjectImportUtil.canLinkAndRefreshGradleProject$lambda$0(validationInfo2, project, title), (int)1, null);
        }
        return false;
    }

    public static /* synthetic */ boolean canLinkAndRefreshGradleProject$default(String string, Project project, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return GradleProjectImportUtil.canLinkAndRefreshGradleProject(string, project, bl);
    }

    @Deprecated(message="Use linkAndSyncGradleProject instead", replaceWith=@ReplaceWith(expression="linkAndSyncGradleProject(project, projectFilePath)", imports={}))
    public static final void linkAndRefreshGradleProject(@NotNull String projectFilePath, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LOG.warn("Use linkAndSyncGradleProject instead");
        TrackingUtil.launchTracked$default((CoroutineScope)GradleCoroutineScope.INSTANCE.getGradleCoroutineScope(project), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(projectFilePath, project, null){
            int label;
            final /* synthetic */ String $projectFilePath;
            final /* synthetic */ Project $project;
            {
                this.$projectFilePath = $projectFilePath;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = new GradleOpenProjectProvider().linkToExistingProjectAsync(this.$projectFilePath, this.$project, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @Nullable
    public static final Object linkAndSyncGradleProject(@NotNull Project project, @NotNull String projectFilePath, @NotNull Continuation<? super Unit> $completion) {
        Object object = new GradleOpenProjectProvider().linkToExistingProjectAsync(projectFilePath, project, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public static final Object linkAndSyncGradleProject(@NotNull Project project, @NotNull VirtualFile projectFile, @NotNull Continuation<? super Unit> $completion) {
        Object object = new GradleOpenProjectProvider().linkToExistingProjectAsync(projectFile, project, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @ApiStatus.Internal
    @NotNull
    public static final GradleProjectSettings createLinkSettings(@NotNull Path projectDirectory, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GradleSettings gradleSettings = GradleSettings.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"getInstance(...)");
        GradleSettings gradleSettings2 = gradleSettings;
        GradleProjectImportUtil.setupGradleSettings(gradleSettings2);
        GradleProjectSettings gradleProjectSettings = GradleDefaultProjectSettings.Companion.createProjectSettings(NioPathUtil.toCanonicalPath((Path)projectDirectory));
        GradleVersion gradleVersion = gradleProjectSettings.resolveGradleVersion();
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion, (String)"resolveGradleVersion(...)");
        GradleVersion gradleVersion2 = gradleVersion;
        GradleJvmResolutionUtil.setupGradleJvm(project, gradleProjectSettings, gradleVersion2);
        return gradleProjectSettings;
    }

    @ApiStatus.Internal
    public static final void setupGradleSettings(@NotNull GradleSettings $this$setupGradleSettings) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$setupGradleSettings), (String)"<this>");
        String string = GradleEnvironment.Headless.GRADLE_VM_OPTIONS;
        if (string == null) {
            string = $this$setupGradleSettings.getGradleVmOptions();
        }
        $this$setupGradleSettings.setGradleVmOptions(string);
        String string2 = GradleEnvironment.Headless.GRADLE_OFFLINE;
        $this$setupGradleSettings.setOfflineWork(string2 != null ? Boolean.parseBoolean(string2) : $this$setupGradleSettings.isOfflineWork());
        String string3 = GradleEnvironment.Headless.GRADLE_SERVICE_DIRECTORY;
        if (string3 == null) {
            string3 = $this$setupGradleSettings.getServiceDirectoryPath();
        }
        $this$setupGradleSettings.setServiceDirectoryPath(string3);
        $this$setupGradleSettings.setStoreProjectFilesExternally(true);
    }

    @Nullable
    public static final String suggestGradleHome(@Nullable Project project) {
        Path gradleHome;
        String defaultGradleHome = GradleDefaultProjectSettings.Companion.getInstance().getGradleHome();
        if (defaultGradleHome != null) {
            return defaultGradleHome;
        }
        String string = GradleUtil.getLastUsedGradleHome();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLastUsedGradleHome(...)");
        String lastUsedGradleHome = string;
        if (((CharSequence)lastUsedGradleHome).length() > 0) {
            return lastUsedGradleHome;
        }
        Path path = gradleHome = GradleInstallationManager.Companion.getInstance().getAutodetectedGradleHome(project);
        return path != null ? NioPathUtil.toCanonicalPath((Path)path) : null;
    }

    private static final ValidationInfo validateGradleProject(String projectFilePath, Project project) {
        AbstractExternalSystemSettings abstractExternalSystemSettings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
        Intrinsics.checkNotNullExpressionValue((Object)abstractExternalSystemSettings, (String)"getSettings(...)");
        AbstractExternalSystemSettings systemSettings = abstractExternalSystemSettings;
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem localFileSystem2 = localFileSystem;
        VirtualFile projectFile = localFileSystem2.refreshAndFindFileByPath(projectFilePath);
        if (projectFile == null) {
            String shortPath = UiUtils.getPresentablePath((String)projectFilePath);
            Object[] objectArray = new Object[]{"Gradle", shortPath};
            return new ValidationInfo(ExternalSystemBundle.message((String)"error.project.does.not.exist", (Object[])objectArray));
        }
        VirtualFile projectDirectory = projectFile.isDirectory() ? projectFile : projectFile.getParent();
        ExternalProjectSettings projectSettings = systemSettings.getLinkedProjectSettings(projectDirectory.getPath());
        if (projectSettings != null) {
            return new ValidationInfo(ExternalSystemBundle.message((String)"error.project.already.registered", (Object[])new Object[0]));
        }
        return null;
    }

    @ApiStatus.Experimental
    @JvmOverloads
    public static final boolean canLinkAndRefreshGradleProject(@NotNull String projectFilePath, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return GradleProjectImportUtil.canLinkAndRefreshGradleProject$default(projectFilePath, project, false, 4, null);
    }

    private static final Unit canLinkAndRefreshGradleProject$lambda$0(ValidationInfo $validationInfo, Project $project, String $title) {
        if ($validationInfo.warning) {
            Messages.showWarningDialog((Project)$project, (String)$validationInfo.message, (String)$title);
        } else {
            Messages.showErrorDialog((Project)$project, (String)$validationInfo.message, (String)$title);
        }
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance((String)"#org.jetbrains.plugins.gradle.service.project.open.GradleProjectImportUtil");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

