/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.syncAction.impl.bridge;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.syncAction.impl.bridge.GradleBridgeData;
import org.jetbrains.plugins.gradle.service.syncAction.impl.bridge.GradleBridgeEntitySource;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0016J6\u0010\b\u001a\u00020\u00032\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/gradle/service/syncAction/impl/bridge/GradleBridgeProjectDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lorg/jetbrains/plugins/gradle/service/syncAction/impl/bridge/GradleBridgeData;", "", "<init>", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "importData", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "removeModulesFromModelProvider", "removeEntitiesFromWorkspaceModel", "intellij.gradle"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGradleBridgeProjectDataService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleBridgeProjectDataService.kt\norg/jetbrains/plugins/gradle/service/syncAction/impl/bridge/GradleBridgeProjectDataService\n+ 2 EntityStorage.kt\ncom/intellij/platform/workspace/storage/EntityStorageKt\n*L\n1#1,53:1\n66#2:54\n*S KotlinDebug\n*F\n+ 1 GradleBridgeProjectDataService.kt\norg/jetbrains/plugins/gradle/service/syncAction/impl/bridge/GradleBridgeProjectDataService\n*L\n35#1:54\n*E\n"})
public final class GradleBridgeProjectDataService
extends AbstractProjectDataService<GradleBridgeData, Unit> {
    @NotNull
    public Key<GradleBridgeData> getTargetDataKey() {
        return GradleBridgeData.INSTANCE.getKEY();
    }

    public void importData(@NotNull Collection<? extends DataNode<GradleBridgeData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkNotNullParameter(toImport, (String)"toImport");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        if (!Registry.Companion.is("gradle.phased.sync.bridge.disabled")) {
            this.removeModulesFromModelProvider(modelsProvider);
            this.removeEntitiesFromWorkspaceModel(modelsProvider);
        }
    }

    private final void removeModulesFromModelProvider(IdeModifiableModelsProvider modelsProvider) {
        ModifiableModuleModel modifiableModuleModel = modelsProvider.getModifiableModuleModel();
        Intrinsics.checkNotNullExpressionValue((Object)modifiableModuleModel, (String)"getModifiableModuleModel(...)");
        ModifiableModuleModel moduleModel = modifiableModuleModel;
        MutableEntityStorage mutableEntityStorage = modelsProvider.getActualStorageBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)mutableEntityStorage, (String)"getActualStorageBuilder(...)");
        MutableEntityStorage entityStorage = mutableEntityStorage;
        EntityStorage $this$entities$iv = (EntityStorage)entityStorage;
        boolean $i$f$entities = false;
        List moduleNames = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)$this$entities$iv.entities(ModuleEntity.class), GradleBridgeProjectDataService::removeModulesFromModelProvider$lambda$0), GradleBridgeProjectDataService::removeModulesFromModelProvider$lambda$1));
        for (String moduleName : moduleNames) {
            Module module;
            if (moduleModel.findModuleByName(moduleName) == null) continue;
            moduleModel.disposeModule(module);
        }
    }

    private final void removeEntitiesFromWorkspaceModel(IdeModifiableModelsProvider modelsProvider) {
        MutableEntityStorage mutableEntityStorage = modelsProvider.getActualStorageBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)mutableEntityStorage, (String)"getActualStorageBuilder(...)");
        MutableEntityStorage entityStorage = mutableEntityStorage;
        List entities = SequencesKt.toList((Sequence)entityStorage.entitiesBySource(GradleBridgeProjectDataService::removeEntitiesFromWorkspaceModel$lambda$0));
        for (WorkspaceEntity entity : entities) {
            entityStorage.removeEntity(entity);
        }
    }

    private static final boolean removeModulesFromModelProvider$lambda$0(ModuleEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getEntitySource() instanceof GradleBridgeEntitySource;
    }

    private static final String removeModulesFromModelProvider$lambda$1(ModuleEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final boolean removeEntitiesFromWorkspaceModel$lambda$0(EntitySource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof GradleBridgeEntitySource;
    }
}

