/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.proxy;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.gradle.api.Action;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.DefaultExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.remote.ConnectionAcceptor;
import org.gradle.internal.remote.internal.ConnectCompletion;
import org.gradle.internal.remote.internal.IncomingConnector;
import org.gradle.internal.remote.internal.KryoBackedMessageSerializer;
import org.gradle.internal.remote.internal.MessageSerializer;
import org.gradle.internal.remote.internal.RemoteConnection;
import org.gradle.internal.remote.internal.inet.InetAddressFactory;
import org.gradle.internal.remote.internal.inet.SocketConnection;
import org.gradle.internal.remote.internal.inet.SocketInetAddress;
import org.gradle.internal.serialize.StatefulSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.tooling.proxy.InetAddresses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0003\u0017\u0018\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/gradle/tooling/proxy/TargetIncomingConnector;", "Lorg/gradle/internal/remote/internal/IncomingConnector;", "<init>", "()V", "DEFAULT_READ_TIMEOUT_SECONDS", "", "GRADLE_MAGIC", "", "addressFactory", "Lorg/gradle/internal/remote/internal/inet/InetAddressFactory;", "executorFactory", "Lorg/gradle/internal/concurrent/DefaultExecutorFactory;", "accept", "Lorg/gradle/internal/remote/ConnectionAcceptor;", "action", "Lorg/gradle/api/Action;", "Lorg/gradle/internal/remote/internal/ConnectCompletion;", "allowRemote", "", "getBindingPort", "", "getBindingAddress", "Ljava/net/InetAddress;", "Receiver", "SocketConnectCompletion", "Companion", "intellij.gradle.toolingProxy"})
@SourceDebugExtension(value={"SMAP\nTargetIncomingConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetIncomingConnector.kt\norg/jetbrains/plugins/gradle/tooling/proxy/TargetIncomingConnector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n1#2:159\n*E\n"})
public final class TargetIncomingConnector
implements IncomingConnector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long DEFAULT_READ_TIMEOUT_SECONDS;
    @NotNull
    private final byte[] GRADLE_MAGIC;
    @NotNull
    private final InetAddressFactory addressFactory;
    @NotNull
    private final DefaultExecutorFactory executorFactory;
    private static final Logger logger = LoggerFactory.getLogger(TargetIncomingConnector.class);

    public TargetIncomingConnector() {
        this.DEFAULT_READ_TIMEOUT_SECONDS = 5L;
        String string = "Gradle Magic";
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.GRADLE_MAGIC = byArray;
        this.addressFactory = new InetAddressFactory();
        this.executorFactory = new DefaultExecutorFactory();
    }

    @NotNull
    public ConnectionAcceptor accept(@NotNull Action<ConnectCompletion> action, boolean allowRemote) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        ServerSocketChannel serverSocketChannel = null;
        try {
            int bindingPort = this.getBindingPort();
            ServerSocketChannel serverSocketChannel2 = ServerSocketChannel.open();
            Intrinsics.checkNotNullExpressionValue((Object)serverSocketChannel2, (String)"open(...)");
            serverSocketChannel = serverSocketChannel2;
            serverSocketChannel.configureBlocking(false);
            InetAddress bindingAddress = this.getBindingAddress(allowRemote);
            serverSocketChannel.bind(new InetSocketAddress(bindingAddress, bindingPort));
        }
        catch (Exception e) {
            RuntimeException runtimeException = UncheckedException.throwAsUncheckedException((Throwable)e);
            Intrinsics.checkNotNullExpressionValue((Object)runtimeException, (String)"throwAsUncheckedException(...)");
            throw (Throwable)runtimeException;
        }
        SocketAddress socketAddress = serverSocketChannel.getLocalAddress();
        Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
        InetSocketAddress localAddress = (InetSocketAddress)socketAddress;
        int localPort2 = localAddress.getPort();
        SocketInetAddress address = new SocketInetAddress(localAddress.getAddress(), localPort2);
        logger.debug("Listening on " + address + '.');
        ManagedExecutor managedExecutor = this.executorFactory.create("Incoming " + (allowRemote ? "remote" : "local") + " TCP Connector on port " + localPort2);
        Intrinsics.checkNotNullExpressionValue((Object)managedExecutor, (String)"create(...)");
        ManagedExecutor executor = managedExecutor;
        executor.execute((Runnable)new Receiver(serverSocketChannel, action, allowRemote));
        return new ConnectionAcceptor(address, serverSocketChannel, executor){
            final /* synthetic */ SocketInetAddress $address;
            final /* synthetic */ ServerSocketChannel $serverSocketChannel;
            final /* synthetic */ ManagedExecutor $executor;
            {
                this.$address = $address;
                this.$serverSocketChannel = $serverSocketChannel;
                this.$executor = $executor;
            }

            public SocketInetAddress getAddress() {
                return this.$address;
            }

            public void requestStop() {
                Object[] objectArray = new Object[]{this.$serverSocketChannel};
                CompositeStoppable.stoppable((Object[])objectArray).stop();
            }

            public void stop() {
                this.requestStop();
                this.$executor.stop();
            }
        };
    }

    private final int getBindingPort() {
        Object object = System.getenv("serverBindingPort");
        return object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
    }

    private final InetAddress getBindingAddress(boolean allowRemote) {
        InetAddress inetAddress;
        InetAddress inetAddress2;
        Object v0;
        block3: {
            String bindingHost = System.getenv("serverBindingHost");
            CharSequence charSequence = bindingHost;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return allowRemote ? null : this.addressFactory.getLocalBindingAddress();
            }
            InetAddresses inetAddresses = new InetAddresses();
            Iterable iterable = CollectionsKt.plus((Collection)inetAddresses.getRemote(), (Iterable)inetAddresses.getLoopback());
            for (Object t : iterable) {
                InetAddress it = (InetAddress)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getHostName(), (Object)bindingHost) || Intrinsics.areEqual((Object)it.getHostAddress(), (Object)bindingHost))) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        if ((inetAddress2 = (inetAddress = (InetAddress)v0)) == null) {
            inetAddress2 = allowRemote ? null : this.addressFactory.getLocalBindingAddress();
        }
        return inetAddress2;
    }

    public static final /* synthetic */ InetAddressFactory access$getAddressFactory$p(TargetIncomingConnector $this) {
        return $this.addressFactory;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/gradle/tooling/proxy/TargetIncomingConnector$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "intellij.gradle.toolingProxy"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\f*\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/gradle/tooling/proxy/TargetIncomingConnector$Receiver;", "Ljava/lang/Runnable;", "serverSocket", "Ljava/nio/channels/ServerSocketChannel;", "action", "Lorg/gradle/api/Action;", "Lorg/gradle/internal/remote/internal/ConnectCompletion;", "allowRemote", "", "<init>", "(Lorg/jetbrains/plugins/gradle/tooling/proxy/TargetIncomingConnector;Ljava/nio/channels/ServerSocketChannel;Lorg/gradle/api/Action;Z)V", "run", "", "offsetHeader", "Ljava/nio/channels/SocketChannel;", "intellij.gradle.toolingProxy"})
    private final class Receiver
    implements Runnable {
        @NotNull
        private final ServerSocketChannel serverSocket;
        @NotNull
        private final Action<ConnectCompletion> action;
        private final boolean allowRemote;

        public Receiver(@NotNull ServerSocketChannel serverSocket, Action<ConnectCompletion> action, boolean allowRemote) {
            Intrinsics.checkNotNullParameter((Object)serverSocket, (String)"serverSocket");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            this.serverSocket = serverSocket;
            this.action = action;
            this.allowRemote = allowRemote;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 8[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private final void offsetHeader(SocketChannel $this$offsetHeader) {
            ByteBuffer buffer = ByteBuffer.allocate(TargetIncomingConnector.this.GRADLE_MAGIC.length);
            long deadline = System.nanoTime() + Duration.getInWholeNanoseconds-impl((long)DurationKt.toDuration((long)TargetIncomingConnector.this.DEFAULT_READ_TIMEOUT_SECONDS, (DurationUnit)DurationUnit.SECONDS));
            block4: while (buffer.hasRemaining() && System.nanoTime() < deadline) {
                int read = $this$offsetHeader.read(buffer);
                switch (read) {
                    case -1: {
                        break block4;
                    }
                    case 0: {
                        Thread.sleep(100L);
                    }
                    default: {
                        continue block4;
                    }
                }
            }
            if (!Arrays.equals(TargetIncomingConnector.this.GRADLE_MAGIC, buffer.array())) {
                StringBuilder stringBuilder = new StringBuilder().append("Gradle message prefix does not match with the expected value. Expected: ").append(new String(TargetIncomingConnector.this.GRADLE_MAGIC, Charsets.UTF_8)).append(" but got: ");
                byte[] byArray = buffer.array();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
                byte[] byArray2 = byArray;
                throw new IllegalStateException(stringBuilder.append(new String(byArray2, Charsets.UTF_8)).toString());
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u00020\u0007H\u0096\u0080\u0004J&\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\b\b\u0000\u0010\n*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/gradle/tooling/proxy/TargetIncomingConnector$SocketConnectCompletion;", "Lorg/gradle/internal/remote/internal/ConnectCompletion;", "socket", "Ljava/nio/channels/SocketChannel;", "<init>", "(Ljava/nio/channels/SocketChannel;)V", "toString", "", "create", "Lorg/gradle/internal/remote/internal/RemoteConnection;", "T", "", "serializer", "Lorg/gradle/internal/serialize/StatefulSerializer;", "intellij.gradle.toolingProxy"})
    public static final class SocketConnectCompletion
    implements ConnectCompletion {
        @NotNull
        private final SocketChannel socket;

        public SocketConnectCompletion(@NotNull SocketChannel socket) {
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            this.socket = socket;
        }

        @NotNull
        public String toString() {
            return this.socket.socket().getLocalSocketAddress() + " to " + this.socket.socket().getRemoteSocketAddress();
        }

        @NotNull
        public <T> RemoteConnection<T> create(@NotNull StatefulSerializer<T> serializer) {
            Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
            return (RemoteConnection)new SocketConnection(this.socket, (MessageSerializer)new KryoBackedMessageSerializer(), serializer);
        }
    }
}

