/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.openapi.project.Project;
import com.intellij.util.lang.JavaVersion;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;
import org.jetbrains.plugins.gradle.util.GradleJvmSupportMatrices;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u001b\u001a\u00020\u00002\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fJ\u0010\u0010\u001d\u001a\u00020\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u001e\u001a\u00020\u00002\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u0010\u0010!\u001a\u00020\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\u0006\u0010\"\u001a\u00020\u0000J\u0006\u0010#\u001a\u00020\u0000R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR,\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017\u00a8\u0006$"}, d2={"Lorg/jetbrains/plugins/gradle/util/SuggestGradleVersionOptions;", "", "<init>", "()V", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "setProject", "(Lcom/intellij/openapi/project/Project;)V", "filters", "", "Lkotlin/Function1;", "Lorg/gradle/util/GradleVersion;", "", "getFilters", "()Ljava/util/List;", "setFilters", "(Ljava/util/List;)V", "checkDefaultProjectSettingsVersion", "getCheckDefaultProjectSettingsVersion", "()Z", "setCheckDefaultProjectSettingsVersion", "(Z)V", "checkLinkedProjectSettingsVersion", "getCheckLinkedProjectSettingsVersion", "setCheckLinkedProjectSettingsVersion", "withFilter", "filter", "withProject", "withJavaVersionFilter", "javaVersion", "Lcom/intellij/util/lang/JavaVersion;", "withProjectJdkVersionFilter", "dontCheckDefaultProjectSettingsVersion", "dontCheckLinkedProjectSettingsVersion", "intellij.gradle"})
public final class SuggestGradleVersionOptions {
    @Nullable
    private Project project;
    @NotNull
    private List<? extends Function1<? super GradleVersion, Boolean>> filters = CollectionsKt.emptyList();
    private boolean checkDefaultProjectSettingsVersion = true;
    private boolean checkLinkedProjectSettingsVersion = true;

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    public final void setProject(@Nullable Project project) {
        this.project = project;
    }

    @NotNull
    public final List<Function1<GradleVersion, Boolean>> getFilters() {
        return this.filters;
    }

    public final void setFilters(@NotNull List<? extends Function1<? super GradleVersion, Boolean>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.filters = list;
    }

    public final boolean getCheckDefaultProjectSettingsVersion() {
        return this.checkDefaultProjectSettingsVersion;
    }

    public final void setCheckDefaultProjectSettingsVersion(boolean bl) {
        this.checkDefaultProjectSettingsVersion = bl;
    }

    public final boolean getCheckLinkedProjectSettingsVersion() {
        return this.checkLinkedProjectSettingsVersion;
    }

    public final void setCheckLinkedProjectSettingsVersion(boolean bl) {
        this.checkLinkedProjectSettingsVersion = bl;
    }

    @NotNull
    public final SuggestGradleVersionOptions withFilter(@NotNull Function1<? super GradleVersion, Boolean> filter) {
        SuggestGradleVersionOptions suggestGradleVersionOptions;
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        SuggestGradleVersionOptions $this$withFilter_u24lambda_u240 = suggestGradleVersionOptions = this;
        boolean bl = false;
        $this$withFilter_u24lambda_u240.filters = CollectionsKt.plus((Collection)$this$withFilter_u24lambda_u240.filters, filter);
        return suggestGradleVersionOptions;
    }

    @NotNull
    public final SuggestGradleVersionOptions withProject(@Nullable Project project) {
        SuggestGradleVersionOptions suggestGradleVersionOptions;
        SuggestGradleVersionOptions $this$withProject_u24lambda_u240 = suggestGradleVersionOptions = this;
        boolean bl = false;
        $this$withProject_u24lambda_u240.project = project;
        return suggestGradleVersionOptions;
    }

    @NotNull
    public final SuggestGradleVersionOptions withJavaVersionFilter(@Nullable JavaVersion javaVersion) {
        SuggestGradleVersionOptions suggestGradleVersionOptions;
        SuggestGradleVersionOptions $this$withJavaVersionFilter_u24lambda_u240 = suggestGradleVersionOptions = this;
        boolean bl = false;
        if (javaVersion != null) {
            $this$withJavaVersionFilter_u24lambda_u240.withFilter((Function1<? super GradleVersion, Boolean>)((Function1)arg_0 -> SuggestGradleVersionOptions.withJavaVersionFilter$lambda$0$0(javaVersion, arg_0)));
        }
        return suggestGradleVersionOptions;
    }

    @NotNull
    public final SuggestGradleVersionOptions withProjectJdkVersionFilter(@Nullable Project project) {
        SuggestGradleVersionOptions suggestGradleVersionOptions;
        SuggestGradleVersionOptions $this$withProjectJdkVersionFilter_u24lambda_u240 = suggestGradleVersionOptions = this;
        boolean bl = false;
        Project project2 = project;
        $this$withProjectJdkVersionFilter_u24lambda_u240.withJavaVersionFilter((JavaVersion)(project2 != null ? GradleJvmSupportMatrices.access$getProjectJdkVersion(project2) : null));
        return suggestGradleVersionOptions;
    }

    @NotNull
    public final SuggestGradleVersionOptions dontCheckDefaultProjectSettingsVersion() {
        SuggestGradleVersionOptions suggestGradleVersionOptions;
        SuggestGradleVersionOptions $this$dontCheckDefaultProjectSettingsVersion_u24lambda_u240 = suggestGradleVersionOptions = this;
        boolean bl = false;
        $this$dontCheckDefaultProjectSettingsVersion_u24lambda_u240.checkDefaultProjectSettingsVersion = false;
        return suggestGradleVersionOptions;
    }

    @NotNull
    public final SuggestGradleVersionOptions dontCheckLinkedProjectSettingsVersion() {
        SuggestGradleVersionOptions suggestGradleVersionOptions;
        SuggestGradleVersionOptions $this$dontCheckLinkedProjectSettingsVersion_u24lambda_u240 = suggestGradleVersionOptions = this;
        boolean bl = false;
        $this$dontCheckLinkedProjectSettingsVersion_u24lambda_u240.checkLinkedProjectSettingsVersion = false;
        return suggestGradleVersionOptions;
    }

    private static final boolean withJavaVersionFilter$lambda$0$0(JavaVersion $javaVersion, GradleVersion it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return GradleJvmSupportMatrix.Companion.isSupported(it, $javaVersion);
    }
}

