/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.config;

import com.intellij.microservices.jvm.config.ConfigKeyPathBeanPropertyResolver;
import com.intellij.microservices.jvm.config.ConfigKeyPathMethodResolverKt;
import com.intellij.microservices.jvm.config.ConfigKeyPathUtils;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.RelaxedNames;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.util.PropertyUtilBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/microservices/jvm/config/ConfigKeyPathMethodResolver;", "Lcom/intellij/microservices/jvm/config/ConfigKeyPathBeanPropertyResolver;", "allowGetters", "", "<init>", "(Z)V", "resolveProperty", "Lcom/intellij/psi/PsiElement;", "configKey", "Lcom/intellij/microservices/jvm/config/MetaConfigKey;", "psiType", "Lcom/intellij/psi/PsiType;", "propertyName", "", "getAllBeanProperties", "", "Lcom/intellij/psi/impl/beanProperties/BeanProperty;", "getProperties", "", "Lcom/intellij/psi/PsiMethod;", "psiClass", "Lcom/intellij/psi/PsiClass;", "intellij.microservices.config"})
@SourceDebugExtension(value={"SMAP\nConfigKeyPathMethodResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigKeyPathMethodResolver.kt\ncom/intellij/microservices/jvm/config/ConfigKeyPathMethodResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1642#2,10:61\n1915#2:71\n1916#2:73\n1652#2:74\n1#3:72\n*S KotlinDebug\n*F\n+ 1 ConfigKeyPathMethodResolver.kt\ncom/intellij/microservices/jvm/config/ConfigKeyPathMethodResolver\n*L\n41#1:61,10\n41#1:71\n41#1:73\n41#1:74\n41#1:72\n*E\n"})
public final class ConfigKeyPathMethodResolver
implements ConfigKeyPathBeanPropertyResolver {
    private final boolean allowGetters;

    public ConfigKeyPathMethodResolver(boolean allowGetters) {
        this.allowGetters = allowGetters;
    }

    @Override
    @Nullable
    public PsiElement resolveProperty(@NotNull MetaConfigKey configKey, @NotNull PsiType psiType, @NotNull String propertyName) {
        BeanProperty property;
        Intrinsics.checkNotNullParameter((Object)configKey, (String)"configKey");
        Intrinsics.checkNotNullParameter((Object)psiType, (String)"psiType");
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        PsiClass psiClass = ConfigKeyPathUtils.getPsiClass(psiType);
        if (psiClass == null) {
            return null;
        }
        PsiClass psiClass2 = psiClass;
        PsiMethod method = PropertyUtilBase.findPropertyGetter((PsiClass)psiClass2, (String)propertyName, (boolean)false, (boolean)true, (boolean)true);
        if (method == null) {
            method = PropertyUtilBase.findPropertyGetter((PsiClass)psiClass2, (String)RelaxedNames.separatedPropertyNameToCamelCase(propertyName), (boolean)false, (boolean)true, (boolean)true);
        }
        if (method == null || !method.hasModifierProperty("public")) {
            return null;
        }
        BeanProperty beanProperty = property = BeanProperty.createBeanProperty((PsiMethod)method, (boolean)true);
        return (PsiElement)(beanProperty != null ? beanProperty.getPsiElement() : null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<BeanProperty> getAllBeanProperties(@NotNull MetaConfigKey configKey, @NotNull PsiType psiType) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)configKey, (String)"configKey");
        Intrinsics.checkNotNullParameter((Object)psiType, (String)"psiType");
        PsiClass psiClass = ConfigKeyPathUtils.getPsiClass(psiType);
        if (psiClass == null || ConfigKeyPathUtils.stopResolvingProperty(psiClass)) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$mapNotNull$iv = this.getProperties(psiClass);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            BeanProperty it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PsiMethod it = (PsiMethod)element$iv$iv;
            boolean bl2 = false;
            if (BeanProperty.createBeanProperty((PsiMethod)it, (boolean)true) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Collection<PsiMethod> getProperties(PsiClass psiClass) {
        PsiMethod[] psiMethodArray = psiClass.getAllMethods();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getAllMethods(...)");
        PsiMethod[] methods = psiMethodArray;
        if (this.allowGetters) {
            return PropertyUtilBase.getAllProperties((boolean)true, (boolean)true, (boolean)false, (boolean)true, (String[])ConfigKeyPathMethodResolverKt.access$getONLY_PUBLIC$p(), (PsiMethod[])methods).values();
        }
        Map map = PropertyUtilBase.getAllProperties((boolean)true, (boolean)false, (boolean)false, (boolean)true, (String[])ConfigKeyPathMethodResolverKt.access$getONLY_PUBLIC$p(), (PsiMethod[])methods);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getAllProperties(...)");
        Map setters = map;
        Map map2 = PropertyUtilBase.getAllProperties((boolean)false, (boolean)true, (boolean)false, (boolean)true, (String[])ConfigKeyPathMethodResolverKt.access$getONLY_PUBLIC$p(), (PsiMethod[])methods);
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getAllProperties(...)");
        Map getters = map2;
        ArrayList properties = new ArrayList(setters.values());
        for (Map.Entry entry : getters.entrySet()) {
            String key = (String)entry.getKey();
            PsiMethod value = (PsiMethod)entry.getValue();
            if (setters.containsKey(key) || !ConfigKeyPathMethodResolverKt.access$allowGetter(value.getReturnType())) continue;
            properties.add(value);
        }
        return properties;
    }
}

