/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.index;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.microservices.jvm.index.PropertyCodeReferenceIndexProcessor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.JavaFileElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.text.StringSearcher;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/microservices/jvm/index/JavaPropertyCodeReferenceIndexProcessor;", "Lcom/intellij/microservices/jvm/index/PropertyCodeReferenceIndexProcessor;", "<init>", "()V", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "searcher", "Lcom/intellij/util/text/StringSearcher;", "accept", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "findCodeReferences", "", "", "", "", "inputData", "Lcom/intellij/util/indexing/FileContent;", "intellij.microservices.jvm"})
public final class JavaPropertyCodeReferenceIndexProcessor
implements PropertyCodeReferenceIndexProcessor {
    @NotNull
    private final FileType fileType;
    @NotNull
    private final StringSearcher searcher;

    public JavaPropertyCodeReferenceIndexProcessor() {
        JavaFileType javaFileType = JavaFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)javaFileType, (String)"INSTANCE");
        this.fileType = (FileType)javaFileType;
        this.searcher = new StringSearcher("\"${", true, true);
    }

    @Override
    @NotNull
    public FileType getFileType() {
        return this.fileType;
    }

    @Override
    public boolean accept(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return JavaFileElementType.isInSourceContent((VirtualFile)file);
    }

    @Override
    @NotNull
    public Map<String, List<Integer>> findCodeReferences(@NotNull FileContent inputData) {
        Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
        VirtualFile virtualFile = inputData.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile file = virtualFile;
        if (!JavaFileElementType.isInSourceContent((VirtualFile)file)) {
            return MapsKt.emptyMap();
        }
        CharSequence charSequence = inputData.getContentAsText();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getContentAsText(...)");
        CharSequence content = charSequence;
        if (this.searcher.scan(content) < 0) {
            return MapsKt.emptyMap();
        }
        Map result = new LinkedHashMap();
        Lexer lexer = JavaParserDefinition.createLexer((LanguageLevel)LanguageLevel.HIGHEST);
        Intrinsics.checkNotNullExpressionValue((Object)lexer, (String)"createLexer(...)");
        Lexer lexer2 = lexer;
        lexer2.start(content);
        IElementType tokenType = lexer2.getTokenType();
        int tokenIdx = 0;
        while (tokenType != null) {
            if (tokenIdx++ % 100 == 0) {
                ProgressManager.checkCanceled();
            }
            if (Intrinsics.areEqual((Object)tokenType, (Object)JavaTokenType.STRING_LITERAL)) {
                CharSequence tokenSeq;
                Intrinsics.checkNotNullExpressionValue((Object)lexer2.getTokenSequence(), (String)"getTokenSequence(...)");
                String key = PropertyCodeReferenceIndexProcessor.extractPropertyKey$default(this, tokenSeq, null, null, 6, null);
                if (key != null) {
                    result.computeIfAbsent(key, arg_0 -> JavaPropertyCodeReferenceIndexProcessor.findCodeReferences$lambda$1(JavaPropertyCodeReferenceIndexProcessor::findCodeReferences$lambda$0, arg_0)).add(lexer2.getTokenStart());
                }
            }
            lexer2.advance();
            tokenType = lexer2.getTokenType();
        }
        return result;
    }

    private static final List findCodeReferences$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List findCodeReferences$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }
}

