/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.mq;

import com.intellij.microservices.jvm.mq.DestinationMQType;
import com.intellij.microservices.jvm.mq.MQDestination;
import com.intellij.microservices.jvm.mq.MQModelKt;
import com.intellij.microservices.jvm.mq.MQResolver;
import com.intellij.microservices.jvm.mq.MQResolverFactory;
import com.intellij.microservices.jvm.mq.MQTargetInfo;
import com.intellij.microservices.jvm.mq.MQType;
import com.intellij.microservices.jvm.mq.NamedMQType;
import com.intellij.microservices.jvm.mq.UnknownMQProviderType;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007*\b\u0012\u0004\u0012\u00020\u00120\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/intellij/microservices/jvm/mq/MQResolverManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "allResolvers", "Lkotlin/sequences/Sequence;", "Lcom/intellij/microservices/jvm/mq/MQResolver;", "getAllResolvers", "()Lkotlin/sequences/Sequence;", "getSuitableResolvers", "typeHint", "Lcom/intellij/microservices/jvm/mq/MQType;", "getPriority", "", "resolver", "getVariants", "Lcom/intellij/microservices/jvm/mq/MQTargetInfo;", "getAllVariants", "distinctMqIds", "Companion", "intellij.microservices.jvm"})
@SourceDebugExtension(value={"SMAP\nMQResolverManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MQResolverManager.kt\ncom/intellij/microservices/jvm/mq/MQResolverManager\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n628#2:68\n1807#3,3:69\n*S KotlinDebug\n*F\n+ 1 MQResolverManager.kt\ncom/intellij/microservices/jvm/mq/MQResolverManager\n*L\n22#1:68\n21#1:69,3\n*E\n"})
public final class MQResolverManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final ExtensionPointName<MQResolverFactory> EP_NAME = ExtensionPointName.Companion.create("com.intellij.microservices.mqResolverFactory");

    public MQResolverManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    private final Sequence<MQResolver> getAllResolvers() {
        return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)EP_NAME.getExtensionList()), arg_0 -> MQResolverManager._get_allResolvers_$lambda$0(this, arg_0));
    }

    private final Sequence<MQResolver> getSuitableResolvers(MQType typeHint) {
        Sequence $this$sortedByDescending$iv = SequencesKt.filter(this.getAllResolvers(), arg_0 -> MQResolverManager.getSuitableResolvers$lambda$0(typeHint, arg_0));
        boolean $i$f$sortedByDescending = false;
        return SequencesKt.sortedWith((Sequence)$this$sortedByDescending$iv, (Comparator)new Comparator(this){
            final /* synthetic */ MQResolverManager this$0;
            {
                this.this$0 = mQResolverManager;
            }

            public final int compare(T a, T b) {
                MQResolver it = (MQResolver)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(MQResolverManager.access$getPriority(this.this$0, it));
                it = (MQResolver)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(MQResolverManager.access$getPriority(this.this$0, it)));
            }
        });
    }

    private final int getPriority(MQResolver resolver) {
        List<MQType> types = resolver.getSupportedTypes();
        if (types.isEmpty()) {
            return -100;
        }
        MQType item = (MQType)CollectionsKt.first(types);
        if (Intrinsics.areEqual((Object)item, (Object)UnknownMQProviderType.INSTANCE)) {
            return -1;
        }
        if (item instanceof DestinationMQType) {
            return 0;
        }
        if (item instanceof NamedMQType && ((NamedMQType)item).getDestinationType() == null) {
            return 1;
        }
        if (types.size() > 1) {
            return 10;
        }
        return 100;
    }

    @NotNull
    public final Sequence<MQTargetInfo> getVariants(@NotNull MQType typeHint) {
        Intrinsics.checkNotNullParameter((Object)typeHint, (String)"typeHint");
        return this.distinctMqIds((Sequence<? extends MQTargetInfo>)SequencesKt.distinctBy(this.getAllVariants(typeHint), MQResolverManager::getVariants$lambda$0));
    }

    @NotNull
    public final Sequence<MQTargetInfo> getAllVariants(@NotNull MQType typeHint) {
        Intrinsics.checkNotNullParameter((Object)typeHint, (String)"typeHint");
        return DumbService.Companion.isDumb(this.project) ? SequencesKt.emptySequence() : SequencesKt.flatMap(this.getSuitableResolvers(typeHint), arg_0 -> MQResolverManager.getAllVariants$lambda$0(typeHint, arg_0));
    }

    private final Sequence<MQTargetInfo> distinctMqIds(Sequence<? extends MQTargetInfo> $this$distinctMqIds) {
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super MQTargetInfo>, Continuation<? super Unit>, Object>($this$distinctMqIds, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Sequence<MQTargetInfo> $this_distinctMqIds;
            {
                this.$this_distinctMqIds = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Object invokeSuspend(Object $result) {
                Object object;
                MQTargetInfo next;
                String nextName;
                MQType nextType;
                MQType existingType;
                Iterator iterator;
                HashMap observed;
                SequenceScope sequenceScope = (SequenceScope)this.L$0;
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        observed = new HashMap();
                        iterator = this.$this_distinctMqIds.iterator();
                        break;
                    }
                    case 1: {
                        existingType = (MQType)this.L$6;
                        nextType = (MQType)this.L$5;
                        nextName = (String)this.L$4;
                        next = (MQTargetInfo)this.L$3;
                        iterator = (Iterator)this.L$2;
                        observed = (HashMap)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        object = $result;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                while (iterator.hasNext()) {
                    void $this$sequence;
                    next = (MQTargetInfo)iterator.next();
                    nextName = next.getDestination().getName();
                    nextType = next.getDestination().getType();
                    Object object3 = (MQTargetInfo)observed.get(nextName);
                    MQType mQType = object3 != null && (object3 = object3.getDestination()) != null ? ((MQDestination)object3).getType() : (existingType = null);
                    if (existingType != null && (Intrinsics.areEqual((Object)nextType, (Object)UnknownMQProviderType.INSTANCE) || Intrinsics.areEqual((Object)nextType, (Object)existingType) || nextType.isCompatibleWith(existingType))) continue;
                    ((Map)observed).put(nextName, next);
                    this.L$0 = $this$sequence;
                    this.L$1 = observed;
                    this.L$2 = iterator;
                    this.L$3 = SpillingKt.nullOutSpilledVariable((Object)next);
                    this.L$4 = SpillingKt.nullOutSpilledVariable((Object)nextName);
                    this.L$5 = SpillingKt.nullOutSpilledVariable((Object)nextType);
                    this.L$6 = SpillingKt.nullOutSpilledVariable((Object)existingType);
                    this.label = 1;
                    object = $this$sequence.yield((Object)next, (Continuation)this);
                    if (object != object2) continue;
                    return object2;
                }
                return Unit.INSTANCE;
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super MQTargetInfo> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final Sequence _get_allResolvers_$lambda$0(MQResolverManager this$0, MQResolverFactory it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CollectionsKt.asSequence((Iterable)it.forProject(this$0.project));
    }

    private static final boolean getSuitableResolvers$lambda$0(MQType $typeHint, MQResolver resolver) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
            Iterable $this$any$iv = resolver.getSupportedTypes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    MQType it = (MQType)element$iv;
                    boolean bl2 = false;
                    if (!MQModelKt.areMQTypesCompatible($typeHint, it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final MQDestination getVariants$lambda$0(MQTargetInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDestination();
    }

    private static final Sequence getAllVariants$lambda$0(MQType $typeHint, MQResolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return CollectionsKt.asSequence(resolver.getVariants($typeHint));
    }

    public static final /* synthetic */ int access$getPriority(MQResolverManager $this, MQResolver resolver) {
        return $this.getPriority(resolver);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/microservices/jvm/mq/MQResolverManager$Companion;", "", "<init>", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/microservices/jvm/mq/MQResolverFactory;", "getInstance", "Lcom/intellij/microservices/jvm/mq/MQResolverManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.microservices.jvm"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MQResolverManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return new MQResolverManager(project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

