/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.oas;

import com.intellij.microservices.http.HttpCode;
import com.intellij.microservices.jvm.oas.JvmSwaggerUtilsKt;
import com.intellij.microservices.jvm.oas.v3.SwApiResponse;
import com.intellij.microservices.jvm.oas.v3.SwApiResponses;
import com.intellij.microservices.jvm.oas.v3.SwContent;
import com.intellij.microservices.jvm.oas.v3.SwSchema;
import com.intellij.microservices.oas.OasMediaTypeObject;
import com.intellij.microservices.oas.OasResponse;
import com.intellij.microservices.oas.OasSchema;
import com.intellij.microservices.oas.OasSchemaType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UMethod;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002\u001a0\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\n2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002\u001a$\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002\u001a\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0007H\u0002\u001a\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002\u001a$\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a8\u0006\u001e"}, d2={"getSwDocumentedResponses", "", "Lcom/intellij/microservices/oas/OasResponse;", "uMethod", "Lorg/jetbrains/uast/UMethod;", "schemas", "", "", "Lcom/intellij/microservices/oas/OasSchema;", "getMethodResponses", "Lcom/intellij/microservices/jvm/oas/v3/SwApiResponse;", "getClassResponses", "getDescription", "response", "code", "generateFromSwContent", "", "Lcom/intellij/microservices/oas/OasMediaTypeObject;", "apiResponse", "generateSchema", "schema", "Lcom/intellij/microservices/jvm/oas/v3/SwSchema;", "tryToRetrieveSchemaType", "Lcom/intellij/microservices/oas/OasSchemaType;", "type", "tryToRetrieveHttpCode", "Lcom/intellij/microservices/http/HttpCode;", "getDetailedOasSchema", "psiType", "Lcom/intellij/psi/PsiType;", "intellij.microservices.jvm"})
@SourceDebugExtension(value={"SMAP\nSwResponseProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwResponseProvider.kt\ncom/intellij/microservices/jvm/oas/SwResponseProviderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n1220#2,2:100\n1249#2,4:102\n1915#2,2:106\n1586#2:108\n1661#2,3:109\n777#2:113\n873#2,2:114\n1205#2,2:116\n1282#2,4:118\n296#2,2:122\n296#2,2:124\n1#3:112\n*S KotlinDebug\n*F\n+ 1 SwResponseProvider.kt\ncom/intellij/microservices/jvm/oas/SwResponseProviderKt\n*L\n17#1:100,2\n17#1:102,4\n20#1:106,2\n24#1:108\n24#1:109,3\n59#1:113\n59#1:114,2\n60#1:116,2\n60#1:118,4\n87#1:122,2\n91#1:124,2\n*E\n"})
public final class SwResponseProviderKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<OasResponse> getSwDocumentedResponses(@NotNull UMethod uMethod, @NotNull Map<String, OasSchema> schemas) {
        void $this$mapTo$iv$iv;
        SwApiResponse it;
        Object object;
        Iterable $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        Intrinsics.checkNotNullParameter(schemas, (String)"schemas");
        Iterable $this$associateBy$iv = SwResponseProviderKt.getMethodResponses(uMethod);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        Iterator iterator = $this$associateByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            SwApiResponse swApiResponse = (SwApiResponse)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.put(it.getResponseCode(), element$iv$iv);
        }
        Map methodResponsesByCode = MapsKt.toMutableMap((Map)destination$iv$iv);
        List<SwApiResponse> classResponses = SwResponseProviderKt.getClassResponses(uMethod);
        Iterable $this$forEach$iv = classResponses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SwApiResponse classResponse = (SwApiResponse)element$iv;
            boolean bl = false;
            methodResponsesByCode.putIfAbsent(classResponse.getResponseCode(), classResponse);
        }
        Iterable $this$map$iv = methodResponsesByCode.values();
        boolean $i$f$map = false;
        $this$associateByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void response;
            it = (SwApiResponse)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            String string = response.getResponseCode();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getResponseCode(...)");
            String string2 = response.getResponseCode();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getResponseCode(...)");
            object.add(new OasResponse(string, SwResponseProviderKt.getDescription((SwApiResponse)response, string2), SwResponseProviderKt.generateFromSwContent((SwApiResponse)response, schemas), null, 8, null));
        }
        return (List)destination$iv$iv;
    }

    private static final List<SwApiResponse> getMethodResponses(UMethod uMethod) {
        Object object;
        block5: {
            block4: {
                List<SwApiResponse> responses;
                SwApiResponses swApiResponses = (SwApiResponses)SwApiResponses.METHOD_META.getJamElement((PsiModifierListOwner)uMethod.getJavaPsi());
                List<SwApiResponse> list = responses = swApiResponses != null ? swApiResponses.getResponses() : null;
                if (responses != null) {
                    return responses;
                }
                object = (SwApiResponse)SwApiResponse.METHOD_META.getJamElement((PsiModifierListOwner)uMethod.getJavaPsi());
                if (object == null) break block4;
                SwApiResponse it = object;
                boolean bl = false;
                List list2 = CollectionsKt.listOf((Object)it);
                object = list2;
                if (list2 != null) break block5;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final List<SwApiResponse> getClassResponses(UMethod uMethod) {
        Object object;
        block6: {
            block5: {
                List<SwApiResponse> responses;
                PsiClass psiClass = uMethod.getJavaPsi().getContainingClass();
                if (psiClass == null) {
                    return CollectionsKt.emptyList();
                }
                PsiClass containingClass = psiClass;
                SwApiResponses swApiResponses = (SwApiResponses)SwApiResponses.CLASS_META.getJamElement((PsiModifierListOwner)containingClass);
                List<SwApiResponse> list = responses = swApiResponses != null ? swApiResponses.getResponses() : null;
                if (responses != null) {
                    return responses;
                }
                object = (SwApiResponse)SwApiResponse.CLASS_META.getJamElement((PsiModifierListOwner)containingClass);
                if (object == null) break block5;
                SwApiResponse it = object;
                boolean bl = false;
                List list2 = CollectionsKt.listOf((Object)it);
                object = list2;
                if (list2 != null) break block6;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final String getDescription(SwApiResponse response, String code) {
        String description = response.getDescription();
        if (description != null) {
            return description;
        }
        Object object = SwResponseProviderKt.tryToRetrieveHttpCode(code);
        if (object == null || (object = object.getShortDescription()) == null) {
            object = "Unknown description";
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, OasMediaTypeObject> generateFromSwContent(SwApiResponse apiResponse, Map<String, OasSchema> schemas) {
        void $this$associateTo$iv$iv;
        void $this$filterTo$iv$iv;
        List<SwContent> list = apiResponse.getContent();
        if (list == null) {
            return MapsKt.emptyMap();
        }
        List<SwContent> swContent = list;
        Iterable $this$filter$iv = swContent;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SwContent it = (SwContent)element$iv$iv;
            boolean bl = false;
            if (!(it.getSchema() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            SwSchema schema;
            Map map = destination$iv$iv2;
            SwContent content = (SwContent)element$iv$iv;
            boolean bl = false;
            String string = content.getMediaType();
            if (string == null) {
                string = "application/json";
            }
            String mediaType = string;
            Intrinsics.checkNotNull((Object)content.getSchema());
            OasMediaTypeObject mediaTypeObject = new OasMediaTypeObject(SwResponseProviderKt.generateSchema(schema, schemas), MapsKt.emptyMap());
            Pair pair = TuplesKt.to((Object)mediaType, (Object)mediaTypeObject);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    private static final OasSchema generateSchema(SwSchema schema, Map<String, OasSchema> schemas) {
        OasSchemaType oasSchemaType;
        String string = schema.getType();
        if (string != null) {
            String it = string;
            boolean bl = false;
            oasSchemaType = SwResponseProviderKt.tryToRetrieveSchemaType(it);
        } else {
            oasSchemaType = null;
        }
        OasSchemaType type = oasSchemaType;
        PsiClass implementation = schema.getImplementation();
        if (implementation != null) {
            PsiClassType psiClassType = PsiTypesUtil.getClassType((PsiClass)implementation);
            Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"getClassType(...)");
            PsiClassType psiType = psiClassType;
            OasSchema oasSchema = SwResponseProviderKt.getDetailedOasSchema((PsiType)psiType, schemas);
            if (oasSchema != null) {
                return type != null ? oasSchema : OasSchema.copy$default((OasSchema)oasSchema, (OasSchemaType)type, null, null, null, null, null, null, null, (boolean)false, (boolean)false, (int)1022, null);
            }
        }
        return new OasSchema(type, null, null, null, null, schema.getRef(), null, null, false, false, 990, null);
    }

    private static final OasSchemaType tryToRetrieveSchemaType(String type) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = (Iterable)OasSchemaType.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                OasSchemaType it = (OasSchemaType)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getTypeName(), (Object)type) || Intrinsics.areEqual((Object)it.name(), (Object)type))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final HttpCode tryToRetrieveHttpCode(String code) {
        Object v1;
        block1: {
            Iterable $this$firstOrNull$iv = (Iterable)HttpCode.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                HttpCode it = (HttpCode)element$iv;
                boolean bl = false;
                Integer n = StringsKt.toIntOrNull((String)code);
                if (!(n != null && it.getStatusCode() == n.intValue())) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @Nullable
    public static final OasSchema getDetailedOasSchema(@NotNull PsiType psiType, @NotNull Map<String, OasSchema> schemas) {
        OasSchema oasSchema;
        Intrinsics.checkNotNullParameter((Object)psiType, (String)"psiType");
        Intrinsics.checkNotNullParameter(schemas, (String)"schemas");
        Pair pair = JvmSwaggerUtilsKt.getOasSchemaForPsiType$default(psiType, false, 2, null);
        if (pair != null) {
            Pair pair2 = pair;
            boolean bl = false;
            OasSchema paramSchema = (OasSchema)pair2.component1();
            Map generatedSchemas = (Map)pair2.component2();
            schemas.putAll(generatedSchemas);
            oasSchema = paramSchema;
        } else {
            oasSchema = null;
        }
        return oasSchema;
    }
}

