/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.okhttp;

import com.intellij.httpClient.okhttp.minimal.OkHttpConstantsKt;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.microservices.jvm.cache.ProjectCacheValueHolder;
import com.intellij.microservices.jvm.cache.ScopedCacheValueHolder;
import com.intellij.microservices.jvm.okhttp.OkHttp;
import com.intellij.microservices.jvm.okhttp.OkHttpHolder;
import com.intellij.microservices.jvm.okhttp.OkHttpUrl;
import com.intellij.microservices.jvm.okhttp.OkHttpUrlBuilder;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.uast.UastModificationTracker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\u0006\u0010\u0011\u001a\u00020\nJ\u001c\u0010\u0012\u001a\u00020\u00052\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J,\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\t2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u001fH\u0002J\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J&\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u000e2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00170%H\u0002J\u0018\u0010&\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u000eH\u0002J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u000eH\u0002J\u0016\u0010*\u001a\u00020\u000e2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000e0\tH\u0002J\u0018\u0010,\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006-"}, d2={"Lcom/intellij/microservices/jvm/okhttp/OkHttpModel;", "", "<init>", "()V", "hasUsages", "", "project", "Lcom/intellij/openapi/project/Project;", "findHolders", "", "Lcom/intellij/microservices/jvm/okhttp/OkHttpHolder;", "module", "Lcom/intellij/openapi/module/Module;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getEndpoints", "Lcom/intellij/microservices/jvm/okhttp/OkHttpUrl;", "group", "hasApiClassUsages", "query", "Lcom/intellij/microservices/jvm/cache/ScopedCacheValueHolder;", "findEndpoints", "holderPsi", "Lcom/intellij/psi/PsiElement;", "findUrl", "", "apiMethods", "Lcom/intellij/psi/PsiMethod;", "node", "Lorg/jetbrains/uast/UCallExpression;", "urlCollector", "", "findHoldersUnderProgress", "searchMethodHolders", "method", "okhttpScope", "holders", "", "getOkHttpScope", "baseScope", "getUastScope", "originalScope", "unionScope", "scopes", "excludePackages", "intellij.microservices.jvm.okhttp"})
@SourceDebugExtension(value={"SMAP\nOkHttpModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkHttpModel.kt\ncom/intellij/microservices/jvm/okhttp/OkHttpModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,180:1\n1#2:181\n1#2:203\n1586#3:182\n1661#3,3:183\n1586#3:186\n1661#3,3:187\n1642#3,10:192\n1915#3:202\n1916#3:204\n1652#3:205\n37#4,2:190\n*S KotlinDebug\n*F\n+ 1 OkHttpModel.kt\ncom/intellij/microservices/jvm/okhttp/OkHttpModel\n*L\n174#1:203\n121#1:182\n121#1:183,3\n159#1:186\n159#1:187,3\n174#1:192,10\n174#1:202\n174#1:204\n174#1:205\n159#1:190,2\n*E\n"})
public final class OkHttpModel {
    @NotNull
    public static final OkHttpModel INSTANCE = new OkHttpModel();

    private OkHttpModel() {
    }

    public final boolean hasUsages(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ScopedCacheValueHolder scopedCacheValueHolder = new ProjectCacheValueHolder(project);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        return this.hasApiClassUsages(scopedCacheValueHolder, globalSearchScope);
    }

    @NotNull
    public final List<OkHttpHolder> findHolders(@NotNull Module module, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return this.findHoldersUnderProgress(module, scope);
    }

    @NotNull
    public final List<OkHttpUrl> getEndpoints(@NotNull OkHttpHolder group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        PsiElement psiElement = group.getPsiElement();
        Project project = psiElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile virtualFile = psiElement.getContainingFile().getVirtualFile();
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)project2);
        if (ProjectScope.getLibrariesScope((Project)project2).contains(virtualFile)) {
            Object object = cachedValuesManager.getCachedValue((UserDataHolder)psiElement, () -> OkHttpModel.getEndpoints$lambda$0(psiElement, project2));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
            return (List)object;
        }
        Object object = cachedValuesManager.getCachedValue((UserDataHolder)psiElement, () -> OkHttpModel.getEndpoints$lambda$1(psiElement, project2));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    private final boolean hasApiClassUsages(ScopedCacheValueHolder<?> query, GlobalSearchScope scope) {
        List<PsiClass> apiClasses = OkHttp.INSTANCE.getApiClasses(query);
        if (apiClasses.isEmpty()) {
            return false;
        }
        GlobalSearchScope okhttp3Scope = this.getOkHttpScope(query.getProject(), scope);
        if (Intrinsics.areEqual((Object)okhttp3Scope, (Object)GlobalSearchScope.EMPTY_SCOPE)) {
            return false;
        }
        return !Intrinsics.areEqual((Object)okhttp3Scope, (Object)GlobalSearchScope.EMPTY_SCOPE);
    }

    private final List<OkHttpUrl> findEndpoints(PsiElement holderPsi) {
        UElement uElement = UastContextKt.toUElement((PsiElement)holderPsi);
        if (uElement == null) {
            return CollectionsKt.emptyList();
        }
        UElement parent = uElement;
        Project project = holderPsi.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        List<PsiMethod> apiMethods = OkHttp.INSTANCE.getUrlApiMethods(project);
        if (apiMethods.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ArrayList<OkHttpUrl> urls = new ArrayList<OkHttpUrl>();
        parent.accept((UastVisitor)new AbstractUastVisitor(apiMethods, urls){
            final /* synthetic */ List<PsiMethod> $apiMethods;
            final /* synthetic */ ArrayList<OkHttpUrl> $urls;
            {
                this.$apiMethods = $apiMethods;
                this.$urls = $urls;
            }

            public boolean visitCallExpression(UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (Intrinsics.areEqual((Object)node.getKind(), (Object)UastCallKind.METHOD_CALL)) {
                    OkHttpModel.access$findUrl(OkHttpModel.INSTANCE, this.$apiMethods, node, this.$urls);
                }
                return super.visitCallExpression(node);
            }
        });
        return urls;
    }

    private final void findUrl(List<? extends PsiMethod> apiMethods, UCallExpression node, List<OkHttpUrl> urlCollector) {
        Object v5;
        PsiElement sourcePsi;
        Object methodName;
        block10: {
            Object object = node.getMethodIdentifier();
            if (object == null || (object = object.getName()) == null) {
                return;
            }
            methodName = object;
            if (!OkHttpConstantsKt.getURL_RECEIVER_NAMES().contains(methodName)) {
                return;
            }
            if (node.getValueArgumentCount() != 1) {
                return;
            }
            UExpression uExpression = node.getArgumentForParameter(0);
            if (uExpression == null) {
                return;
            }
            UExpression argument = uExpression;
            PsiElement psiElement = argument.getSourcePsi();
            if (psiElement == null) {
                return;
            }
            sourcePsi = psiElement;
            PsiMethod psiMethod = node.resolve();
            if (psiMethod == null) {
                return;
            }
            PsiMethod callExprMethod = psiMethod;
            if (!callExprMethod.hasModifier(JvmModifier.PUBLIC)) {
                return;
            }
            PsiClass psiClass = callExprMethod.getContainingClass();
            if (psiClass == null) {
                return;
            }
            PsiClass callTargetClass = psiClass;
            PsiManager psiManager = callExprMethod.getManager();
            Sequence sequence2 = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)apiMethods), OkHttpModel::findUrl$lambda$0);
            for (Object e : sequence2) {
                PsiClass it = (PsiClass)e;
                boolean bl = false;
                if (!psiManager.areElementsEquivalent((PsiElement)callTargetClass, (PsiElement)it)) continue;
                v5 = e;
                break block10;
            }
            v5 = null;
        }
        PsiClass apiClass = v5;
        if (apiClass == null) {
            return;
        }
        CollectionsKt.addAll((Collection)urlCollector, (Iterable)OkHttpUrlBuilder.INSTANCE.collectUrls(node, sourcePsi, (String)methodName));
    }

    /*
     * WARNING - void declaration
     */
    private final List<OkHttpHolder> findHoldersUnderProgress(Module module, GlobalSearchScope scope) {
        void $this$mapTo$iv$iv;
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        List<PsiMethod> apiMethods = OkHttp.INSTANCE.getUrlApiMethods(project);
        if (apiMethods.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Project project2 = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        GlobalSearchScope okhttpScope = this.getOkHttpScope(project2, scope);
        if (Intrinsics.areEqual((Object)okhttpScope, (Object)GlobalSearchScope.EMPTY_SCOPE)) {
            return CollectionsKt.emptyList();
        }
        HashSet holders = new HashSet();
        for (PsiMethod method : apiMethods) {
            this.searchMethodHolders(method, okhttpScope, holders);
        }
        Iterable $this$map$iv = holders;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiElement psiElement = (PsiElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new OkHttpHolder((PsiElement)it));
        }
        return (List)destination$iv$iv;
    }

    private final void searchMethodHolders(PsiMethod method, GlobalSearchScope okhttpScope, Set<PsiElement> holders) {
        CacheManager cacheManager = CacheManager.getInstance((Project)method.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)cacheManager, (String)"getInstance(...)");
        CacheManager cacheManager2 = cacheManager;
        Object[] objectArray = cacheManager2.getVirtualFilesWithWord(method.getName(), (short)1, okhttpScope, true);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getVirtualFilesWithWord(...)");
        Object[] methodIdFiles = objectArray;
        if (methodIdFiles.length == 0) {
            return;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope((Project)method.getProject(), (Collection)ArraysKt.toList((Object[])methodIdFiles));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"filesScope(...)");
        GlobalSearchScope methodIdScope = globalSearchScope;
        for (PsiReference usage : MethodReferencesSearch.search((PsiMethod)method, (SearchScope)((SearchScope)methodIdScope), (boolean)true).asIterable()) {
            UAnnotated parent;
            UElement uElement;
            if (UastContextKt.toUElement((PsiElement)usage.getElement()) == null) continue;
            Class[] classArray = new Class[]{UFile.class};
            if ((UAnnotated)UastUtils.getParentOfType((UElement)uElement, (boolean)true, UClass.class, (Class[])classArray) == null) continue;
            PsiElement javaParent = parent.getJavaPsi();
            if (javaParent != null) {
                holders.add(javaParent);
                continue;
            }
            PsiFile file = usage.getElement().getContainingFile();
            if (file == null) continue;
            holders.add((PsiElement)file);
        }
    }

    private final GlobalSearchScope getOkHttpScope(Project project, GlobalSearchScope baseScope) {
        GlobalSearchScope nonBlackListScope = this.excludePackages(project, this.getUastScope(baseScope));
        CacheManager cacheManager = CacheManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)cacheManager, (String)"getInstance(...)");
        CacheManager cacheManager2 = cacheManager;
        Object[] objectArray = cacheManager2.getVirtualFilesWithWord("okhttp3", (short)1, nonBlackListScope, true);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getVirtualFilesWithWord(...)");
        Object[] containingFiles = objectArray;
        if (containingFiles.length == 0) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"EMPTY_SCOPE");
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope((Project)project, (Collection)ArraysKt.toList((Object[])containingFiles));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"filesScope(...)");
        return globalSearchScope;
    }

    /*
     * WARNING - void declaration
     */
    private final GlobalSearchScope getUastScope(GlobalSearchScope originalScope) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = UastLanguagePlugin.Companion.getInstances();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UastLanguagePlugin uastLanguagePlugin = (UastLanguagePlugin)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getLanguage().getAssociatedFileType());
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        LanguageFileType[] fileTypes = thisCollection$iv.toArray(new LanguageFileType[0]);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)originalScope, (FileType[])((FileType[])Arrays.copyOf(fileTypes, fileTypes.length)));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getScopeRestrictedByFileTypes(...)");
        return globalSearchScope;
    }

    private final GlobalSearchScope unionScope(List<? extends GlobalSearchScope> scopes) {
        GlobalSearchScope globalSearchScope;
        if (scopes.isEmpty()) {
            GlobalSearchScope globalSearchScope2 = GlobalSearchScope.EMPTY_SCOPE;
            globalSearchScope = globalSearchScope2;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"EMPTY_SCOPE");
        } else {
            GlobalSearchScope globalSearchScope3 = GlobalSearchScope.union((Collection)scopes);
            globalSearchScope = globalSearchScope3;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope3, (String)"union(...)");
        }
        return globalSearchScope;
    }

    /*
     * WARNING - void declaration
     */
    private final GlobalSearchScope excludePackages(Project project, GlobalSearchScope scope) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        Iterable iterable = OkHttp.INSTANCE.getPACKAGE_SEARCH_BLACK_LIST();
        OkHttpModel okHttpModel = this;
        boolean $i$f$mapNotNull = false;
        void var7_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            GlobalSearchScope globalSearchScope;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String pkg = (String)element$iv$iv;
            boolean bl2 = false;
            if (javaPsiFacade.findPackage(pkg) != null) {
                PsiPackage it;
                boolean bl3 = false;
                globalSearchScope = PackageScope.packageScope((PsiPackage)it, (boolean)false);
            } else {
                globalSearchScope = null;
            }
            if (globalSearchScope == null) continue;
            GlobalSearchScope it$iv$iv = globalSearchScope;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        GlobalSearchScope excludedPackagesScope = okHttpModel.unionScope((List)destination$iv$iv);
        GlobalSearchScope globalSearchScope = scope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)excludedPackagesScope));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"intersectWith(...)");
        return globalSearchScope;
    }

    private static final CachedValueProvider.Result getEndpoints$lambda$0(PsiElement $psiElement, Project $project) {
        return CachedValueProvider.Result.createSingleDependency(INSTANCE.findEndpoints($psiElement), (Object)JavaLibraryModificationTracker.getInstance((Project)$project));
    }

    private static final CachedValueProvider.Result getEndpoints$lambda$1(PsiElement $psiElement, Project $project) {
        return CachedValueProvider.Result.createSingleDependency(INSTANCE.findEndpoints($psiElement), (Object)UastModificationTracker.Companion.getInstance($project));
    }

    private static final PsiClass findUrl$lambda$0(PsiMethod it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getContainingClass();
    }

    public static final /* synthetic */ void access$findUrl(OkHttpModel $this, List apiMethods, UCallExpression node, List urlCollector) {
        $this.findUrl(apiMethods, node, urlCollector);
    }
}

