/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmIrAttributesKt;
import org.jetbrains.kotlin.backend.jvm.MultifileFacadesKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrInlineUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitor;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u0015H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ResolveInlineCalls;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitCall", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "resolveMultiFileFacadeMember", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "backend.jvm.lower"})
public final class ResolveInlineCalls
extends IrVisitorVoid
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public ResolveInlineCalls(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        irFile.acceptChildren((IrVisitor)this, null);
    }

    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.acceptChildren((IrVisitor)this, null);
    }

    public void visitCall(@NotNull IrCall expression2) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            expression2.acceptChildren((IrVisitor)this, null);
            if (!JvmIrInlineUtilsKt.isInlineFunctionCall(expression2.getSymbol().getOwner(), this.context)) {
                return;
            }
            IrSimpleFunction maybeFakeOverrideOfMultiFileBridge = (IrSimpleFunction)expression2.getSymbol().getOwner();
            IrSimpleFunction irSimpleFunction = this.resolveMultiFileFacadeMember((IrFunction)maybeFakeOverrideOfMultiFileBridge);
            if (irSimpleFunction == null && (irSimpleFunction = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride$default((IrOverridableDeclaration)((IrOverridableDeclaration)maybeFakeOverrideOfMultiFileBridge), null, (int)1, null)) == null) {
                return;
            }
            IrSimpleFunction resolved = irSimpleFunction;
            expression2.setSymbol(resolved.getSymbol());
            IrExpression irExpression = expression2.getDispatchReceiver();
            if (irExpression == null) break block2;
            IrExpression receiver = irExpression;
            boolean bl = false;
            IrSimpleType receiverType = IrUtilsKt.getDefaultType((IrClass)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)resolved)));
            expression2.setDispatchReceiver((IrExpression)BuildersKt.IrTypeOperatorCallImpl((int)receiver.getStartOffset(), (int)receiver.getEndOffset(), (IrType)((IrType)receiverType), (IrTypeOperator)IrTypeOperator.IMPLICIT_CAST, (IrType)((IrType)receiverType), (IrExpression)receiver));
        }
    }

    private final IrSimpleFunction resolveMultiFileFacadeMember(IrFunction $this$resolveMultiFileFacadeMember) {
        return MultifileFacadesKt.isMultifileBridge($this$resolveMultiFileFacadeMember) && $this$resolveMultiFileFacadeMember instanceof IrSimpleFunction ? JvmIrAttributesKt.getMultifileFacadePartMember((IrSimpleFunction)$this$resolveMultiFileFacadeMember) : null;
    }
}

