/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.wasm.BackendWasmSymbols;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsLoweredDeclarationOrigin;
import org.jetbrains.kotlin.ir.backend.js.ir.ExportUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.tsexport.ExportedClass;
import org.jetbrains.kotlin.ir.backend.js.tsexport.ExportedConstructor;
import org.jetbrains.kotlin.ir.backend.js.tsexport.ExportedDeclaration;
import org.jetbrains.kotlin.ir.backend.js.tsexport.ExportedFunction;
import org.jetbrains.kotlin.ir.backend.js.tsexport.ExportedMemberName;
import org.jetbrains.kotlin.ir.backend.js.tsexport.ExportedModule;
import org.jetbrains.kotlin.ir.backend.js.tsexport.ExportedNamespace;
import org.jetbrains.kotlin.ir.backend.js.tsexport.ExportedObject;
import org.jetbrains.kotlin.ir.backend.js.tsexport.ExportedParameter;
import org.jetbrains.kotlin.ir.backend.js.tsexport.ExportedProperty;
import org.jetbrains.kotlin.ir.backend.js.tsexport.ExportedRegularClass;
import org.jetbrains.kotlin.ir.backend.js.tsexport.ExportedType;
import org.jetbrains.kotlin.ir.backend.js.tsexport.ExportedTypeParameter;
import org.jetbrains.kotlin.ir.backend.js.tsexport.ExportedVisibility;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrPossiblyExternalDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.js.config.ModuleKind;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\fH\u0002J\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\fJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001c\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020&H\u0002J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J\u0012\u00100\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0010\u00101\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u000202H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010$\u001a\u0012\u0012\u0004\u0012\u00020&0%j\b\u0012\u0004\u0012\u00020&`'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u00103\u001a\u000204*\u0002058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00106\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/export/ExportModelGenerator;", "", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "excludedFromExport", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "collectAllTheDeclarationsToExport", "", "modules", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "generateExport", "Lorg/jetbrains/kotlin/ir/backend/js/tsexport/ExportedModule;", "exportDeclaration", "Lorg/jetbrains/kotlin/ir/backend/js/tsexport/ExportedDeclaration;", "declaration", "exportFunction", "Lorg/jetbrains/kotlin/ir/backend/js/tsexport/ExportedFunction;", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "exportConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "exportProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "specializeType", "Lorg/jetbrains/kotlin/ir/backend/js/tsexport/ExportedType;", "exportParameter", "Lorg/jetbrains/kotlin/ir/backend/js/tsexport/ExportedParameter;", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "currentlyProcessedTypes", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lkotlin/collections/HashSet;", "exportType", "type", "exportTypeArgument", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "exportTypeParameter", "Lorg/jetbrains/kotlin/ir/backend/js/tsexport/ExportedTypeParameter;", "typeParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "exportMemberDeclaration", "exportClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "isInterface", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "(Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;)Z", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nExportModelGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportModelGenerator.kt\norg/jetbrains/kotlin/backend/wasm/export/ExportModelGenerator\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 6 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n+ 7 IrUtils.kt\norg/jetbrains/kotlin/ir/util/IrUtilsKt\n*L\n1#1,352:1\n1342#2,2:353\n1642#3,10:355\n1915#3:365\n1916#3:367\n1652#3:368\n1661#3,3:371\n777#3:374\n873#3,2:375\n1661#3,3:378\n777#3:382\n873#3,2:383\n1661#3,3:386\n1661#3,2:390\n1663#3:393\n1661#3,3:395\n2829#3,7:398\n1661#3,3:406\n777#3:409\n873#3,2:410\n1586#3:412\n1661#3,3:413\n873#3,2:417\n1651#3:420\n1915#3:421\n1916#3:423\n1652#3:424\n1#4:366\n1#4:381\n1#4:422\n245#5:369\n16#6:370\n16#6:377\n16#6:385\n16#6:389\n16#6:394\n16#6:405\n48#6:416\n32#6:419\n369#7:392\n*S KotlinDebug\n*F\n+ 1 ExportModelGenerator.kt\norg/jetbrains/kotlin/backend/wasm/export/ExportModelGenerator\n*L\n56#1:353,2\n118#1:355,10\n118#1:365\n118#1:367\n118#1:368\n135#1:371,3\n140#1:374\n140#1:375,2\n141#1:378,3\n147#1:382\n147#1:383,2\n149#1:386,3\n208#1:390,2\n208#1:393\n230#1:395,3\n276#1:398,7\n293#1:406,3\n301#1:409\n301#1:410,2\n302#1:412\n302#1:413,3\n303#1:417,2\n306#1:420\n306#1:421\n306#1:423\n306#1:424\n118#1:366\n306#1:422\n130#1:369\n135#1:370\n141#1:377\n149#1:385\n208#1:389\n230#1:394\n293#1:405\n303#1:416\n306#1:419\n210#1:392\n*E\n"})
public final class ExportModelGenerator {
    @NotNull
    private final WasmBackendContext context;
    @NotNull
    private final Set<IrDeclaration> excludedFromExport;
    @NotNull
    private final HashSet<IrType> currentlyProcessedTypes;

    public ExportModelGenerator(@NotNull WasmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        Object[] objectArray = new IrDeclaration[]{this.context.getWasmSymbols().getJsRelatedSymbols().getJsReferenceClass().getOwner(), IrTypesKt.getClassOrFail((IrType)this.context.getWasmSymbols().getJsRelatedSymbols().getJsAnyType()).getOwner(), IrTypesKt.getClassOrFail((IrType)this.context.getWasmSymbols().getJsRelatedSymbols().getJsNumberType()).getOwner(), IrTypesKt.getClassOrFail((IrType)this.context.getWasmSymbols().getJsRelatedSymbols().getJsStringType()).getOwner(), IrTypesKt.getClassOrFail((IrType)this.context.getWasmSymbols().getJsRelatedSymbols().getJsBooleanType()).getOwner(), IrTypesKt.getClassOrFail((IrType)this.context.getWasmSymbols().getJsRelatedSymbols().getJsBigIntType()).getOwner()};
        this.excludedFromExport = SetsKt.setOf((Object[])objectArray);
        this.currentlyProcessedTypes = new HashSet();
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<IrDeclaration> collectAllTheDeclarationsToExport(Iterable<? extends IrModuleFragment> modules) {
        void $this$forEach$iv;
        ArrayDeque arrayDeque;
        Set declarationsToExport = new LinkedHashSet();
        ArrayDeque $this$collectAllTheDeclarationsToExport_u24lambda_u240 = arrayDeque = new ArrayDeque();
        boolean bl = false;
        Sequence sequence = SequencesKt.filter((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence(modules), ExportModelGenerator::collectAllTheDeclarationsToExport$lambda$0$0), ExportModelGenerator::collectAllTheDeclarationsToExport$lambda$0$1), ExportModelGenerator::collectAllTheDeclarationsToExport$lambda$0$2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrDeclaration it = (IrDeclaration)element$iv;
            boolean bl2 = false;
            declarationsToExport.add(it);
            $this$collectAllTheDeclarationsToExport_u24lambda_u240.addLast((Object)it);
        }
        ArrayDeque queue = arrayDeque;
        IrVisitorVoid declarationVisitor2 = new IrVisitorVoid(this, declarationsToExport, (ArrayDeque<IrDeclaration>)queue){
            final /* synthetic */ ExportModelGenerator this$0;
            final /* synthetic */ Set<IrDeclaration> $declarationsToExport;
            final /* synthetic */ ArrayDeque<IrDeclaration> $queue;
            {
                this.this$0 = $receiver;
                this.$declarationsToExport = $declarationsToExport;
                this.$queue = $queue;
            }

            public void visitFunction(IrFunction declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                this.visitType(declaration.getReturnType());
                Iterable $this$forEach$iv = declaration.getTypeParameters();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    IrTypeParameter p0 = (IrTypeParameter)element$iv;
                    boolean bl = false;
                    this.visitTypeParameter(p0);
                }
                $this$forEach$iv = declaration.getParameters();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    IrValueParameter it = (IrValueParameter)element$iv;
                    boolean bl = false;
                    if (it.getKind() == IrParameterKind.DispatchReceiver) continue;
                    this.visitValueParameter(it);
                }
            }

            public void visitClass(IrClass declaration) {
                IrType p0;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                Iterable $this$forEach$iv = declaration.getSuperTypes();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    p0 = (IrType)element$iv;
                    boolean bl = false;
                    this.visitType(p0);
                }
                $this$forEach$iv = declaration.getTypeParameters();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    p0 = (IrTypeParameter)element$iv;
                    boolean bl = false;
                    this.visitTypeParameter((IrTypeParameter)p0);
                }
                $this$forEach$iv = declaration.getDeclarations();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    IrDeclaration it = (IrDeclaration)element$iv;
                    boolean bl = false;
                    IrVisitorsKt.acceptVoid((IrElement)((IrElement)it), (IrVisitorVoid)this);
                }
            }

            public void visitProperty(IrProperty declaration) {
                block1: {
                    IrField p0;
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    IrField irField = declaration.getBackingField();
                    if (irField != null) {
                        p0 = irField;
                        boolean bl = false;
                        this.visitField(p0);
                    }
                    IrSimpleFunction irSimpleFunction = declaration.getGetter();
                    if (irSimpleFunction == null) break block1;
                    p0 = (IrFunction)irSimpleFunction;
                    boolean bl = false;
                    this.visitFunction((IrFunction)p0);
                }
            }

            public void visitField(IrField declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                this.visitType(declaration.getType());
            }

            public void visitValueParameter(IrValueParameter declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                this.visitType(declaration.getType());
            }

            public void visitTypeParameter(IrTypeParameter declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                Iterable $this$forEach$iv = declaration.getSuperTypes();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    IrType p0 = (IrType)element$iv;
                    boolean bl = false;
                    this.visitType(p0);
                }
            }

            private final void visitType(IrType type) {
                if (!(type instanceof IrSimpleType)) {
                    return;
                }
                IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)type).getClassifier();
                IrClassSymbol irClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
                if (irClassSymbol == null) {
                    return;
                }
                IrClassSymbol classifier = irClassSymbol;
                IrClass klass = (IrClass)classifier.getOwner();
                if (!klass.isExternal() || ExportModelGenerator.access$getExcludedFromExport$p(this.this$0).contains(klass) || this.$declarationsToExport.contains(klass)) {
                    return;
                }
                this.$queue.add((Object)klass);
                this.$declarationsToExport.add((IrDeclaration)klass);
                Iterable $this$forEach$iv = ((IrSimpleType)type).getArguments();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    IrType p0;
                    IrTypeArgument it = (IrTypeArgument)element$iv;
                    boolean bl = false;
                    if (IrTypesKt.getTypeOrNull((IrTypeArgument)it) == null) continue;
                    boolean bl2 = false;
                    this.visitType(p0);
                }
            }
        };
        while (!((Collection)queue).isEmpty()) {
            IrDeclaration declaration = (IrDeclaration)queue.removeFirst();
            IrVisitorsKt.acceptVoid((IrElement)((IrElement)declaration), (IrVisitorVoid)declarationVisitor2);
        }
        return declarationsToExport;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ExportedModule generateExport(@NotNull Iterable<? extends IrModuleFragment> modules) {
        List list;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Object object = this.context.getConfiguration().get(CommonConfigurationKeys.MODULE_NAME);
        Intrinsics.checkNotNull((Object)object);
        Iterable<IrDeclaration> iterable = this.collectAllTheDeclarationsToExport(modules);
        ModuleKind moduleKind = ModuleKind.ES;
        String string = (String)object;
        boolean $i$f$mapNotNull = false;
        void var4_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ExportedDeclaration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrDeclaration p0 = (IrDeclaration)element$iv$iv;
            boolean bl2 = false;
            if (this.exportDeclaration(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = list = (List)destination$iv$iv;
        ModuleKind moduleKind2 = moduleKind;
        String string2 = string;
        return new ExportedModule(string2, moduleKind2, list2);
    }

    private final ExportedDeclaration exportDeclaration(IrDeclaration declaration) {
        ExportedDeclaration exportedDeclaration;
        IrDeclaration irDeclaration = declaration;
        if (irDeclaration instanceof IrSimpleFunction) {
            exportedDeclaration = (ExportedDeclaration)this.exportFunction((IrSimpleFunction)declaration);
        } else if (irDeclaration instanceof IrClass) {
            exportedDeclaration = this.exportClass((IrClass)declaration);
        } else {
            throw new IllegalStateException(("Can't export declaration " + declaration).toString());
        }
        ExportedDeclaration exportedDeclaration2 = exportedDeclaration;
        return exportedDeclaration2 != null ? ExportModelGeneratorKt.access$withAttributesFor(exportedDeclaration2, declaration) : null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ExportedFunction exportFunction(IrSimpleFunction function2) {
        void $this$mapTo$iv$iv;
        void $this$memoryOptimizedMap$iv;
        IrValueParameter it;
        Iterable $this$filterTo$iv$iv;
        Iterable p0;
        Collection collection;
        void $this$mapTo$iv$iv2;
        if (function2.getCorrespondingPropertySymbol() != null) return null;
        IrClass irClass = IrUtilsKt.getParentClassOrNull((IrDeclaration)((IrDeclaration)IrResolveUtilsKt.getRealOverrideTarget(function2)));
        if (Intrinsics.areEqual((Object)(irClass != null ? irClass.getSymbol() : null), (Object)this.context.getIrBuiltIns().getAnyClass())) return null;
        boolean bl = true;
        boolean condition$iv = bl;
        boolean $i$f$runIf = false;
        if (!condition$iv) return null;
        boolean bl2 = false;
        IrClass parentClass = IrUtilsKt.getParentClassOrNull((IrDeclaration)((IrDeclaration)function2));
        ExportedMemberName.Identifier identifier = new ExportedMemberName.Identifier(ExportUtilsKt.getExportedIdentifier((IrDeclarationWithName)function2));
        ExportedType exportedType = this.exportType(function2.getReturnType());
        Collection $this$memoryOptimizedMap$iv2 = function2.getTypeParameters();
        boolean $i$f$memoryOptimizedMap = false;
        Iterable iterable = $this$memoryOptimizedMap$iv2;
        Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv2.size());
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(this.exportTypeParameter((IrTypeParameter)p0));
        }
        List list = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)((List)destination$iv$iv));
        boolean bl4 = parentClass != null;
        boolean bl5 = IrDeclarationsKt.isStaticMethodOfClass((IrFunction)((IrFunction)function2));
        boolean bl6 = Intrinsics.areEqual((Object)function2.getVisibility(), (Object)DescriptorVisibilities.PROTECTED);
        boolean bl7 = parentClass != null && !IrUtilsKt.isInterface((IrClass)parentClass) && function2.getModality() == Modality.ABSTRACT;
        Iterable $this$filter$iv = function2.getParameters();
        boolean $i$f$filter = false;
        p0 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrValueParameter)element$iv$iv;
            boolean bl8 = false;
            if (!(it.getKind() != IrParameterKind.DispatchReceiver)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$memoryOptimizedMap2 = false;
        $this$filterTo$iv$iv = (Iterable)$this$memoryOptimizedMap$iv;
        destination$iv$iv2 = new ArrayList($this$memoryOptimizedMap$iv.size());
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IrValueParameter)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl9 = false;
            collection.add(this.exportParameter(it));
        }
        List list2 = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)((List)destination$iv$iv2));
        ExportedFunction exportedFunction = new ExportedFunction((ExportedMemberName)identifier, exportedType, list2, list, bl4, bl5, bl7, bl6);
        return exportedFunction;
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedDeclaration exportConstructor(IrConstructor constructor) {
        void $this$mapTo$iv$iv;
        IrValueParameter it;
        Iterable $this$filterTo$iv$iv;
        boolean bl = constructor.isPrimary();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ExportModelGenerator$exportConstructor$22 = false;
            String $i$a$-assert-ExportModelGenerator$exportConstructor$22 = "Can't export not-primary constructor";
            throw new AssertionError((Object)$i$a$-assert-ExportModelGenerator$exportConstructor$22);
        }
        Iterable $this$filter$iv = constructor.getParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrValueParameter)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getKind() != IrParameterKind.DispatchReceiver)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allValueParameters = (List)destination$iv$iv;
        Collection $this$memoryOptimizedMap$iv = allValueParameters;
        boolean $i$f$memoryOptimizedMap = false;
        $this$filterTo$iv$iv = $this$memoryOptimizedMap$iv;
        destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(this.exportParameter(it));
        }
        ExportedVisibility exportedVisibility = org.jetbrains.kotlin.ir.backend.js.tsexport.ExportModelGeneratorKt.toExportedVisibility(constructor.getVisibility());
        List list = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)((List)destination$iv$iv));
        return (ExportedDeclaration)new ExportedConstructor(list, exportedVisibility);
    }

    /*
     * Unable to fully structure code
     */
    private final ExportedDeclaration exportProperty(IrProperty property, ExportedType specializeType) {
        var4_3 = property.getParent();
        v0 = parentClass = var4_3 instanceof IrClass != false ? (IrClass)var4_3 : null;
        if (parentClass == null) ** GOTO lbl-1000
        v1 = property.getGetter();
        v2 = v1 != null && (v1 = v1.getReturnType()) != null ? IrTypeUtilsKt.isNullable((IrType)v1) : false;
        if (v2) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        isOptional = v3;
        var5_6 = new ExportedMemberName.Identifier(ExportUtilsKt.getExportedIdentifier((IrDeclarationWithName)property));
        v4 = specializeType;
        if (v4 == null) {
            v5 = property.getGetter();
            Intrinsics.checkNotNull((Object)v5);
            v4 = this.exportType(v5.getReturnType());
        }
        var6_7 = v4;
        var7_8 = property.isVar();
        var8_9 = parentClass != null;
        v6 = parentClass;
        var9_10 = (v6 != null ? !IrUtilsKt.isInterface((IrClass)v6) : false) != false && property.getModality() == Modality.ABSTRACT;
        var10_11 = Intrinsics.areEqual((Object)property.getVisibility(), (Object)DescriptorVisibilities.PROTECTED);
        v7 = parentClass;
        var11_12 = v7 != null ? IrUtilsKt.isInterface((IrClass)v7) : false;
        v8 = property.getGetter();
        var12_13 = Intrinsics.areEqual((Object)(v8 != null ? v8.getOrigin() : null), (Object)JsLoweredDeclarationOrigin.INSTANCE.getOBJECT_GET_INSTANCE_FUNCTION());
        v9 = property.getGetter();
        if (v9 == null) {
            v9 = property.getSetter();
        }
        var13_14 = v9 != null ? IrDeclarationsKt.isStaticMethodOfClass((IrFunction)((IrFunction)v9)) : false;
        return (ExportedDeclaration)new ExportedProperty((ExportedMemberName)var5_6, var6_7, var7_8, var8_9, var13_14, var9_10, var10_11, var11_12, var12_13, isOptional, false, 1024, null);
    }

    static /* synthetic */ ExportedDeclaration exportProperty$default(ExportModelGenerator exportModelGenerator, IrProperty irProperty, ExportedType exportedType, int n, Object object) {
        if ((n & 2) != 0) {
            exportedType = null;
        }
        return exportModelGenerator.exportProperty(irProperty, exportedType);
    }

    private final ExportedParameter exportParameter(IrValueParameter parameter) {
        return new ExportedParameter(parameter.getName().asString(), this.exportType(parameter.getType()), parameter.getDefaultValue() != null);
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedType exportType(IrType type) {
        ExportedType exportedType;
        ExportedType exportedType2;
        boolean isMarkedNullable;
        block13: {
            IrClassifierSymbol classifier;
            block22: {
                void $this$mapTo$iv$iv;
                void $this$memoryOptimizedMap$iv;
                IrTypeArgument fqName$iv;
                Object object;
                Collection destination$iv$iv;
                BackendWasmSymbols.JsRelatedSymbols jsRelatedSymbols;
                block21: {
                    block20: {
                        IrSimpleType nonNullType;
                        block19: {
                            void $this$mapTo$iv$iv2;
                            block18: {
                                block17: {
                                    block16: {
                                        block15: {
                                            block14: {
                                                block12: {
                                                    if (this.currentlyProcessedTypes.contains(type)) {
                                                        return (ExportedType)ExportedType.Primitive.Unknown.INSTANCE;
                                                    }
                                                    if (!(type instanceof IrSimpleType)) {
                                                        return (ExportedType)new ExportedType.ErrorType("NonSimpleType " + RenderIrElementKt.render$default((IrType)type, null, (int)1, null));
                                                    }
                                                    this.currentlyProcessedTypes.add(type);
                                                    classifier = ((IrSimpleType)type).getClassifier();
                                                    isMarkedNullable = IrTypePredicatesKt.isMarkedNullable((IrSimpleType)((IrSimpleType)type));
                                                    IrType irType = IrTypesKt.makeNotNull((IrType)type);
                                                    Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
                                                    nonNullType = (IrSimpleType)irType;
                                                    jsRelatedSymbols = this.context.getWasmSymbols().getJsRelatedSymbols();
                                                    if (!IrTypePredicatesKt.isBoolean((IrType)((IrType)nonNullType)) && !Intrinsics.areEqual((Object)nonNullType, (Object)jsRelatedSymbols.getJsBooleanType())) break block12;
                                                    exportedType2 = (ExportedType)ExportedType.Primitive.Boolean.INSTANCE;
                                                    break block13;
                                                }
                                                if (!IrTypePredicatesKt.isLong((IrType)((IrType)nonNullType)) && !IrTypePredicatesKt.isULong((IrType)((IrType)nonNullType)) && !Intrinsics.areEqual((Object)nonNullType, (Object)jsRelatedSymbols.getJsBigIntType())) break block14;
                                                exportedType2 = (ExportedType)ExportedType.Primitive.BigInt.INSTANCE;
                                                break block13;
                                            }
                                            if (!IrTypePredicatesKt.isPrimitiveType$default((IrType)((IrType)nonNullType), (boolean)false, (int)1, null) && !IrTypePredicatesKt.isUByte((IrType)((IrType)nonNullType)) && !IrTypePredicatesKt.isUShort((IrType)((IrType)nonNullType)) && !IrTypePredicatesKt.isUInt((IrType)((IrType)nonNullType)) && !Intrinsics.areEqual((Object)nonNullType, (Object)jsRelatedSymbols.getJsNumberType())) break block15;
                                            exportedType2 = (ExportedType)ExportedType.Primitive.Number.INSTANCE;
                                            break block13;
                                        }
                                        if (!IrTypePredicatesKt.isString((IrType)((IrType)nonNullType)) && !Intrinsics.areEqual((Object)nonNullType, (Object)jsRelatedSymbols.getJsStringType())) break block16;
                                        exportedType2 = (ExportedType)ExportedType.Primitive.String.INSTANCE;
                                        break block13;
                                    }
                                    if (!Intrinsics.areEqual((Object)nonNullType, (Object)jsRelatedSymbols.getJsAnyType())) break block17;
                                    exportedType2 = (ExportedType)ExportedType.Primitive.Unknown.INSTANCE;
                                    break block13;
                                }
                                if (!IrTypePredicatesKt.isUnit((IrType)((IrType)nonNullType)) && !Intrinsics.areEqual((Object)nonNullType, (Object)this.context.getWasmSymbols().getVoidType())) break block18;
                                exportedType2 = (ExportedType)ExportedType.Primitive.Unit.INSTANCE;
                                break block13;
                            }
                            if (!IrTypeUtilsKt.isFunction((IrType)((IrType)nonNullType))) break block19;
                            Collection $this$memoryOptimizedMap$iv2 = CollectionsKt.dropLast((List)nonNullType.getArguments(), (int)1);
                            boolean $i$f$memoryOptimizedMap = false;
                            Iterable iterable = $this$memoryOptimizedMap$iv2;
                            destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv2.size());
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                                String string;
                                void it;
                                IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
                                object = destination$iv$iv;
                                boolean bl = false;
                                IrTypeProjection irTypeProjection = it instanceof IrTypeProjection ? (IrTypeProjection)it : null;
                                if (irTypeProjection != null && (irTypeProjection = irTypeProjection.getType()) != null) {
                                    void $this$getAnnotationArgumentValue$iv;
                                    IrAnnotationContainer irAnnotationContainer = (IrAnnotationContainer)irTypeProjection;
                                    FqName fqName = StandardNames.FqNames.parameterName;
                                    String argumentName$iv = "name";
                                    boolean $i$f$getAnnotationArgumentValue = false;
                                    string = (String)IrUtilsKt.getAnnotationArgumentValueImpl((IrAnnotationContainer)$this$getAnnotationArgumentValue$iv, (FqName)fqName$iv, (String)argumentName$iv);
                                } else {
                                    string = null;
                                }
                                object.add(new ExportedParameter(string, this.exportTypeArgument((IrTypeArgument)it), false, 4, null));
                            }
                            ExportedType exportedType3 = this.exportTypeArgument((IrTypeArgument)CollectionsKt.last((List)nonNullType.getArguments()));
                            List list = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)((List)destination$iv$iv));
                            exportedType2 = (ExportedType)new ExportedType.Function(list, exportedType3);
                            break block13;
                        }
                        if (!IrTypePredicatesKt.isNothing((IrType)((IrType)nonNullType))) break block20;
                        exportedType2 = (ExportedType)ExportedType.Primitive.Nothing.INSTANCE;
                        break block13;
                    }
                    if (!(classifier instanceof IrTypeParameterSymbol)) break block21;
                    String string = ((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner()).getName().getIdentifier();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifier(...)");
                    exportedType2 = (ExportedType)new ExportedType.TypeParameterRef(new ExportedTypeParameter(string, null, 2, null));
                    break block13;
                }
                if (!(classifier instanceof IrClassSymbol)) break block22;
                IrClass klass = (IrClass)((IrClassSymbol)classifier).getOwner();
                if (Intrinsics.areEqual((Object)klass.getSymbol(), (Object)jsRelatedSymbols.getJsReferenceClass())) {
                    return (ExportedType)ExportedType.Primitive.Unknown.INSTANCE;
                }
                if (!klass.isExternal()) {
                    boolean $i$a$-require-ExportModelGenerator$exportType$exportedType$32 = false;
                    String $i$a$-require-ExportModelGenerator$exportType$exportedType$32 = "Unexpected non-external class: " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)klass));
                    throw new IllegalArgumentException($i$a$-require-ExportModelGenerator$exportType$exportedType$32.toString());
                }
                String name = "not.exported." + IrJsUtilsKt.getFqNameWithJsNameWhenAvailable((IrDeclarationWithName)klass, true, true).asString();
                destination$iv$iv = ((IrSimpleType)type).getArguments();
                object = name;
                boolean $i$f$memoryOptimizedMap = false;
                Iterable iterable = (Iterable)$this$memoryOptimizedMap$iv;
                Collection destination$iv$iv2 = new ArrayList($this$memoryOptimizedMap$iv.size());
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    fqName$iv = (IrTypeArgument)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(this.exportTypeArgument((IrTypeArgument)it));
                }
                ClassId classId = AdditionalIrUtilsKt.getClassId((IrClass)klass);
                List list = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)((List)destination$iv$iv2));
                Object object2 = object;
                ExportedType.ClassType classType = new ExportedType.ClassType((String)object2, list, classId);
                switch (WhenMappings.$EnumSwitchMapping$0[klass.getKind().ordinal()]) {
                    case 1: {
                        exportedType2 = (ExportedType)new ExportedType.TypeOf(classType);
                        break block13;
                    }
                    case 2: 
                    case 3: {
                        exportedType2 = (ExportedType)classType;
                        break block13;
                    }
                    default: {
                        throw new IllegalStateException(("Unexpected class kind " + klass.getKind()).toString());
                    }
                }
            }
            throw new IllegalStateException(("Unexpected classifier " + classifier).toString());
        }
        ExportedType exportedType4 = exportedType2;
        ExportedType it = exportedType = exportedType4.withNullability(isMarkedNullable);
        boolean bl = false;
        this.currentlyProcessedTypes.remove(type);
        return exportedType;
    }

    private final ExportedType exportTypeArgument(IrTypeArgument type) {
        if (type instanceof IrTypeProjection) {
            return this.exportType(((IrTypeProjection)type).getType());
        }
        if (type instanceof IrType) {
            return this.exportType((IrType)type);
        }
        return (ExportedType)new ExportedType.ErrorType("UnknownType " + RenderIrElementKt.render$default((IrTypeArgument)type, null, (int)1, null));
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedTypeParameter exportTypeParameter(IrTypeParameter typeParameter) {
        ExportedType exportedType;
        void $this$exportTypeParameter_u24lambda_u243;
        List constraint = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)typeParameter.getSuperTypes()), arg_0 -> ExportModelGenerator.exportTypeParameter$lambda$0(this, arg_0)), arg_0 -> ExportModelGenerator.exportTypeParameter$lambda$1(this, arg_0)), ExportModelGenerator::exportTypeParameter$lambda$2));
        String string = typeParameter.getName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifier(...)");
        List list = constraint;
        String string2 = string;
        boolean bl = false;
        switch ($this$exportTypeParameter_u24lambda_u243.size()) {
            case 0: {
                exportedType = null;
                break;
            }
            case 1: {
                exportedType = (ExportedType)CollectionsKt.single((List)$this$exportTypeParameter_u24lambda_u243);
                break;
            }
            default: {
                Iterable $this$reduce$iv = (Iterable)$this$exportTypeParameter_u24lambda_u243;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void p1;
                    ExportedType exportedType2 = (ExportedType)iterator$iv.next();
                    ExportedType p0 = (ExportedType)accumulator$iv;
                    boolean bl2 = false;
                    accumulator$iv = new ExportedType.IntersectionType(p0, (ExportedType)p1);
                }
                exportedType = (ExportedType)accumulator$iv;
            }
        }
        ExportedType exportedType3 = exportedType;
        String string3 = string2;
        return new ExportedTypeParameter(string3, exportedType3);
    }

    private final ExportedDeclaration exportMemberDeclaration(IrDeclaration declaration) {
        if (!(declaration instanceof IrDeclarationWithVisibility) || Intrinsics.areEqual((Object)((IrDeclarationWithVisibility)declaration).getVisibility(), (Object)DescriptorVisibilities.PRIVATE)) {
            return null;
        }
        IrDeclarationWithVisibility irDeclarationWithVisibility = (IrDeclarationWithVisibility)declaration;
        ExportedDeclaration exportedDeclaration = irDeclarationWithVisibility instanceof IrSimpleFunction ? (ExportedDeclaration)this.exportFunction((IrSimpleFunction)declaration) : (irDeclarationWithVisibility instanceof IrConstructor ? this.exportConstructor((IrConstructor)declaration) : (irDeclarationWithVisibility instanceof IrProperty ? ExportModelGenerator.exportProperty$default(this, (IrProperty)declaration, null, 2, null) : null));
        return exportedDeclaration != null ? ExportModelGeneratorKt.access$withAttributesFor(exportedDeclaration, declaration) : null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ExportedDeclaration exportClass(IrClass declaration) {
        block13: {
            $this$memoryOptimizedMap$iv = declaration.getTypeParameters();
            $i$f$memoryOptimizedMap = false;
            var5_5 = $this$memoryOptimizedMap$iv;
            destination$iv$iv = new ArrayList<E>($this$memoryOptimizedMap$iv.size());
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var10_22 = (IrTypeParameter)item$iv$iv;
                var22_17 = destination$iv$iv;
                $i$a$-memoryOptimizedMap-ExportModelGenerator$exportClass$typeParameters$1 = false;
                var22_17.add(this.exportTypeParameter((IrTypeParameter)p0));
            }
            typeParameters = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)((List)destination$iv$iv));
            destination$iv$iv = declaration.getSuperTypes();
            for (Iterator<T> var8_11 : destination$iv$iv) {
                it = (IrType)var8_11 /* !! */ ;
                $i$a$-find-ExportModelGenerator$exportClass$superClass$1 = false;
                if (!(Intrinsics.areEqual((Object)it, (Object)this.context.getIrBuiltIns().getAnyType()) == false && this.isInterface(IrTypesKt.getClassifierOrFail((IrType)it)) == false)) continue;
                v0 /* !! */  = var8_11 /* !! */ ;
                break block13;
            }
            v0 /* !! */  = null;
        }
        $i$f$memoryOptimizedMap = (IrType)v0 /* !! */ ;
        if ($i$f$memoryOptimizedMap == null) ** GOTO lbl-1000
        p0 = $i$f$memoryOptimizedMap;
        $i$a$-let-ExportModelGenerator$exportClass$superClass$2 = false;
        $this$mapTo$iv$iv = this.exportType(p0);
        if ($this$mapTo$iv$iv != null) {
            it = destination$iv$iv = $this$mapTo$iv$iv;
            $i$a$-takeIf-ExportModelGenerator$exportClass$superClass$3 = false;
            v1 /* !! */  = it instanceof ExportedType.ErrorType == false ? destination$iv$iv : null;
        } else lbl-1000:
        // 2 sources

        {
            v1 /* !! */  = null;
        }
        superClass = v1 /* !! */ ;
        $this$mapTo$iv$iv = declaration.getSuperTypes();
        $i$f$filter = false;
        it = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrType)element$iv$iv;
            $i$a$-filter-ExportModelGenerator$exportClass$superInterfaces$1 = false;
            if (!(Intrinsics.areEqual((Object)it, (Object)this.context.getWasmSymbols().getJsRelatedSymbols().getJsAnyType()) == false && this.isInterface(IrTypesKt.getClassifierOrFail((IrType)it)) != false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            it = (IrType)item$iv$iv;
            var22_17 = destination$iv$iv;
            $i$a$-map-ExportModelGenerator$exportClass$superInterfaces$2 = false;
            var22_17.add(this.exportType((IrType)p0));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$memoryOptimizedFilter = false;
        $this$mapTo$iv$iv = (Iterable)$this$memoryOptimizedFilter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (ExportedType)element$iv$iv;
            $i$a$-memoryOptimizedFilter-ExportModelGenerator$exportClass$superInterfaces$3 = false;
            if (!(it instanceof ExportedType.ErrorType == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        superInterfaces = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)((List)destination$iv$iv));
        name = ExportUtilsKt.getExportedIdentifier((IrDeclarationWithName)declaration);
        $this$memoryOptimizedMapNotNull$iv = declaration.getDeclarations();
        $i$f$memoryOptimizedMapNotNull = false;
        $i$f$filterTo = $this$memoryOptimizedMapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var14_40 = $this$forEach$iv$iv$iv.iterator();
        while (var14_40.hasNext()) {
            element$iv$iv = element$iv$iv$iv = var14_40.next();
            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
            p0 = (IrDeclaration)element$iv$iv;
            $i$a$-memoryOptimizedMapNotNull-ExportModelGenerator$exportClass$members$1 = false;
            if (this.exportMemberDeclaration(p0) == null) continue;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        members = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)((List)destination$iv$iv));
        if (declaration.getKind() == ClassKind.OBJECT) {
            $i$f$memoryOptimizedMapNotNull = CollectionsKt.listOfNotNull(superClass);
            var9_20 = CollectionsKt.emptyList();
            var10_24 = AdditionalIrUtilsKt.getClassId((IrClass)declaration);
            var11_30 = IrUtilsKt.isEffectivelyExternal((IrPossiblyExternalDeclaration)((IrPossiblyExternalDeclaration)declaration));
            $this$forEach$iv$iv$iv = declaration.isCompanion();
            $i$f$forEach = IrUtilsKt.isTopLevel((IrDeclaration)((IrDeclaration)declaration));
            v2 = (ExportedClass)new ExportedObject(name, $i$f$memoryOptimizedMapNotNull, superInterfaces, members, var9_20, null, var10_24, var11_30, $this$forEach$iv$iv$iv, $i$f$forEach, 32, null);
        } else {
            $i$f$memoryOptimizedMapNotNull = IrUtilsKt.isInterface((IrClass)declaration);
            var9_21 = declaration.getModality() == Modality.ABSTRACT || declaration.getModality() == Modality.SEALED;
            var10_25 = IrUtilsKt.isEffectivelyExternal((IrPossiblyExternalDeclaration)((IrPossiblyExternalDeclaration)declaration));
            var11_31 = CollectionsKt.listOfNotNull(superClass);
            $this$forEach$iv$iv$iv = CollectionsKt.emptyList();
            $i$f$forEach = AdditionalIrUtilsKt.getClassId((IrClass)declaration);
            v2 = (ExportedClass)new ExportedRegularClass(name, $i$f$memoryOptimizedMapNotNull, var9_21, false, var11_31, superInterfaces, typeParameters, members, $this$forEach$iv$iv$iv, $i$f$forEach, var10_25, 8, null);
        }
        exportedDeclaration = v2;
        parentFqName = FqNamesUtilKt.parentOrNull((FqName)IrJsUtilsKt.getFqNameWithJsNameWhenAvailable((IrDeclarationWithName)declaration, true, true));
        v3 = new StringBuilder().append("not.exported");
        v4 /* !! */  = parentFqName;
        if (v4 /* !! */  == null || (v4 /* !! */  = v4 /* !! */ .asString()) == null) ** GOTO lbl-1000
        $this$forEach$iv$iv$iv /* !! */  = var11_32 /* !! */  = v4 /* !! */ ;
        var23_48 = v3;
        $i$a$-takeIf-ExportModelGenerator$exportClass$1 = false;
        var24_49 = ((CharSequence)it /* !! */ ).length() > 0;
        v3 = var23_48;
        v4 /* !! */  = var24_49 != false ? var11_32 /* !! */  : null;
        if (v4 /* !! */  != null) {
            it /* !! */  = v4 /* !! */ ;
            var23_48 = v3;
            $i$a$-let-ExportModelGenerator$exportClass$2 = false;
            v5 = '.' + (String)it /* !! */ ;
            v3 = var23_48;
        } else lbl-1000:
        // 2 sources

        {
            v5 = v6 = null;
        }
        if (v5 == null) {
            v6 = "";
        }
        var25_50 = true;
        var26_51 = CollectionsKt.listOf((Object)exportedDeclaration);
        var27_52 = v3.append(v6).toString();
        return (ExportedDeclaration)new ExportedNamespace(var27_52, var26_51, var25_50);
    }

    private final boolean isInterface(IrClassifierSymbol $this$isInterface) {
        IrSymbolOwner irSymbolOwner = $this$isInterface.getOwner();
        IrClass irClass = irSymbolOwner instanceof IrClass ? (IrClass)irSymbolOwner : null;
        return irClass != null ? IrUtilsKt.isInterface((IrClass)irClass) : false;
    }

    private static final Iterable collectAllTheDeclarationsToExport$lambda$0$0(IrModuleFragment it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFiles();
    }

    private static final Iterable collectAllTheDeclarationsToExport$lambda$0$1(IrFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDeclarations();
    }

    private static final boolean collectAllTheDeclarationsToExport$lambda$0$2(IrDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AnnotationUtilsKt.isExplicitlyExported((IrAnnotationContainer)it);
    }

    private static final boolean exportTypeParameter$lambda$0(ExportModelGenerator this$0, IrType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !IrTypeUtilsKt.isNullable((IrType)it) || !Intrinsics.areEqual((Object)IrTypesKt.makeNotNull((IrType)it), (Object)this$0.context.getWasmSymbols().getJsRelatedSymbols().getJsAnyType());
    }

    private static final ExportedType exportTypeParameter$lambda$1(ExportModelGenerator this$0, IrType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.exportType(it);
    }

    private static final boolean exportTypeParameter$lambda$2(ExportedType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !(it instanceof ExportedType.ErrorType);
    }

    public static final /* synthetic */ Set access$getExcludedFromExport$p(ExportModelGenerator $this) {
        return $this.excludedFromExport;
    }

    @Metadata(mv={2, 4, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.OBJECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.CLASS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.INTERFACE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

