/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/AbstractNameCharsChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "suggestion", "Lorg/jetbrains/kotlin/js/naming/NameSuggestion;", "<init>", "(Lorg/jetbrains/kotlin/js/naming/NameSuggestion;)V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "js.frontend"})
@SourceDebugExtension(value={"SMAP\nJsNameCharsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsNameCharsChecker.kt\norg/jetbrains/kotlin/js/resolve/diagnostics/AbstractNameCharsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1807#2,3:47\n*S KotlinDebug\n*F\n+ 1 JsNameCharsChecker.kt\norg/jetbrains/kotlin/js/resolve/diagnostics/AbstractNameCharsChecker\n*L\n41#1:47,3\n*E\n"})
public abstract class AbstractNameCharsChecker
implements DeclarationChecker {
    @NotNull
    private final NameSuggestion suggestion;

    public AbstractNameCharsChecker(@NotNull NameSuggestion suggestion) {
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        this.suggestion = suggestion;
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowInvalidCharsIdentifiersEscaping)) {
            return;
        }
        BindingContext bindingContext = context.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        BindingContext bindingContext2 = bindingContext;
        if (descriptor instanceof PropertyAccessorDescriptor && AnnotationsUtils.getJsName(descriptor) == null) {
            return;
        }
        if (descriptor instanceof ConstructorDescriptor && AnnotationsUtils.getJsName(descriptor) == null && AnnotationsUtils.isExportedObject(descriptor, bindingContext2)) {
            return;
        }
        SuggestedName suggestedName = this.suggestion.suggest(descriptor, bindingContext2);
        if (suggestedName == null) {
            return;
        }
        SuggestedName suggestedName2 = suggestedName;
        if (suggestedName2.getStable()) {
            boolean bl;
            block9: {
                Iterable $this$any$iv = suggestedName2.getNames();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!(!Intrinsics.areEqual((Object)NameSuggestion.Companion.sanitizeName(it), (Object)it))) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl) {
                context.getTrace().report(ErrorsJs.NAME_CONTAINS_ILLEGAL_CHARS.on((PsiElement)declaration));
            }
        }
    }
}

