/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.UByteValue;
import org.jetbrains.kotlin.resolve.constants.UIntValue;
import org.jetbrains.kotlin.resolve.constants.ULongValue;
import org.jetbrains.kotlin.resolve.constants.UShortValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.DescriptorAwareStringTable;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0014J\u0012\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/serialization/AnnotationSerializer;", "", "stringTable", "Lorg/jetbrains/kotlin/serialization/DescriptorAwareStringTable;", "<init>", "(Lorg/jetbrains/kotlin/serialization/DescriptorAwareStringTable;)V", "serializeAnnotation", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Annotation;", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "getAnnotationClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "valueProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Annotation$Argument$Value$Builder;", "constant", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "serialization"})
public class AnnotationSerializer {
    @NotNull
    private final DescriptorAwareStringTable stringTable;

    public AnnotationSerializer(@NotNull DescriptorAwareStringTable stringTable) {
        Intrinsics.checkNotNullParameter((Object)stringTable, (String)"stringTable");
        this.stringTable = stringTable;
    }

    @Nullable
    public final ProtoBuf.Annotation serializeAnnotation(@NotNull AnnotationDescriptor annotation) {
        ProtoBuf.Annotation.Builder builder;
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        ProtoBuf.Annotation.Builder $this$serializeAnnotation_u24lambda_u240 = builder = ProtoBuf.Annotation.newBuilder();
        boolean bl = false;
        ClassId classId = this.getAnnotationClassId(annotation);
        if (classId == null) {
            return null;
        }
        ClassId classId2 = classId;
        $this$serializeAnnotation_u24lambda_u240.setId(this.stringTable.getQualifiedClassNameIndex(classId2));
        for (Map.Entry<Name, ConstantValue<?>> entry : annotation.getAllValueArguments().entrySet()) {
            Name name = entry.getKey();
            ConstantValue<?> value = entry.getValue();
            ProtoBuf.Annotation.Argument.Builder argument = ProtoBuf.Annotation.Argument.newBuilder();
            String string = name.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            argument.setNameId(this.stringTable.getStringIndex(string));
            argument.setValue(this.valueProto(value));
            $this$serializeAnnotation_u24lambda_u240.addArgument(argument);
        }
        return builder.build();
    }

    @Nullable
    protected ClassId getAnnotationClassId(@NotNull AnnotationDescriptor annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass(annotation);
        if (classDescriptor == null) {
            throw new IllegalStateException(("Annotation type is not a class: " + annotation.getType()).toString());
        }
        ClassDescriptor annotationClass = classDescriptor;
        if (ErrorUtils.isError(annotationClass)) {
            throw new IllegalStateException(("Unresolved annotation type: " + annotation.getType() + " at " + annotation.getSource().getContainingFile()).toString());
        }
        return DescriptorUtilsKt.getClassId((ClassifierDescriptor)annotationClass);
    }

    @NotNull
    public final ProtoBuf.Annotation.Argument.Value.Builder valueProto(@NotNull ConstantValue<?> constant) {
        ProtoBuf.Annotation.Argument.Value.Builder builder;
        Intrinsics.checkNotNullParameter(constant, (String)"constant");
        ProtoBuf.Annotation.Argument.Value.Builder $this$valueProto_u24lambda_u240 = builder = ProtoBuf.Annotation.Argument.Value.newBuilder();
        boolean bl = false;
        constant.accept(new AnnotationArgumentVisitor<Unit, Unit>($this$valueProto_u24lambda_u240, this){
            final /* synthetic */ ProtoBuf.Annotation.Argument.Value.Builder $this_apply;
            final /* synthetic */ AnnotationSerializer this$0;
            {
                this.$this_apply = $this_apply;
                this.this$0 = $receiver;
            }

            public void visitAnnotationValue(AnnotationValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.ANNOTATION);
                this.$this_apply.setAnnotation(this.this$0.serializeAnnotation((AnnotationDescriptor)value.getValue()));
            }

            public void visitArrayValue(ArrayValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.ARRAY);
                for (ConstantValue element : (List)value.getValue()) {
                    this.$this_apply.addArrayElement(this.this$0.valueProto(element).build());
                }
            }

            public void visitBooleanValue(BooleanValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.BOOLEAN);
                this.$this_apply.setIntValue((Boolean)value.getValue() != false ? 1L : 0L);
            }

            public void visitByteValue(ByteValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.BYTE);
                this.$this_apply.setIntValue((long)((Number)value.getValue()).byteValue());
            }

            public void visitCharValue(CharValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.CHAR);
                this.$this_apply.setIntValue((long)((Character)value.getValue()).charValue());
            }

            public void visitDoubleValue(DoubleValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.DOUBLE);
                this.$this_apply.setDoubleValue(((Number)value.getValue()).doubleValue());
            }

            public void visitEnumValue(EnumValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.ENUM);
                this.$this_apply.setClassId(AnnotationSerializer.access$getStringTable$p(this.this$0).getQualifiedClassNameIndex(value.getEnumClassId()));
                DescriptorAwareStringTable descriptorAwareStringTable = AnnotationSerializer.access$getStringTable$p(this.this$0);
                String string = value.getEnumEntryName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                this.$this_apply.setEnumValueId(descriptorAwareStringTable.getStringIndex(string));
            }

            public void visitErrorValue(ErrorValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                throw new UnsupportedOperationException("Error value: " + value);
            }

            public void visitFloatValue(FloatValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.FLOAT);
                this.$this_apply.setFloatValue(((Number)value.getValue()).floatValue());
            }

            public void visitIntValue(IntValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.INT);
                this.$this_apply.setIntValue((long)((Number)value.getValue()).intValue());
            }

            public void visitKClassValue(KClassValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.CLASS);
                KClassValue.Value classValue = (KClassValue.Value)value.getValue();
                if (classValue instanceof KClassValue.Value.NormalClass) {
                    this.$this_apply.setClassId(AnnotationSerializer.access$getStringTable$p(this.this$0).getQualifiedClassNameIndex(((KClassValue.Value.NormalClass)classValue).getClassId()));
                    if (((KClassValue.Value.NormalClass)classValue).getArrayDimensions() > 0) {
                        this.$this_apply.setArrayDimensionCount(((KClassValue.Value.NormalClass)classValue).getArrayDimensions());
                    }
                } else if (classValue instanceof KClassValue.Value.LocalClass) {
                    int arrayDimensions = 0;
                    KotlinType type = ((KClassValue.Value.LocalClass)classValue).getType();
                    while (KotlinBuiltIns.isArray(type)) {
                        ++arrayDimensions;
                        Intrinsics.checkNotNullExpressionValue((Object)((TypeProjection)CollectionsKt.single(type.getArguments())).getType(), (String)"getType(...)");
                    }
                    ClassifierDescriptor classifierDescriptor = type.getConstructor().getDeclarationDescriptor();
                    ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                    if (classDescriptor == null) {
                        throw new IllegalStateException(("Type parameters are not allowed in class literal annotation arguments: " + classValue).toString());
                    }
                    ClassDescriptor descriptor = classDescriptor;
                    this.$this_apply.setClassId(AnnotationSerializer.access$getStringTable$p(this.this$0).getFqNameIndex(descriptor));
                    if (arrayDimensions > 0) {
                        this.$this_apply.setArrayDimensionCount(arrayDimensions);
                    }
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }

            public void visitLongValue(LongValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.LONG);
                this.$this_apply.setIntValue(((Number)value.getValue()).longValue());
            }

            public void visitNullValue(NullValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                throw new UnsupportedOperationException("Null should not appear in annotation arguments");
            }

            public void visitShortValue(ShortValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.SHORT);
                this.$this_apply.setIntValue((long)((Number)value.getValue()).shortValue());
            }

            public void visitStringValue(StringValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.STRING);
                this.$this_apply.setStringValue(AnnotationSerializer.access$getStringTable$p(this.this$0).getStringIndex((String)value.getValue()));
            }

            public void visitUByteValue(UByteValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.BYTE);
                this.$this_apply.setIntValue((long)((Number)value.getValue()).byteValue());
                this.$this_apply.setFlags(Flags.IS_UNSIGNED.toFlags(Boolean.valueOf(true)));
            }

            public void visitUShortValue(UShortValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.SHORT);
                this.$this_apply.setIntValue((long)((Number)value.getValue()).shortValue());
                this.$this_apply.setFlags(Flags.IS_UNSIGNED.toFlags(Boolean.valueOf(true)));
            }

            public void visitUIntValue(UIntValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.INT);
                this.$this_apply.setIntValue((long)((Number)value.getValue()).intValue());
                this.$this_apply.setFlags(Flags.IS_UNSIGNED.toFlags(Boolean.valueOf(true)));
            }

            public void visitULongValue(ULongValue value, Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.LONG);
                this.$this_apply.setIntValue(((Number)value.getValue()).longValue());
                this.$this_apply.setFlags(Flags.IS_UNSIGNED.toFlags(Boolean.valueOf(true)));
            }
        }, Unit.INSTANCE);
        ProtoBuf.Annotation.Argument.Value.Builder builder2 = builder;
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"apply(...)");
        return builder2;
    }

    public static final /* synthetic */ DescriptorAwareStringTable access$getStringTable$p(AnnotationSerializer $this) {
        return $this.stringTable;
    }
}

