/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.github.exceptions.GithubJsonException;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\f\u001a\u00020\n*\u00020\nH\u0002J\u001e\u0010\r\u001a\u0002H\u000e\"\u0006\b\u0000\u0010\u000e\u0018\u00012\u0006\u0010\u000f\u001a\u00020\u0005H\u0086\b\u00a2\u0006\u0002\u0010\u0010J*\u0010\r\u001a\u0002H\u000e\"\u0006\b\u0000\u0010\u000e\u0018\u00012\u0006\u0010\u000f\u001a\u00020\u00052\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0080\b\u00a2\u0006\u0004\b\u0013\u0010\u0014J3\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00162\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007\u00a2\u0006\u0002\u0010\u0017JO\u0010\u0018\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00162\u001a\u0010\u001b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00160\u001c\"\u0006\u0012\u0002\b\u00030\u00162\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007\u00a2\u0006\u0002\u0010\u001dJ*\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u001f\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0016H\u0007J2\u0010!\u001a\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H#0\"\"\u0004\b\u0000\u0010\u000e\"\u0004\b\u0001\u0010#2\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007J-\u0010$\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010'J\u001a\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00012\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007J\u0017\u0010*\u001a\u00020\n2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0001\u00a2\u0006\u0002\b+J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiContentHelper;", "", "<init>", "()V", "JSON_MIME_TYPE", "", "V3_JSON_MIME_TYPE", "V3_HTML_JSON_MIME_TYPE", "V3_DIFF_JSON_MIME_TYPE", "jackson", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "gqlJackson", "genericConfig", "fromJson", "T", "string", "(Ljava/lang/String;)Ljava/lang/Object;", "gqlNaming", "", "fromJson$intellij_vcs_github", "(Ljava/lang/String;Z)Ljava/lang/Object;", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;Z)Ljava/lang/Object;", "readJsonObject", "reader", "Ljava/io/Reader;", "parameters", "", "(Ljava/io/Reader;Ljava/lang/Class;[Ljava/lang/Class;Z)Ljava/lang/Object;", "readJsonList", "", "parameterClass", "readJsonMap", "", "U", "readJson", "type", "Lcom/fasterxml/jackson/databind/JavaType;", "(Ljava/io/Reader;Lcom/fasterxml/jackson/databind/JavaType;Z)Ljava/lang/Object;", "toJson", "content", "getObjectMapper", "getObjectMapper$intellij_vcs_github", "loadImage", "Ljava/awt/image/BufferedImage;", "stream", "Ljava/io/InputStream;", "intellij.vcs.github"})
public final class GithubApiContentHelper {
    @NotNull
    public static final GithubApiContentHelper INSTANCE = new GithubApiContentHelper();
    @NotNull
    public static final String JSON_MIME_TYPE = "application/json";
    @NotNull
    public static final String V3_JSON_MIME_TYPE = "application/vnd.github.v3+json";
    @NotNull
    public static final String V3_HTML_JSON_MIME_TYPE = "application/vnd.github.v3.html+json";
    @NotNull
    public static final String V3_DIFF_JSON_MIME_TYPE = "application/vnd.github.v3.diff+json";
    @NotNull
    private static final ObjectMapper jackson;
    @NotNull
    private static final ObjectMapper gqlJackson;

    private GithubApiContentHelper() {
    }

    private final ObjectMapper genericConfig(ObjectMapper $this$genericConfig) {
        ObjectMapper objectMapper;
        ObjectMapper $this$genericConfig_u24lambda_u240 = objectMapper = $this$genericConfig;
        boolean bl = false;
        $this$genericConfig_u24lambda_u240.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX"));
        $this$genericConfig_u24lambda_u240.setTimeZone(TimeZone.getDefault());
        $this$genericConfig_u24lambda_u240.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        $this$genericConfig_u24lambda_u240.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        MapperFeature[] mapperFeatureArray = new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS};
        $this$genericConfig_u24lambda_u240.enable(mapperFeatureArray);
        $this$genericConfig_u24lambda_u240.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        $this$genericConfig_u24lambda_u240.setVisibility((VisibilityChecker)new VisibilityChecker.Std(JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.ANY));
        $this$genericConfig_u24lambda_u240.configOverride(List.class).setSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.AS_EMPTY));
        return objectMapper;
    }

    public final /* synthetic */ <T> T fromJson(String string) throws GithubJsonException {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        boolean $i$f$fromJson = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)GithubApiContentHelper.fromJson$default(string, Object.class, false, 4, null);
    }

    public final /* synthetic */ <T> T fromJson$intellij_vcs_github(String string, boolean gqlNaming) throws GithubJsonException {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        boolean $i$f$fromJson$intellij_vcs_github = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)GithubApiContentHelper.fromJson(string, Object.class, gqlNaming);
    }

    public static /* synthetic */ Object fromJson$intellij_vcs_github$default(GithubApiContentHelper $this, String string, boolean gqlNaming, int n, Object object) throws GithubJsonException {
        if ((n & 2) != 0) {
            gqlNaming = false;
        }
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        boolean $i$f$fromJson$intellij_vcs_github = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return GithubApiContentHelper.fromJson(string, Object.class, gqlNaming);
    }

    @JvmStatic
    public static final <T> T fromJson(@NotNull String string, @NotNull Class<T> clazz, boolean gqlNaming) throws GithubJsonException {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        try {
            return (T)INSTANCE.getObjectMapper$intellij_vcs_github(gqlNaming).readValue(string, clazz);
        }
        catch (JsonParseException e) {
            throw new GithubJsonException("Can't parse GitHub response", e);
        }
    }

    public static /* synthetic */ Object fromJson$default(String string, Class clazz, boolean bl, int n, Object object) throws GithubJsonException {
        if ((n & 4) != 0) {
            bl = false;
        }
        return GithubApiContentHelper.fromJson(string, clazz, bl);
    }

    @JvmStatic
    public static final <T> T readJsonObject(@NotNull Reader reader, @NotNull Class<T> clazz, @NotNull Class<?>[] parameters, boolean gqlNaming) throws GithubJsonException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        JavaType javaType = jackson.getTypeFactory().constructParametricType(clazz, (Class[])Arrays.copyOf(parameters, parameters.length));
        Intrinsics.checkNotNullExpressionValue((Object)javaType, (String)"constructParametricType(...)");
        return INSTANCE.readJson(reader, javaType, gqlNaming);
    }

    public static /* synthetic */ Object readJsonObject$default(Reader reader, Class clazz, Class[] classArray, boolean bl, int n, Object object) throws GithubJsonException {
        if ((n & 8) != 0) {
            bl = false;
        }
        return GithubApiContentHelper.readJsonObject(reader, clazz, classArray, bl);
    }

    @JvmStatic
    @NotNull
    public static final <T> List<T> readJsonList(@NotNull Reader reader, @NotNull Class<T> parameterClass) throws GithubJsonException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter(parameterClass, (String)"parameterClass");
        CollectionType collectionType = jackson.getTypeFactory().constructCollectionType(List.class, parameterClass);
        Intrinsics.checkNotNullExpressionValue((Object)collectionType, (String)"constructCollectionType(...)");
        return (List)GithubApiContentHelper.readJson$default(INSTANCE, reader, (JavaType)collectionType, false, 4, null);
    }

    @JvmStatic
    @NotNull
    public static final <T, U> Map<T, U> readJsonMap(@NotNull Reader reader, boolean gqlNaming) throws GithubJsonException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        try {
            Object object = INSTANCE.getObjectMapper$intellij_vcs_github(gqlNaming).readValue(reader, new TypeReference<Map<T, ? extends U>>(){});
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
            return (Map)object;
        }
        catch (JsonProcessingException e) {
            throw new GithubJsonException("Can't parse GitHub response", e);
        }
    }

    public static /* synthetic */ Map readJsonMap$default(Reader reader, boolean bl, int n, Object object) throws GithubJsonException {
        if ((n & 2) != 0) {
            bl = false;
        }
        return GithubApiContentHelper.readJsonMap(reader, bl);
    }

    private final <T> T readJson(Reader reader, JavaType type, boolean gqlNaming) throws GithubJsonException {
        try {
            if (type.isTypeOrSubTypeOf(Unit.class) || type.isTypeOrSubTypeOf(Void.class)) {
                return (T)Unit.INSTANCE;
            }
            return (T)this.getObjectMapper$intellij_vcs_github(gqlNaming).readValue(reader, type);
        }
        catch (JsonProcessingException e) {
            throw new GithubJsonException("Can't parse GitHub response", e);
        }
    }

    static /* synthetic */ Object readJson$default(GithubApiContentHelper githubApiContentHelper, Reader reader, JavaType javaType, boolean bl, int n, Object object) throws GithubJsonException {
        if ((n & 4) != 0) {
            bl = false;
        }
        return githubApiContentHelper.readJson(reader, javaType, bl);
    }

    @JvmStatic
    @NotNull
    public static final String toJson(@NotNull Object content2, boolean gqlNaming) throws GithubJsonException {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        try {
            String string = INSTANCE.getObjectMapper$intellij_vcs_github(gqlNaming).writeValueAsString(content2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
            return string;
        }
        catch (JsonProcessingException e) {
            throw new GithubJsonException("Can't serialize GitHub request body", e);
        }
    }

    public static /* synthetic */ String toJson$default(Object object, boolean bl, int n, Object object2) throws GithubJsonException {
        if ((n & 2) != 0) {
            bl = false;
        }
        return GithubApiContentHelper.toJson(object, bl);
    }

    @VisibleForTesting
    @NotNull
    public final ObjectMapper getObjectMapper$intellij_vcs_github(boolean gqlNaming) {
        return !gqlNaming ? jackson : gqlJackson;
    }

    public static /* synthetic */ ObjectMapper getObjectMapper$intellij_vcs_github$default(GithubApiContentHelper githubApiContentHelper, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return githubApiContentHelper.getObjectMapper$intellij_vcs_github(bl);
    }

    @JvmStatic
    @NotNull
    public static final BufferedImage loadImage(@NotNull InputStream stream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        BufferedImage bufferedImage = ImageIO.read(stream);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(...)");
        return bufferedImage;
    }

    static {
        ObjectMapper objectMapper = INSTANCE.genericConfig(ExtensionsKt.jacksonObjectMapper()).setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"setPropertyNamingStrategy(...)");
        jackson = objectMapper;
        ObjectMapper objectMapper2 = INSTANCE.genericConfig(ExtensionsKt.jacksonObjectMapper()).setPropertyNamingStrategy(PropertyNamingStrategy.LOWER_CAMEL_CASE);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"setPropertyNamingStrategy(...)");
        gqlJackson = objectMapper2;
    }
}

