/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\tH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vcs/changes/shelf/ShelfFileWritingAccessProvider;", "Lcom/intellij/openapi/vfs/WritingAccessProvider;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "requestWriting", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "files", "getReadOnlyMessage", "", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public final class ShelfFileWritingAccessProvider
extends WritingAccessProvider {
    @NotNull
    private final Project myProject;

    public ShelfFileWritingAccessProvider(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
    }

    @NotNull
    public final Project getMyProject() {
        return this.myProject;
    }

    @NotNull
    public Collection<VirtualFile> requestWriting(@NotNull Collection<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Collection<VirtualFile> collection = ShelveChangesManager.getInstance(this.myProject).getShelvingFiles();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getShelvingFiles(...)");
        Collection<VirtualFile> shelvingFiles = collection;
        return CollectionsKt.toMutableSet((Iterable)CollectionsKt.intersect((Iterable)files, (Iterable)shelvingFiles));
    }

    @NotNull
    public String getReadOnlyMessage() {
        String string = VcsBundle.message((String)"shelve.file.is.locked.for.editing.message", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

