/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesTreeCompatibilityProvider;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.IgnoredViewDialog;
import com.intellij.openapi.vcs.changes.UnversionedViewDialog;
import com.intellij.openapi.vcs.changes.VcsCurrentRevisionProxy;
import com.intellij.openapi.vcs.changes.VcsIgnoreManagerImpl;
import com.intellij.openapi.vcs.changes.ignore.actions.IgnoreFileActionGroup;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreFileType;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.vcs.commit.CommitSessionCollector;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001f\u0010\u0012\u001a\t\u0018\u00010\u0013\u00a2\u0006\u0002\b\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 H\u0016\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/BackendChangesTreeCompatibilityProvider;", "Lcom/intellij/openapi/vcs/changes/ChangesTreeCompatibilityProvider;", "<init>", "()V", "getFileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "logInclusionToggle", "", "exclude", "", "event", "Ljava/awt/event/MouseEvent;", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "logFileSelected", "getSwitchedBranch", "", "Lcom/intellij/openapi/util/NlsSafe;", "showIgnoredViewDialog", "showUnversionedViewDialog", "resolveLocalFile", "path", "toHijackedChange", "Lcom/intellij/openapi/vcs/changes/Change;", "getScopeVirtualFileFor", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "acceptIgnoredFilesDrop", "dragBean", "Lcom/intellij/openapi/vcs/changes/ui/ChangeListDragBean;", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nBackendChangesTreeCompatibilityProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendChangesTreeCompatibilityProvider.kt\ncom/intellij/openapi/vcs/changes/ui/BackendChangesTreeCompatibilityProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
public final class BackendChangesTreeCompatibilityProvider
implements ChangesTreeCompatibilityProvider {
    @NotNull
    public FileStatus getFileStatus(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileStatus fileStatus = ChangeListManager.getInstance((Project)project).getStatus(file);
        Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getStatus(...)");
        return fileStatus;
    }

    public void logInclusionToggle(@NotNull Project project, boolean exclude, @NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CommitSessionCollector.Companion.getInstance(project).logInclusionToggle(exclude, event);
    }

    public void logInclusionToggle(@NotNull Project project, boolean exclude, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CommitSessionCollector.Companion.getInstance(project).logInclusionToggle(exclude, event);
    }

    public void logFileSelected(@NotNull Project project, @NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CommitSessionCollector.Companion.getInstance(project).logFileSelected(event);
    }

    @Nullable
    public String getSwitchedBranch(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return ChangeListManager.getInstance((Project)project).getSwitchedBranch(file);
    }

    public void showIgnoredViewDialog(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!project.isDisposed()) {
            new IgnoredViewDialog(project).show();
        }
    }

    public void showUnversionedViewDialog(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!project.isDisposed()) {
            new UnversionedViewDialog(project).show();
        }
    }

    @Nullable
    public VirtualFile resolveLocalFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    @Nullable
    public Change toHijackedChange(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VcsCurrentRevisionProxy vcsCurrentRevisionProxy = VcsCurrentRevisionProxy.create(file, project);
        if (vcsCurrentRevisionProxy == null) {
            return null;
        }
        VcsCurrentRevisionProxy before = vcsCurrentRevisionProxy;
        CurrentContentRevision after = new CurrentContentRevision(VcsUtil.getFilePath((VirtualFile)file));
        return new Change((ContentRevision)before, (ContentRevision)after, FileStatus.HIJACKED);
    }

    @Nullable
    public VirtualFile getScopeVirtualFileFor(@NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (filePath.isNonLocal()) {
            return null;
        }
        return VcsImplUtil.findValidParentAccurately(filePath);
    }

    public void acceptIgnoredFilesDrop(@NotNull Project project, @NotNull ChangeListDragBean dragBean) {
        block5: {
            AbstractVcs abstractVcs;
            Tree tree;
            block4: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)dragBean, (String)"dragBean");
                JComponent jComponent = dragBean.getSourceComponent();
                Tree tree2 = jComponent instanceof Tree ? (Tree)jComponent : null;
                if (tree2 == null) {
                    return;
                }
                tree = tree2;
                List list = dragBean.getUnversionedFiles();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getUnversionedFiles(...)");
                for (FilePath file : (Iterable)list) {
                    boolean bl = false;
                    AbstractVcs abstractVcs2 = VcsUtil.getVcsFor((Project)project, (FilePath)file);
                    if (abstractVcs2 == null) continue;
                    abstractVcs = abstractVcs2;
                    break block4;
                }
                abstractVcs = null;
            }
            if (abstractVcs == null) {
                return;
            }
            AbstractVcs vcs = abstractVcs;
            IgnoreFileType ignoreFileType = VcsIgnoreManagerImpl.Companion.getInstanceImpl(project).findIgnoreFileType(vcs);
            if (ignoreFileType == null) {
                return;
            }
            IgnoreFileType ignoreFileType2 = ignoreFileType;
            IgnoreFileActionGroup ignoreGroup = new IgnoreFileActionGroup(ignoreFileType2);
            ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)ignoreGroup, DataManager.getInstance().getDataContext((Component)dragBean.getSourceComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
            Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
            ListPopup popup = listPopup;
            Rectangle rectangle = tree.getPathBounds(new TreePath(dragBean.getTargetNode().getPath()));
            if (rectangle == null) break block5;
            Rectangle dropBounds = rectangle;
            boolean bl = false;
            popup.show(new RelativePoint((Component)dragBean.getSourceComponent(), dropBounds.getLocation()));
        }
    }
}

