/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CommitCheck;
import com.intellij.openapi.vcs.checkin.CommitInfo;
import com.intellij.openapi.vcs.checkin.CommitProblem;
import com.intellij.openapi.vcs.checkin.MergeConflictsCommitProblem;
import com.intellij.openapi.vcs.checkin.UnresolvedMergeCheckProvider;
import com.intellij.platform.vcs.changes.ChangesUtil;
import java.awt.Component;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/checkin/UnresolvedMergeCheckHandler;", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "Lcom/intellij/openapi/vcs/checkin/CommitCheck;", "Lcom/intellij/openapi/project/DumbAware;", "panel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "<init>", "(Lcom/intellij/openapi/vcs/CheckinProjectPanel;Lcom/intellij/openapi/vcs/changes/CommitContext;)V", "isEnabled", "", "getExecutionOrder", "Lcom/intellij/openapi/vcs/checkin/CommitCheck$ExecutionOrder;", "runCheck", "Lcom/intellij/openapi/vcs/checkin/CommitProblem;", "commitInfo", "Lcom/intellij/openapi/vcs/checkin/CommitInfo;", "(Lcom/intellij/openapi/vcs/checkin/CommitInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createProblemFor", "providerResult", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler$ReturnResult;", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nUnresolvedMergeCheckFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnresolvedMergeCheckFactory.kt\ncom/intellij/openapi/vcs/checkin/UnresolvedMergeCheckHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1807#2,3:66\n*S KotlinDebug\n*F\n+ 1 UnresolvedMergeCheckFactory.kt\ncom/intellij/openapi/vcs/checkin/UnresolvedMergeCheckHandler\n*L\n39#1:66,3\n*E\n"})
final class UnresolvedMergeCheckHandler
extends CheckinHandler
implements CommitCheck,
DumbAware {
    @NotNull
    private final CheckinProjectPanel panel;
    @NotNull
    private final CommitContext commitContext;

    public UnresolvedMergeCheckHandler(@NotNull CheckinProjectPanel panel, @NotNull CommitContext commitContext) {
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)commitContext, (String)"commitContext");
        this.panel = panel;
        this.commitContext = commitContext;
    }

    public boolean isEnabled() {
        return true;
    }

    @NotNull
    public CommitCheck.ExecutionOrder getExecutionOrder() {
        return CommitCheck.ExecutionOrder.EARLY;
    }

    @Nullable
    public Object runCheck(@NotNull CommitInfo commitInfo, @NotNull Continuation<? super CommitProblem> $completion) {
        boolean hasUnresolvedConflicts;
        block5: {
            CheckinHandler.ReturnResult providerResult;
            CheckinHandler.ReturnResult returnResult = providerResult = (CheckinHandler.ReturnResult)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])UnresolvedMergeCheckProvider.EP_NAME.getExtensions()), arg_0 -> UnresolvedMergeCheckHandler.runCheck$lambda$0(this, commitInfo, arg_0)));
            if (returnResult != null) {
                return this.createProblemFor(returnResult);
            }
            Iterable $this$any$iv = commitInfo.getCommittedChanges();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Change it = (Change)element$iv;
                    boolean bl = false;
                    if (!ChangesUtil.isMergeConflict((Change)it)) continue;
                    v1 = true;
                    break block5;
                }
                v1 = hasUnresolvedConflicts = false;
            }
        }
        if (!hasUnresolvedConflicts) {
            return null;
        }
        int answer = Messages.showYesNoDialog((Component)this.panel.getComponent(), (String)VcsBundle.message((String)"checkin.unresolved.merge.are.you.sure.you.want.to.commit.changes.with.unresolved.conflicts", (Object[])new Object[0]), (String)VcsBundle.message((String)"checkin.unresolved.merge.unresolved.conflicts", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
        CheckinHandler.ReturnResult result2 = answer != 0 ? CheckinHandler.ReturnResult.CANCEL : CheckinHandler.ReturnResult.COMMIT;
        return this.createProblemFor(result2);
    }

    private final CommitProblem createProblemFor(CheckinHandler.ReturnResult providerResult) {
        if (providerResult == CheckinHandler.ReturnResult.COMMIT) {
            return null;
        }
        return new MergeConflictsCommitProblem(providerResult);
    }

    private static final CheckinHandler.ReturnResult runCheck$lambda$0(UnresolvedMergeCheckHandler this$0, CommitInfo $commitInfo, UnresolvedMergeCheckProvider it) {
        return it.checkUnresolvedConflicts(this$0.panel, this$0.commitContext, $commitInfo);
    }
}

