/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.impl;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.impl.BuildImageCmdWithCleanup;
import com.intellij.docker.agent.progress.DockerResponseItem;
import com.intellij.docker.agent.progress.PromisingSerializedItemsCallback;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/docker/agent/impl/DockerAgentImageBuilderImpl;", "Lcom/intellij/docker/agent/DockerAgent$DockerImageBuilder;", "client", "Lcom/github/dockerjava/api/DockerClient;", "<init>", "(Lcom/github/dockerjava/api/DockerClient;)V", "asyncBuildImage", "Ljava/util/concurrent/CompletableFuture;", "Ljava/util/concurrent/BlockingQueue;", "", "buildConfig", "Lcom/intellij/docker/agent/DockerAgentDeploymentConfig;", "BuildImageCallback", "intellij.clouds.docker.agent"})
public final class DockerAgentImageBuilderImpl
implements DockerAgent.DockerImageBuilder {
    @NotNull
    private final DockerClient client;

    public DockerAgentImageBuilderImpl(@NotNull DockerClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
    }

    @Override
    @NotNull
    public CompletableFuture<BlockingQueue<byte[]>> asyncBuildImage(@NotNull DockerAgentDeploymentConfig buildConfig) {
        Intrinsics.checkNotNullParameter((Object)buildConfig, (String)"buildConfig");
        CompletableFuture<BlockingQueue<byte[]>> result2 = new CompletableFuture<BlockingQueue<byte[]>>();
        try {
            BuildImageCmdWithCleanup cmdWithCleanup = BuildImageCmdWithCleanup.forConfig(this.client, buildConfig);
            cmdWithCleanup.asyncBuildImage(new BuildImageCallback(result2));
        }
        catch (IOException e) {
            result2.completeExceptionally(e);
        }
        catch (ApiTaskException e) {
            result2.completeExceptionally(e);
        }
        return result2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/agent/impl/DockerAgentImageBuilderImpl$BuildImageCallback;", "Lcom/intellij/docker/agent/progress/PromisingSerializedItemsCallback;", "Lcom/github/dockerjava/api/model/BuildResponseItem;", "promise", "Ljava/util/concurrent/CompletableFuture;", "Ljava/util/concurrent/BlockingQueue;", "", "<init>", "(Ljava/util/concurrent/CompletableFuture;)V", "wrapAgentItem", "Lcom/intellij/docker/agent/progress/DockerResponseItem$Builder;", "agentItem", "intellij.clouds.docker.agent"})
    private static final class BuildImageCallback
    extends PromisingSerializedItemsCallback<BuildResponseItem> {
        public BuildImageCallback(@NotNull CompletableFuture<BlockingQueue<byte[]>> promise) {
            Intrinsics.checkNotNullParameter(promise, (String)"promise");
            super(promise);
        }

        @Override
        @NotNull
        protected DockerResponseItem.Builder wrapAgentItem(@NotNull BuildResponseItem agentItem) {
            Intrinsics.checkNotNullParameter((Object)agentItem, (String)"agentItem");
            return DockerResponseItem.Companion.fromAgentBuildItem(agentItem);
        }
    }
}

