/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0010\b\u0086\b\u0018\u0000 (2\u00020\u0001:\u0003&'(B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0000H\u0002JR\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u00160\u0014\"\u0004\b\u0000\u0010\u0015\"\u0004\b\u0001\u0010\u00162\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u0002H\u00150\u00182\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00160\u0018J\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001c\u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010\u001dJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J'\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0014\u0010\"\u001a\u00020\u00112\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010$\u001a\u00020\u0019H\u00d6\u0081\u0004J\n\u0010%\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006)"}, d2={"Lcom/intellij/docker/agent/settings/DockerPortSpec;", "", "rawText", "", "localSpec", "Lcom/intellij/docker/agent/settings/DockerPortSpec$LocalPortsSpec;", "containerSpec", "Lcom/intellij/docker/agent/settings/DockerPortSpec$ContainerPortsSpec;", "<init>", "(Ljava/lang/String;Lcom/intellij/docker/agent/settings/DockerPortSpec$LocalPortsSpec;Lcom/intellij/docker/agent/settings/DockerPortSpec$ContainerPortsSpec;)V", "getRawText", "()Ljava/lang/String;", "getLocalSpec", "()Lcom/intellij/docker/agent/settings/DockerPortSpec$LocalPortsSpec;", "getContainerSpec", "()Lcom/intellij/docker/agent/settings/DockerPortSpec$ContainerPortsSpec;", "isRangesMatched", "", "ensureMatched", "toNativeMap", "", "CONTAINER", "LOCAL", "containerFactory", "Ljava/util/function/BiFunction;", "", "localFactory", "localPortFor", "containerPort", "(I)Ljava/lang/Integer;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "LocalPortsSpec", "ContainerPortsSpec", "Companion", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\nDockerPortSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerPortSpec.kt\ncom/intellij/docker/agent/settings/DockerPortSpec\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1915#2,2:129\n*S KotlinDebug\n*F\n+ 1 DockerPortSpec.kt\ncom/intellij/docker/agent/settings/DockerPortSpec\n*L\n24#1:129,2\n*E\n"})
public final class DockerPortSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String rawText;
    @NotNull
    private final LocalPortsSpec localSpec;
    @NotNull
    private final ContainerPortsSpec containerSpec;

    public DockerPortSpec(@NotNull String rawText, @NotNull LocalPortsSpec localSpec, @NotNull ContainerPortsSpec containerSpec) {
        Intrinsics.checkNotNullParameter((Object)rawText, (String)"rawText");
        Intrinsics.checkNotNullParameter((Object)localSpec, (String)"localSpec");
        Intrinsics.checkNotNullParameter((Object)containerSpec, (String)"containerSpec");
        this.rawText = rawText;
        this.localSpec = localSpec;
        this.containerSpec = containerSpec;
    }

    @NotNull
    public final String getRawText() {
        return this.rawText;
    }

    @NotNull
    public final LocalPortsSpec getLocalSpec() {
        return this.localSpec;
    }

    @NotNull
    public final ContainerPortsSpec getContainerSpec() {
        return this.containerSpec;
    }

    public final boolean isRangesMatched() {
        return this.localSpec.matches(this.containerSpec);
    }

    private final DockerPortSpec ensureMatched() {
        if (!this.isRangesMatched()) {
            throw new IllegalStateException();
        }
        return this;
    }

    @NotNull
    public final <CONTAINER, LOCAL> Map<CONTAINER, LOCAL> toNativeMap(@NotNull BiFunction<String, Integer, CONTAINER> containerFactory, @NotNull BiFunction<String, String, LOCAL> localFactory) {
        Intrinsics.checkNotNullParameter(containerFactory, (String)"containerFactory");
        Intrinsics.checkNotNullParameter(localFactory, (String)"localFactory");
        this.ensureMatched();
        HashMap result2 = new HashMap();
        if (DockerPortSpec.Companion.size(this.containerSpec.getPortsRange()) == 1) {
            CONTAINER containerOne = this.containerSpec.toNativeList(containerFactory).get(0);
            LOCAL localOne = localFactory.apply(this.localSpec.getHostIP(), this.localSpec.toNativePortRange());
            ((Map)result2).put(containerOne, localOne);
        } else {
            Iterable $this$forEach$iv = (Iterable)this.containerSpec.getPortsRange();
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int it = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                LOCAL nextLocal = localFactory.apply(this.localSpec.getHostIP(), String.valueOf(this.localPortFor(it)));
                CONTAINER nextContainer = containerFactory.apply(this.containerSpec.getProtocol(), it);
                ((Map)result2).put(nextContainer, nextLocal);
            }
        }
        return result2;
    }

    private final Integer localPortFor(int containerPort) {
        this.ensureMatched();
        IntRange intRange = this.localSpec.getPortRange();
        if (intRange != null) {
            IntRange it = intRange;
            boolean bl = false;
            return it.getStart() + containerPort - this.containerSpec.getPortsRange().getFirst();
        }
        return null;
    }

    @NotNull
    public final String component1() {
        return this.rawText;
    }

    @NotNull
    public final LocalPortsSpec component2() {
        return this.localSpec;
    }

    @NotNull
    public final ContainerPortsSpec component3() {
        return this.containerSpec;
    }

    @NotNull
    public final DockerPortSpec copy(@NotNull String rawText, @NotNull LocalPortsSpec localSpec, @NotNull ContainerPortsSpec containerSpec) {
        Intrinsics.checkNotNullParameter((Object)rawText, (String)"rawText");
        Intrinsics.checkNotNullParameter((Object)localSpec, (String)"localSpec");
        Intrinsics.checkNotNullParameter((Object)containerSpec, (String)"containerSpec");
        return new DockerPortSpec(rawText, localSpec, containerSpec);
    }

    public static /* synthetic */ DockerPortSpec copy$default(DockerPortSpec dockerPortSpec, String string, LocalPortsSpec localPortsSpec, ContainerPortsSpec containerPortsSpec, int n, Object object) {
        if ((n & 1) != 0) {
            string = dockerPortSpec.rawText;
        }
        if ((n & 2) != 0) {
            localPortsSpec = dockerPortSpec.localSpec;
        }
        if ((n & 4) != 0) {
            containerPortsSpec = dockerPortSpec.containerSpec;
        }
        return dockerPortSpec.copy(string, localPortsSpec, containerPortsSpec);
    }

    @NotNull
    public String toString() {
        return "DockerPortSpec(rawText=" + this.rawText + ", localSpec=" + this.localSpec + ", containerSpec=" + this.containerSpec + ")";
    }

    public int hashCode() {
        int result2 = this.rawText.hashCode();
        result2 = result2 * 31 + this.localSpec.hashCode();
        result2 = result2 * 31 + this.containerSpec.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DockerPortSpec)) {
            return false;
        }
        DockerPortSpec dockerPortSpec = (DockerPortSpec)other;
        if (!Intrinsics.areEqual((Object)this.rawText, (Object)dockerPortSpec.rawText)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.localSpec, (Object)dockerPortSpec.localSpec)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.containerSpec, (Object)dockerPortSpec.containerSpec);
    }

    @JvmStatic
    @NotNull
    public static final DockerPortSpec fromRawString(@NotNull String raw) {
        return Companion.fromRawString(raw);
    }

    @JvmStatic
    private static final IntRange rangeFromString(String range) {
        return DockerPortSpec.Companion.rangeFromString(range);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0003J\f\u0010\u000b\u001a\u00020\f*\u00020\u0007H\u0002J\f\u0010\r\u001a\u00020\f*\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/docker/agent/settings/DockerPortSpec$Companion;", "", "<init>", "()V", "fromRawString", "Lcom/intellij/docker/agent/settings/DockerPortSpec;", "raw", "", "rangeFromString", "Lkotlin/ranges/IntRange;", "range", "toIntOrIAE", "", "size", "intellij.clouds.docker.agent"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DockerPortSpec fromRawString(@NotNull String raw) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            CharSequence charSequence = raw;
            Regex regex = new Regex(":+");
            int n = 0;
            List parts = regex.split(charSequence, n);
            return switch (parts.size()) {
                case 3 -> new DockerPortSpec(raw, LocalPortsSpec.Companion.fromString(parts.get(0) + ":" + parts.get(1)), ContainerPortsSpec.Companion.fromString((String)parts.get(2)));
                case 2 -> new DockerPortSpec(raw, LocalPortsSpec.Companion.fromString((String)parts.get(0)), ContainerPortsSpec.Companion.fromString((String)parts.get(1)));
                case 1 -> new DockerPortSpec(raw, LocalPortsSpec.Companion.fromString(""), ContainerPortsSpec.Companion.fromString((String)parts.get(0)));
                default -> throw new IllegalArgumentException();
            };
        }

        @JvmStatic
        private final IntRange rangeFromString(String range) {
            String[] stringArray = new String[]{"-"};
            List parts = StringsKt.split$default((CharSequence)range, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            return switch (parts.size()) {
                case 1 -> new IntRange(this.toIntOrIAE(range), this.toIntOrIAE(range));
                case 2 -> new IntRange(this.toIntOrIAE((String)parts.get(0)), this.toIntOrIAE((String)parts.get(1)));
                default -> throw new IllegalArgumentException();
            };
        }

        private final int toIntOrIAE(String $this$toIntOrIAE) {
            try {
                return Integer.parseInt(((Object)StringsKt.trim((CharSequence)$this$toIntOrIAE)).toString());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e);
            }
        }

        private final int size(IntRange $this$size) {
            return $this$size.isEmpty() ? 0 : $this$size.getLast() - $this$size.getFirst() + 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\r\"\u0004\b\u0000\u0010\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u0002H\u000e0\u0010J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0018\u001a\u00020\u0011H\u00d6\u0081\u0004J\n\u0010\u0019\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/docker/agent/settings/DockerPortSpec$ContainerPortsSpec;", "", "protocol", "", "portsRange", "Lkotlin/ranges/IntRange;", "<init>", "(Ljava/lang/String;Lkotlin/ranges/IntRange;)V", "getProtocol", "()Ljava/lang/String;", "getPortsRange", "()Lkotlin/ranges/IntRange;", "toNativeList", "", "PORT", "nativeFactory", "Ljava/util/function/BiFunction;", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "intellij.clouds.docker.agent"})
    @SourceDebugExtension(value={"SMAP\nDockerPortSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerPortSpec.kt\ncom/intellij/docker/agent/settings/DockerPortSpec$ContainerPortsSpec\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1586#2:129\n1661#2,3:130\n*S KotlinDebug\n*F\n+ 1 DockerPortSpec.kt\ncom/intellij/docker/agent/settings/DockerPortSpec$ContainerPortsSpec\n*L\n76#1:129\n76#1:130,3\n*E\n"})
    public static final class ContainerPortsSpec {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String protocol;
        @NotNull
        private final IntRange portsRange;

        public ContainerPortsSpec(@NotNull String protocol, @NotNull IntRange portsRange) {
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            Intrinsics.checkNotNullParameter((Object)portsRange, (String)"portsRange");
            this.protocol = protocol;
            this.portsRange = portsRange;
        }

        @NotNull
        public final String getProtocol() {
            return this.protocol;
        }

        @NotNull
        public final IntRange getPortsRange() {
            return this.portsRange;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final <PORT> List<PORT> toNativeList(@NotNull BiFunction<String, Integer, PORT> nativeFactory) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(nativeFactory, (String)"nativeFactory");
            Iterable $this$map$iv = (Iterable)this.portsRange;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(nativeFactory.apply(this.protocol, (int)it));
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final String component1() {
            return this.protocol;
        }

        @NotNull
        public final IntRange component2() {
            return this.portsRange;
        }

        @NotNull
        public final ContainerPortsSpec copy(@NotNull String protocol, @NotNull IntRange portsRange) {
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            Intrinsics.checkNotNullParameter((Object)portsRange, (String)"portsRange");
            return new ContainerPortsSpec(protocol, portsRange);
        }

        public static /* synthetic */ ContainerPortsSpec copy$default(ContainerPortsSpec containerPortsSpec, String string, IntRange intRange, int n, Object object) {
            if ((n & 1) != 0) {
                string = containerPortsSpec.protocol;
            }
            if ((n & 2) != 0) {
                intRange = containerPortsSpec.portsRange;
            }
            return containerPortsSpec.copy(string, intRange);
        }

        @NotNull
        public String toString() {
            return "ContainerPortsSpec(protocol=" + this.protocol + ", portsRange=" + this.portsRange + ")";
        }

        public int hashCode() {
            int result2 = this.protocol.hashCode();
            result2 = result2 * 31 + this.portsRange.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ContainerPortsSpec)) {
                return false;
            }
            ContainerPortsSpec containerPortsSpec = (ContainerPortsSpec)other;
            if (!Intrinsics.areEqual((Object)this.protocol, (Object)containerPortsSpec.protocol)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.portsRange, (Object)containerPortsSpec.portsRange);
        }

        @JvmStatic
        @NotNull
        public static final ContainerPortsSpec fromString(@NotNull String text) {
            return Companion.fromString(text);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/agent/settings/DockerPortSpec$ContainerPortsSpec$Companion;", "", "<init>", "()V", "fromString", "Lcom/intellij/docker/agent/settings/DockerPortSpec$ContainerPortsSpec;", "text", "", "intellij.clouds.docker.agent"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final ContainerPortsSpec fromString(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                String[] stringArray = new String[]{"/"};
                List portsAndProtocol = StringsKt.split$default((CharSequence)text, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                int size = portsAndProtocol.size();
                stringArray = size == 1 ? new Pair(portsAndProtocol.get(0), (Object)"tcp") : new Pair(portsAndProtocol.get(size - 2), portsAndProtocol.get(size - 1));
                String ports = (String)stringArray.component1();
                String protocol = (String)stringArray.component2();
                return new ContainerPortsSpec(protocol, DockerPortSpec.Companion.rangeFromString(ports));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0014\u0010\u0014\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0016\u001a\u00020\u0017H\u00d6\u0081\u0004J\n\u0010\u0018\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/docker/agent/settings/DockerPortSpec$LocalPortsSpec;", "", "hostIP", "", "portRange", "Lkotlin/ranges/IntRange;", "<init>", "(Ljava/lang/String;Lkotlin/ranges/IntRange;)V", "getHostIP", "()Ljava/lang/String;", "getPortRange", "()Lkotlin/ranges/IntRange;", "matches", "", "containerSpec", "Lcom/intellij/docker/agent/settings/DockerPortSpec$ContainerPortsSpec;", "toNativePortRange", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "intellij.clouds.docker.agent"})
    public static final class LocalPortsSpec {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String hostIP;
        @Nullable
        private final IntRange portRange;

        public LocalPortsSpec(@NotNull String hostIP, @Nullable IntRange portRange) {
            Intrinsics.checkNotNullParameter((Object)hostIP, (String)"hostIP");
            this.hostIP = hostIP;
            this.portRange = portRange;
        }

        @NotNull
        public final String getHostIP() {
            return this.hostIP;
        }

        @Nullable
        public final IntRange getPortRange() {
            return this.portRange;
        }

        public final boolean matches(@NotNull ContainerPortsSpec containerSpec) {
            Intrinsics.checkNotNullParameter((Object)containerSpec, (String)"containerSpec");
            int thatSize = Companion.size(containerSpec.getPortsRange());
            return switch (thatSize) {
                case 0 -> false;
                case 1 -> true;
                default -> {
                    IntRange v1 = this.portRange;
                    yield (v1 != null ? Companion.size(v1) : 0) == thatSize;
                }
            };
        }

        @NotNull
        public final String toNativePortRange() {
            IntRange intRange = this.portRange;
            if (intRange == null) {
                intRange = IntRange.Companion.getEMPTY();
            }
            IntRange safeRange = intRange;
            return switch (Companion.size(safeRange)) {
                case 0 -> "";
                case 1 -> String.valueOf(safeRange.getFirst());
                default -> safeRange.getFirst() + "-" + safeRange.getLast();
            };
        }

        @NotNull
        public final String component1() {
            return this.hostIP;
        }

        @Nullable
        public final IntRange component2() {
            return this.portRange;
        }

        @NotNull
        public final LocalPortsSpec copy(@NotNull String hostIP, @Nullable IntRange portRange) {
            Intrinsics.checkNotNullParameter((Object)hostIP, (String)"hostIP");
            return new LocalPortsSpec(hostIP, portRange);
        }

        public static /* synthetic */ LocalPortsSpec copy$default(LocalPortsSpec localPortsSpec, String string, IntRange intRange, int n, Object object) {
            if ((n & 1) != 0) {
                string = localPortsSpec.hostIP;
            }
            if ((n & 2) != 0) {
                intRange = localPortsSpec.portRange;
            }
            return localPortsSpec.copy(string, intRange);
        }

        @NotNull
        public String toString() {
            return "LocalPortsSpec(hostIP=" + this.hostIP + ", portRange=" + this.portRange + ")";
        }

        public int hashCode() {
            int result2 = this.hostIP.hashCode();
            result2 = result2 * 31 + (this.portRange == null ? 0 : this.portRange.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LocalPortsSpec)) {
                return false;
            }
            LocalPortsSpec localPortsSpec = (LocalPortsSpec)other;
            if (!Intrinsics.areEqual((Object)this.hostIP, (Object)localPortsSpec.hostIP)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.portRange, (Object)localPortsSpec.portRange);
        }

        @JvmStatic
        @NotNull
        public static final LocalPortsSpec fromString(@NotNull String serialized) {
            return Companion.fromString(serialized);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/agent/settings/DockerPortSpec$LocalPortsSpec$Companion;", "", "<init>", "()V", "fromString", "Lcom/intellij/docker/agent/settings/DockerPortSpec$LocalPortsSpec;", "serialized", "", "intellij.clouds.docker.agent"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final LocalPortsSpec fromString(@NotNull String serialized) {
                Intrinsics.checkNotNullParameter((Object)serialized, (String)"serialized");
                String[] stringArray = new String[]{":"};
                List parts = StringsKt.split$default((CharSequence)serialized, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                return switch (parts.size()) {
                    case 2 -> new LocalPortsSpec((String)parts.get(0), DockerPortSpec.Companion.rangeFromString((String)parts.get(1)));
                    case 1 -> {
                        if (StringsKt.contains$default((CharSequence)serialized, (char)'.', (boolean)false, (int)2, null) || StringsKt.isBlank((CharSequence)serialized)) {
                            yield new LocalPortsSpec(serialized, null);
                        }
                        yield new LocalPortsSpec("", DockerPortSpec.Companion.rangeFromString(serialized));
                    }
                    default -> throw new IllegalArgumentException();
                };
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

