/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.TripleFunction;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompilerMessageImpl
implements CompilerMessage {
    private final Project myProject;
    private final CompilerMessageCategory myCategory;
    @Nullable
    private Navigatable myNavigatable;
    @Nls(capitalization=Nls.Capitalization.Sentence)
    private final String myMessage;
    private final VirtualFile myFile;
    private final int myRow;
    private final int myColumn;
    private final Collection<String> myModuleNames;
    @NotNull
    private TripleFunction<? super CompilerMessage, ? super Integer, ? super Integer, Integer> myColumnAdjuster;

    public CompilerMessageImpl(Project project, CompilerMessageCategory category, @Nls(capitalization=Nls.Capitalization.Sentence) String message) {
        this(project, category, message, null, -1, -1, null);
    }

    public CompilerMessageImpl(Project project, @NotNull CompilerMessageCategory category, @Nls(capitalization=Nls.Capitalization.Sentence) String message, @Nullable VirtualFile file, int row, int column, @Nullable Navigatable navigatable) {
        if (category == null) {
            CompilerMessageImpl.$$$reportNull$$$0(0);
        }
        this(project, category, message, file, row, column, navigatable, Collections.emptyList());
    }

    public CompilerMessageImpl(Project project, @NotNull CompilerMessageCategory category, @Nls(capitalization=Nls.Capitalization.Sentence) String message, @Nullable VirtualFile file, int row, int column, @Nullable Navigatable navigatable, @NotNull Collection<String> moduleNames) {
        if (category == null) {
            CompilerMessageImpl.$$$reportNull$$$0(1);
        }
        if (moduleNames == null) {
            CompilerMessageImpl.$$$reportNull$$$0(2);
        }
        this.myColumnAdjuster = (msg, line, col) -> col;
        this.myProject = project;
        this.myCategory = category;
        this.myNavigatable = navigatable;
        this.myMessage = message == null ? "" : message;
        this.myRow = row;
        this.myColumn = column;
        this.myFile = file;
        this.myModuleNames = Collections.unmodifiableCollection(moduleNames);
    }

    public void setColumnAdjuster(@NotNull TripleFunction<? super CompilerMessage, ? super Integer, ? super Integer, Integer> columnAdjuster) {
        if (columnAdjuster == null) {
            CompilerMessageImpl.$$$reportNull$$$0(3);
        }
        this.myColumnAdjuster = columnAdjuster;
    }

    @NotNull
    public CompilerMessageCategory getCategory() {
        CompilerMessageCategory compilerMessageCategory = this.myCategory;
        if (compilerMessageCategory == null) {
            CompilerMessageImpl.$$$reportNull$$$0(4);
        }
        return compilerMessageCategory;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public Navigatable getNavigatable() {
        int line;
        if (this.myNavigatable != null) {
            return this.myNavigatable;
        }
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile != null && virtualFile.isValid() && !virtualFile.getFileType().isBinary() && (line = this.getLine() - 1) >= 0) {
            this.myNavigatable = new OpenFileDescriptor(this.myProject, virtualFile, line, ((Integer)this.myColumnAdjuster.fun((Object)this, (Object)line, (Object)Math.max(0, this.getColumn() - 1))).intValue());
            return this.myNavigatable;
        }
        return null;
    }

    public VirtualFile getVirtualFile() {
        return this.myFile;
    }

    public String getExportTextPrefix() {
        if (this.getLine() >= 0) {
            return JavaCompilerBundle.message((String)"compiler.results.export.text.prefix", (Object[])new Object[]{this.getLine()});
        }
        return "";
    }

    public String getRenderTextPrefix() {
        if (this.getLine() >= 0) {
            return "(" + this.getLine() + ", " + this.getColumn() + ")";
        }
        return "";
    }

    public int getLine() {
        return this.myRow;
    }

    public int getColumn() {
        return this.myColumn;
    }

    public Collection<String> getModuleNames() {
        return this.myModuleNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompilerMessage)) {
            return false;
        }
        CompilerMessageImpl compilerMessage = (CompilerMessageImpl)o;
        if (this.myColumn != compilerMessage.myColumn) {
            return false;
        }
        if (this.myRow != compilerMessage.myRow) {
            return false;
        }
        if (!this.myCategory.equals((Object)compilerMessage.myCategory)) {
            return false;
        }
        if (this.myFile != null ? !this.myFile.equals(compilerMessage.myFile) : compilerMessage.myFile != null) {
            return false;
        }
        return this.myMessage.equals(compilerMessage.myMessage);
    }

    public int hashCode() {
        int result = this.myCategory.hashCode();
        result = 29 * result + this.myMessage.hashCode();
        result = 29 * result + (this.myFile != null ? this.myFile.hashCode() : 0);
        result = 29 * result + this.myRow;
        result = 29 * result + this.myColumn;
        return result;
    }

    public String toString() {
        return this.myMessage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNames";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnAdjuster";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/CompilerMessageImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/CompilerMessageImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCategory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setColumnAdjuster";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

