/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.compiler.ParserAction;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;

public abstract class OutputParser {
    protected final List<ParserAction> myParserActions = new ArrayList<ParserAction>(10);

    public boolean processMessageLine(Callback callback) {
        String line = callback.getNextLine();
        if (line == null) {
            return false;
        }
        for (ParserAction action : this.myParserActions) {
            if (!action.execute(line, callback)) continue;
            return true;
        }
        return StringUtil.startsWithChar((CharSequence)line, (char)'[') && StringUtil.endsWithChar((CharSequence)line, (char)']');
    }

    protected static void addMessage(Callback callback, CompilerMessageCategory type, @Nls String message) {
        if (message == null || message.trim().isEmpty()) {
            return;
        }
        OutputParser.addMessage(callback, type, message, null, -1, -1);
    }

    protected static void addMessage(Callback callback, CompilerMessageCategory type, @Nls String text, @NlsSafe String url, int line, int column) {
        callback.message(type, text, url, line, column);
    }

    public static interface Callback {
        @NlsSafe
        public String getNextLine();

        @NlsSafe
        public String getCurrentLine();

        public void pushBack(@Nls String var1);

        public void setProgressText(@NlsContexts.ProgressText String var1);

        public void fileProcessed(@NlsSafe String var1);

        public void fileGenerated(@NlsSafe String var1);

        public void message(CompilerMessageCategory var1, @Nls String var2, @NlsSafe String var3, int var4, int var5);
    }
}

