/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceBase;
import com.intellij.compiler.backwardRefs.ExcludedFromCompileFilesUtil;
import com.intellij.compiler.backwardRefs.view.DirtyScopeTestInfo;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludedEntriesListener;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleEntityUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class DirtyScopeHolder
extends UserDataHolderBase
implements AsyncFileListener {
    private final Project myProject;
    private final Set<FileType> myFileTypes;
    private final ProjectFileIndex myProjectFileIndex;
    private final ModificationTracker myModificationTracker;
    private final Object myLock;
    private final Set<Module> myVFSChangedModules;
    private final Set<Module> myChangedModulesDuringCompilation;
    private final List<ExcludeEntryDescription> myExcludedDescriptions;
    private boolean myCompilationPhase;
    private volatile GlobalSearchScope myExcludedFilesScope;
    private final Set<String> myCompilationAffectedModules;
    private final FileTypeRegistry myFileTypeRegistry;

    public DirtyScopeHolder(@NotNull Project project, @NotNull Set<FileType> fileTypes, @NotNull ProjectFileIndex projectFileIndex, @NotNull Disposable parentDisposable, @NotNull ModificationTracker modificationTracker, @NotNull BiConsumer<? super MessageBusConnection, ? super Set<String>> compilationAffectedModulesSubscription) {
        if (project == null) {
            DirtyScopeHolder.$$$reportNull$$$0(0);
        }
        if (fileTypes == null) {
            DirtyScopeHolder.$$$reportNull$$$0(1);
        }
        if (projectFileIndex == null) {
            DirtyScopeHolder.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            DirtyScopeHolder.$$$reportNull$$$0(3);
        }
        if (modificationTracker == null) {
            DirtyScopeHolder.$$$reportNull$$$0(4);
        }
        if (compilationAffectedModulesSubscription == null) {
            DirtyScopeHolder.$$$reportNull$$$0(5);
        }
        this.myLock = new Object();
        this.myVFSChangedModules = new HashSet<Module>();
        this.myChangedModulesDuringCompilation = new HashSet<Module>();
        this.myExcludedDescriptions = new SmartList();
        this.myCompilationAffectedModules = ConcurrentCollectionFactory.createConcurrentSet();
        this.myFileTypeRegistry = FileTypeRegistry.getInstance();
        this.myProject = project;
        this.myFileTypes = fileTypes;
        this.myProjectFileIndex = projectFileIndex;
        this.myModificationTracker = modificationTracker;
        if (!CompilerReferenceServiceBase.isEnabled()) {
            return;
        }
        MessageBusConnection connect = project.getMessageBus().connect(parentDisposable);
        connect.subscribe(ExcludedEntriesListener.TOPIC, (Object)new ExcludedEntriesListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onEntryAdded(@NotNull ExcludeEntryDescription description) {
                if (description == null) {
                    1.$$$reportNull$$$0(0);
                }
                Object object = DirtyScopeHolder.this.myLock;
                synchronized (object) {
                    if (DirtyScopeHolder.this.myCompilationPhase) {
                        DirtyScopeHolder.this.myExcludedDescriptions.add(description);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/compiler/backwardRefs/DirtyScopeHolder$1", "onEntryAdded"));
            }
        });
        compilationAffectedModulesSubscription.accept((MessageBusConnection)connect, this.myCompilationAffectedModules);
        connect.subscribe(WorkspaceModelTopics.CHANGED, (Object)new WorkspaceModelChangeListener(){

            public void changed(@NotNull VersionedStorageChange event) {
                ModuleEntity oldEntity;
                ModuleEntity newEntity;
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (EntityChange change : event.getChanges(ModuleEntity.class)) {
                    newEntity = (ModuleEntity)change.getNewEntity();
                    if (newEntity != null) {
                        DirtyScopeHolder.this.addToDirtyModules((Module)ModuleEntityUtils.findModule((ModuleEntity)newEntity, (EntityStorage)event.getStorageAfter()));
                    }
                    if ((oldEntity = (ModuleEntity)change.getOldEntity()) == null) continue;
                    DirtyScopeHolder.this.addToDirtyModules((Module)ModuleEntityUtils.findModule((ModuleEntity)oldEntity, (EntityStorage)event.getStorageBefore()));
                }
                for (EntityChange change : event.getChanges(ContentRootEntity.class)) {
                    newEntity = (ContentRootEntity)change.getNewEntity();
                    if (newEntity != null) {
                        DirtyScopeHolder.this.addToDirtyModules((Module)ModuleEntityUtils.findModule((ModuleEntity)newEntity.getModule(), (EntityStorage)event.getStorageAfter()));
                    }
                    if ((oldEntity = (ContentRootEntity)change.getOldEntity()) == null) continue;
                    DirtyScopeHolder.this.addToDirtyModules((Module)ModuleEntityUtils.findModule((ModuleEntity)oldEntity.getModule(), (EntityStorage)event.getStorageBefore()));
                }
                DirtyScopeHolder.this.clearDisposedModules();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/compiler/backwardRefs/DirtyScopeHolder$2", "changed"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compilerActivityStarted() {
        ExcludeEntryDescription[] excludeEntryDescriptions = CompilerConfiguration.getInstance((Project)this.myProject).getExcludedEntriesConfiguration().getExcludeEntryDescriptions();
        Object object = this.myLock;
        synchronized (object) {
            this.myCompilationPhase = true;
            Collections.addAll(this.myExcludedDescriptions, excludeEntryDescriptions);
            this.myExcludedFilesScope = null;
            this.myCompilationAffectedModules.clear();
        }
    }

    public void upToDateCheckFinished(@Nullable Collection<@NotNull Module> allModules, @Nullable Collection<@NotNull Module> compiledModules) {
        this.compilationFinished(() -> {
            if (allModules != null) {
                this.myVFSChangedModules.addAll(allModules);
            }
            if (compiledModules != null) {
                compiledModules.forEach(this.myVFSChangedModules::remove);
            }
        });
    }

    @NotNull
    public Set<String> getCompilationAffectedModules() {
        Set<String> set = this.myCompilationAffectedModules;
        if (set == null) {
            DirtyScopeHolder.$$$reportNull$$$0(6);
        }
        return set;
    }

    public void compilerActivityFinished(List<Module> compiledModules) {
        this.compilationFinished(() -> {
            if (compiledModules == null) {
                return;
            }
            compiledModules.forEach(this.myVFSChangedModules::remove);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compilationFinished(@NotNull Runnable action) {
        ExcludeEntryDescription[] descriptions;
        if (action == null) {
            DirtyScopeHolder.$$$reportNull$$$0(7);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myCompilationPhase = false;
            action.run();
            this.myVFSChangedModules.addAll(this.myChangedModulesDuringCompilation);
            this.myChangedModulesDuringCompilation.clear();
            descriptions = this.myExcludedDescriptions.toArray(new ExcludeEntryDescription[0]);
            this.myExcludedDescriptions.clear();
        }
        this.myCompilationAffectedModules.clear();
        this.myExcludedFilesScope = ExcludedFromCompileFilesUtil.getExcludedFilesScope(descriptions, this.myFileTypes, this.myProject);
    }

    @NotNull
    public GlobalSearchScope getDirtyScope() {
        Project project = this.myProject;
        GlobalSearchScope globalSearchScope = (GlobalSearchScope)ReadAction.compute(() -> {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myCompilationPhase) {
                    return ProjectScope.getContentScope((Project)project);
                }
                if (project.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                return (GlobalSearchScope)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)this, () -> CachedValueProvider.Result.create((Object)this.calculateDirtyScope(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, VirtualFileManager.getInstance(), this.myModificationTracker}));
            }
        });
        if (globalSearchScope == null) {
            DirtyScopeHolder.$$$reportNull$$$0(8);
        }
        return globalSearchScope;
    }

    @NotNull
    private GlobalSearchScope calculateDirtyScope() {
        Set<Module> dirtyModules = this.getAllDirtyModules();
        if (dirtyModules.isEmpty()) {
            GlobalSearchScope globalSearchScope = this.myExcludedFilesScope;
            if (globalSearchScope == null) {
                DirtyScopeHolder.$$$reportNull$$$0(9);
            }
            return globalSearchScope;
        }
        if (dirtyModules.size() == ModuleManager.getInstance((Project)this.myProject).getModules().length) {
            GlobalSearchScope globalSearchScope = ProjectScope.getContentScope((Project)this.myProject);
            if (globalSearchScope == null) {
                DirtyScopeHolder.$$$reportNull$$$0(10);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.union((Collection)ContainerUtil.append((List)ContainerUtil.map(dirtyModules, Module::getModuleWithDependentsScope), (Object[])new GlobalSearchScope[]{this.myExcludedFilesScope}));
        if (globalSearchScope == null) {
            DirtyScopeHolder.$$$reportNull$$$0(11);
        }
        return globalSearchScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @VisibleForTesting
    @NotNull
    public Set<Module> getAllDirtyModules() {
        HashSet<Module> dirtyModules;
        Object object = this.myLock;
        synchronized (object) {
            dirtyModules = new HashSet<Module>(this.myVFSChangedModules);
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        for (Document document : fileDocumentManager.getUnsavedDocuments()) {
            Module m;
            VirtualFile file = fileDocumentManager.getFile(document);
            if (file == null || (m = this.getModuleForSourceContentFile(file)) == null) continue;
            dirtyModules.add(m);
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        for (Document document : psiDocumentManager.getUncommittedDocuments()) {
            Module m;
            VirtualFile file;
            PsiFile psiFile = psiDocumentManager.getPsiFile(document);
            if (psiFile == null || (file = psiFile.getVirtualFile()) == null || (m = this.getModuleForSourceContentFile(file)) == null) continue;
            dirtyModules.add(m);
        }
        HashSet<Module> hashSet = dirtyModules;
        if (hashSet == null) {
            DirtyScopeHolder.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            DirtyScopeHolder.$$$reportNull$$$0(13);
        }
        return this.getDirtyScope().contains(file);
    }

    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(final @NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
        if (events == null) {
            DirtyScopeHolder.$$$reportNull$$$0(14);
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        final List<Module> modulesToBeMarkedDirty = this.getModulesToBeMarkedDirtyBefore(events);
        return new AsyncFileListener.ChangeApplier(){

            public void beforeVfsChange() {
                modulesToBeMarkedDirty.forEach(DirtyScopeHolder.this::addToDirtyModules);
            }

            public void afterVfsChange() {
                if (!DirtyScopeHolder.this.myProject.isDisposed()) {
                    DirtyScopeHolder.this.after(events);
                }
            }
        };
    }

    private void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            DirtyScopeHolder.$$$reportNull$$$0(15);
        }
        for (VFileEvent vFileEvent : events) {
            VFilePropertyChangeEvent pce;
            String propertyName;
            if (vFileEvent instanceof VFileCreateEvent) {
                String fileName;
                VirtualFile parent = ((VFileCreateEvent)vFileEvent).getParent();
                Module module = this.getModuleForSourceContentFile(parent, fileName = ((VFileCreateEvent)vFileEvent).getChildName());
                if (module == null) continue;
                this.addToDirtyModules(module);
                continue;
            }
            if (vFileEvent instanceof VFileCopyEvent || vFileEvent instanceof VFileMoveEvent) {
                VirtualFile file = vFileEvent.getFile();
                assert (file != null);
                this.fileChanged(file);
                continue;
            }
            if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !"name".equals(propertyName = (pce = (VFilePropertyChangeEvent)vFileEvent).getPropertyName()) && !"symlink".equals(propertyName)) continue;
            this.fileChanged(pce.getFile());
        }
    }

    @Contract(pure=true)
    @NotNull
    private List<Module> getModulesToBeMarkedDirtyBefore(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            DirtyScopeHolder.$$$reportNull$$$0(16);
        }
        ArrayList<Module> modulesToBeMarkedDirty = new ArrayList<Module>();
        for (VFileEvent vFileEvent : events) {
            VFilePropertyChangeEvent pce;
            String propertyName;
            ProgressManager.checkCanceled();
            if (vFileEvent instanceof VFileDeleteEvent || vFileEvent instanceof VFileMoveEvent || vFileEvent instanceof VFileContentChangeEvent) {
                VirtualFile file = vFileEvent.getFile();
                assert (file != null);
                Module module = this.getModuleForSourceContentFile(file);
                ContainerUtil.addIfNotNull(modulesToBeMarkedDirty, (Object)module);
                continue;
            }
            if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !"name".equals(propertyName = (pce = (VFilePropertyChangeEvent)vFileEvent).getPropertyName()) && !"symlink".equals(propertyName)) continue;
            String path = pce.getFile().getPath();
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                if (!FileUtil.isAncestor((String)path, (String)module.getModuleFilePath(), (boolean)true)) continue;
                modulesToBeMarkedDirty.add(module);
            }
        }
        ArrayList<Module> arrayList = modulesToBeMarkedDirty;
        if (arrayList == null) {
            DirtyScopeHolder.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    public void installVFSListener(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            DirtyScopeHolder.$$$reportNull$$$0(18);
        }
        VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)this, parentDisposable);
    }

    private void fileChanged(@NotNull VirtualFile file) {
        Module module;
        if (file == null) {
            DirtyScopeHolder.$$$reportNull$$$0(19);
        }
        if ((module = this.getModuleForSourceContentFile(file)) != null) {
            this.addToDirtyModules(module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToDirtyModules(@Nullable Module module) {
        if (module == null) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myCompilationPhase) {
                this.myChangedModulesDuringCompilation.add(module);
            } else {
                this.myVFSChangedModules.add(module);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearDisposedModules() {
        Object object = this.myLock;
        synchronized (object) {
            this.myChangedModulesDuringCompilation.removeIf(module -> module.isDisposed());
            this.myVFSChangedModules.removeIf(module -> module.isDisposed());
        }
    }

    private Module getModuleForSourceContentFile(@NotNull VirtualFile file) {
        if (file == null) {
            DirtyScopeHolder.$$$reportNull$$$0(20);
        }
        return this.getModuleForSourceContentFile(file, file.getNameSequence());
    }

    private Module getModuleForSourceContentFile(@NotNull VirtualFile parent, @NotNull CharSequence fileName) {
        FileType fileType;
        if (parent == null) {
            DirtyScopeHolder.$$$reportNull$$$0(21);
        }
        if (fileName == null) {
            DirtyScopeHolder.$$$reportNull$$$0(22);
        }
        if (this.myFileTypes.contains(fileType = this.myFileTypeRegistry.getFileTypeByFileName(fileName)) && this.myProjectFileIndex.isInSourceContent(parent)) {
            return this.myProjectFileIndex.getModuleForFile(parent);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public DirtyScopeTestInfo getState() {
        Object object = this.myLock;
        // MONITORENTER : object
        Object[] vfsChangedModules = this.myVFSChangedModules.toArray(Module.EMPTY_ARRAY);
        ArrayList<Module> unsavedChangedModuleList = new ArrayList<Module>(this.getAllDirtyModules());
        ContainerUtil.removeAll(unsavedChangedModuleList, (Object[])vfsChangedModules);
        Module[] unsavedChangedModules = unsavedChangedModuleList.toArray(Module.EMPTY_ARRAY);
        ArrayList excludedFiles = this.myExcludedFilesScope instanceof Iterable ? ContainerUtil.newArrayList((Iterable)((Iterable)this.myExcludedFilesScope)) : Collections.emptyList();
        DirtyScopeTestInfo dirtyScopeTestInfo = new DirtyScopeTestInfo((Module[])vfsChangedModules, unsavedChangedModules, excludedFiles.toArray(VirtualFile.EMPTY_ARRAY), this.getDirtyScope());
        // MONITOREXIT : object
        if (dirtyScopeTestInfo != null) return dirtyScopeTestInfo;
        DirtyScopeHolder.$$$reportNull$$$0(23);
        return dirtyScopeTestInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 9, 10, 11, 12, 17, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFileIndex";
                break;
            }
            case 3: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modificationTracker";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilationAffectedModulesSubscription";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/backwardRefs/DirtyScopeHolder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 13: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/backwardRefs/DirtyScopeHolder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilationAffectedModules";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirtyScope";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateDirtyScope";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDirtyModules";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesToBeMarkedDirtyBefore";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 23: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "compilationFinished";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "prepareChange";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "after";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getModulesToBeMarkedDirtyBefore";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "installVFSListener";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "fileChanged";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getModuleForSourceContentFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 9, 10, 11, 12, 17, 23 -> new IllegalStateException(string);
        };
    }
}

