/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.impl.CompileDriverNotifications;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.UnknownSdkBlockingCollector;
import com.intellij.openapi.projectRoots.impl.UnknownSdkCollector;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFix;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFixAction;
import com.intellij.openapi.projectRoots.impl.UnknownSdkTracker;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0001\u0010\r\u001a\u00020\u000eJ\"\u0010\u000f\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000bJ\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/compiler/impl/CompilerDriverUnknownSdkTracker;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "fixSdkSettings", "Lcom/intellij/compiler/impl/CompilerDriverUnknownSdkTracker$Outcome;", "updateProjectSdk", "", "modules", "", "Lcom/intellij/openapi/module/Module;", "formattedModulesList", "", "processManualFixes", "actions", "Lcom/intellij/openapi/projectRoots/impl/UnknownSdkFix;", "applySuggestions", "", "suggestions", "Lcom/intellij/openapi/projectRoots/impl/UnknownSdkFixAction;", "Companion", "Outcome", "intellij.java.compiler.impl"})
@SourceDebugExtension(value={"SMAP\nCompilerDriverUnknownSdkTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilerDriverUnknownSdkTracker.kt\ncom/intellij/compiler/impl/CompilerDriverUnknownSdkTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,147:1\n1642#2,10:148\n1915#2:158\n1916#2:160\n1652#2:161\n777#2:162\n873#2,2:163\n1068#2:165\n1586#2:166\n1661#2,3:167\n1068#2:170\n1586#2:171\n1661#2,3:172\n1#3:159\n13#4:175\n*S KotlinDebug\n*F\n+ 1 CompilerDriverUnknownSdkTracker.kt\ncom/intellij/compiler/impl/CompilerDriverUnknownSdkTracker\n*L\n83#1:148,10\n83#1:158\n83#1:160\n83#1:161\n84#1:162\n84#1:163,2\n99#1:165\n99#1:166\n99#1:167,3\n109#1:170\n109#1:171\n109#1:172,3\n83#1:159\n31#1:175\n*E\n"})
public final class CompilerDriverUnknownSdkTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;

    public CompilerDriverUnknownSdkTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Outcome fixSdkSettings(boolean updateProjectSdk, @NotNull List<? extends Module> modules, @NlsSafe @NotNull String formattedModulesList) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Intrinsics.checkNotNullParameter((Object)formattedModulesList, (String)"formattedModulesList");
        if (!Registry.Companion.is("unknown.sdk.modal.jps")) {
            return Outcome.CONTINUE_COMPILE;
        }
        Project project = this.project;
        String string = ProjectBundle.message((String)"progress.title.resolving.sdks", (Object[])new Object[0]);
        Object object = ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<Outcome, Exception>(this, modules, updateProjectSdk, project, string){
            final /* synthetic */ CompilerDriverUnknownSdkTracker this$0;
            final /* synthetic */ List<Module> $modules;
            final /* synthetic */ boolean $updateProjectSdk;
            {
                this.this$0 = $receiver;
                this.$modules = $modules;
                this.$updateProjectSdk = $updateProjectSdk;
                super($super_call_param$1, $super_call_param$2, true);
            }

            protected Outcome compute(ProgressIndicator indicator) {
                Outcome outcome;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    outcome = this.computeImpl(indicator);
                }
                catch (Throwable t) {
                    if (t instanceof ControlFlowException) {
                        throw t;
                    }
                    CompilerDriverUnknownSdkTracker.Companion.getLOG().warn("Failed to test for Unknown SDKs. " + t.getMessage(), t);
                    outcome = Outcome.CONTINUE_COMPILE;
                }
                return outcome;
            }

            public final Outcome computeImpl(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Project project = this.getProject();
                UnknownSdkCollector collector2 = new UnknownSdkCollector(this.$updateProjectSdk, this.$modules, project){
                    final /* synthetic */ boolean $updateProjectSdk;
                    final /* synthetic */ List<Module> $modules;
                    {
                        this.$updateProjectSdk = $updateProjectSdk;
                        this.$modules = $modules;
                        Intrinsics.checkNotNull((Object)$super_call_param$1);
                        super($super_call_param$1);
                    }

                    protected boolean checkProjectSdk(Project project) {
                        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                        return this.$updateProjectSdk;
                    }

                    protected List<Module> collectModulesToCheckSdk(Project project) {
                        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                        return this.$modules;
                    }
                };
                List list = UnknownSdkTracker.getInstance((Project)this.getProject()).collectUnknownSdks((UnknownSdkBlockingCollector)collector2, indicator);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"collectUnknownSdks(...)");
                List allActions = list;
                if (allActions.isEmpty()) {
                    return Outcome.CONTINUE_COMPILE;
                }
                List list2 = UnknownSdkTracker.getInstance((Project)this.getProject()).applyAutoFixesAndNotify(allActions, indicator);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"applyAutoFixesAndNotify(...)");
                List actions = list2;
                if (actions.isEmpty()) {
                    return Outcome.CONTINUE_COMPILE;
                }
                return this.this$0.processManualFixes(this.$modules, actions);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (Outcome)((Object)object);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Outcome processManualFixes(@NotNull List<? extends Module> modules, @NotNull List<? extends UnknownSdkFix> actions) {
        Collection<HtmlChunk.Element> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Iterable $this$mapNotNull$iv = actions;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<UnknownSdkFixAction> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            UnknownSdkFixAction it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            UnknownSdkFix it = (UnknownSdkFix)element$iv$iv;
            boolean bl2 = false;
            if (it.getSuggestedFixAction() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List actionsWithFix = (List)destination$iv$iv;
        Iterable $this$filter$iv = actions;
        boolean $i$f$filter22 = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            UnknownSdkFix it = (UnknownSdkFix)element$iv$iv;
            boolean bl = false;
            if (!(it.getSuggestedFixAction() == null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List actionsWithoutFix = (List)destination$iv$iv2;
        if (actionsWithFix.isEmpty()) {
            return Outcome.CONTINUE_COMPILE;
        }
        HtmlBuilder message = new HtmlBuilder();
        Object[] $i$f$filter22 = new Object[]{modules.size(), modules.size()};
        message.append(JavaCompilerBundle.message((String)"dialog.message.error.jdk.not.specified.with.fixSuggestion", (Object[])$i$f$filter22));
        Iterable $this$sortedBy$iv = actionsWithFix;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                UnknownSdkFixAction it = (UnknownSdkFixAction)a;
                boolean bl = false;
                String string = it.getActionDetailedText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getActionDetailedText(...)");
                String string2 = string;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                it = (UnknownSdkFixAction)b;
                Comparable comparable = (Comparable)((Object)string3);
                bl = false;
                String string4 = it.getActionDetailedText();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getActionDetailedText(...)");
                string2 = string4;
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
                String string5 = string2.toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string5)));
            }
        });
        HtmlChunk.Element element = HtmlChunk.ul();
        HtmlBuilder htmlBuilder = message;
        boolean $i$f$map = false;
        destination$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void fix;
            UnknownSdkFixAction bl = (UnknownSdkFixAction)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl4 = false;
            HtmlChunk.Element li = null;
            HtmlChunk.Element element2 = HtmlChunk.li().addText(fix.getActionDetailedText());
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"addText(...)");
            li = element2;
            if (fix.getActionTooltipText() != null) {
                String it;
                boolean bl5 = false;
                HtmlChunk.Element element3 = li.addText(it);
                Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"addText(...)");
                li = element3;
            }
            collection.add(li);
        }
        collection = (List)destination$iv$iv3;
        htmlBuilder.append((HtmlChunk)element.children((List)collection));
        if (!((Collection)actionsWithoutFix).isEmpty()) {
            message.append(JavaCompilerBundle.message((String)"dialog.message.error.jdk.not.specified.with.noFix", (Object[])new Object[0]));
            $this$sortedBy$iv = actionsWithoutFix;
            $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    UnknownSdkFix it = (UnknownSdkFix)a;
                    boolean bl = false;
                    String string = it.getNotificationText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNotificationText(...)");
                    String string2 = string;
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    String string3 = string2.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                    it = (UnknownSdkFix)b;
                    Comparable comparable = (Comparable)((Object)string3);
                    bl = false;
                    String string4 = it.getNotificationText();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getNotificationText(...)");
                    string2 = string4;
                    Locale locale2 = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
                    String string5 = string2.toLowerCase(locale2);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string5)));
                }
            });
            element = HtmlChunk.ul();
            htmlBuilder = message;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                UnknownSdkFix fix = (UnknownSdkFix)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl = false;
                collection.add(HtmlChunk.li().addText(fix.getNotificationText()));
            }
            collection = (List)destination$iv$iv3;
            htmlBuilder.append((HtmlChunk)element.children(collection));
        }
        CompileDriverNotifications.LightNotification lightNotification = CompileDriverNotifications.Companion.getInstance(this.project).createCannotStartNotification();
        String string = message.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        CompileDriverNotifications.LightNotification lightNotification2 = lightNotification.withContent(string);
        String string2 = JavaCompilerBundle.message((String)"dialog.message.action.apply.fix", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Module module = (Module)CollectionsKt.firstOrNull(modules);
        lightNotification2.withExpiringAction(string2, (Function0<Unit>)((Function0)() -> CompilerDriverUnknownSdkTracker.processManualFixes$lambda$6(this, actionsWithFix))).withOpenSettingsAction(module != null ? module.getName() : null, null).showNotification();
        return Outcome.STOP_COMPILE;
    }

    private final void applySuggestions(List<? extends UnknownSdkFixAction> suggestions) {
        if (suggestions.isEmpty()) {
            return;
        }
        Project project = this.project;
        String string = ProjectBundle.message((String)"progress.title.resolving.sdks", (Object[])new Object[0]);
        Task.Backgroundable task2 = new Task.Backgroundable(suggestions, project, string){
            final /* synthetic */ List<UnknownSdkFixAction> $suggestions;
            {
                this.$suggestions = $suggestions;
                super($super_call_param$1, $super_call_param$2, true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                for (UnknownSdkFixAction suggestion : this.$suggestions) {
                    try {
                        Sdk sdk;
                        ProgressIndicator $this$withPushPop$iv = indicator;
                        boolean $i$f$withPushPop = false;
                        boolean wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
                        $this$withPushPop$iv.pushState();
                        try {
                            boolean bl = false;
                            sdk = suggestion.applySuggestionBlocking(indicator);
                        }
                        finally {
                            $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv);
                            $this$withPushPop$iv.popState();
                        }
                        Sdk sdk2 = sdk;
                        Intrinsics.checkNotNull((Object)sdk2);
                    }
                    catch (Throwable t) {
                        if (t instanceof ControlFlowException) break;
                        CompilerDriverUnknownSdkTracker.Companion.getLOG().warn("Failed to apply suggestion " + suggestion + ". " + t.getMessage(), t);
                    }
                }
            }
        };
        ProgressManager.getInstance().run((Task)task2);
    }

    private static final Unit processManualFixes$lambda$6(CompilerDriverUnknownSdkTracker this$0, List $actionsWithFix) {
        this$0.applySuggestions($actionsWithFix);
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final CompilerDriverUnknownSdkTracker getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CompilerDriverUnknownSdkTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/compiler/impl/CompilerDriverUnknownSdkTracker$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/compiler/impl/CompilerDriverUnknownSdkTracker;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.java.compiler.impl"})
    @SourceDebugExtension(value={"SMAP\nCompilerDriverUnknownSdkTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilerDriverUnknownSdkTracker.kt\ncom/intellij/compiler/impl/CompilerDriverUnknownSdkTracker$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,147:1\n30#2,2:148\n*S KotlinDebug\n*F\n+ 1 CompilerDriverUnknownSdkTracker.kt\ncom/intellij/compiler/impl/CompilerDriverUnknownSdkTracker$Companion\n*L\n34#1:148,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @JvmStatic
        @NotNull
        public final CompilerDriverUnknownSdkTracker getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<CompilerDriverUnknownSdkTracker> serviceClass$iv = CompilerDriverUnknownSdkTracker.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (CompilerDriverUnknownSdkTracker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/compiler/impl/CompilerDriverUnknownSdkTracker$Outcome;", "", "<init>", "(Ljava/lang/String;I)V", "STOP_COMPILE", "CONTINUE_COMPILE", "intellij.java.compiler.impl"})
    public static final class Outcome
    extends Enum<Outcome> {
        public static final /* enum */ Outcome STOP_COMPILE = new Outcome();
        public static final /* enum */ Outcome CONTINUE_COMPILE = new Outcome();
        private static final /* synthetic */ Outcome[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Outcome[] values() {
            return (Outcome[])$VALUES.clone();
        }

        public static Outcome valueOf(String value) {
            return Enum.valueOf(Outcome.class, value);
        }

        @NotNull
        public static EnumEntries<Outcome> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = outcomeArray = new Outcome[]{Outcome.STOP_COMPILE, Outcome.CONTINUE_COMPILE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

