/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.inspection;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.ui.MemberSelectionPanel;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

public final class ChangeSuperClassFix
implements LocalQuickFix,
HighPriorityAction {
    @NotNull
    private final SmartPsiElementPointer<PsiClass> myNewSuperClass;
    @NotNull
    private final SmartPsiElementPointer<PsiClass> myOldSuperClass;
    private final int myInheritorCount;
    @NotNull
    private final String myNewSuperName;
    private final boolean myImplements;

    public ChangeSuperClassFix(@NotNull PsiClass newSuperClass, @NotNull PsiClass oldSuperClass, int percent, boolean isImplements) {
        if (newSuperClass == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(0);
        }
        if (oldSuperClass == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(1);
        }
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)newSuperClass.getProject());
        this.myNewSuperName = Objects.requireNonNull(newSuperClass.getQualifiedName());
        this.myNewSuperClass = smartPointerManager.createSmartPsiElementPointer((PsiElement)newSuperClass);
        this.myOldSuperClass = smartPointerManager.createSmartPsiElementPointer((PsiElement)oldSuperClass);
        this.myInheritorCount = percent;
        this.myImplements = isImplements;
    }

    @TestOnly
    @NotNull
    public PsiClass getNewSuperClass() {
        PsiClass psiClass = Objects.requireNonNull((PsiClass)this.myNewSuperClass.getElement());
        if (psiClass == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(2);
        }
        return psiClass;
    }

    @TestOnly
    public int getInheritorCount() {
        return this.myInheritorCount;
    }

    @NotNull
    public String getName() {
        if (this.myImplements) {
            String string = JavaCompilerBundle.message((String)"intention.name.make.implements", (Object[])new Object[]{this.myNewSuperName});
            if (string == null) {
                ChangeSuperClassFix.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = JavaCompilerBundle.message((String)"intention.name.make.extends", (Object[])new Object[]{this.myNewSuperName});
        if (string == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"group.names.inheritance.issues", (Object[])new Object[0]);
        if (string == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
        if (project == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(6);
        }
        if (problemDescriptor == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(7);
        }
        PsiClass oldSuperClass = (PsiClass)this.myOldSuperClass.getElement();
        PsiClass newSuperClass = (PsiClass)this.myNewSuperClass.getElement();
        if (oldSuperClass == null || newSuperClass == null) {
            return;
        }
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)problemDescriptor.getPsiElement(), PsiClass.class, (boolean)false);
        if (aClass == null || !FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{aClass})) {
            return;
        }
        ChangeSuperClassFix.changeSuperClass(aClass, oldSuperClass, newSuperClass);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        PsiClass aClass;
        if (project == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(8);
        }
        if (previewDescriptor == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(9);
        }
        if ((aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)previewDescriptor.getPsiElement(), PsiClass.class, (boolean)false)) == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                ChangeSuperClassFix.$$$reportNull$$$0(10);
            }
            return intentionPreviewInfo;
        }
        PsiClass oldSuperClass = (PsiClass)this.myOldSuperClass.getElement();
        PsiClass newSuperClass = (PsiClass)this.myNewSuperClass.getElement();
        if (oldSuperClass == null || newSuperClass == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                ChangeSuperClassFix.$$$reportNull$$$0(11);
            }
            return intentionPreviewInfo;
        }
        ChangeSuperClassFix.addSuperClass(aClass, oldSuperClass, newSuperClass);
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        if (intentionPreviewInfo == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(12);
        }
        return intentionPreviewInfo;
    }

    private static void changeSuperClass(@NotNull PsiClass aClass, @NotNull PsiClass oldSuperClass, @NotNull PsiClass newSuperClass) {
        if (aClass == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(13);
        }
        if (oldSuperClass == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(14);
        }
        if (newSuperClass == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(15);
        }
        Object[] ownMethods = aClass.getMethods();
        List oldOverridenMethods = ContainerUtil.mapNotNull((Object[])ownMethods, m -> {
            if (m.isConstructor()) {
                return null;
            }
            Object[] supers = m.findSuperMethods(oldSuperClass);
            if (supers.length == 0) {
                return null;
            }
            return Pair.create((Object)m, (Object)ContainerUtil.newHashSet((Object[])supers));
        });
        WriteAction.run(() -> ChangeSuperClassFix.addSuperClass(aClass, oldSuperClass, newSuperClass));
        List<MemberInfo> memberInfos = oldOverridenMethods.stream().filter(m -> {
            HashSet newSupers = ContainerUtil.newHashSet((Object[])((PsiMethod)m.getFirst()).findSuperMethods(newSuperClass));
            return !newSupers.equals(m.getSecond());
        }).map(m -> (PsiMethod)m.getFirst()).map(m -> {
            MemberInfo info = new MemberInfo((PsiMember)m);
            info.setChecked(true);
            return info;
        }).collect(Collectors.toList());
        if (memberInfos.isEmpty()) {
            return;
        }
        List<PsiMethod> toDelete = ChangeSuperClassFix.getOverridenMethodsToDelete(memberInfos, newSuperClass.getName(), aClass.getProject());
        if (!toDelete.isEmpty()) {
            WriteAction.run(() -> {
                for (PsiMethod method : toDelete) {
                    method.delete();
                }
            });
        }
    }

    private static void addSuperClass(@NotNull PsiClass aClass, @NotNull PsiClass oldSuperClass, @NotNull PsiClass newSuperClass) {
        PsiElement ref;
        if (aClass == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(16);
        }
        if (oldSuperClass == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(17);
        }
        if (newSuperClass == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(18);
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)aClass.getProject());
        PsiElementFactory factory = psiFacade.getElementFactory();
        if (aClass instanceof PsiAnonymousClass) {
            ref = ((PsiAnonymousClass)aClass).getBaseClassReference().replace((PsiElement)factory.createClassReferenceElement(newSuperClass));
        } else {
            PsiReferenceList list;
            PsiJavaCodeReferenceElement[] refElements;
            PsiReferenceList extendsList = Objects.requireNonNull(aClass.getExtendsList());
            for (PsiJavaCodeReferenceElement refElement : refElements = (PsiJavaCodeReferenceElement[])ArrayUtil.mergeArrays((Object[])ChangeSuperClassFix.getReferences(extendsList), (Object[])ChangeSuperClassFix.getReferences(aClass.getImplementsList()))) {
                if (!refElement.isReferenceTo((PsiElement)oldSuperClass)) continue;
                refElement.delete();
            }
            if (newSuperClass.isInterface() && !aClass.isInterface()) {
                list = aClass.getImplementsList();
            } else {
                PsiClass objectClass;
                list = extendsList;
                PsiJavaCodeReferenceElement[] elements = list.getReferenceElements();
                if (elements.length == 1 && (objectClass = psiFacade.findClass("java.lang.Object", aClass.getResolveScope())) != null && elements[0].isReferenceTo((PsiElement)objectClass)) {
                    elements[0].delete();
                }
            }
            assert (list != null);
            ref = list.add((PsiElement)factory.createClassReferenceElement(newSuperClass));
        }
        JavaCodeStyleManager.getInstance((Project)aClass.getProject()).shortenClassReferences(ref);
    }

    private static PsiJavaCodeReferenceElement @NotNull [] getReferences(PsiReferenceList list) {
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = list == null ? PsiJavaCodeReferenceElement.EMPTY_ARRAY : list.getReferenceElements();
        if (psiJavaCodeReferenceElementArray == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(19);
        }
        return psiJavaCodeReferenceElementArray;
    }

    @NotNull
    private static @Unmodifiable List<PsiMethod> getOverridenMethodsToDelete(List<MemberInfo> candidates, String newClassName, Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            List list = ContainerUtil.map(candidates, c -> (PsiMethod)c.getMember());
            if (list == null) {
                ChangeSuperClassFix.$$$reportNull$$$0(20);
            }
            return list;
        }
        final MemberSelectionPanel panel = new MemberSelectionPanel(JavaCompilerBundle.message((String)"separator.choose.members.to.delete", (Object[])new Object[]{newClassName}), candidates, null);
        DialogWrapper dlg = new DialogWrapper(project, false){
            {
                super(arg0, arg1);
                this.setOKButtonText(CommonBundle.message((String)"button.without.mnemonic.remove", (Object[])new Object[0]));
                this.setTitle(JavaCompilerBundle.message((String)"choose.members", (Object[])new Object[0]));
                this.init();
            }

            @NotNull
            protected JComponent createCenterPanel() {
                MemberSelectionPanel memberSelectionPanel = panel;
                if (memberSelectionPanel == null) {
                    1.$$$reportNull$$$0(0);
                }
                return memberSelectionPanel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/inspection/ChangeSuperClassFix$1", "createCenterPanel"));
            }
        };
        List list = dlg.showAndGet() ? ContainerUtil.map((Collection)panel.getTable().getSelectedMemberInfos(), info -> (PsiMethod)info.getMember()) : Collections.emptyList();
        if (list == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(21);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 10, 11, 12, 19, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSuperClass";
                break;
            }
            case 1: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldSuperClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/inspection/ChangeSuperClassFix";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/inspection/ChangeSuperClassFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewSuperClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverridenMethodsToDelete";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "changeSuperClass";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addSuperClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 10, 11, 12, 19, 20, 21 -> new IllegalStateException(string);
        };
    }
}

