/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.progress;

import com.intellij.compiler.CompilerManagerImpl;
import com.intellij.compiler.impl.ExitStatus;
import com.intellij.compiler.progress.BuildOutputService;
import com.intellij.compiler.progress.BuildViewService;
import com.intellij.compiler.progress.CompilerMessagesService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.AppIconScheme;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.pom.Navigatable;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.ui.AppIcon;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class CompilerTask
extends Task.Backgroundable {
    private static final String APP_ICON_ID = "compiler";
    @NotNull
    private final Object myContentId;
    @NotNull
    private Object mySessionId;
    private final boolean myModal;
    private final boolean myHeadlessMode;
    private final boolean myForceAsyncExecution;
    private final boolean myWaitForPreviousSession;
    private int myErrorCount;
    private int myWarningCount;
    private volatile ProgressIndicator myIndicator;
    private Runnable myCompileWork;
    private Runnable myRestartWork;
    private final boolean myCompilationStartedAutomatically;
    private final BuildViewService myBuildViewService;
    private long myStartCompilationStamp;
    private long myEndCompilationStamp;
    private ExitStatus myExitStatus;

    public CompilerTask(@NotNull Project project, @NlsContexts.TabTitle String contentName, boolean headlessMode, boolean forceAsync, boolean waitForPreviousSession, boolean compilationStartedAutomatically) {
        if (project == null) {
            CompilerTask.$$$reportNull$$$0(0);
        }
        this(project, contentName, headlessMode, forceAsync, waitForPreviousSession, compilationStartedAutomatically, false);
    }

    public CompilerTask(@NotNull Project project, @NlsContexts.TabTitle String contentName, boolean headlessMode, boolean forceAsync, boolean waitForPreviousSession, boolean compilationStartedAutomatically, boolean modal) {
        if (project == null) {
            CompilerTask.$$$reportNull$$$0(1);
        }
        super(project, contentName);
        this.myErrorCount = 0;
        this.myWarningCount = 0;
        this.myIndicator = new EmptyProgressIndicator();
        this.myHeadlessMode = headlessMode;
        this.myForceAsyncExecution = forceAsync;
        this.myWaitForPreviousSession = waitForPreviousSession;
        this.myCompilationStartedAutomatically = compilationStartedAutomatically;
        this.myModal = modal;
        this.mySessionId = this.myContentId = new IDObject("content_id");
        this.myBuildViewService = SystemProperties.getBooleanProperty((String)"ide.jps.use.build.tool.window", (boolean)true) ? new BuildOutputService(project, contentName, this.myCompilationStartedAutomatically) : new CompilerMessagesService(project, this.myContentId, contentName, headlessMode);
    }

    @NotNull
    public Object getSessionId() {
        Object object = this.mySessionId;
        if (object == null) {
            CompilerTask.$$$reportNull$$$0(2);
        }
        return object;
    }

    public void setSessionId(@NotNull Object sessionId) {
        if (sessionId == null) {
            CompilerTask.$$$reportNull$$$0(3);
        }
        this.mySessionId = sessionId;
    }

    @NotNull
    public Object getContentId() {
        Object object = this.myContentId;
        if (object == null) {
            CompilerTask.$$$reportNull$$$0(4);
        }
        return object;
    }

    public void setStartCompilationStamp(long startCompilationStamp) {
        this.myStartCompilationStamp = startCompilationStamp;
    }

    public void setEndCompilationStamp(ExitStatus exitStatus, long endCompilationStamp) {
        this.myExitStatus = exitStatus;
        this.myEndCompilationStamp = endCompilationStamp;
    }

    public void registerCloseAction(Runnable onClose) {
        this.myBuildViewService.registerCloseAction(onClose);
    }

    public boolean shouldStartInBackground() {
        return !this.myModal;
    }

    public boolean isConditionalModal() {
        return this.myModal;
    }

    public ProgressIndicator getIndicator() {
        return this.myIndicator;
    }

    @NotNull
    public Task.NotificationInfo getNotificationInfo() {
        return new Task.NotificationInfo(this.myErrorCount > 0 ? "Compiler (errors)" : "Compiler (success)", JavaCompilerBundle.message((String)"compilation.finished", (Object[])new Object[0]), JavaCompilerBundle.message((String)"0.errors.1.warnings", (Object[])new Object[]{this.myErrorCount, this.myWarningCount}), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CompilerTask.$$$reportNull$$$0(5);
        }
        this.myIndicator = indicator;
        this.myIndicator.setIndeterminate(false);
        this.myBuildViewService.onStart(this.mySessionId, this.myStartCompilationStamp, this.myRestartWork, indicator);
        Semaphore semaphore = ((CompilerManagerImpl)CompilerManager.getInstance((Project)this.myProject)).getCompilationSemaphore();
        boolean acquired = false;
        try {
            if (!this.myCompilationStartedAutomatically || !this.isHeadless()) {
                while (true) {
                    try {
                        if (acquired) break;
                        acquired = semaphore.tryAcquire(300L, TimeUnit.MILLISECONDS);
                        if (acquired || this.myWaitForPreviousSession) continue;
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                        break;
                    }
                    {
                        if (!indicator.isCanceled()) continue;
                    }
                    break;
                }
            }
            if (!this.isHeadless()) {
                this.addIndicatorDelegate();
            }
            this.myCompileWork.run();
            return;
        }
        catch (ProcessCanceledException processCanceledException) {
            try {
                indicator.stop();
                this.myBuildViewService.onEnd(this.mySessionId, this.myExitStatus, this.myEndCompilationStamp);
                return;
            }
            finally {
                if (acquired) {
                    semaphore.release();
                }
            }
        }
        finally {
            try {
                indicator.stop();
                this.myBuildViewService.onEnd(this.mySessionId, this.myExitStatus, this.myEndCompilationStamp);
            }
            finally {
                if (acquired) {
                    semaphore.release();
                }
            }
        }
    }

    private void addIndicatorDelegate() {
        ProgressIndicator indicator = this.myIndicator;
        if (!(indicator instanceof ProgressIndicatorEx)) {
            return;
        }
        ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

            public void cancel() {
                super.cancel();
                this.stopAppIconProgress();
            }

            public void stop() {
                super.stop();
                this.stopAppIconProgress();
            }

            private void stopAppIconProgress() {
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (CompilerTask.this.myProject != null && CompilerTask.this.myProject.isDisposed()) {
                        return;
                    }
                    AppIcon appIcon = AppIcon.getInstance();
                    if (appIcon.hideProgress(CompilerTask.this.myProject, (Object)CompilerTask.APP_ICON_ID)) {
                        if (CompilerTask.this.myErrorCount > 0) {
                            appIcon.setErrorBadge(CompilerTask.this.myProject, String.valueOf(CompilerTask.this.myErrorCount));
                            appIcon.requestAttention(CompilerTask.this.myProject, true);
                        } else if (!CompilerTask.this.myCompilationStartedAutomatically) {
                            appIcon.setOkBadge(CompilerTask.this.myProject, true);
                            appIcon.requestAttention(CompilerTask.this.myProject, false);
                        }
                    }
                });
            }

            public void setFraction(double fraction) {
                super.setFraction(fraction);
                ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.any(), () -> AppIcon.getInstance().setProgress(CompilerTask.this.myProject, (Object)CompilerTask.APP_ICON_ID, AppIconScheme.Progress.BUILD, fraction, true));
            }

            protected void onProgressChange() {
                CompilerTask.this.myBuildViewService.onProgressChange(CompilerTask.this.mySessionId, (ProgressIndicator)this);
            }
        });
    }

    public void cancel() {
        if (!this.myIndicator.isCanceled()) {
            this.myIndicator.cancel();
        }
    }

    public void addMessage(CompilerMessage message) {
        CompilerMessageCategory messageCategory = message.getCategory();
        if (CompilerMessageCategory.WARNING.equals((Object)messageCategory)) {
            ++this.myWarningCount;
        } else if (CompilerMessageCategory.ERROR.equals((Object)messageCategory)) {
            ++this.myErrorCount;
            this.informWolf(message);
        }
        this.myBuildViewService.addMessage(this.mySessionId, message);
    }

    private void informWolf(CompilerMessage message) {
        if (this.myProject == null) {
            return;
        }
        Runnable task2 = () -> {
            Navigatable navigatable;
            if (this.myProject.isDisposed()) {
                return;
            }
            VirtualFile file = message.getVirtualFile();
            if (file == null && (navigatable = message.getNavigatable()) instanceof OpenFileDescriptor) {
                file = ((OpenFileDescriptor)navigatable).getFile();
            }
            if (file != null) {
                WolfTheProblemSolver.getInstance((Project)this.myProject).queue(file);
            }
        };
        Application app = ApplicationManager.getApplication();
        if (app.isDispatchThread()) {
            app.executeOnPooledThread(task2);
        } else {
            task2.run();
        }
    }

    public static int translateCategory(CompilerMessageCategory category) {
        return CompilerMessagesService.translateCategory(category);
    }

    public void start(Runnable compileWork, Runnable restartWork) {
        this.myCompileWork = compileWork;
        this.myRestartWork = restartWork;
        ProgressManager.getInstance().run((Task)this);
    }

    public void run(Runnable compileWork, Runnable restartWork, ProgressIndicator progressIndicator) {
        this.myCompileWork = compileWork;
        this.myRestartWork = restartWork;
        this.run(progressIndicator);
    }

    public boolean isHeadless() {
        return this.myHeadlessMode && !this.myForceAsyncExecution;
    }

    public static TextRange getTextRange(CompilerMessage message) {
        Navigatable navigatable = message.getNavigatable();
        if (navigatable instanceof OpenFileDescriptor) {
            int offset = ((OpenFileDescriptor)navigatable).getOffset();
            return new TextRange(offset, offset);
        }
        return TextRange.EMPTY_RANGE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/progress/CompilerTask";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/progress/CompilerTask";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSessionId";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }

    public static final class IDObject {
        private final String myDisplayName;

        public IDObject(@NotNull String displayName) {
            if (displayName == null) {
                IDObject.$$$reportNull$$$0(0);
            }
            this.myDisplayName = displayName;
        }

        public String toString() {
            return this.myDisplayName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/compiler/progress/CompilerTask$IDObject", "<init>"));
        }
    }
}

