/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.intellij.compiler.cache.CompilerCacheLoadingSettings;
import com.intellij.compiler.cache.git.GitRepositoryUtil;
import com.intellij.compiler.server.BuilderMessageHandler;
import com.intellij.compiler.server.CustomBuilderMessageHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import io.netty.channel.Channel;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.api.CmdlineRemoteProto;

public abstract class DefaultMessageHandler
implements BuilderMessageHandler {
    private static final Logger LOG = Logger.getInstance(DefaultMessageHandler.class);
    private final Project myProject;

    protected DefaultMessageHandler(Project project) {
        this.myProject = project;
    }

    @Override
    public void buildStarted(@NotNull UUID sessionId) {
        if (sessionId == null) {
            DefaultMessageHandler.$$$reportNull$$$0(0);
        }
    }

    @Override
    public final void handleBuildMessage(Channel channel, UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage msg) {
        switch (msg.getType()) {
            case BUILD_EVENT: {
                CmdlineRemoteProto.Message.BuilderMessage.BuildEvent event = msg.getBuildEvent();
                if (event.getEventType() == CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Type.CUSTOM_BUILDER_MESSAGE && event.hasCustomBuilderMessage()) {
                    CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.CustomBuilderMessage message = event.getCustomBuilderMessage();
                    if (!this.myProject.isDisposed()) {
                        ((CustomBuilderMessageHandler)this.myProject.getMessageBus().syncPublisher(CustomBuilderMessageHandler.TOPIC)).messageReceived(sessionId, message.getBuilderId(), message.getMessageType(), message.getMessageText());
                    }
                }
                this.handleBuildEvent(sessionId, event);
                break;
            }
            case COMPILE_MESSAGE: {
                CmdlineRemoteProto.Message.BuilderMessage.CompileMessage compileMessage = msg.getCompileMessage();
                this.handleCompileMessage(sessionId, compileMessage);
                if (compileMessage.getKind() != CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.INTERNAL_BUILDER_ERROR) break;
                LOG.error("Internal build error:\n" + compileMessage.getText());
                break;
            }
            case CACHE_DOWNLOAD_MESSAGE: {
                CmdlineRemoteProto.Message.BuilderMessage.CacheDownloadMessage cacheDownloadMessage = msg.getCacheDownloadMessage();
                ProgressIndicator progressIndicator = this.getProgressIndicator();
                progressIndicator.setIndeterminate(false);
                @NlsSafe String descriptionText = cacheDownloadMessage.getDescriptionText();
                progressIndicator.setText(descriptionText);
                if (!cacheDownloadMessage.hasDone()) break;
                progressIndicator.setFraction((double)cacheDownloadMessage.getDone());
                break;
            }
            case SAVE_LATEST_DOWNLOAD_STATISTIC_MESSAGE: {
                CmdlineRemoteProto.Message.BuilderMessage.CommitAndDownloadStatistics downloadStatisticsMessage = msg.getCommitAndDownloadStatistics();
                GitRepositoryUtil.saveLatestDownloadedCommit(downloadStatisticsMessage.getCommit());
                CompilerCacheLoadingSettings.saveApproximateDecompressionSpeed(downloadStatisticsMessage.getDecompressionSpeed());
                CompilerCacheLoadingSettings.saveApproximateDeletionSpeed(downloadStatisticsMessage.getDeletionSpeed());
                break;
            }
            case SAVE_LATEST_BUILT_COMMIT_MESSAGE: {
                GitRepositoryUtil.saveLatestBuiltMasterCommit(this.myProject);
                break;
            }
        }
    }

    protected abstract void handleCompileMessage(UUID var1, CmdlineRemoteProto.Message.BuilderMessage.CompileMessage var2);

    protected abstract void handleBuildEvent(UUID var1, CmdlineRemoteProto.Message.BuilderMessage.BuildEvent var2);

    @NotNull
    public abstract ProgressIndicator getProgressIndicator();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionId", "com/intellij/compiler/server/DefaultMessageHandler", "buildStarted"));
    }
}

